/*
 * Decompiled with CFR 0.152.
 */
package java.time.format.internal;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.Instant$;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalDateTime$;
import java.time.ZoneId;
import java.time.ZoneId$;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.Chronology$;
import java.time.format.CasePlatformHelper$;
import java.time.format.DateTimeFormatStyleProvider$;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatter$;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DecimalStyle;
import java.time.format.FormatStyle;
import java.time.format.SignStyle;
import java.time.format.SignStyle$;
import java.time.format.TextStyle;
import java.time.format.TextStyle$;
import java.time.format.internal.DateTimePrinterParser;
import java.time.format.internal.TTBPDateTimeFormatterBuilder$InstantPrinterParser$;
import java.time.format.internal.TTBPDateTimeFormatterBuilder$NumberPrinterParser$;
import java.time.format.internal.TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$;
import java.time.format.internal.TTBPDateTimeFormatterBuilder$ReducedPrinterParser$;
import java.time.format.internal.TTBPDateTimeFormatterBuilder$SettingsParser$;
import java.time.format.internal.TTBPDateTimeFormatterBuilder$ZoneIdPrinterParser$;
import java.time.format.internal.TTBPDateTimeFormatterBuilder$ZoneTextPrinterParser$;
import java.time.format.internal.TTBPDateTimeParseContext;
import java.time.format.internal.TTBPDateTimePrintContext;
import java.time.format.internal.TTBPDateTimeTextProvider;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.time.temporal.WeekFields$;
import java.time.zone.ZoneRulesProvider$;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.TimeZone$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

public final class TTBPDateTimeFormatterBuilder {

    public static final class CharLiteralPrinterParser
    implements DateTimePrinterParser {
        private final char literal;

        public CharLiteralPrinterParser(char literal) {
            this.literal = literal;
        }

        private char literal() {
            return this.literal;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            buf.append(this.literal());
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            int length = text.length();
            if (position == length) {
                return ~position;
            }
            if (position < 0 || position > length) {
                throw new StringIndexOutOfBoundsException();
            }
            char ch = text.charAt(position);
            if (!context.charEquals(this.literal(), ch)) {
                return ~position;
            }
            return position + 1;
        }

        public String toString() {
            if (this.literal() == '\'') {
                return "''";
            }
            return new StringBuilder(2).append("'").append(this.literal()).append("'").toString();
        }
    }

    public static final class ChronoPrinterParser
    implements DateTimePrinterParser {
        private final TextStyle textStyle;

        public ChronoPrinterParser(TextStyle textStyle) {
            this.textStyle = textStyle;
        }

        private TextStyle textStyle() {
            return this.textStyle;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            StringBuilder stringBuilder;
            Chronology chrono = context.getValue(TemporalQueries$.MODULE$.chronology());
            if (chrono == null) {
                return false;
            }
            if (this.textStyle() == null) {
                stringBuilder = buf.append(chrono.getId());
            } else {
                ResourceBundle bundle = ResourceBundle.getBundle("org.threeten.bp.format.ChronologyText", context.getLocale(), DateTimeFormatterBuilder.class.getClassLoader());
                try {
                    String text = bundle.getString(chrono.getId());
                    stringBuilder = buf.append(text);
                }
                catch (MissingResourceException missingResourceException) {
                    stringBuilder = buf.append(chrono.getId());
                }
            }
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            if (position < 0 || position > text.length()) {
                throw new IndexOutOfBoundsException();
            }
            java.util.Iterator<Chronology> chronos = Chronology$.MODULE$.getAvailableChronologies().iterator();
            Chronology bestMatch = null;
            int matchLen = -1;
            while (chronos.hasNext()) {
                Chronology chrono = chronos.next();
                String id = chrono.getId();
                int idLen = id.length();
                if (idLen <= matchLen || !context.subSequenceEquals(text, position, id, 0, idLen)) continue;
                bestMatch = chrono;
                matchLen = idLen;
            }
            if (bestMatch == null) {
                return ~position;
            }
            context.setParsed(bestMatch);
            return position + matchLen;
        }
    }

    public static final class CompositePrinterParser
    implements DateTimePrinterParser {
        private final DateTimePrinterParser[] printerParsers;
        private final boolean optional;

        public CompositePrinterParser(DateTimePrinterParser[] printerParsers, boolean optional) {
            this.printerParsers = printerParsers;
            this.optional = optional;
        }

        private DateTimePrinterParser[] printerParsers() {
            return this.printerParsers;
        }

        private boolean optional() {
            return this.optional;
        }

        public CompositePrinterParser(List<DateTimePrinterParser> printerParsers, boolean optional) {
            this((DateTimePrinterParser[])printerParsers.toArray((Object[])new DateTimePrinterParser[printerParsers.size()]), optional);
        }

        public CompositePrinterParser withOptional(boolean optional) {
            if (optional == this.optional()) {
                return this;
            }
            return new CompositePrinterParser(this.printerParsers(), optional);
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            boolean bl;
            Object object = new Object();
            try {
                int length = buf.length();
                if (this.optional()) {
                    context.startOptional();
                }
                try {
                    Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.printerParsers());
                    ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)pp -> {
                        this.print$$anonfun$1(context, buf, length, object, (DateTimePrinterParser)pp);
                        return BoxedUnit.UNIT;
                    });
                }
                finally {
                    if (this.optional()) {
                        context.endOptional();
                    }
                }
                bl = true;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    bl = BoxesRunTime.unboxToBoolean((Object)ex.value());
                }
                throw ex;
            }
            return bl;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            int n;
            Object object = new Object();
            try {
                int _position = position;
                if (this.optional()) {
                    context.startOptional();
                    IntRef pos = IntRef.create((int)_position);
                    Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.printerParsers());
                    ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)pp -> {
                        this.parse$$anonfun$1(context, text, pos, object, _position, (DateTimePrinterParser)pp);
                        return BoxedUnit.UNIT;
                    });
                    context.endOptional(true);
                    n = pos.elem;
                } else {
                    Object object3 = Predef$.MODULE$.refArrayOps((Object[])this.printerParsers());
                    n = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.foldLeft$extension(object3, (Object)BoxesRunTime.boxToInteger((int)_position), (Function2 & Serializable)(x$1, x$2) -> this.parse$$anonfun$2(context, text, BoxesRunTime.unboxToInt((Object)x$1), (DateTimePrinterParser)x$2)));
                }
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    n = BoxesRunTime.unboxToInt((Object)ex.value());
                }
                throw ex;
            }
            return n;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.printerParsers() != null) {
                buf.append(this.optional() ? "[" : "(");
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.printerParsers());
                ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)pp -> buf.append(pp));
                buf.append(this.optional() ? "]" : ")");
            }
            return buf.toString();
        }

        private final /* synthetic */ void print$$anonfun$1(TTBPDateTimePrintContext context$1, StringBuilder buf$1, int length$1, Object nonLocalReturnKey1$1, DateTimePrinterParser pp) {
            if (!pp.print(context$1, buf$1)) {
                buf$1.setLength(length$1);
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }

        private final /* synthetic */ void parse$$anonfun$1(TTBPDateTimeParseContext context$2, CharSequence text$1, IntRef pos$1, Object nonLocalReturnKey2$1, int _position$1, DateTimePrinterParser pp) {
            int n;
            pos$1.elem = n = pp.parse(context$2, text$1, pos$1.elem);
            if (pos$1.elem < 0) {
                context$2.endOptional(false);
                throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)BoxesRunTime.boxToInteger((int)_position$1));
            }
        }

        private final /* synthetic */ int parse$$anonfun$2(TTBPDateTimeParseContext context$3, CharSequence text$2, int x$1, DateTimePrinterParser x$2) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
            if (tuple2 != null) {
                int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
                int pos = n;
                if (pos < 0) {
                    return pos;
                }
                int pos2 = n;
                DateTimePrinterParser pp = (DateTimePrinterParser)tuple2._2();
                return pp.parse(context$3, text$2, pos2);
            }
            throw new MatchError((Object)tuple2);
        }
    }

    public static class DefaultingParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final Long value;

        public DefaultingParser(TemporalField field, Long value) {
            this.field = field;
            this.value = value;
        }

        private TemporalField field() {
            return this.field;
        }

        private Long value() {
            return this.value;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            if (context.getParsed(this.field()) == null) {
                context.setParsedField(this.field(), Predef$.MODULE$.Long2long(this.value()), position, position);
            }
            return position;
        }
    }

    public static final class FractionPrinterParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final int minWidth;
        private final int maxWidth;
        private final boolean decimalPoint;

        public FractionPrinterParser(TemporalField field, int minWidth, int maxWidth, boolean decimalPoint) {
            this.field = field;
            this.minWidth = minWidth;
            this.maxWidth = maxWidth;
            this.decimalPoint = decimalPoint;
            Objects.requireNonNull(field, "field");
            if (!field.range().isFixed()) {
                throw new IllegalArgumentException(new StringBuilder(39).append("Field must have a fixed set of values: ").append(field).toString());
            }
            if (minWidth < 0 || minWidth > 9) {
                throw new IllegalArgumentException(new StringBuilder(52).append("Minimum width must be from 0 to 9 inclusive but was ").append(minWidth).toString());
            }
            if (maxWidth < 1 || maxWidth > 9) {
                throw new IllegalArgumentException(new StringBuilder(52).append("Maximum width must be from 1 to 9 inclusive but was ").append(maxWidth).toString());
            }
            if (maxWidth < minWidth) {
                throw new IllegalArgumentException(new StringBuilder(60).append("Maximum width must exceed or equal the minimum width but ").append(maxWidth).append(" < ").append(minWidth).toString());
            }
        }

        private TemporalField field() {
            return this.field;
        }

        private int minWidth() {
            return this.minWidth;
        }

        private int maxWidth() {
            return this.maxWidth;
        }

        private boolean decimalPoint() {
            return this.decimalPoint;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            Object object;
            Long value = context.getValue(this.field());
            if (value == null) {
                return false;
            }
            DecimalStyle symbols = context.getSymbols();
            BigDecimal fraction = this.convertToFraction(value);
            if (fraction.scale() == 0) {
                if (this.minWidth() > 0) {
                    if (this.decimalPoint()) {
                        buf.append(symbols.getDecimalSeparator());
                    }
                    for (int i = 0; i < this.minWidth(); ++i) {
                        buf.append(symbols.getZeroDigit());
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else {
                int outputScale = Math.min(Math.max(fraction.scale(), this.minWidth()), this.maxWidth());
                fraction = fraction.setScale(outputScale, RoundingMode.FLOOR);
                String str = fraction.toPlainString().substring(2);
                str = symbols.convertNumberToI18N(str);
                if (this.decimalPoint()) {
                    buf.append(symbols.getDecimalSeparator());
                }
                object = buf.append(str);
            }
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            int minEndPos;
            int _position = position;
            int effectiveMin = context.isStrict() ? this.minWidth() : 0;
            int effectiveMax = context.isStrict() ? this.maxWidth() : 9;
            int length = text.length();
            if (_position == length) {
                if (effectiveMin > 0) {
                    return ~_position;
                }
                return _position;
            }
            if (this.decimalPoint()) {
                if (text.charAt(_position) != context.getSymbols().getDecimalSeparator()) {
                    if (effectiveMin > 0) {
                        return ~_position;
                    }
                    return _position;
                }
                ++_position;
            }
            if ((minEndPos = _position + effectiveMin) > length) {
                return ~_position;
            }
            int maxEndPos = Math.min(_position + effectiveMax, length);
            int total = 0;
            int pos = _position;
            boolean bl = false;
            while (!bl && pos < maxEndPos) {
                char ch = text.charAt(pos);
                ++pos;
                int digit = context.getSymbols().convertToDigit(ch);
                if (digit < 0) {
                    if (pos < minEndPos) {
                        return ~_position;
                    }
                    --pos;
                    bl = true;
                }
                if (bl) continue;
                total = total * 10 + digit;
            }
            BigDecimal fraction = new BigDecimal(total).movePointLeft(pos - _position);
            Long value = this.convertFromFraction(fraction);
            return context.setParsedField(this.field(), Predef$.MODULE$.Long2long(value), _position, pos);
        }

        private BigDecimal convertToFraction(Long value) {
            ValueRange range = this.field().range();
            range.checkValidValue(Predef$.MODULE$.Long2long(value), this.field());
            BigDecimal minBD = BigDecimal.valueOf(range.getMinimum());
            BigDecimal rangeBD = BigDecimal.valueOf(range.getMaximum()).subtract(minBD).add(BigDecimal.ONE);
            BigDecimal valueBD = BigDecimal.valueOf(Predef$.MODULE$.Long2long(value)).subtract(minBD);
            BigDecimal fraction = valueBD.divide(rangeBD, 9, RoundingMode.FLOOR);
            if (fraction.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            }
            return fraction.stripTrailingZeros();
        }

        private Long convertFromFraction(BigDecimal fraction) {
            ValueRange range = this.field().range();
            BigDecimal minBD = BigDecimal.valueOf(range.getMinimum());
            BigDecimal rangeBD = BigDecimal.valueOf(range.getMaximum()).subtract(minBD).add(BigDecimal.ONE);
            return Predef$.MODULE$.long2Long(fraction.multiply(rangeBD).setScale(0, RoundingMode.FLOOR).add(minBD).longValueExact());
        }

        public String toString() {
            String decimal = this.decimalPoint() ? ",DecimalPoint" : "";
            return new StringBuilder(12).append("Fraction(").append(this.field()).append(",").append(this.minWidth()).append(",").append(this.maxWidth()).append(decimal).append(")").toString();
        }
    }

    public static final class InstantPrinterParser
    implements DateTimePrinterParser {
        private final int fractionalDigits;

        public InstantPrinterParser(int fractionalDigits) {
            this.fractionalDigits = fractionalDigits;
        }

        private int fractionalDigits() {
            return this.fractionalDigits;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            Long inSecs = context.getValue(ChronoField$.INSTANT_SECONDS);
            Long inNanos = Predef$.MODULE$.long2Long(0L);
            if (context.getTemporal().isSupported(ChronoField$.NANO_OF_SECOND)) {
                inNanos = Predef$.MODULE$.long2Long(context.getTemporal().getLong(ChronoField$.NANO_OF_SECOND));
            }
            if (inSecs == null) {
                return false;
            }
            Long inSec = inSecs;
            int inNano = ChronoField$.NANO_OF_SECOND.checkValidIntValue(Predef$.MODULE$.Long2long(inNanos));
            if (Predef$.MODULE$.Long2long(inSec) >= -Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_0000_TO_1970)) {
                Long zeroSecs = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inSec) - Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_PER_10000_YEARS) + Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_0000_TO_1970));
                Long hi = Predef$.MODULE$.long2Long(Math.floorDiv(Predef$.MODULE$.Long2long(zeroSecs), Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_PER_10000_YEARS)) + 1L);
                Long lo = Predef$.MODULE$.long2Long(Math.floorMod(Predef$.MODULE$.Long2long(zeroSecs), Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_PER_10000_YEARS)));
                LocalDateTime ldt = LocalDateTime$.MODULE$.ofEpochSecond(Predef$.MODULE$.Long2long(lo) - Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_0000_TO_1970), 0, ZoneOffset$.MODULE$.UTC());
                if (Predef$.MODULE$.Long2long(hi) > 0L) {
                    buf.append('+').append(hi);
                }
                buf.append(ldt);
                if (ldt.getSecond() == 0) {
                    buf.append(":00");
                }
            } else {
                Long zeroSecs = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inSec) + Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_0000_TO_1970));
                Long hi = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(zeroSecs) / Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_PER_10000_YEARS));
                Long lo = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(zeroSecs) % Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_PER_10000_YEARS));
                LocalDateTime ldt = LocalDateTime$.MODULE$.ofEpochSecond(Predef$.MODULE$.Long2long(lo) - Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_0000_TO_1970), 0, ZoneOffset$.MODULE$.UTC());
                int pos = buf.length();
                buf.append(ldt);
                if (ldt.getSecond() == 0) {
                    buf.append(":00");
                }
                if (Predef$.MODULE$.Long2long(hi) < 0L) {
                    if (ldt.getYear() == -10000) {
                        buf.replace(pos, pos + 2, Long.toString(Predef$.MODULE$.Long2long(hi) - 1L));
                    } else if (BoxesRunTime.equals((Object)lo, (Object)BoxesRunTime.boxToInteger((int)0))) {
                        buf.insert(pos, hi);
                    } else {
                        buf.insert(pos + 1, Math.abs(Predef$.MODULE$.Long2long(hi)));
                    }
                }
            }
            if (this.fractionalDigits() == -2) {
                if (inNano != 0) {
                    buf.append('.');
                    if (inNano % 1000000 == 0) {
                        buf.append(Integer.toString(inNano / 1000000 + 1000).substring(1));
                    } else if (inNano % 1000 == 0) {
                        buf.append(Integer.toString(inNano / 1000 + 1000000).substring(1));
                    } else {
                        buf.append(Integer.toString(inNano + 1000000000).substring(1));
                    }
                }
            } else if (this.fractionalDigits() > 0 || this.fractionalDigits() == -1 && inNano > 0) {
                buf.append('.');
                int div = 100000000;
                for (int i = 0; this.fractionalDigits() == -1 && inNano > 0 || i < this.fractionalDigits(); ++i) {
                    int digit = inNano / div;
                    buf.append((char)(digit + 48));
                    inNano -= digit * div;
                    div /= 10;
                }
            }
            buf.append('Z');
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            TTBPDateTimeParseContext newContext = context.copy();
            int minDigits = this.fractionalDigits() < 0 ? 0 : this.fractionalDigits();
            int maxDigits = this.fractionalDigits() < 0 ? 9 : this.fractionalDigits();
            CompositePrinterParser parser = new DateTimeFormatterBuilder().append(DateTimeFormatter$.MODULE$.ISO_LOCAL_DATE()).appendLiteral('T').appendValue(ChronoField$.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField$.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField$.SECOND_OF_MINUTE, 2).appendFraction(ChronoField$.NANO_OF_SECOND, minDigits, maxDigits, true).appendLiteral('Z').toFormatter().toPrinterParser(false);
            int pos = parser.parse(newContext, text, position);
            if (pos < 0) {
                return pos;
            }
            Long yearParsed = newContext.getParsed(ChronoField$.YEAR);
            int month = newContext.getParsed(ChronoField$.MONTH_OF_YEAR).intValue();
            int day = newContext.getParsed(ChronoField$.DAY_OF_MONTH).intValue();
            int hour = newContext.getParsed(ChronoField$.HOUR_OF_DAY).intValue();
            int min = newContext.getParsed(ChronoField$.MINUTE_OF_HOUR).intValue();
            Long secVal = newContext.getParsed(ChronoField$.SECOND_OF_MINUTE);
            Long nanoVal = newContext.getParsed(ChronoField$.NANO_OF_SECOND);
            int sec = secVal != null ? secVal.intValue() : 0;
            int nano = nanoVal != null ? nanoVal.intValue() : 0;
            int year = (int)Predef$.MODULE$.Long2long(yearParsed) % 10000;
            int days = 0;
            if (hour == 24 && min == 0 && sec == 0 && nano == 0) {
                hour = 0;
                days = 1;
            } else if (hour == 23 && min == 59 && sec == 60) {
                context.setParsedLeapSecond();
                sec = 59;
            }
            Long instantSecs = Predef$.MODULE$.long2Long(0L);
            try {
                LocalDateTime ldt = LocalDateTime$.MODULE$.of(year, month, day, hour, min, sec, 0).plusDays(days);
                instantSecs = Predef$.MODULE$.long2Long(ldt.toEpochSecond(ZoneOffset$.MODULE$.UTC()));
                instantSecs = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(instantSecs) + Math.multiplyExact(Predef$.MODULE$.Long2long(yearParsed) / 10000L, Predef$.MODULE$.Long2long(TTBPDateTimeFormatterBuilder$InstantPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$InstantPrinterParser$$$SECONDS_PER_10000_YEARS)));
            }
            catch (RuntimeException runtimeException) {
                return ~position;
            }
            int successPos = pos;
            successPos = context.setParsedField(ChronoField$.INSTANT_SECONDS, Predef$.MODULE$.Long2long(instantSecs), position, successPos);
            return context.setParsedField(ChronoField$.NANO_OF_SECOND, nano, position, successPos);
        }

        public String toString() {
            return "Instant()";
        }
    }

    public static final class LocalizedOffsetPrinterParser
    implements DateTimePrinterParser {
        private final TextStyle style;

        public LocalizedOffsetPrinterParser(TextStyle style) {
            this.style = style;
        }

        private TextStyle style() {
            return this.style;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            Long offsetSecs = context.getValue(ChronoField$.OFFSET_SECONDS);
            if (offsetSecs == null) {
                return false;
            }
            buf.append("GMT");
            if (this.style() == TextStyle$.FULL) {
                return new OffsetIdPrinterParser("", "+HH:MM:ss").print(context, buf);
            }
            int totalSecs = Math.toIntExact(Predef$.MODULE$.Long2long(offsetSecs));
            if (totalSecs != 0) {
                int absHours = Math.abs(totalSecs / 3600 % 100);
                int absMinutes = Math.abs(totalSecs / 60 % 60);
                int absSeconds = Math.abs(totalSecs % 60);
                buf.append(totalSecs < 0 ? "-" : "+").append(absHours);
                if (absMinutes > 0 || absSeconds > 0) {
                    buf.append(":").append((char)(absMinutes / 10 + 48)).append((char)(absMinutes % 10 + 48));
                    if (absSeconds > 0) {
                        buf.append(":").append((char)(absSeconds / 10 + 48)).append((char)(absSeconds % 10 + 48));
                    }
                }
            }
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            char ch;
            int negative;
            int _position = position;
            if (!context.subSequenceEquals(text, _position, "GMT", 0, 3)) {
                return ~_position;
            }
            _position += 3;
            if (this.style() == TextStyle$.FULL) {
                return new OffsetIdPrinterParser("", "+HH:MM:ss").parse(context, text, _position);
            }
            int end = text.length();
            if (_position == end) {
                return context.setParsedField(ChronoField$.OFFSET_SECONDS, 0L, _position, _position);
            }
            char sign = text.charAt(_position);
            if (sign != '+' && sign != '-') {
                return context.setParsedField(ChronoField$.OFFSET_SECONDS, 0L, _position, _position);
            }
            int n = negative = sign == '-' ? -1 : 1;
            if (_position == end) {
                return ~_position;
            }
            if ((ch = text.charAt(++_position)) < '0' || ch > '9') {
                return ~_position;
            }
            int hour = ch - 48;
            if (++_position != end && (ch = text.charAt(_position)) >= '0' && ch <= '9') {
                if ((hour = hour * 10 + (ch - 48)) > 23) {
                    return ~_position;
                }
                ++_position;
            }
            if (_position == end || text.charAt(_position) != ':') {
                int offset = negative * 3600 * hour;
                return context.setParsedField(ChronoField$.OFFSET_SECONDS, offset, _position, _position);
            }
            if (++_position > end - 2) {
                return ~_position;
            }
            ch = text.charAt(_position);
            if (ch < '0' || ch > '9') {
                return ~_position;
            }
            int min = ch - 48;
            if ((ch = text.charAt(++_position)) < '0' || ch > '9') {
                return ~_position;
            }
            ++_position;
            if ((min = min * 10 + (ch - 48)) > 59) {
                return ~_position;
            }
            if (_position == end || text.charAt(_position) != ':') {
                int offset = negative * (3600 * hour + 60 * min);
                return context.setParsedField(ChronoField$.OFFSET_SECONDS, offset, _position, _position);
            }
            if (++_position > end - 2) {
                return ~_position;
            }
            ch = text.charAt(_position);
            if (ch < '0' || ch > '9') {
                return ~_position;
            }
            int sec = ch - 48;
            if ((ch = text.charAt(++_position)) < '0' || ch > '9') {
                return ~_position;
            }
            ++_position;
            if ((sec = sec * 10 + (ch - 48)) > 59) {
                return ~_position;
            }
            int offset = negative * (3600 * hour + 60 * min + sec);
            return context.setParsedField(ChronoField$.OFFSET_SECONDS, offset, _position, _position);
        }
    }

    public static final class LocalizedPrinterParser
    implements DateTimePrinterParser {
        private final FormatStyle dateStyle;
        private final FormatStyle timeStyle;

        public LocalizedPrinterParser(FormatStyle dateStyle, FormatStyle timeStyle) {
            this.dateStyle = dateStyle;
            this.timeStyle = timeStyle;
        }

        private FormatStyle dateStyle() {
            return this.dateStyle;
        }

        private FormatStyle timeStyle() {
            return this.timeStyle;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            Chronology chrono = Chronology$.MODULE$.from(context.getTemporal());
            return this.formatter(context.getLocale(), chrono).toPrinterParser(false).print(context, buf);
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            Chronology chrono = context.getEffectiveChronology();
            return this.formatter(context.getLocale(), chrono).toPrinterParser(false).parse(context, text, position);
        }

        private DateTimeFormatter formatter(Locale locale, Chronology chrono) {
            return DateTimeFormatStyleProvider$.MODULE$.getInstance().getFormatter(this.dateStyle(), this.timeStyle(), chrono, locale);
        }

        public String toString() {
            return new StringBuilder(12).append("Localized(").append(this.dateStyle() != null ? this.dateStyle() : "").append(",").append(this.timeStyle() != null ? this.timeStyle() : "").append(")").toString();
        }
    }

    public static class NumberPrinterParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final int minWidth;
        private final int maxWidth;
        private final SignStyle signStyle;
        private final int subsequentWidth;

        public static int[] EXCEED_POINTS() {
            return TTBPDateTimeFormatterBuilder$NumberPrinterParser$.MODULE$.EXCEED_POINTS();
        }

        public NumberPrinterParser(TemporalField field, int minWidth, int maxWidth, SignStyle signStyle, int subsequentWidth) {
            this.field = field;
            this.minWidth = minWidth;
            this.maxWidth = maxWidth;
            this.signStyle = signStyle;
            this.subsequentWidth = subsequentWidth;
        }

        public TemporalField field() {
            return this.field;
        }

        public int minWidth() {
            return this.minWidth;
        }

        public int maxWidth() {
            return this.maxWidth;
        }

        public SignStyle signStyle() {
            return this.signStyle;
        }

        public int subsequentWidth() {
            return this.subsequentWidth;
        }

        public NumberPrinterParser(TemporalField field, int minWidth, int maxWidth, SignStyle signStyle) {
            this(field, minWidth, maxWidth, signStyle, 0);
        }

        public NumberPrinterParser withFixedWidth() {
            if (this.subsequentWidth() == -1) {
                return this;
            }
            return new NumberPrinterParser(this.field(), this.minWidth(), this.maxWidth(), this.signStyle(), -1);
        }

        public NumberPrinterParser withSubsequentWidth(int subsequentWidth) {
            return new NumberPrinterParser(this.field(), this.minWidth(), this.maxWidth(), this.signStyle(), this.subsequentWidth() + subsequentWidth);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            block11: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        valueLong = context.getValue(this.field());
                                        if (valueLong == null) {
                                            return false;
                                        }
                                        value = this.getValue(context, valueLong);
                                        symbols = context.getSymbols();
                                        v0 = str = BoxesRunTime.equals((Object)value, (Object)BoxesRunTime.boxToLong((long)-9223372036854775808L)) != false ? "9223372036854775808" : BoxesRunTime.boxToLong((long)Math.abs(Predef$.MODULE$.Long2long(value))).toString();
                                        if (str.length() > this.maxWidth()) {
                                            throw new DateTimeException(new StringBuilder(74).append("Field ").append(this.field()).append(" cannot be printed as the value ").append(value).append(" exceeds the maximum print width of ").append(this.maxWidth()).toString());
                                        }
                                        str = symbols.convertNumberToI18N(str);
                                        if (Predef$.MODULE$.Long2long(value) < 0L) break block10;
                                        var7_7 = this.signStyle();
                                        v1 = SignStyle$.EXCEEDS_PAD;
                                        var8_8 = var7_7;
                                        if (!(v1 != null ? v1.equals((Object)var8_8) == false : var8_8 != null)) {
                                            if (this.minWidth() < 19 && Predef$.MODULE$.Long2long(value) >= (long)TTBPDateTimeFormatterBuilder$NumberPrinterParser$.MODULE$.EXCEED_POINTS()[this.minWidth()]) {
                                                buf.append(symbols.getPositiveSign());
                                                v2 /* !! */  = BoxedUnit.UNIT;
                                            } else {
                                                v2 /* !! */  = BoxedUnit.UNIT;
                                            }
                                        } else {
                                            v3 = SignStyle$.ALWAYS;
                                            var9_9 = var7_7;
                                            v2 /* !! */  = !(v3 != null ? v3.equals((Object)var9_9) == false : var9_9 != null) ? buf.append(symbols.getPositiveSign()) : BoxedUnit.UNIT;
                                        }
                                        break block11;
                                    }
                                    var10_10 = this.signStyle();
                                    v4 = SignStyle$.NORMAL;
                                    var11_11 = var10_10;
                                    if (v4 != null) break block12;
                                    if (var11_11 == null) ** GOTO lbl-1000
                                    break block13;
                                }
                                if (v4.equals((Object)var11_11)) ** GOTO lbl-1000
                            }
                            v5 = SignStyle$.EXCEEDS_PAD;
                            var12_12 = var10_10;
                            if (v5 != null) break block14;
                            if (var12_12 == null) ** GOTO lbl-1000
                            break block15;
                        }
                        if (v5.equals((Object)var12_12)) ** GOTO lbl-1000
                    }
                    v6 = SignStyle$.ALWAYS;
                    var13_13 = var10_10;
                    if (v6 != null) break block16;
                    if (var13_13 == null) ** GOTO lbl-1000
                    ** GOTO lbl-1000
                }
                if (v6.equals((Object)var13_13)) lbl-1000:
                // 6 sources

                {
                    v2 /* !! */  = buf.append(symbols.getNegativeSign());
                } else lbl-1000:
                // 2 sources

                {
                    v7 = SignStyle$.NOT_NEGATIVE;
                    var14_14 = var10_10;
                    if (!(v7 != null ? v7.equals((Object)var14_14) == false : var14_14 != null)) {
                        throw new DateTimeException(new StringBuilder(84).append("Field ").append(this.field()).append(" cannot be printed as the value ").append(value).append(" cannot be negative according to the SignStyle").toString());
                    }
                    v2 /* !! */  = BoxedUnit.UNIT;
                }
            }
            for (i = 0; i < this.minWidth() - str.length(); ++i) {
                buf.append(symbols.getZeroDigit());
            }
            buf.append(str);
            return true;
        }

        public Long getValue(TTBPDateTimePrintContext context, Long value) {
            if (context != null) {
                return value;
            }
            return value;
        }

        public boolean isFixedWidth(TTBPDateTimeParseContext context) {
            if (context != null) {
                return this.subsequentWidth() == -1 || this.subsequentWidth() > 0 && this.minWidth() == this.maxWidth() && this.signStyle() == SignStyle$.NOT_NEGATIVE;
            }
            return this.subsequentWidth() == -1 || this.subsequentWidth() > 0 && this.minWidth() == this.maxWidth() && this.signStyle() == SignStyle$.NOT_NEGATIVE;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            int _position = position;
            int length = text.length();
            if (_position == length) {
                return ~_position;
            }
            if (_position < 0 || position > length) {
                throw new StringIndexOutOfBoundsException();
            }
            char sign = text.charAt(_position);
            boolean negative = false;
            boolean positive = false;
            if (sign == context.getSymbols().getPositiveSign()) {
                if (!this.signStyle().parse(true, context.isStrict(), this.minWidth() == this.maxWidth())) {
                    return ~_position;
                }
                positive = true;
                ++_position;
            } else if (sign == context.getSymbols().getNegativeSign()) {
                if (!this.signStyle().parse(false, context.isStrict(), this.minWidth() == this.maxWidth())) {
                    return ~_position;
                }
                negative = true;
                ++_position;
            } else if (this.signStyle() == SignStyle$.ALWAYS && context.isStrict()) {
                return ~_position;
            }
            int effMinWidth = context.isStrict() || this.isFixedWidth(context) ? this.minWidth() : 1;
            int minEndPos = _position + effMinWidth;
            if (minEndPos > length) {
                return ~_position;
            }
            int effMaxWidth = (context.isStrict() || this.isFixedWidth(context) ? this.maxWidth() : 9) + Math.max(this.subsequentWidth(), 0);
            Long total = Predef$.MODULE$.long2Long(0L);
            BigInteger totalBig = null;
            int pos = _position;
            int pass = 0;
            boolean outerBreak = false;
            while (!outerBreak && pass < 2) {
                int maxEndPos = Math.min(pos + effMaxWidth, length);
                boolean bl = false;
                while (!bl && pos < maxEndPos) {
                    char ch = text.charAt(pos);
                    ++pos;
                    int digit = context.getSymbols().convertToDigit(ch);
                    if (digit < 0) {
                        if (--pos < minEndPos) {
                            return ~_position;
                        }
                        bl = true;
                    }
                    if (bl) continue;
                    if (pos - _position > 18) {
                        if (totalBig == null) {
                            totalBig = BigInteger.valueOf(Predef$.MODULE$.Long2long(total));
                        }
                        totalBig = totalBig.multiply(BigInteger.TEN).add(BigInteger.valueOf(digit));
                        continue;
                    }
                    total = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(total) * 10L + (long)digit);
                }
                if (this.subsequentWidth() > 0 && pass == 0) {
                    int parseLen = pos - _position;
                    effMaxWidth = Math.max(effMinWidth, parseLen - this.subsequentWidth());
                    pos = _position;
                    total = Predef$.MODULE$.long2Long(0L);
                    totalBig = null;
                    ++pass;
                    continue;
                }
                outerBreak = true;
            }
            if (negative) {
                if (totalBig != null) {
                    if (BoxesRunTime.equals(totalBig, (Object)BigInteger.ZERO) && context.isStrict()) {
                        return ~(_position - 1);
                    }
                    totalBig = totalBig.negate();
                } else {
                    if (BoxesRunTime.equals((Object)total, (Object)BoxesRunTime.boxToInteger((int)0)) && context.isStrict()) {
                        return ~(_position - 1);
                    }
                    total = Predef$.MODULE$.long2Long(-Predef$.MODULE$.Long2long(total));
                }
            } else if (this.signStyle() == SignStyle$.EXCEEDS_PAD && context.isStrict()) {
                int parseLen = pos - _position;
                if (positive) {
                    if (parseLen <= this.minWidth()) {
                        return ~(_position - 1);
                    }
                } else if (parseLen > this.minWidth()) {
                    return ~_position;
                }
            }
            if (totalBig != null) {
                if (totalBig.bitLength() > 63) {
                    totalBig = totalBig.divide(BigInteger.TEN);
                    --pos;
                }
                return this.setValue(context, Predef$.MODULE$.long2Long(totalBig.longValue()), _position, pos);
            }
            return this.setValue(context, total, _position, pos);
        }

        public int setValue(TTBPDateTimeParseContext context, Long value, int errorPos, int successPos) {
            return context.setParsedField(this.field(), Predef$.MODULE$.Long2long(value), errorPos, successPos);
        }

        public String toString() {
            if (this.minWidth() == 1 && this.maxWidth() == 19 && this.signStyle() == SignStyle$.NORMAL) {
                return new StringBuilder(7).append("Value(").append(this.field()).append(")").toString();
            }
            if (this.minWidth() == this.maxWidth() && this.signStyle() == SignStyle$.NOT_NEGATIVE) {
                return new StringBuilder(8).append("Value(").append(this.field()).append(",").append(this.minWidth()).append(")").toString();
            }
            return new StringBuilder(10).append("Value(").append(this.field()).append(",").append(this.minWidth()).append(",").append(this.maxWidth()).append(",").append((Object)this.signStyle()).append(")").toString();
        }
    }

    public static final class OffsetIdPrinterParser
    implements DateTimePrinterParser {
        private final String noOffsetText;
        private final int type;

        public static OffsetIdPrinterParser INSTANCE_ID() {
            return TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$.MODULE$.INSTANCE_ID();
        }

        public static String[] PATTERNS() {
            return TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$.MODULE$.PATTERNS();
        }

        public OffsetIdPrinterParser(String noOffsetText, String pattern) {
            this.noOffsetText = noOffsetText;
            Objects.requireNonNull(noOffsetText, "noOffsetText");
            Objects.requireNonNull(pattern, "pattern");
            this.type = this.checkPattern(pattern);
        }

        private String noOffsetText() {
            return this.noOffsetText;
        }

        private int checkPattern(String pattern) {
            for (int i = 0; i < TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$.MODULE$.PATTERNS().length; ++i) {
                String string = TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$.MODULE$.PATTERNS()[i];
                String string2 = pattern;
                if (string != null ? !string.equals(string2) : string2 != null) continue;
                return i;
            }
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid zone offset pattern: ").append(pattern).toString());
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            StringBuilder stringBuilder;
            Long offsetSecs = context.getValue(ChronoField$.OFFSET_SECONDS);
            if (offsetSecs == null) {
                return false;
            }
            int totalSecs = Math.toIntExact(Predef$.MODULE$.Long2long(offsetSecs));
            if (totalSecs == 0) {
                stringBuilder = buf.append(this.noOffsetText());
            } else {
                int absHours = Math.abs(totalSecs / 3600 % 100);
                int absMinutes = Math.abs(totalSecs / 60 % 60);
                int absSeconds = Math.abs(totalSecs % 60);
                int bufPos = buf.length();
                int output = absHours;
                buf.append(totalSecs < 0 ? "-" : "+").append((char)(absHours / 10 + 48)).append((char)(absHours % 10 + 48));
                if (this.type >= 3 || this.type >= 1 && absMinutes > 0) {
                    buf.append(this.type % 2 == 0 ? ":" : "").append((char)(absMinutes / 10 + 48)).append((char)(absMinutes % 10 + 48));
                    output += absMinutes;
                    if (this.type >= 7 || this.type >= 5 && absSeconds > 0) {
                        buf.append(this.type % 2 == 0 ? ":" : "").append((char)(absSeconds / 10 + 48)).append((char)(absSeconds % 10 + 48));
                        output += absSeconds;
                    }
                }
                if (output == 0) {
                    buf.setLength(bufPos);
                    buf.append(this.noOffsetText());
                    stringBuilder = BoxedUnit.UNIT;
                } else {
                    stringBuilder = BoxedUnit.UNIT;
                }
            }
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            char sign;
            int length = text.length();
            int noOffsetLen = this.noOffsetText().length();
            if (noOffsetLen == 0) {
                if (position == length) {
                    return context.setParsedField(ChronoField$.OFFSET_SECONDS, 0L, position, position);
                }
            } else {
                if (position == length) {
                    return ~position;
                }
                if (context.subSequenceEquals(text, position, this.noOffsetText(), 0, noOffsetLen)) {
                    return context.setParsedField(ChronoField$.OFFSET_SECONDS, 0L, position, position + noOffsetLen);
                }
            }
            if ((sign = text.charAt(position)) == '+' || sign == '-') {
                int negative = sign == '-' ? -1 : 1;
                int[] array = new int[4];
                array[0] = position + 1;
                if (!(this.parseNumber(array, 1, text, true) || this.parseNumber(array, 2, text, this.type >= 3) || this.parseNumber(array, 3, text, false))) {
                    Long offsetSecs = Predef$.MODULE$.long2Long((long)negative * ((long)array[1] * 3600L + (long)array[2] * 60L + (long)array[3]));
                    return context.setParsedField(ChronoField$.OFFSET_SECONDS, Predef$.MODULE$.Long2long(offsetSecs), position, array[0]);
                }
            }
            if (noOffsetLen == 0) {
                return context.setParsedField(ChronoField$.OFFSET_SECONDS, 0L, position, position + noOffsetLen);
            }
            return ~position;
        }

        private boolean parseNumber(int[] array, int arrayIndex, CharSequence parseText, boolean required) {
            if ((this.type + 3) / 2 < arrayIndex) {
                return false;
            }
            int pos = array[0];
            if (this.type % 2 == 0 && arrayIndex > 1) {
                if (pos + 1 > parseText.length() || parseText.charAt(pos) != ':') {
                    return required;
                }
                ++pos;
            }
            if (pos + 2 > parseText.length()) {
                return required;
            }
            char ch1 = parseText.charAt(pos);
            char ch2 = parseText.charAt(++pos);
            ++pos;
            if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9') {
                return required;
            }
            int value = (ch1 - 48) * 10 + (ch2 - 48);
            if (value < 0 || value > 59) {
                return required;
            }
            array[arrayIndex] = value;
            array[0] = pos;
            return false;
        }

        public String toString() {
            String converted = this.noOffsetText().replace("'", "''");
            return new StringBuilder(11).append("Offset(").append(TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$.MODULE$.PATTERNS()[this.type]).append(",'").append(converted).append("')").toString();
        }
    }

    public static final class PadPrinterParserDecorator
    implements DateTimePrinterParser {
        private final DateTimePrinterParser printerParser;
        private final int padWidth;
        private final char padChar;

        public PadPrinterParserDecorator(DateTimePrinterParser printerParser, int padWidth, char padChar) {
            this.printerParser = printerParser;
            this.padWidth = padWidth;
            this.padChar = padChar;
        }

        private DateTimePrinterParser printerParser() {
            return this.printerParser;
        }

        private int padWidth() {
            return this.padWidth;
        }

        private char padChar() {
            return this.padChar;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            int preLen = buf.length();
            if (!this.printerParser().print(context, buf)) {
                return false;
            }
            int len = buf.length() - preLen;
            if (len > this.padWidth()) {
                throw new DateTimeException(new StringBuilder(59).append("Cannot print as output of ").append(len).append(" characters exceeds pad width of ").append(this.padWidth()).toString());
            }
            for (int i = 0; i < this.padWidth() - len; ++i) {
                buf.insert(preLen, this.padChar());
            }
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            int pos;
            CharSequence _text = text;
            boolean strict = context.isStrict();
            boolean caseSensitive = context.isCaseSensitive();
            if (position > _text.length()) {
                throw new IndexOutOfBoundsException();
            }
            if (position == _text.length()) {
                return ~position;
            }
            int endPos = position + this.padWidth();
            if (endPos > _text.length()) {
                if (strict) {
                    return ~position;
                }
                endPos = _text.length();
            }
            for (pos = position; pos < endPos && !(!caseSensitive ? !context.charEquals(_text.charAt(pos), this.padChar()) : _text.charAt(pos) != this.padChar()); ++pos) {
            }
            _text = _text.subSequence(0, endPos);
            int resultPos = this.printerParser().parse(context, _text, pos);
            if (resultPos != endPos && strict) {
                return ~(position + pos);
            }
            return resultPos;
        }

        public String toString() {
            return new StringBuilder(5).append("Pad(").append(this.printerParser()).append(",").append(this.padWidth()).append(this.padChar() == ' ' ? ")" : new StringBuilder(4).append(",'").append(this.padChar()).append("')").toString()).toString();
        }
    }

    public static final class ReducedPrinterParser
    extends NumberPrinterParser {
        private final int baseValue;
        private final ChronoLocalDate baseDate;

        public static LocalDate BASE_DATE() {
            return TTBPDateTimeFormatterBuilder$ReducedPrinterParser$.MODULE$.BASE_DATE();
        }

        public ReducedPrinterParser(TemporalField field, int minWidth, int maxWidth, int baseValue, ChronoLocalDate baseDate, int subsequentWidth) {
            this.baseValue = baseValue;
            this.baseDate = baseDate;
            super(field, minWidth, maxWidth, SignStyle$.NOT_NEGATIVE, subsequentWidth);
            if (minWidth < 1 || minWidth > 10) {
                throw new IllegalArgumentException(new StringBuilder(49).append("The width must be from 1 to 10 inclusive but was ").append(minWidth).toString());
            }
            if (maxWidth < 1 || maxWidth > 10) {
                throw new IllegalArgumentException(new StringBuilder(52).append("The maxWidth must be from 1 to 10 inclusive but was ").append(maxWidth).toString());
            }
            if (maxWidth < minWidth) {
                throw new IllegalArgumentException("The maxWidth must be greater than the width");
            }
            if (baseDate == null) {
                if (!field.range().isValidValue(baseValue)) {
                    throw new IllegalArgumentException("The base value must be within the range of the field");
                }
                if ((long)baseValue + (long)TTBPDateTimeFormatterBuilder$NumberPrinterParser$.MODULE$.EXCEED_POINTS()[minWidth] > Integer.MAX_VALUE) {
                    throw new DateTimeException("Unable to add printer-parser as the range exceeds the capacity of an int");
                }
            }
        }

        private TemporalField field$accessor() {
            return super.field();
        }

        private int minWidth$accessor() {
            return super.minWidth();
        }

        private int maxWidth$accessor() {
            return super.maxWidth();
        }

        private int baseValue() {
            return this.baseValue;
        }

        private ChronoLocalDate baseDate() {
            return this.baseDate;
        }

        private int subsequentWidth$accessor() {
            return super.subsequentWidth();
        }

        public ReducedPrinterParser(TemporalField field, int minWidth, int maxWidth, int baseValue, ChronoLocalDate baseDate) {
            this(field, minWidth, maxWidth, baseValue, baseDate, 0);
        }

        @Override
        public Long getValue(TTBPDateTimePrintContext context, Long value) {
            Long absValue = Predef$.MODULE$.long2Long(Math.abs(Predef$.MODULE$.Long2long(value)));
            int baseValue = this.baseValue();
            if (this.baseDate() != null) {
                Chronology chrono = Chronology$.MODULE$.from(context.getTemporal());
                baseValue = chrono.date(this.baseDate()).get(this.field$accessor());
            }
            if (Predef$.MODULE$.Long2long(value) >= (long)baseValue && Predef$.MODULE$.Long2long(value) < (long)(baseValue + TTBPDateTimeFormatterBuilder$NumberPrinterParser$.MODULE$.EXCEED_POINTS()[this.minWidth$accessor()])) {
                return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(absValue) % (long)TTBPDateTimeFormatterBuilder$NumberPrinterParser$.MODULE$.EXCEED_POINTS()[this.minWidth$accessor()]);
            }
            return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(absValue) % (long)TTBPDateTimeFormatterBuilder$NumberPrinterParser$.MODULE$.EXCEED_POINTS()[this.maxWidth$accessor()]);
        }

        @Override
        public int setValue(TTBPDateTimeParseContext context, Long value, int errorPos, int successPos) {
            int parseLen;
            Long _value = value;
            int baseValue = this.baseValue();
            if (this.baseDate() != null) {
                Chronology chrono = context.getEffectiveChronology();
                baseValue = chrono.date(this.baseDate()).get(this.field$accessor());
                context.addChronologyChangedParser(this, Predef$.MODULE$.Long2long(_value), errorPos, successPos);
            }
            if ((parseLen = successPos - errorPos) == this.minWidth$accessor() && Predef$.MODULE$.Long2long(_value) >= 0L) {
                Long range = Predef$.MODULE$.long2Long((long)TTBPDateTimeFormatterBuilder$NumberPrinterParser$.MODULE$.EXCEED_POINTS()[this.minWidth$accessor()]);
                Long lastPart = Predef$.MODULE$.long2Long((long)baseValue % Predef$.MODULE$.Long2long(range));
                Long basePart = Predef$.MODULE$.long2Long((long)baseValue - Predef$.MODULE$.Long2long(lastPart));
                _value = baseValue > 0 ? Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(basePart) + Predef$.MODULE$.Long2long(_value)) : Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(basePart) - Predef$.MODULE$.Long2long(_value));
                if (Predef$.MODULE$.Long2long(_value) < (long)baseValue) {
                    _value = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(_value) + Predef$.MODULE$.Long2long(range));
                }
            }
            return context.setParsedField(this.field$accessor(), Predef$.MODULE$.Long2long(_value), errorPos, successPos);
        }

        @Override
        public NumberPrinterParser withFixedWidth() {
            if (this.subsequentWidth$accessor() == -1) {
                return this;
            }
            return new ReducedPrinterParser(this.field$accessor(), this.minWidth$accessor(), this.maxWidth$accessor(), this.baseValue(), this.baseDate(), -1);
        }

        @Override
        public ReducedPrinterParser withSubsequentWidth(int subsequentWidth) {
            return new ReducedPrinterParser(this.field$accessor(), this.minWidth$accessor(), this.maxWidth$accessor(), this.baseValue(), this.baseDate(), this.subsequentWidth$accessor() + subsequentWidth);
        }

        @Override
        public boolean isFixedWidth(TTBPDateTimeParseContext context) {
            if (!context.isStrict()) {
                return false;
            }
            return super.isFixedWidth(context);
        }

        @Override
        public String toString() {
            return new StringBuilder(17).append("ReducedValue(").append(this.field$accessor()).append(",").append(this.minWidth$accessor()).append(",").append(this.maxWidth$accessor()).append(",").append(this.baseDate() != null ? this.baseDate() : BoxesRunTime.boxToInteger((int)this.baseValue())).append(")").toString();
        }
    }

    public static abstract class SettingsParser
    extends Enum<SettingsParser>
    implements DateTimePrinterParser,
    scala.reflect.Enum {
        private final int ordinal;

        public static SettingsParser fromOrdinal(int n) {
            return TTBPDateTimeFormatterBuilder$SettingsParser$.MODULE$.fromOrdinal(n);
        }

        public static SettingsParser valueOf(String string) {
            return TTBPDateTimeFormatterBuilder$SettingsParser$.MODULE$.valueOf(string);
        }

        public static SettingsParser[] values() {
            return TTBPDateTimeFormatterBuilder$SettingsParser$.MODULE$.values();
        }

        public SettingsParser(String _$name, int _$ordinal) {
            this.ordinal = ordinal;
        }

        public static SettingsParser SENSITIVE() {
            return TTBPDateTimeFormatterBuilder$SettingsParser$.SENSITIVE;
        }

        public static SettingsParser INSENSITIVE() {
            return TTBPDateTimeFormatterBuilder$SettingsParser$.INSENSITIVE;
        }

        public static SettingsParser STRICT() {
            return TTBPDateTimeFormatterBuilder$SettingsParser$.STRICT;
        }

        public static SettingsParser LENIENT() {
            return TTBPDateTimeFormatterBuilder$SettingsParser$.LENIENT;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            int n = this.ordinal;
            switch (n) {
                case 0: {
                    context.setCaseSensitive(true);
                    break;
                }
                case 1: {
                    context.setCaseSensitive(false);
                    break;
                }
                case 2: {
                    context.setStrict(true);
                    break;
                }
                case 3: {
                    context.setStrict(false);
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            return position;
        }

        public String toString() {
            int n = this.ordinal;
            switch (n) {
                case 0: {
                    return "ParseCaseSensitive(true)";
                }
                case 1: {
                    return "ParseCaseSensitive(false)";
                }
                case 2: {
                    return "ParseStrict(true)";
                }
                case 3: {
                    return "ParseStrict(false)";
                }
            }
            throw new IllegalStateException("Unreachable");
        }
    }

    public static final class StringLiteralPrinterParser
    implements DateTimePrinterParser {
        private final String literal;

        public StringLiteralPrinterParser(String literal) {
            this.literal = literal;
        }

        private String literal() {
            return this.literal;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            buf.append(this.literal());
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            int length = text.length();
            if (position > length || position < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (!context.subSequenceEquals(text, position, this.literal(), 0, this.literal().length())) {
                return ~position;
            }
            return position + this.literal().length();
        }

        public String toString() {
            String converted = this.literal().replace("'", "''");
            return new StringBuilder(2).append("'").append(converted).append("'").toString();
        }
    }

    public static final class TextPrinterParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final TextStyle textStyle;
        private final TTBPDateTimeTextProvider provider;
        private volatile NumberPrinterParser _numberPrinterParser;

        public TextPrinterParser(TemporalField field, TextStyle textStyle, TTBPDateTimeTextProvider provider) {
            this.field = field;
            this.textStyle = textStyle;
            this.provider = provider;
            this._numberPrinterParser = null;
        }

        private TemporalField field() {
            return this.field;
        }

        private TextStyle textStyle() {
            return this.textStyle;
        }

        private TTBPDateTimeTextProvider provider() {
            return this.provider;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            Long value = context.getValue(this.field());
            if (value == null) {
                return false;
            }
            String text = this.provider().getText(this.field(), Predef$.MODULE$.Long2long(value), this.textStyle(), context.getLocale());
            if (text == null) {
                return this.numberPrinterParser().print(context, buf);
            }
            buf.append(text);
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence parseText, int position) {
            int length = parseText.length();
            if (position < 0 || position > length) {
                throw new IndexOutOfBoundsException();
            }
            TextStyle style = context.isStrict() ? this.textStyle() : null;
            Iterator<Tuple2<String, Object>> it = this.provider().getTextIterator(this.field(), style, context.getLocale());
            if (it != null) {
                while (it.hasNext()) {
                    Tuple2 entry = (Tuple2)it.next();
                    String itText = (String)entry._1();
                    if (!context.subSequenceEquals(itText, 0, parseText, position, itText.length())) continue;
                    return context.setParsedField(this.field(), BoxesRunTime.unboxToLong((Object)entry._2()), position, position + itText.length());
                }
                if (context.isStrict()) {
                    return ~position;
                }
            }
            return this.numberPrinterParser().parse(context, parseText, position);
        }

        private NumberPrinterParser numberPrinterParser() {
            if (this._numberPrinterParser == null) {
                this._numberPrinterParser = new NumberPrinterParser(this.field(), 1, 19, SignStyle$.NORMAL);
            }
            return this._numberPrinterParser;
        }

        public String toString() {
            if (this.textStyle() == TextStyle$.FULL) {
                return new StringBuilder(6).append("Text(").append(this.field()).append(")").toString();
            }
            return new StringBuilder(7).append("Text(").append(this.field()).append(",").append((Object)this.textStyle()).append(")").toString();
        }
    }

    public static final class WeekFieldsPrinterParser
    implements DateTimePrinterParser {
        private final char letter;
        private final int count;

        public WeekFieldsPrinterParser(char letter, int count) {
            this.letter = letter;
            this.count = count;
        }

        private char letter() {
            return this.letter;
        }

        private int count() {
            return this.count;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            return this.evaluate(WeekFields$.MODULE$.of(context.getLocale())).print(context, buf);
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            return this.evaluate(WeekFields$.MODULE$.of(context.getLocale())).parse(context, text, position);
        }

        private DateTimePrinterParser evaluate(WeekFields weekFields) {
            char c = this.letter();
            switch (c) {
                case 'e': {
                    return new NumberPrinterParser(weekFields.dayOfWeek(), this.count(), 2, SignStyle$.NOT_NEGATIVE);
                }
                case 'c': {
                    return new NumberPrinterParser(weekFields.dayOfWeek(), this.count(), 2, SignStyle$.NOT_NEGATIVE);
                }
                case 'w': {
                    return new NumberPrinterParser(weekFields.weekOfWeekBasedYear(), this.count(), 2, SignStyle$.NOT_NEGATIVE);
                }
                case 'W': {
                    return new NumberPrinterParser(weekFields.weekOfMonth(), 1, 2, SignStyle$.NOT_NEGATIVE);
                }
                case 'Y': {
                    if (this.count() == 2) {
                        return new ReducedPrinterParser(weekFields.weekBasedYear(), 2, 2, 0, TTBPDateTimeFormatterBuilder$ReducedPrinterParser$.MODULE$.BASE_DATE());
                    }
                    return new NumberPrinterParser(weekFields.weekBasedYear(), this.count(), 19, this.count() < 4 ? SignStyle$.NORMAL : SignStyle$.EXCEEDS_PAD, -1);
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
        }

        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder sb = new StringBuilder(30);
            sb.append("Localized(");
            if (this.letter() == 'Y') {
                stringBuilder = this.count() == 1 ? sb.append("WeekBasedYear") : (this.count() == 2 ? sb.append("ReducedValue(WeekBasedYear,2,2,2000-01-01)") : sb.append("WeekBasedYear,").append(this.count()).append(",").append(19).append(",").append((Object)(this.count() < 4 ? SignStyle$.NORMAL : SignStyle$.EXCEEDS_PAD)));
            } else {
                if (this.letter() == 'c' || this.letter() == 'e') {
                    sb.append("DayOfWeek");
                } else if (this.letter() == 'w') {
                    sb.append("WeekOfWeekBasedYear");
                } else if (this.letter() == 'W') {
                    sb.append("WeekOfMonth");
                }
                sb.append(",");
                stringBuilder = sb.append(this.count());
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static final class ZoneIdPrinterParser
    implements DateTimePrinterParser {
        private final TemporalQuery query;
        private final String description;

        public ZoneIdPrinterParser(TemporalQuery<ZoneId> query, String description) {
            this.query = query;
            this.description = description;
        }

        private TemporalQuery<ZoneId> query() {
            return this.query;
        }

        private String description() {
            return this.description;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            ZoneId zone = context.getValue(this.query());
            if (zone == null) {
                return false;
            }
            buf.append(zone.getId());
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            int length = text.length();
            if (position > length) {
                throw new IndexOutOfBoundsException();
            }
            if (position == length) {
                return ~position;
            }
            char nextChar = text.charAt(position);
            if (nextChar == '+' || nextChar == '-') {
                TTBPDateTimeParseContext newContext = context.copy();
                int endPos = TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$.MODULE$.INSTANCE_ID().parse(newContext, text, position);
                if (endPos < 0) {
                    return endPos;
                }
                int offset = (int)newContext.getParsed(ChronoField$.OFFSET_SECONDS).longValue();
                context.setParsed(ZoneOffset$.MODULE$.ofTotalSeconds(offset));
                return endPos;
            }
            if (length >= position + 2) {
                char nextNextChar = text.charAt(position + 1);
                if (context.charEquals(nextChar, 'U') && context.charEquals(nextNextChar, 'T')) {
                    if (length >= position + 3 && context.charEquals(text.charAt(position + 2), 'C')) {
                        return this.parsePrefixedOffset(context, text, position, position + 3);
                    }
                    return this.parsePrefixedOffset(context, text, position, position + 2);
                }
                if (context.charEquals(nextChar, 'G') && length >= position + 3 && context.charEquals(nextNextChar, 'M') && context.charEquals(text.charAt(position + 2), 'T')) {
                    return this.parsePrefixedOffset(context, text, position, position + 3);
                }
            }
            Set<String> regionIds = ZoneRulesProvider$.MODULE$.getAvailableZoneIds();
            int regionIdsSize = regionIds.size();
            Map.Entry<Integer, SubstringTree> cached = TTBPDateTimeFormatterBuilder$ZoneIdPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$ZoneIdPrinterParser$$$cachedSubstringTree;
            if (cached == null || !BoxesRunTime.equals((Object)cached.getKey(), (Object)BoxesRunTime.boxToInteger((int)regionIdsSize))) {
                ZoneIdPrinterParser zoneIdPrinterParser = this;
                synchronized (zoneIdPrinterParser) {
                    BoxedUnit boxedUnit;
                    cached = TTBPDateTimeFormatterBuilder$ZoneIdPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$ZoneIdPrinterParser$$$cachedSubstringTree;
                    if (cached == null || !BoxesRunTime.equals((Object)cached.getKey(), (Object)BoxesRunTime.boxToInteger((int)regionIdsSize))) {
                        TTBPDateTimeFormatterBuilder$ZoneIdPrinterParser$.java$time$format$internal$TTBPDateTimeFormatterBuilder$ZoneIdPrinterParser$$$cachedSubstringTree = cached = new AbstractMap.SimpleImmutableEntry<Integer, SubstringTree>(Predef$.MODULE$.int2Integer(regionIdsSize), TTBPDateTimeFormatterBuilder$ZoneIdPrinterParser$.MODULE$.java$time$format$internal$TTBPDateTimeFormatterBuilder$ZoneIdPrinterParser$$$prepareParser(regionIds));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
            SubstringTree tree = cached.getValue();
            String parsedZoneId = null;
            String lastZoneId = null;
            boolean bl = false;
            while (!bl && tree != null) {
                int nodeLength = tree.length();
                if (position + nodeLength > length) {
                    bl = true;
                    continue;
                }
                lastZoneId = parsedZoneId;
                parsedZoneId = text.subSequence(position, position + nodeLength).toString();
                tree = tree.get(parsedZoneId, context.isCaseSensitive());
            }
            ZoneId zone = this.convertToZone(regionIds, parsedZoneId, context.isCaseSensitive());
            if (zone == null) {
                zone = this.convertToZone(regionIds, lastZoneId, context.isCaseSensitive());
                if (zone == null) {
                    if (context.charEquals(nextChar, 'Z')) {
                        context.setParsed(ZoneOffset$.MODULE$.UTC());
                        return position + 1;
                    }
                    return ~position;
                }
                parsedZoneId = lastZoneId;
            }
            context.setParsed(zone);
            return position + parsedZoneId.length();
        }

        private ZoneId convertToZone(Set<String> regionIds, String parsedZoneId, boolean caseSensitive) {
            if (parsedZoneId == null) {
                return null;
            }
            if (caseSensitive) {
                if (regionIds.contains(parsedZoneId)) {
                    return ZoneId$.MODULE$.of(parsedZoneId);
                }
                return null;
            }
            for (String regionId : regionIds) {
                if (!regionId.equalsIgnoreCase(parsedZoneId)) continue;
                return ZoneId$.MODULE$.of(regionId);
            }
            return null;
        }

        private int parsePrefixedOffset(TTBPDateTimeParseContext context, CharSequence text, int prefixPos, int position) {
            String prefix = text.subSequence(prefixPos, position).toString().toUpperCase();
            TTBPDateTimeParseContext newContext = context.copy();
            if (position < text.length() && context.charEquals(text.charAt(position), 'Z')) {
                context.setParsed(ZoneId$.MODULE$.ofOffset(prefix, ZoneOffset$.MODULE$.UTC()));
                return position;
            }
            int endPos = TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$.MODULE$.INSTANCE_ID().parse(newContext, text, position);
            if (endPos < 0) {
                context.setParsed(ZoneId$.MODULE$.ofOffset(prefix, ZoneOffset$.MODULE$.UTC()));
                return position;
            }
            int offsetSecs = (int)newContext.getParsed(ChronoField$.OFFSET_SECONDS).longValue();
            ZoneOffset offset = ZoneOffset$.MODULE$.ofTotalSeconds(offsetSecs);
            context.setParsed(ZoneId$.MODULE$.ofOffset(prefix, offset));
            return endPos;
        }

        public String toString() {
            return this.description();
        }

        public static final class SubstringTree {
            private final int length;
            private final Map<CharSequence, SubstringTree> substringMap;
            private final Map<String, SubstringTree> substringMapCI;

            public SubstringTree(int length) {
                this.length = length;
                this.substringMap = new HashMap<CharSequence, SubstringTree>();
                this.substringMapCI = new HashMap<String, SubstringTree>();
            }

            public int length() {
                return this.length;
            }

            public SubstringTree get(CharSequence substring2, boolean caseSensitive) {
                if (caseSensitive) {
                    return this.substringMap.get(substring2);
                }
                return this.substringMapCI.get(CasePlatformHelper$.MODULE$.toLocaleIndependentLowerCase(substring2.toString()));
            }

            public void add(String newSubstring) {
                while (true) {
                    int idLen;
                    if ((idLen = newSubstring.length()) == this_.length()) {
                        this_.substringMap.put(newSubstring, null);
                        this_.substringMapCI.put(CasePlatformHelper$.MODULE$.toLocaleIndependentLowerCase(newSubstring), null);
                        return;
                    }
                    if (idLen <= this_.length()) break;
                    String substring = newSubstring.substring(0, this_.length());
                    SubstringTree parserTree = this_.substringMap.get(substring);
                    if (parserTree == null) {
                        parserTree = new SubstringTree(idLen);
                        this_.substringMap.put(substring, parserTree);
                        this_.substringMapCI.put(CasePlatformHelper$.MODULE$.toLocaleIndependentLowerCase(substring), parserTree);
                    }
                    SubstringTree this_ = parserTree;
                }
            }
        }
    }

    public static final class ZoneTextPrinterParser
    implements DateTimePrinterParser {
        private final TextStyle textStyle;

        public ZoneTextPrinterParser(TextStyle textStyle) {
            this.textStyle = textStyle;
            Objects.requireNonNull(textStyle, "textStyle");
        }

        private TextStyle textStyle() {
            return this.textStyle;
        }

        @Override
        public boolean print(TTBPDateTimePrintContext context, StringBuilder buf) {
            ZoneId zone = context.getValue(TemporalQueries$.MODULE$.zoneId());
            if (zone == null) {
                return false;
            }
            if (zone.normalized() instanceof ZoneOffset) {
                buf.append(zone.getId());
                return true;
            }
            TemporalAccessor temporal = context.getTemporal();
            boolean daylight = false;
            if (temporal.isSupported(ChronoField$.INSTANT_SECONDS)) {
                Instant instant = Instant$.MODULE$.ofEpochSecond(temporal.getLong(ChronoField$.INSTANT_SECONDS));
                daylight = zone.getRules().isDaylightSavings(instant);
            }
            TimeZone tz = TimeZone$.MODULE$.getTimeZone(zone.getId());
            int tzstyle = this.textStyle().asNormal() == TextStyle$.FULL ? 1 : 0;
            String text = tz.getDisplayName(daylight, tzstyle, context.getLocale());
            buf.append(text);
            return true;
        }

        @Override
        public int parse(TTBPDateTimeParseContext context, CharSequence text, int position) {
            HashMap<String, String> ids = new HashMap<String, String>();
            for (String id : ZoneId$.MODULE$.getAvailableZoneIds()) {
                ids.put(id, id);
                TimeZone tz = TimeZone$.MODULE$.getTimeZone(id);
                int tzstyle = this.textStyle().asNormal() == TextStyle$.FULL ? 1 : 0;
                String textWinter = tz.getDisplayName(false, tzstyle, context.getLocale());
                if (textWinter != null && id.startsWith("Etc/") || !textWinter.startsWith("GMT+") && !textWinter.startsWith("GMT+")) {
                    ids.put(textWinter, id);
                } else if (textWinter == null) {
                    ids.put(tz.getDisplayName(false, tzstyle, context.getLocale()), id);
                }
                String textSummer = tz.getDisplayName(true, tzstyle, context.getLocale());
                if (textSummer != null && id.startsWith("Etc/") || !textSummer.startsWith("GMT+") && !textSummer.startsWith("GMT+")) {
                    ids.put(textSummer, id);
                    continue;
                }
                if (textSummer != null) continue;
                ids.put(tz.getDisplayName(true, tzstyle, context.getLocale()), id);
            }
            ArrayList tmpIds = new ArrayList(ids.entrySet());
            Collections.sort(tmpIds, TTBPDateTimeFormatterBuilder$ZoneTextPrinterParser$.MODULE$.java$time$format$internal$TTBPDateTimeFormatterBuilder$ZoneTextPrinterParser$$$LENGTH_COMPARATOR());
            for (Map.Entry v : tmpIds) {
                String name = (String)v.getKey();
                if (!context.subSequenceEquals(text, position, name, 0, name.length())) continue;
                context.setParsed(ZoneId$.MODULE$.of((String)v.getValue()));
                return position + name.length();
            }
            return ~position;
        }

        public String toString() {
            return new StringBuilder(10).append("ZoneText(").append((Object)this.textStyle()).append(")").toString();
        }
    }
}

