/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatStyleProvider;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.format.SimpleDateTimeFormatStyleProvider$;
import java.util.Locale;

public final class SimpleDateTimeFormatStyleProvider
extends DateTimeFormatStyleProvider {
    @Override
    public Locale[] getAvailableLocales() {
        return DateFormat.getAvailableLocales();
    }

    @Override
    public DateTimeFormatter getFormatter(FormatStyle dateStyle, FormatStyle timeStyle, Chronology chrono, Locale locale) {
        DateFormat dateFormat;
        if (dateStyle == null && timeStyle == null) {
            throw new IllegalArgumentException("Date and Time style must not both be null");
        }
        String key = new StringBuilder(22).append(chrono.getId()).append('|').append(locale.toString()).append('|').append((Object)dateStyle).append((Object)timeStyle).toString();
        Object cached = SimpleDateTimeFormatStyleProvider$.MODULE$.java$time$format$SimpleDateTimeFormatStyleProvider$$$FORMATTER_CACHE().get(key);
        if (cached != null) {
            Object object = cached;
            String string = "";
            if (!(object != null ? !object.equals(string) : string != null)) {
                throw new IllegalArgumentException("Unable to convert DateFormat to DateTimeFormatter");
            }
            return (DateTimeFormatter)cached;
        }
        DateFormat dateFormat2 = dateStyle != null ? (timeStyle != null ? DateFormat.getDateTimeInstance(this.convertStyle(dateStyle), this.convertStyle(timeStyle), locale) : DateFormat.getDateInstance(this.convertStyle(dateStyle), locale)) : (dateFormat = DateFormat.getTimeInstance(this.convertStyle(timeStyle), locale));
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat format = (SimpleDateFormat)dateFormat;
            String pattern = format.toPattern();
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern(pattern).toFormatter(locale);
            SimpleDateTimeFormatStyleProvider$.MODULE$.java$time$format$SimpleDateTimeFormatStyleProvider$$$FORMATTER_CACHE().put(key, formatter);
            return formatter;
        }
        SimpleDateTimeFormatStyleProvider$.MODULE$.java$time$format$SimpleDateTimeFormatStyleProvider$$$FORMATTER_CACHE().put(key, "");
        throw new IllegalArgumentException("Unable to convert DateFormat to DateTimeFormatter");
    }

    private int convertStyle(FormatStyle style) {
        return style.ordinal();
    }
}

