/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.time.format.DecimalStyle$;
import java.util.Locale;
import java.util.Set;

public final class DecimalStyle {
    private final char zeroDigit;
    private final char positiveSign;
    private final char negativeSign;
    private final char decimalSeparator;

    public static DecimalStyle STANDARD() {
        return DecimalStyle$.MODULE$.STANDARD();
    }

    public static Set<Locale> getAvailableLocales() {
        return DecimalStyle$.MODULE$.getAvailableLocales();
    }

    public static DecimalStyle of(Locale locale) {
        return DecimalStyle$.MODULE$.of(locale);
    }

    public static DecimalStyle ofDefaultLocale() {
        return DecimalStyle$.MODULE$.ofDefaultLocale();
    }

    public DecimalStyle(char zeroDigit, char positiveSign, char negativeSign, char decimalSeparator) {
        this.zeroDigit = zeroDigit;
        this.positiveSign = positiveSign;
        this.negativeSign = negativeSign;
        this.decimalSeparator = decimalSeparator;
    }

    public char zeroDigit() {
        return this.zeroDigit;
    }

    public char positiveSign() {
        return this.positiveSign;
    }

    public char negativeSign() {
        return this.negativeSign;
    }

    public char decimalSeparator() {
        return this.decimalSeparator;
    }

    public char getZeroDigit() {
        return this.zeroDigit();
    }

    public DecimalStyle withZeroDigit(char zeroDigit) {
        if (zeroDigit == this.zeroDigit()) {
            return this;
        }
        return new DecimalStyle(zeroDigit, this.positiveSign(), this.negativeSign(), this.decimalSeparator());
    }

    public char getPositiveSign() {
        return this.positiveSign();
    }

    public DecimalStyle withPositiveSign(char positiveSign) {
        if (positiveSign == this.positiveSign()) {
            return this;
        }
        return new DecimalStyle(this.zeroDigit(), positiveSign, this.negativeSign(), this.decimalSeparator());
    }

    public char getNegativeSign() {
        return this.negativeSign();
    }

    public DecimalStyle withNegativeSign(char negativeSign) {
        if (negativeSign == this.negativeSign()) {
            return this;
        }
        return new DecimalStyle(this.zeroDigit(), this.positiveSign(), negativeSign, this.decimalSeparator());
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator();
    }

    public DecimalStyle withDecimalSeparator(char decimalSeparator) {
        if (decimalSeparator == this.decimalSeparator()) {
            return this;
        }
        return new DecimalStyle(this.zeroDigit(), this.positiveSign(), this.negativeSign(), decimalSeparator);
    }

    public int convertToDigit(char ch) {
        int value = ch - this.zeroDigit();
        if (value >= 0 && value <= 9) {
            return value;
        }
        return -1;
    }

    public String convertNumberToI18N(String numericText) {
        if (this.zeroDigit() == '0') {
            return numericText;
        }
        int diff = this.zeroDigit() - 48;
        char[] array = numericText.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            array[i] = (char)(array[i] + diff);
        }
        return new String(array);
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof DecimalStyle) {
            DecimalStyle other = (DecimalStyle)object;
            return this == other || this.zeroDigit() == other.zeroDigit() && this.positiveSign() == other.positiveSign() && this.negativeSign() == other.negativeSign() && this.decimalSeparator() == other.decimalSeparator();
        }
        return false;
    }

    public int hashCode() {
        return this.zeroDigit() + this.positiveSign() + this.negativeSign() + this.decimalSeparator();
    }

    public String toString() {
        return new StringBuilder(14).append("DecimalStyle[").append(this.zeroDigit()).append(this.positiveSign()).append(this.negativeSign()).append(this.decimalSeparator()).append("]").toString();
    }
}

