/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder$;
import java.time.format.DecimalStyle$;
import java.time.format.FormatStyle;
import java.time.format.ResolverStyle;
import java.time.format.ResolverStyle$;
import java.time.format.SignStyle;
import java.time.format.SignStyle$;
import java.time.format.TextStyle;
import java.time.format.TextStyle$;
import java.time.format.internal.DateTimePrinterParser;
import java.time.format.internal.TTBPDateTimeFormatterBuilder;
import java.time.format.internal.TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$;
import java.time.format.internal.TTBPDateTimeFormatterBuilder$ReducedPrinterParser$;
import java.time.format.internal.TTBPDateTimeFormatterBuilder$SettingsParser$;
import java.time.format.internal.TTBPDateTimeTextProvider;
import java.time.format.internal.TTBPDateTimeTextProvider$;
import java.time.format.internal.TTBPSimpleDateTimeTextProvider;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DateTimeFormatterBuilder {
    private final DateTimeFormatterBuilder parent;
    private final boolean optional;
    private DateTimeFormatterBuilder active;
    private final List printerParsers;
    private int padNextWidth;
    private char padNextChar;
    private int valueParserIndex;

    public static Comparator<String> LENGTH_SORT() {
        return DateTimeFormatterBuilder$.MODULE$.LENGTH_SORT();
    }

    public static String getLocalizedDateTimePattern(FormatStyle formatStyle, FormatStyle formatStyle2, Chronology chronology, Locale locale) {
        return DateTimeFormatterBuilder$.MODULE$.getLocalizedDateTimePattern(formatStyle, formatStyle2, chronology, locale);
    }

    private DateTimeFormatterBuilder(DateTimeFormatterBuilder parent, boolean optional) {
        this.parent = parent;
        this.optional = optional;
        this.active = this;
        this.printerParsers = new ArrayList();
        this.padNextWidth = 0;
        this.padNextChar = '\u0000';
        this.valueParserIndex = -1;
    }

    private DateTimeFormatterBuilder parent() {
        return this.parent;
    }

    private boolean optional() {
        return this.optional;
    }

    public DateTimeFormatterBuilder() {
        this(null, false);
    }

    private List<DateTimePrinterParser> printerParsers() {
        return this.printerParsers;
    }

    private int padNextWidth() {
        return this.padNextWidth;
    }

    private void padNextWidth_$eq(int x$0) {
        this.padNextWidth = x$0;
    }

    private char padNextChar() {
        return this.padNextChar;
    }

    private void padNextChar_$eq(char x$0) {
        this.padNextChar = x$0;
    }

    private int valueParserIndex() {
        return this.valueParserIndex;
    }

    private void valueParserIndex_$eq(int x$0) {
        this.valueParserIndex = x$0;
    }

    public DateTimeFormatterBuilder parseCaseSensitive() {
        this.appendInternal(TTBPDateTimeFormatterBuilder$SettingsParser$.SENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseCaseInsensitive() {
        this.appendInternal(TTBPDateTimeFormatterBuilder$SettingsParser$.INSENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseStrict() {
        this.appendInternal(TTBPDateTimeFormatterBuilder$SettingsParser$.STRICT);
        return this;
    }

    public DateTimeFormatterBuilder parseLenient() {
        this.appendInternal(TTBPDateTimeFormatterBuilder$SettingsParser$.LENIENT);
        return this;
    }

    public DateTimeFormatterBuilder parseDefaulting(TemporalField field, Long value) {
        Objects.requireNonNull(field, "field");
        this.appendInternal(new TTBPDateTimeFormatterBuilder.DefaultingParser(field, value));
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField field) {
        Objects.requireNonNull(field, "field");
        this.appendValue(new TTBPDateTimeFormatterBuilder.NumberPrinterParser(field, 1, 19, SignStyle$.NORMAL));
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField field, int width) {
        Objects.requireNonNull(field, "field");
        if (width < 1 || width > 19) {
            throw new IllegalArgumentException(new StringBuilder(49).append("The width must be from 1 to 19 inclusive but was ").append(width).toString());
        }
        this.appendValue(new TTBPDateTimeFormatterBuilder.NumberPrinterParser(field, width, width, SignStyle$.NOT_NEGATIVE));
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField field, int minWidth, int maxWidth, SignStyle signStyle) {
        if (minWidth == maxWidth && signStyle == SignStyle$.NOT_NEGATIVE) {
            return this.appendValue(field, maxWidth);
        }
        Objects.requireNonNull(field, "field");
        Objects.requireNonNull(signStyle, "signStyle");
        if (minWidth < 1 || minWidth > 19) {
            throw new IllegalArgumentException(new StringBuilder(57).append("The minimum width must be from 1 to 19 inclusive but was ").append(minWidth).toString());
        }
        if (maxWidth < 1 || maxWidth > 19) {
            throw new IllegalArgumentException(new StringBuilder(57).append("The maximum width must be from 1 to 19 inclusive but was ").append(maxWidth).toString());
        }
        if (maxWidth < minWidth) {
            throw new IllegalArgumentException(new StringBuilder(64).append("The maximum width must exceed or equal the minimum width but ").append(maxWidth).append(" < ").append(minWidth).toString());
        }
        this.appendValue(new TTBPDateTimeFormatterBuilder.NumberPrinterParser(field, minWidth, maxWidth, signStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendValueReduced(TemporalField field, int width, int maxWidth, int baseValue) {
        Objects.requireNonNull(field, "field");
        this.appendValue(new TTBPDateTimeFormatterBuilder.ReducedPrinterParser(field, width, maxWidth, baseValue, null));
        return this;
    }

    public DateTimeFormatterBuilder appendValueReduced(TemporalField field, int width, int maxWidth, ChronoLocalDate baseDate) {
        Objects.requireNonNull(field, "field");
        Objects.requireNonNull(baseDate, "baseDate");
        this.appendValue(new TTBPDateTimeFormatterBuilder.ReducedPrinterParser(field, width, maxWidth, 0, baseDate));
        return this;
    }

    private DateTimeFormatterBuilder appendValue(TTBPDateTimeFormatterBuilder.NumberPrinterParser pp) {
        Object object;
        if (this.active.valueParserIndex() >= 0 && this.active.printerParsers().get(this.active.valueParserIndex()) instanceof TTBPDateTimeFormatterBuilder.NumberPrinterParser) {
            int activeValueParser = this.active.valueParserIndex();
            TTBPDateTimeFormatterBuilder.NumberPrinterParser basePP = (TTBPDateTimeFormatterBuilder.NumberPrinterParser)this.active.printerParsers().get(activeValueParser);
            if (pp.minWidth() == pp.maxWidth() && pp.signStyle() == SignStyle$.NOT_NEGATIVE) {
                basePP = basePP.withSubsequentWidth(pp.maxWidth());
                this.appendInternal(pp.withFixedWidth());
                this.active.valueParserIndex_$eq(activeValueParser);
            } else {
                basePP = basePP.withFixedWidth();
                this.active.valueParserIndex_$eq(this.appendInternal(pp));
            }
            object = this.active.printerParsers().set(activeValueParser, basePP);
        } else {
            this.active.valueParserIndex_$eq(this.appendInternal(pp));
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    public DateTimeFormatterBuilder appendFraction(TemporalField field, int minWidth, int maxWidth, boolean decimalPoint) {
        this.appendInternal(new TTBPDateTimeFormatterBuilder.FractionPrinterParser(field, minWidth, maxWidth, decimalPoint));
        return this;
    }

    public DateTimeFormatterBuilder appendText(TemporalField field) {
        return this.appendText(field, TextStyle$.FULL);
    }

    public DateTimeFormatterBuilder appendText(TemporalField field, TextStyle textStyle) {
        Objects.requireNonNull(field, "field");
        Objects.requireNonNull(textStyle, "textStyle");
        this.appendInternal(new TTBPDateTimeFormatterBuilder.TextPrinterParser(field, textStyle, TTBPDateTimeTextProvider$.MODULE$.Provider()));
        return this;
    }

    public DateTimeFormatterBuilder appendText(TemporalField field, Map<Long, String> textLookup) {
        Objects.requireNonNull(field, "field");
        Objects.requireNonNull(textLookup, "textLookup");
        scala.collection.immutable.Map copy = (scala.collection.immutable.Map)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(textLookup).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Long x = (Long)tuple2._1();
                String i = (String)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)), (Object)i);
            }
            throw new MatchError((Object)tuple2);
        });
        Object[] objectArray = new Tuple2[1];
        TextStyle textStyle = (TextStyle)((Object)Predef$.MODULE$.ArrowAssoc((Object)TextStyle$.FULL));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)textStyle, (Object)copy);
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TTBPSimpleDateTimeTextProvider.LocaleStore store = new TTBPSimpleDateTimeTextProvider.LocaleStore((scala.collection.immutable.Map<TextStyle, scala.collection.immutable.Map<Object, String>>)map);
        TTBPDateTimeTextProvider provider = new TTBPDateTimeTextProvider(store){
            private final TTBPSimpleDateTimeTextProvider.LocaleStore store$1;
            {
                this.store$1 = store$2;
            }

            public String getText(TemporalField field, long value, TextStyle style, Locale locale) {
                return this.store$1.getText(value, style);
            }

            public Iterator getTextIterator(TemporalField field, TextStyle style, Locale locale) {
                return this.store$1.getTextIterator(style);
            }
        };
        this.appendInternal(new TTBPDateTimeFormatterBuilder.TextPrinterParser(field, TextStyle$.FULL, provider));
        return this;
    }

    public DateTimeFormatterBuilder appendInstant() {
        this.appendInternal(new TTBPDateTimeFormatterBuilder.InstantPrinterParser(-2));
        return this;
    }

    public DateTimeFormatterBuilder appendInstant(int fractionalDigits) {
        if (fractionalDigits < -1 || fractionalDigits > 9) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Invalid fractional digits: ").append(fractionalDigits).toString());
        }
        this.appendInternal(new TTBPDateTimeFormatterBuilder.InstantPrinterParser(fractionalDigits));
        return this;
    }

    public DateTimeFormatterBuilder appendOffsetId() {
        this.appendInternal(TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$.MODULE$.INSTANCE_ID());
        return this;
    }

    public DateTimeFormatterBuilder appendOffset(String pattern, String noOffsetText) {
        this.appendInternal(new TTBPDateTimeFormatterBuilder.OffsetIdPrinterParser(noOffsetText, pattern));
        return this;
    }

    public DateTimeFormatterBuilder appendLocalizedOffset(TextStyle style) {
        Objects.requireNonNull(style, "style");
        if (style != TextStyle$.FULL && style != TextStyle$.SHORT) {
            throw new IllegalArgumentException("Style must be either full or short");
        }
        this.appendInternal(new TTBPDateTimeFormatterBuilder.LocalizedOffsetPrinterParser(style));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneId() {
        this.appendInternal(new TTBPDateTimeFormatterBuilder.ZoneIdPrinterParser(TemporalQueries$.MODULE$.zoneId(), "ZoneId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneRegionId() {
        this.appendInternal(new TTBPDateTimeFormatterBuilder.ZoneIdPrinterParser(DateTimeFormatterBuilder$.MODULE$.java$time$format$DateTimeFormatterBuilder$$$QUERY_REGION_ONLY(), "ZoneRegionId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneOrOffsetId() {
        this.appendInternal(new TTBPDateTimeFormatterBuilder.ZoneIdPrinterParser(TemporalQueries$.MODULE$.zone(), "ZoneOrOffsetId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle) {
        this.appendInternal(new TTBPDateTimeFormatterBuilder.ZoneTextPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle, Set<ZoneId> preferredZones) {
        Objects.requireNonNull(preferredZones, "preferredZones");
        this.appendInternal(new TTBPDateTimeFormatterBuilder.ZoneTextPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendChronologyId() {
        this.appendInternal(new TTBPDateTimeFormatterBuilder.ChronoPrinterParser(null));
        return this;
    }

    public DateTimeFormatterBuilder appendChronologyText(TextStyle textStyle) {
        Objects.requireNonNull(textStyle, "textStyle");
        this.appendInternal(new TTBPDateTimeFormatterBuilder.ChronoPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendLocalized(FormatStyle dateStyle, FormatStyle timeStyle) {
        if (dateStyle == null && timeStyle == null) {
            throw new IllegalArgumentException("Either the date or time style must be non-null");
        }
        this.appendInternal(new TTBPDateTimeFormatterBuilder.LocalizedPrinterParser(dateStyle, timeStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char literal) {
        this.appendInternal(new TTBPDateTimeFormatterBuilder.CharLiteralPrinterParser(literal));
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(String literal) {
        Objects.requireNonNull(literal, "literal");
        if (literal.length() > 0) {
            if (literal.length() == 1) {
                this.appendInternal(new TTBPDateTimeFormatterBuilder.CharLiteralPrinterParser(literal.charAt(0)));
            } else {
                this.appendInternal(new TTBPDateTimeFormatterBuilder.StringLiteralPrinterParser(literal));
            }
        }
        return this;
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        this.appendInternal(formatter.toPrinterParser(false));
        return this;
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        this.appendInternal(formatter.toPrinterParser(true));
        return this;
    }

    public DateTimeFormatterBuilder appendPattern(String pattern) {
        Objects.requireNonNull(pattern, "pattern");
        this.parsePattern(pattern);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePattern(String pattern) {
        for (int pos = 0; pos < pattern.length(); ++pos) {
            DateTimeFormatterBuilder dateTimeFormatterBuilder;
            char cur = pattern.charAt(pos);
            if (cur >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z') {
                Object object;
                TemporalField field;
                int start = pos++;
                while (pos < pattern.length() && pattern.charAt(pos) == cur) {
                    ++pos;
                }
                int count = pos - start;
                if (cur == 'p') {
                    int pad = 0;
                    if (pos < pattern.length() && ((cur = pattern.charAt(pos)) >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z')) {
                        pad = count;
                        start = pos++;
                        while (pos < pattern.length() && pattern.charAt(pos) == cur) {
                            ++pos;
                        }
                        count = pos - start;
                    }
                    if (pad == 0) {
                        throw new IllegalArgumentException(new StringBuilder(54).append("Pad letter 'p' must be followed by valid pad pattern: ").append(pattern).toString());
                    }
                    this.padNext(pad);
                }
                if ((field = DateTimeFormatterBuilder$.MODULE$.java$time$format$DateTimeFormatterBuilder$$$FIELD_MAP().get(BoxesRunTime.boxToCharacter((char)cur))) != null) {
                    this.parseField(cur, count, field);
                    object = BoxedUnit.UNIT;
                } else if (cur == 'z') {
                    if (count > 4) {
                        throw new IllegalArgumentException(new StringBuilder(26).append("Too many pattern letters: ").append(cur).toString());
                    }
                    object = count == 4 ? this.appendZoneText(TextStyle$.FULL) : this.appendZoneText(TextStyle$.SHORT);
                } else if (cur == 'V') {
                    if (count != 2) {
                        throw new IllegalArgumentException(new StringBuilder(32).append("Pattern letter count must be 2: ").append(cur).toString());
                    }
                    object = this.appendZoneId();
                } else if (cur == 'Z') {
                    if (count < 4) {
                        object = this.appendOffset("+HHMM", "+0000");
                    } else if (count == 4) {
                        object = this.appendLocalizedOffset(TextStyle$.FULL);
                    } else {
                        if (count != 5) throw new IllegalArgumentException(new StringBuilder(26).append("Too many pattern letters: ").append(cur).toString());
                        object = this.appendOffset("+HH:MM:ss", "Z");
                    }
                } else if (cur == 'O') {
                    if (count == 1) {
                        object = this.appendLocalizedOffset(TextStyle$.SHORT);
                    } else {
                        if (count != 4) throw new IllegalArgumentException(new StringBuilder(37).append("Pattern letter count must be 1 or 4: ").append(cur).toString());
                        object = this.appendLocalizedOffset(TextStyle$.FULL);
                    }
                } else if (cur == 'X') {
                    if (count > 5) {
                        throw new IllegalArgumentException(new StringBuilder(26).append("Too many pattern letters: ").append(cur).toString());
                    }
                    object = this.appendOffset(TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$.MODULE$.PATTERNS()[count + (count == 1 ? 0 : 1)], "Z");
                } else if (cur == 'x') {
                    if (count > 5) {
                        throw new IllegalArgumentException(new StringBuilder(26).append("Too many pattern letters: ").append(cur).toString());
                    }
                    String zero = count == 1 ? "+00" : (count % 2 == 0 ? "+0000" : "+00:00");
                    object = this.appendOffset(TTBPDateTimeFormatterBuilder$OffsetIdPrinterParser$.MODULE$.PATTERNS()[count + (count == 1 ? 0 : 1)], zero);
                } else if (cur == 'W') {
                    if (count > 1) {
                        throw new IllegalArgumentException(new StringBuilder(26).append("Too many pattern letters: ").append(cur).toString());
                    }
                    object = BoxesRunTime.boxToInteger((int)this.appendInternal(new TTBPDateTimeFormatterBuilder.WeekFieldsPrinterParser('W', count)));
                } else if (cur == 'w') {
                    if (count > 2) {
                        throw new IllegalArgumentException(new StringBuilder(26).append("Too many pattern letters: ").append(cur).toString());
                    }
                    object = BoxesRunTime.boxToInteger((int)this.appendInternal(new TTBPDateTimeFormatterBuilder.WeekFieldsPrinterParser('w', count)));
                } else {
                    if (cur != 'Y') throw new IllegalArgumentException(new StringBuilder(24).append("Unknown pattern letter: ").append(cur).toString());
                    object = BoxesRunTime.boxToInteger((int)this.appendInternal(new TTBPDateTimeFormatterBuilder.WeekFieldsPrinterParser('Y', count)));
                }
                --pos;
                dateTimeFormatterBuilder = BoxedUnit.UNIT;
                continue;
            }
            if (cur == '\'') {
                int start = pos++;
                boolean bl = false;
                while (!bl && pos < pattern.length()) {
                    if (pattern.charAt(pos) == '\'') {
                        if (pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\'') {
                            ++pos;
                        } else {
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    ++pos;
                }
                if (pos >= pattern.length()) {
                    throw new IllegalArgumentException(new StringBuilder(48).append("Pattern ends with an incomplete string literal: ").append(pattern).toString());
                }
                String str = pattern.substring(start + 1, pos);
                if (str.length() == 0) {
                    dateTimeFormatterBuilder = this.appendLiteral('\'');
                    continue;
                }
                dateTimeFormatterBuilder = this.appendLiteral(str.replace("''", "'"));
                continue;
            }
            if (cur == '[') {
                dateTimeFormatterBuilder = this.optionalStart();
                continue;
            }
            if (cur == ']') {
                if (this.active.parent() == null) {
                    throw new IllegalArgumentException("Pattern invalid as it contains ] without previous [");
                }
                dateTimeFormatterBuilder = this.optionalEnd();
                continue;
            }
            if (cur == '{' || cur == '}' || cur == '#') {
                throw new IllegalArgumentException(new StringBuilder(39).append("Pattern includes reserved character: '").append(cur).append("'").toString());
            }
            dateTimeFormatterBuilder = this.appendLiteral(cur);
        }
    }

    private void parseField(char cur, int count, TemporalField field) {
        IllegalArgumentException exc = new IllegalArgumentException(new StringBuilder(26).append("Too many pattern letters: ").append(cur).toString());
        char c = cur;
        block0 : switch (c) {
            case 'u': 
            case 'y': {
                Object object;
                if (count == 2) {
                    object = this.appendValueReduced(field, 2, 2, TTBPDateTimeFormatterBuilder$ReducedPrinterParser$.MODULE$.BASE_DATE());
                    break;
                }
                if (count < 4) {
                    object = this.appendValue(field, count, 19, SignStyle$.NORMAL);
                    break;
                }
                object = this.appendValue(field, count, 19, SignStyle$.EXCEEDS_PAD);
                break;
            }
            case 'M': 
            case 'Q': {
                Object object;
                int n = count;
                switch (n) {
                    case 1: {
                        object = this.appendValue(field);
                        break block0;
                    }
                    case 2: {
                        object = this.appendValue(field, 2);
                        break block0;
                    }
                    case 3: {
                        object = this.appendText(field, TextStyle$.SHORT);
                        break block0;
                    }
                    case 4: {
                        object = this.appendText(field, TextStyle$.FULL);
                        break block0;
                    }
                    case 5: {
                        object = this.appendText(field, TextStyle$.NARROW);
                        break block0;
                    }
                }
                throw exc;
            }
            case 'L': 
            case 'q': {
                Object object;
                int n = count;
                switch (n) {
                    case 1: {
                        object = this.appendValue(field);
                        break block0;
                    }
                    case 2: {
                        object = this.appendValue(field, 2);
                        break block0;
                    }
                    case 3: {
                        object = this.appendText(field, TextStyle$.SHORT_STANDALONE);
                        break block0;
                    }
                    case 4: {
                        object = this.appendText(field, TextStyle$.FULL_STANDALONE);
                        break block0;
                    }
                    case 5: {
                        object = this.appendText(field, TextStyle$.NARROW_STANDALONE);
                        break block0;
                    }
                }
                throw exc;
            }
            case 'e': {
                Object object;
                int n = count;
                switch (n) {
                    case 1: 
                    case 2: {
                        object = BoxesRunTime.boxToInteger((int)this.appendInternal(new TTBPDateTimeFormatterBuilder.WeekFieldsPrinterParser('e', count)));
                        break block0;
                    }
                    case 3: {
                        object = this.appendText(field, TextStyle$.SHORT);
                        break block0;
                    }
                    case 4: {
                        object = this.appendText(field, TextStyle$.FULL);
                        break block0;
                    }
                    case 5: {
                        object = this.appendText(field, TextStyle$.NARROW);
                        break block0;
                    }
                }
                throw exc;
            }
            case 'c': {
                Object object;
                int n = count;
                switch (n) {
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.appendInternal(new TTBPDateTimeFormatterBuilder.WeekFieldsPrinterParser('c', count)));
                        break block0;
                    }
                    case 2: {
                        throw new IllegalArgumentException(new StringBuilder(35).append("Invalid number of pattern letters: ").append(cur).toString());
                    }
                    case 3: {
                        object = this.appendText(field, TextStyle$.SHORT_STANDALONE);
                        break block0;
                    }
                    case 4: {
                        object = this.appendText(field, TextStyle$.FULL_STANDALONE);
                        break block0;
                    }
                    case 5: {
                        object = this.appendText(field, TextStyle$.NARROW_STANDALONE);
                        break block0;
                    }
                }
                throw exc;
            }
            case 'a': {
                Object object;
                if (count == 1) {
                    object = this.appendText(field, TextStyle$.SHORT);
                    break;
                }
                throw exc;
            }
            case 'E': 
            case 'G': {
                Object object;
                int n = count;
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: {
                        object = this.appendText(field, TextStyle$.SHORT);
                        break block0;
                    }
                    case 4: {
                        object = this.appendText(field, TextStyle$.FULL);
                        break block0;
                    }
                    case 5: {
                        object = this.appendText(field, TextStyle$.NARROW);
                        break block0;
                    }
                }
                throw exc;
            }
            case 'S': {
                Object object = this.appendFraction(ChronoField$.NANO_OF_SECOND, count, count, false);
                break;
            }
            case 'F': {
                Object object;
                if (count == 1) {
                    object = this.appendValue(field);
                    break;
                }
                throw exc;
            }
            case 'H': 
            case 'K': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': {
                Object object;
                if (count == 1) {
                    object = this.appendValue(field);
                    break;
                }
                if (count == 2) {
                    object = this.appendValue(field, count);
                    break;
                }
                throw exc;
            }
            case 'D': {
                Object object;
                if (count == 1) {
                    object = this.appendValue(field);
                    break;
                }
                if (count <= 3) {
                    object = this.appendValue(field, count);
                    break;
                }
                throw exc;
            }
            default: {
                Object object;
                if (count == 1) {
                    object = this.appendValue(field);
                    break;
                }
                object = this.appendValue(field, count);
                break;
            }
        }
    }

    public DateTimeFormatterBuilder padNext(int padWidth) {
        return this.padNext(padWidth, ' ');
    }

    public DateTimeFormatterBuilder padNext(int padWidth, char padChar) {
        if (padWidth < 1) {
            throw new IllegalArgumentException(new StringBuilder(43).append("The pad width must be at least one but was ").append(padWidth).toString());
        }
        this.active.padNextWidth_$eq(padWidth);
        this.active.padNextChar_$eq(padChar);
        this.active.valueParserIndex_$eq(-1);
        return this;
    }

    public DateTimeFormatterBuilder optionalStart() {
        this.active.valueParserIndex_$eq(-1);
        this.active = new DateTimeFormatterBuilder(this.active, true);
        return this;
    }

    public DateTimeFormatterBuilder optionalEnd() {
        Object object;
        if (this.active.parent() == null) {
            throw new IllegalStateException("Cannot call optionalEnd() as there was no previous call to optionalStart()");
        }
        if (this.active.printerParsers().size() > 0) {
            TTBPDateTimeFormatterBuilder.CompositePrinterParser cpp = new TTBPDateTimeFormatterBuilder.CompositePrinterParser(this.active.printerParsers(), this.active.optional());
            this.active = this.active.parent();
            object = BoxesRunTime.boxToInteger((int)this.appendInternal(cpp));
        } else {
            this.active = this.active.parent();
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    private int appendInternal(DateTimePrinterParser pp) {
        DateTimePrinterParser _pp = pp;
        Objects.requireNonNull(_pp, "pp");
        if (this.active.padNextWidth() > 0) {
            if (_pp != null) {
                _pp = new TTBPDateTimeFormatterBuilder.PadPrinterParserDecorator(_pp, this.active.padNextWidth(), this.active.padNextChar());
            }
            this.active.padNextWidth_$eq(0);
            this.active.padNextChar_$eq('\u0000');
        }
        this.active.printerParsers().add(_pp);
        this.active.valueParserIndex_$eq(-1);
        return this.active.printerParsers().size() - 1;
    }

    public DateTimeFormatter toFormatter() {
        return this.toFormatter(Locale.getDefault());
    }

    public DateTimeFormatter toFormatter(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        while (this.active.parent() != null) {
            this.optionalEnd();
        }
        TTBPDateTimeFormatterBuilder.CompositePrinterParser pp = new TTBPDateTimeFormatterBuilder.CompositePrinterParser(this.printerParsers(), false);
        return new DateTimeFormatter(pp, locale, DecimalStyle$.MODULE$.STANDARD(), ResolverStyle$.SMART, null, null, null);
    }

    public DateTimeFormatter toFormatter(ResolverStyle style) {
        return this.toFormatter().withResolverStyle(style);
    }
}

