/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.io.IOException;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Period;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.format.DateTimeBuilder;
import java.time.format.DateTimeFormatter$;
import java.time.format.DateTimeParseException;
import java.time.format.DecimalStyle;
import java.time.format.FormatStyle;
import java.time.format.ResolverStyle;
import java.time.format.internal.TTBPDateTimeFormatterBuilder;
import java.time.format.internal.TTBPDateTimeParseContext;
import java.time.format.internal.TTBPDateTimePrintContext;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

public final class DateTimeFormatter {
    private final TTBPDateTimeFormatterBuilder.CompositePrinterParser printerParser;
    private final Locale locale;
    private final DecimalStyle decimalStyle;
    private final ResolverStyle resolverStyle;
    private final Set resolverFields;
    private final Chronology chrono;
    private final ZoneId zone;

    public static DateTimeFormatter BASIC_ISO_DATE() {
        return DateTimeFormatter$.MODULE$.BASIC_ISO_DATE();
    }

    public static DateTimeFormatter ISO_DATE() {
        return DateTimeFormatter$.MODULE$.ISO_DATE();
    }

    public static DateTimeFormatter ISO_DATE_TIME() {
        return DateTimeFormatter$.MODULE$.ISO_DATE_TIME();
    }

    public static DateTimeFormatter ISO_INSTANT() {
        return DateTimeFormatter$.MODULE$.ISO_INSTANT();
    }

    public static DateTimeFormatter ISO_LOCAL_DATE() {
        return DateTimeFormatter$.MODULE$.ISO_LOCAL_DATE();
    }

    public static DateTimeFormatter ISO_LOCAL_DATE_TIME() {
        return DateTimeFormatter$.MODULE$.ISO_LOCAL_DATE_TIME();
    }

    public static DateTimeFormatter ISO_LOCAL_TIME() {
        return DateTimeFormatter$.MODULE$.ISO_LOCAL_TIME();
    }

    public static DateTimeFormatter ISO_OFFSET_DATE() {
        return DateTimeFormatter$.MODULE$.ISO_OFFSET_DATE();
    }

    public static DateTimeFormatter ISO_OFFSET_DATE_TIME() {
        return DateTimeFormatter$.MODULE$.ISO_OFFSET_DATE_TIME();
    }

    public static DateTimeFormatter ISO_OFFSET_TIME() {
        return DateTimeFormatter$.MODULE$.ISO_OFFSET_TIME();
    }

    public static DateTimeFormatter ISO_ORDINAL_DATE() {
        return DateTimeFormatter$.MODULE$.ISO_ORDINAL_DATE();
    }

    public static DateTimeFormatter ISO_TIME() {
        return DateTimeFormatter$.MODULE$.ISO_TIME();
    }

    public static DateTimeFormatter ISO_WEEK_DATE() {
        return DateTimeFormatter$.MODULE$.ISO_WEEK_DATE();
    }

    public static DateTimeFormatter ISO_ZONED_DATE_TIME() {
        return DateTimeFormatter$.MODULE$.ISO_ZONED_DATE_TIME();
    }

    public static DateTimeFormatter RFC_1123_DATE_TIME() {
        return DateTimeFormatter$.MODULE$.RFC_1123_DATE_TIME();
    }

    public static DateTimeFormatter ofLocalizedDate(FormatStyle formatStyle) {
        return DateTimeFormatter$.MODULE$.ofLocalizedDate(formatStyle);
    }

    public static DateTimeFormatter ofLocalizedDateTime(FormatStyle formatStyle) {
        return DateTimeFormatter$.MODULE$.ofLocalizedDateTime(formatStyle);
    }

    public static DateTimeFormatter ofLocalizedDateTime(FormatStyle formatStyle, FormatStyle formatStyle2) {
        return DateTimeFormatter$.MODULE$.ofLocalizedDateTime(formatStyle, formatStyle2);
    }

    public static DateTimeFormatter ofLocalizedTime(FormatStyle formatStyle) {
        return DateTimeFormatter$.MODULE$.ofLocalizedTime(formatStyle);
    }

    public static DateTimeFormatter ofPattern(String string) {
        return DateTimeFormatter$.MODULE$.ofPattern(string);
    }

    public static DateTimeFormatter ofPattern(String string, Locale locale) {
        return DateTimeFormatter$.MODULE$.ofPattern(string, locale);
    }

    public static TemporalQuery<Period> parsedExcessDays() {
        return DateTimeFormatter$.MODULE$.parsedExcessDays();
    }

    public static TemporalQuery<Object> parsedLeapSecond() {
        return DateTimeFormatter$.MODULE$.parsedLeapSecond();
    }

    public DateTimeFormatter(TTBPDateTimeFormatterBuilder.CompositePrinterParser printerParser, Locale locale, DecimalStyle decimalStyle, ResolverStyle resolverStyle, Set<TemporalField> resolverFields, Chronology chrono, ZoneId zone) {
        this.printerParser = printerParser;
        this.locale = locale;
        this.decimalStyle = decimalStyle;
        this.resolverStyle = resolverStyle;
        this.resolverFields = resolverFields;
        this.chrono = chrono;
        this.zone = zone;
        Objects.requireNonNull(printerParser, "printerParser");
        Objects.requireNonNull(locale, "locale");
        Objects.requireNonNull(decimalStyle, "decimalStyle");
        Objects.requireNonNull(resolverStyle, "resolverStyle");
    }

    private TTBPDateTimeFormatterBuilder.CompositePrinterParser printerParser() {
        return this.printerParser;
    }

    private Locale locale() {
        return this.locale;
    }

    private DecimalStyle decimalStyle() {
        return this.decimalStyle;
    }

    private ResolverStyle resolverStyle() {
        return this.resolverStyle;
    }

    private Set<TemporalField> resolverFields() {
        return this.resolverFields;
    }

    private Chronology chrono() {
        return this.chrono;
    }

    private ZoneId zone() {
        return this.zone;
    }

    public Locale getLocale() {
        return this.locale();
    }

    public DateTimeFormatter withLocale(Locale locale) {
        Locale locale2 = this.locale();
        Locale locale3 = locale;
        if (!(locale2 != null ? !((Object)locale2).equals(locale3) : locale3 != null)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser(), locale, this.decimalStyle(), this.resolverStyle(), this.resolverFields(), this.chrono(), this.zone());
    }

    public DecimalStyle getDecimalStyle() {
        return this.decimalStyle();
    }

    public DateTimeFormatter withDecimalStyle(DecimalStyle decimalStyle) {
        DecimalStyle decimalStyle2 = this.decimalStyle();
        DecimalStyle decimalStyle3 = decimalStyle;
        if (!(decimalStyle2 != null ? !((Object)decimalStyle2).equals(decimalStyle3) : decimalStyle3 != null)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser(), this.locale(), decimalStyle, this.resolverStyle(), this.resolverFields(), this.chrono(), this.zone());
    }

    public Chronology getChronology() {
        return this.chrono();
    }

    public DateTimeFormatter withChronology(Chronology chrono) {
        if (Objects.equals(this.chrono(), chrono)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser(), this.locale(), this.decimalStyle(), this.resolverStyle(), this.resolverFields(), chrono, this.zone());
    }

    public ZoneId getZone() {
        return this.zone();
    }

    public DateTimeFormatter withZone(ZoneId zone) {
        if (Objects.equals(this.zone(), zone)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser(), this.locale(), this.decimalStyle(), this.resolverStyle(), this.resolverFields(), this.chrono(), zone);
    }

    public ResolverStyle getResolverStyle() {
        return this.resolverStyle();
    }

    public DateTimeFormatter withResolverStyle(ResolverStyle resolverStyle) {
        Objects.requireNonNull(resolverStyle, "resolverStyle");
        if (Objects.equals((Object)this.resolverStyle(), (Object)resolverStyle)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser(), this.locale(), this.decimalStyle(), resolverStyle, this.resolverFields(), this.chrono(), this.zone());
    }

    public Set<TemporalField> getResolverFields() {
        return this.resolverFields();
    }

    public DateTimeFormatter withResolverFields(Seq<TemporalField> resolverFields) {
        if (resolverFields == null) {
            return new DateTimeFormatter(this.printerParser(), this.locale(), this.decimalStyle(), this.resolverStyle(), null, this.chrono(), this.zone());
        }
        HashSet<TemporalField> fields = new HashSet<TemporalField>(Arrays.asList((TemporalField[])Arrays$.MODULE$.seqToArray(resolverFields, TemporalField.class)));
        if (Objects.equals(this.resolverFields(), fields)) {
            return this;
        }
        return new DateTimeFormatter(this.printerParser(), this.locale(), this.decimalStyle(), this.resolverStyle(), Collections.unmodifiableSet(fields), this.chrono(), this.zone());
    }

    public DateTimeFormatter withResolverFields(Set<TemporalField> resolverFields) {
        if (resolverFields == null) {
            return new DateTimeFormatter(this.printerParser(), this.locale(), this.decimalStyle(), this.resolverStyle(), null, this.chrono(), this.zone());
        }
        if (Objects.equals(this.resolverFields(), resolverFields)) {
            return this;
        }
        Set<TemporalField> _resolverFields = Collections.unmodifiableSet(new HashSet<TemporalField>(resolverFields));
        return new DateTimeFormatter(this.printerParser(), this.locale(), this.decimalStyle(), this.resolverStyle(), _resolverFields, this.chrono(), this.zone());
    }

    public String format(TemporalAccessor temporal) {
        StringBuilder buf = new StringBuilder(32);
        this.formatTo(temporal, buf);
        return buf.toString();
    }

    public void formatTo(TemporalAccessor temporal, Appendable appendable) {
        Objects.requireNonNull(temporal, "temporal");
        Objects.requireNonNull(appendable, "appendable");
        try {
            TTBPDateTimePrintContext context = new TTBPDateTimePrintContext(temporal, this);
            if (appendable instanceof StringBuilder) {
                this.printerParser().print(context, (StringBuilder)appendable);
            } else {
                StringBuilder buf = new StringBuilder(32);
                this.printerParser().print(context, buf);
                appendable.append(buf);
            }
        }
        catch (IOException ex) {
            throw new DateTimeException(ex.getMessage(), ex);
        }
    }

    public TemporalAccessor parse(CharSequence text) {
        DateTimeBuilder dateTimeBuilder;
        Objects.requireNonNull(text, "text");
        try {
            dateTimeBuilder = this.java$time$format$DateTimeFormatter$$parseToBuilder(text, null).resolve(this.resolverStyle(), this.resolverFields());
        }
        catch (DateTimeParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.createError(text, ex);
        }
        return dateTimeBuilder;
    }

    public TemporalAccessor parse(CharSequence text, ParsePosition position) {
        DateTimeBuilder dateTimeBuilder;
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(position, "position");
        try {
            dateTimeBuilder = this.java$time$format$DateTimeFormatter$$parseToBuilder(text, position).resolve(this.resolverStyle(), this.resolverFields());
        }
        catch (DateTimeParseException ex) {
            throw ex;
        }
        catch (IndexOutOfBoundsException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.createError(text, ex);
        }
        return dateTimeBuilder;
    }

    public <T> T parse(CharSequence text, TemporalQuery<T> type) {
        T t;
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(type, "type");
        try {
            DateTimeBuilder builder = this.java$time$format$DateTimeFormatter$$parseToBuilder(text, null).resolve(this.resolverStyle(), this.resolverFields());
            t = builder.build(type);
        }
        catch (DateTimeParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.createError(text, ex);
        }
        return t;
    }

    /*
     * Loose catch block
     */
    public TemporalAccessor parseBest(CharSequence text, Seq<TemporalQuery<?>> types) {
        Object object = new Object();
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(types, "types");
        if (types.length() < 2) {
            throw new IllegalArgumentException("At least two types must be specified");
        }
        try {
            DateTimeBuilder builder = this.java$time$format$DateTimeFormatter$$parseToBuilder(text, null).resolve(this.resolverStyle(), this.resolverFields());
            types.foreach((Function1 & Serializable)tpe -> {
                DateTimeFormatter.parseBest$$anonfun$1(object, builder, tpe);
                return BoxedUnit.UNIT;
            });
            throw new DateTimeException(new StringBuilder(53).append("Unable to convert parsed text to any specified type: ").append(types.mkString("[", ", ", "]")).toString());
        }
        catch (DateTimeParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.createError(text, ex);
            {
                catch (NonLocalReturnControl ex2) {
                    if (ex2.key() != object) {
                        throw ex2;
                    }
                    return (TemporalAccessor)ex2.value();
                }
            }
        }
    }

    public TemporalAccessor parseBest(CharSequence text, TemporalQuery<?> ... types) {
        return this.parseBest(text, (Seq<TemporalQuery<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])types));
    }

    private DateTimeParseException createError(CharSequence text, RuntimeException ex) {
        String abbr = text.length() > 64 ? new StringBuilder(3).append(text.subSequence(0, 64).toString()).append("...").toString() : text.toString();
        return new DateTimeParseException(new StringBuilder(29).append("Text '").append(abbr).append("' could not be parsed: ").append(ex.getMessage()).toString(), text, 0, ex);
    }

    public DateTimeBuilder java$time$format$DateTimeFormatter$$parseToBuilder(CharSequence text, ParsePosition position) {
        ParsePosition pos = position != null ? position : new ParsePosition(0);
        TTBPDateTimeParseContext.Parsed result = this.java$time$format$DateTimeFormatter$$parseUnresolved0(text, pos);
        if (result == null || pos.getErrorIndex() >= 0 || position == null && pos.getIndex() < text.length()) {
            String abbr;
            String string = abbr = text.length() > 64 ? new StringBuilder(3).append(text.subSequence(0, 64).toString()).append("...").toString() : text.toString();
            if (pos.getErrorIndex() >= 0) {
                throw new DateTimeParseException(new StringBuilder(37).append("Text '").append(abbr).append("' could not be parsed at index ").append(pos.getErrorIndex()).toString(), text, pos.getErrorIndex());
            }
            throw new DateTimeParseException(new StringBuilder(58).append("Text '").append(abbr).append("' could not be parsed, unparsed text found at index ").append(pos.getIndex()).toString(), text, pos.getIndex());
        }
        return result.toBuilder();
    }

    public TemporalAccessor parseUnresolved(CharSequence text, ParsePosition position) {
        return this.java$time$format$DateTimeFormatter$$parseUnresolved0(text, position);
    }

    public TTBPDateTimeParseContext.Parsed java$time$format$DateTimeFormatter$$parseUnresolved0(CharSequence text, ParsePosition position) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(position, "position");
        TTBPDateTimeParseContext context = new TTBPDateTimeParseContext(this);
        int pos = this.printerParser().parse(context, text, position.getIndex());
        if (pos < 0) {
            position.setErrorIndex(~pos);
            return null;
        }
        position.setIndex(pos);
        return context.toParsed();
    }

    public TTBPDateTimeFormatterBuilder.CompositePrinterParser toPrinterParser(boolean optional) {
        return this.printerParser().withOptional(optional);
    }

    public Format toFormat() {
        return new ClassicFormat(this, null);
    }

    public Format toFormat(TemporalQuery<? extends Object> query) {
        Objects.requireNonNull(query, "query");
        return new ClassicFormat(this, query);
    }

    public String toString() {
        String pattern = this.printerParser().toString();
        if (pattern.startsWith("[")) {
            return pattern;
        }
        return pattern.substring(1, pattern.length() - 1);
    }

    private static final /* synthetic */ void parseBest$$anonfun$1(Object nonLocalReturnKey1$1, DateTimeBuilder builder$1, TemporalQuery tpe) {
        try {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)((TemporalAccessor)builder$1.build(tpe)));
        }
        catch (RuntimeException runtimeException) {
            return;
        }
    }

    public static class ClassicFormat
    extends Format {
        private final DateTimeFormatter formatter;
        private final TemporalQuery query;

        public ClassicFormat(DateTimeFormatter formatter, TemporalQuery<? extends Object> query) {
            this.formatter = formatter;
            this.query = query;
        }

        private DateTimeFormatter formatter() {
            return this.formatter;
        }

        private TemporalQuery<? extends Object> query() {
            return this.query;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            Objects.requireNonNull(obj, "obj");
            Objects.requireNonNull(toAppendTo, "toAppendTo");
            Objects.requireNonNull(pos, "pos");
            if (!(obj instanceof TemporalAccessor)) {
                throw new IllegalArgumentException("Format target must implement TemporalAccessor");
            }
            pos.setBeginIndex(0);
            pos.setEndIndex(0);
            try {
                this.formatter().formatTo((TemporalAccessor)obj, toAppendTo);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
            return toAppendTo;
        }

        @Override
        public Object parseObject(String text) throws ParseException {
            Object object;
            Objects.requireNonNull(text, "text");
            try {
                if (this.query() == null) {
                    return this.formatter().java$time$format$DateTimeFormatter$$parseToBuilder(text, null).resolve(this.formatter().getResolverStyle(), this.formatter().getResolverFields());
                }
                object = this.formatter().parse((CharSequence)text, this.query());
            }
            catch (DateTimeParseException ex) {
                throw new ParseException(ex.getMessage(), ex.getErrorIndex());
            }
            catch (RuntimeException ex) {
                throw (ParseException)new ParseException(ex.getMessage(), 0).initCause(ex);
            }
            return object;
        }

        @Override
        public Object parseObject(String text, ParsePosition pos) {
            Object object;
            Objects.requireNonNull(text, "text");
            TTBPDateTimeParseContext.Parsed unresolved = null;
            try {
                unresolved = this.formatter().java$time$format$DateTimeFormatter$$parseUnresolved0(text, pos);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (pos.getErrorIndex() < 0) {
                    pos.setErrorIndex(0);
                }
                return null;
            }
            if (unresolved == null) {
                if (pos.getErrorIndex() < 0) {
                    pos.setErrorIndex(0);
                }
                return null;
            }
            try {
                DateTimeBuilder builder = unresolved.toBuilder().resolve(this.formatter().getResolverStyle(), this.formatter().getResolverFields());
                if (this.query() == null) {
                    return builder;
                }
                object = builder.build(this.query());
            }
            catch (RuntimeException runtimeException) {
                pos.setErrorIndex(0);
                object = null;
            }
            return object;
        }
    }
}

