/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.Instant$;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.LocalTime;
import java.time.LocalTime$;
import java.time.Period;
import java.time.Period$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.chrono.IsoChronology$;
import java.time.format.ResolverStyle;
import java.time.format.ResolverStyle$;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DateTimeBuilder
implements TemporalAccessor,
Cloneable {
    private final Map fieldValues = new HashMap();
    private Chronology chrono = null;
    private ZoneId zone = null;
    private ChronoLocalDate date = null;
    private LocalTime time = null;
    private boolean leapSecond = false;
    private Period excessDays = null;

    public DateTimeBuilder() {
    }

    public Map<TemporalField, Long> fieldValues() {
        return this.fieldValues;
    }

    public Chronology chrono() {
        return this.chrono;
    }

    public void chrono_$eq(Chronology x$1) {
        this.chrono = x$1;
    }

    public ZoneId zone() {
        return this.zone;
    }

    public void zone_$eq(ZoneId x$1) {
        this.zone = x$1;
    }

    public ChronoLocalDate date() {
        return this.date;
    }

    public void date_$eq(ChronoLocalDate x$1) {
        this.date = x$1;
    }

    public LocalTime time() {
        return this.time;
    }

    public void time_$eq(LocalTime x$1) {
        this.time = x$1;
    }

    public boolean leapSecond() {
        return this.leapSecond;
    }

    public void leapSecond_$eq(boolean x$1) {
        this.leapSecond = x$1;
    }

    public Period excessDays() {
        return this.excessDays;
    }

    public void excessDays_$eq(Period x$1) {
        this.excessDays = x$1;
    }

    public DateTimeBuilder(TemporalField field, long value) {
        this();
        this.addFieldValue(field, value);
    }

    private Long getFieldValue0(TemporalField field) {
        return this.fieldValues().get(field);
    }

    public DateTimeBuilder addFieldValue(TemporalField field, long value) {
        Objects.requireNonNull(field, "field");
        Long old = this.getFieldValue0(field);
        if (old != null && old != value) {
            throw new DateTimeException(new StringBuilder(34).append("Conflict found: ").append(field).append(" ").append(old).append(" differs from ").append(field).append(" ").append(value).append(": ").append(this).toString());
        }
        return this.putFieldValue0(field, value);
    }

    private DateTimeBuilder putFieldValue0(TemporalField field, long value) {
        this.fieldValues().put(field, Predef$.MODULE$.long2Long(value));
        return this;
    }

    public void addObject(ChronoLocalDate date) {
        this.date_$eq(date);
    }

    public void addObject(LocalTime time) {
        this.time_$eq(time);
    }

    public DateTimeBuilder resolve(ResolverStyle resolverStyle, Set<TemporalField> resolverFields) {
        if (resolverFields != null) {
            this.fieldValues().keySet().retainAll(resolverFields);
        }
        this.mergeInstantFields();
        this.mergeDate(resolverStyle);
        this.mergeTime(resolverStyle);
        if (this.resolveFields(resolverStyle)) {
            this.mergeInstantFields();
            this.mergeDate(resolverStyle);
            this.mergeTime(resolverStyle);
        }
        this.resolveTimeInferZeroes(resolverStyle);
        this.crossCheck();
        if (this.excessDays() != null && !this.excessDays().isZero() && this.date() != null && this.time() != null) {
            this.date_$eq(this.date().plus(this.excessDays()));
            this.excessDays_$eq(Period$.MODULE$.ZERO());
        }
        this.resolveFractional();
        this.resolveInstant();
        return this;
    }

    private boolean resolveFields(ResolverStyle resolverStyle) {
        int changes = 0;
        Iterator<Map.Entry<TemporalField, Long>> entries = this.fieldValues().entrySet().iterator();
        boolean bl = false;
        while (!bl && entries.hasNext()) {
            Map.Entry<TemporalField, Long> entry = entries.next();
            TemporalField targetField = entry.getKey();
            ChronoLocalDateTime resolvedObject = targetField.resolve(this.fieldValues(), this, resolverStyle);
            ChronoLocalDateTime chronoLocalDateTime = resolvedObject;
            if (chronoLocalDateTime instanceof ChronoZonedDateTime) {
                ChronoZonedDateTime czdt = (ChronoZonedDateTime)((Object)chronoLocalDateTime);
                if (this.zone() == null) {
                    this.zone_$eq(czdt.getZone());
                } else {
                    ZoneId zoneId = this.zone();
                    ZoneId zoneId2 = czdt.getZone();
                    if (zoneId == null ? zoneId2 != null : !((Object)zoneId).equals(zoneId2)) {
                        throw new DateTimeException(new StringBuilder(56).append("ChronoZonedDateTime must use the effective parsed zone: ").append(this.zone()).toString());
                    }
                }
                resolvedObject = czdt.toLocalDateTime();
                continue;
            }
            if (chronoLocalDateTime instanceof ChronoLocalDate) {
                ChronoLocalDate cld = (ChronoLocalDate)((Object)chronoLocalDateTime);
                this.resolveMakeChanges(targetField, cld);
                ++changes;
                bl = true;
                continue;
            }
            if (chronoLocalDateTime instanceof LocalTime) {
                LocalTime lt = (LocalTime)((Object)chronoLocalDateTime);
                this.resolveMakeChanges(targetField, lt);
                ++changes;
                bl = true;
                continue;
            }
            if (chronoLocalDateTime instanceof ChronoLocalDateTime) {
                ChronoLocalDateTime cldt = chronoLocalDateTime;
                this.resolveMakeChanges(targetField, (ChronoLocalDate)cldt.toLocalDate());
                this.resolveMakeChanges(targetField, cldt.toLocalTime());
                ++changes;
                bl = true;
                continue;
            }
            if (chronoLocalDateTime == null) {
                if (this.fieldValues().containsKey(targetField)) continue;
                ++changes;
                bl = true;
                continue;
            }
            throw new DateTimeException(new StringBuilder(14).append("Unknown type: ").append(resolvedObject.getClass().getName()).toString());
        }
        if (changes == 100) {
            throw new DateTimeException("Badly written field");
        }
        return changes > 0;
    }

    private void resolveMakeChanges(TemporalField targetField, ChronoLocalDate date) {
        Chronology chronology = this.chrono();
        Chronology chronology2 = date.getChronology();
        if (chronology == null ? chronology2 != null : !((Object)chronology).equals(chronology2)) {
            throw new DateTimeException(new StringBuilder(58).append("ChronoLocalDate must use the effective parsed chronology: ").append(this.chrono()).toString());
        }
        long epochDay = date.toEpochDay();
        Long old = this.fieldValues().put(ChronoField$.EPOCH_DAY, Predef$.MODULE$.long2Long(epochDay));
        if (old != null && old != epochDay) {
            throw new DateTimeException(new StringBuilder(48).append("Conflict found: ").append(LocalDate$.MODULE$.ofEpochDay(Predef$.MODULE$.Long2long(old))).append(" differs from ").append(LocalDate$.MODULE$.ofEpochDay(epochDay)).append(" while resolving  ").append(targetField).toString());
        }
    }

    private void resolveMakeChanges(TemporalField targetField, LocalTime time) {
        long nanOfDay = time.toNanoOfDay();
        Long old = this.fieldValues().put(ChronoField$.NANO_OF_DAY, Predef$.MODULE$.long2Long(nanOfDay));
        if (old != null && old != nanOfDay) {
            throw new DateTimeException(new StringBuilder(48).append("Conflict found: ").append(LocalTime$.MODULE$.ofNanoOfDay(Predef$.MODULE$.Long2long(old))).append(" differs from ").append(time).append(" while resolving  ").append(targetField).toString());
        }
    }

    private void mergeDate(ResolverStyle resolverStyle) {
        if (this.chrono() instanceof IsoChronology) {
            this.checkDate((LocalDate)IsoChronology$.MODULE$.INSTANCE().resolveDate((Map)this.fieldValues(), resolverStyle));
            return;
        }
        if (this.fieldValues().containsKey(ChronoField$.EPOCH_DAY)) {
            this.checkDate(LocalDate$.MODULE$.ofEpochDay(Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.EPOCH_DAY))));
            return;
        }
    }

    private void checkDate(LocalDate date) {
        if (date != null) {
            this.addObject(date);
            Iterator<TemporalField> fields = this.fieldValues().keySet().iterator();
            boolean bl = false;
            while (!bl && fields.hasNext()) {
                long val2;
                TemporalField field = fields.next();
                if (!(field instanceof ChronoField) || !field.isDateBased()) continue;
                long val1 = 0L;
                try {
                    val1 = date.getLong(field);
                }
                catch (DateTimeException dateTimeException) {
                    bl = true;
                }
                if (bl || val1 == (val2 = Predef$.MODULE$.Long2long(this.fieldValues().get(field)))) continue;
                throw new DateTimeException(new StringBuilder(52).append("Conflict found: Field ").append(field).append(" ").append(val1).append(" differs from ").append(field).append(" ").append(val2).append(" derived from ").append(date).toString());
            }
            return;
        }
    }

    private void mergeTime(ResolverStyle resolverStyle) {
        if (this.fieldValues().containsKey(ChronoField$.CLOCK_HOUR_OF_DAY)) {
            long ch = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.CLOCK_HOUR_OF_DAY));
            if (resolverStyle != ResolverStyle$.LENIENT && (resolverStyle != ResolverStyle$.SMART || ch != 0L)) {
                ChronoField$.CLOCK_HOUR_OF_DAY.checkValidValue(ch);
            }
            this.addFieldValue(ChronoField$.HOUR_OF_DAY, ch == 24L ? 0L : ch);
        }
        if (this.fieldValues().containsKey(ChronoField$.CLOCK_HOUR_OF_AMPM)) {
            long ch = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.CLOCK_HOUR_OF_AMPM));
            if (resolverStyle != ResolverStyle$.LENIENT && (resolverStyle != ResolverStyle$.SMART || ch != 0L)) {
                ChronoField$.CLOCK_HOUR_OF_AMPM.checkValidValue(ch);
            }
            this.addFieldValue(ChronoField$.HOUR_OF_AMPM, ch == 12L ? 0L : ch);
        }
        if (resolverStyle != ResolverStyle$.LENIENT) {
            if (this.fieldValues().containsKey(ChronoField$.AMPM_OF_DAY)) {
                ChronoField$.AMPM_OF_DAY.checkValidValue(Predef$.MODULE$.Long2long(this.fieldValues().get(ChronoField$.AMPM_OF_DAY)));
            }
            if (this.fieldValues().containsKey(ChronoField$.HOUR_OF_AMPM)) {
                ChronoField$.HOUR_OF_AMPM.checkValidValue(Predef$.MODULE$.Long2long(this.fieldValues().get(ChronoField$.HOUR_OF_AMPM)));
            }
        }
        if (this.fieldValues().containsKey(ChronoField$.AMPM_OF_DAY) && this.fieldValues().containsKey(ChronoField$.HOUR_OF_AMPM)) {
            long ap = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.AMPM_OF_DAY));
            long hap = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.HOUR_OF_AMPM));
            this.addFieldValue(ChronoField$.HOUR_OF_DAY, ap * 12L + hap);
        }
        if (this.fieldValues().containsKey(ChronoField$.NANO_OF_DAY)) {
            long nod = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.NANO_OF_DAY));
            if (resolverStyle != ResolverStyle$.LENIENT) {
                ChronoField$.NANO_OF_DAY.checkValidValue(nod);
            }
            this.addFieldValue(ChronoField$.SECOND_OF_DAY, nod / 1000000000L);
            this.addFieldValue(ChronoField$.NANO_OF_SECOND, nod % 1000000000L);
        }
        if (this.fieldValues().containsKey(ChronoField$.MICRO_OF_DAY)) {
            long cod = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.MICRO_OF_DAY));
            if (resolverStyle != ResolverStyle$.LENIENT) {
                ChronoField$.MICRO_OF_DAY.checkValidValue(cod);
            }
            this.addFieldValue(ChronoField$.SECOND_OF_DAY, cod / 1000000L);
            this.addFieldValue(ChronoField$.MICRO_OF_SECOND, cod % 1000000L);
        }
        if (this.fieldValues().containsKey(ChronoField$.MILLI_OF_DAY)) {
            long lod = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.MILLI_OF_DAY));
            if (resolverStyle != ResolverStyle$.LENIENT) {
                ChronoField$.MILLI_OF_DAY.checkValidValue(lod);
            }
            this.addFieldValue(ChronoField$.SECOND_OF_DAY, lod / 1000L);
            this.addFieldValue(ChronoField$.MILLI_OF_SECOND, lod % 1000L);
        }
        if (this.fieldValues().containsKey(ChronoField$.SECOND_OF_DAY)) {
            long sod = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.SECOND_OF_DAY));
            if (resolverStyle != ResolverStyle$.LENIENT) {
                ChronoField$.SECOND_OF_DAY.checkValidValue(sod);
            }
            this.addFieldValue(ChronoField$.HOUR_OF_DAY, sod / 3600L);
            this.addFieldValue(ChronoField$.MINUTE_OF_HOUR, sod / 60L % 60L);
            this.addFieldValue(ChronoField$.SECOND_OF_MINUTE, sod % 60L);
        }
        if (this.fieldValues().containsKey(ChronoField$.MINUTE_OF_DAY)) {
            long mod = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.MINUTE_OF_DAY));
            if (resolverStyle != ResolverStyle$.LENIENT) {
                ChronoField$.MINUTE_OF_DAY.checkValidValue(mod);
            }
            this.addFieldValue(ChronoField$.HOUR_OF_DAY, mod / 60L);
            this.addFieldValue(ChronoField$.MINUTE_OF_HOUR, mod % 60L);
        }
        if (resolverStyle != ResolverStyle$.LENIENT) {
            if (this.fieldValues().containsKey(ChronoField$.MILLI_OF_SECOND)) {
                ChronoField$.MILLI_OF_SECOND.checkValidValue(Predef$.MODULE$.Long2long(this.fieldValues().get(ChronoField$.MILLI_OF_SECOND)));
            }
            if (this.fieldValues().containsKey(ChronoField$.MICRO_OF_SECOND)) {
                ChronoField$.MICRO_OF_SECOND.checkValidValue(Predef$.MODULE$.Long2long(this.fieldValues().get(ChronoField$.MICRO_OF_SECOND)));
            }
        }
        if (this.fieldValues().containsKey(ChronoField$.MILLI_OF_SECOND) && this.fieldValues().containsKey(ChronoField$.MICRO_OF_SECOND)) {
            long los = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.MILLI_OF_SECOND));
            long cos = Predef$.MODULE$.Long2long(this.fieldValues().get(ChronoField$.MICRO_OF_SECOND));
            this.addFieldValue(ChronoField$.MICRO_OF_SECOND, los * 1000L + cos % 1000L);
        }
        if (this.fieldValues().containsKey(ChronoField$.MICRO_OF_SECOND) && this.fieldValues().containsKey(ChronoField$.NANO_OF_SECOND)) {
            long nos = Predef$.MODULE$.Long2long(this.fieldValues().get(ChronoField$.NANO_OF_SECOND));
            this.addFieldValue(ChronoField$.MICRO_OF_SECOND, nos / 1000L);
            this.fieldValues().remove(ChronoField$.MICRO_OF_SECOND);
        }
        if (this.fieldValues().containsKey(ChronoField$.MILLI_OF_SECOND) && this.fieldValues().containsKey(ChronoField$.NANO_OF_SECOND)) {
            long nos = Predef$.MODULE$.Long2long(this.fieldValues().get(ChronoField$.NANO_OF_SECOND));
            this.addFieldValue(ChronoField$.MILLI_OF_SECOND, nos / 1000000L);
            this.fieldValues().remove(ChronoField$.MILLI_OF_SECOND);
        }
        if (this.fieldValues().containsKey(ChronoField$.MICRO_OF_SECOND)) {
            long cos = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.MICRO_OF_SECOND));
            this.addFieldValue(ChronoField$.NANO_OF_SECOND, cos * 1000L);
            return;
        }
        if (this.fieldValues().containsKey(ChronoField$.MILLI_OF_SECOND)) {
            long los = Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.MILLI_OF_SECOND));
            this.addFieldValue(ChronoField$.NANO_OF_SECOND, los * 1000000L);
            return;
        }
    }

    private void resolveTimeInferZeroes(ResolverStyle resolverStyle) {
        Long hod = this.fieldValues().get(ChronoField$.HOUR_OF_DAY);
        Long moh = this.fieldValues().get(ChronoField$.MINUTE_OF_HOUR);
        Long som = this.fieldValues().get(ChronoField$.SECOND_OF_MINUTE);
        Long nos = this.fieldValues().get(ChronoField$.NANO_OF_SECOND);
        if (hod == null) {
            return;
        }
        if (moh == null && (som != null || nos != null)) {
            return;
        }
        if (moh != null && som == null && nos != null) {
            return;
        }
        if (resolverStyle != ResolverStyle$.LENIENT) {
            if (hod != null) {
                if (!(resolverStyle != ResolverStyle$.SMART || hod != 24L || moh != null && moh != 0L || som != null && som != 0L || nos != null && nos != 0L)) {
                    hod = Predef$.MODULE$.long2Long(0L);
                    this.excessDays_$eq(Period$.MODULE$.ofDays(1));
                }
                int hodVal = ChronoField$.HOUR_OF_DAY.checkValidIntValue(Predef$.MODULE$.Long2long(hod));
                if (moh != null) {
                    int mohVal = ChronoField$.MINUTE_OF_HOUR.checkValidIntValue(Predef$.MODULE$.Long2long(moh));
                    if (som != null) {
                        int somVal = ChronoField$.SECOND_OF_MINUTE.checkValidIntValue(Predef$.MODULE$.Long2long(som));
                        if (nos != null) {
                            int nosVal = ChronoField$.NANO_OF_SECOND.checkValidIntValue(Predef$.MODULE$.Long2long(nos));
                            this.addObject(LocalTime$.MODULE$.of(hodVal, mohVal, somVal, nosVal));
                        } else {
                            this.addObject(LocalTime$.MODULE$.of(hodVal, mohVal, somVal));
                        }
                    } else if (nos == null) {
                        this.addObject(LocalTime$.MODULE$.of(hodVal, mohVal));
                    }
                } else if (som == null && nos == null) {
                    this.addObject(LocalTime$.MODULE$.of(hodVal, 0));
                }
            }
        } else if (hod != null) {
            long hodVal = Predef$.MODULE$.Long2long(hod);
            if (moh != null) {
                if (som != null) {
                    if (nos == null) {
                        nos = Predef$.MODULE$.long2Long(0L);
                    }
                    long totalNanos = Math.multiplyExact(hodVal, 3600000000000L);
                    totalNanos = Math.addExact(totalNanos, Math.multiplyExact(Predef$.MODULE$.Long2long(moh), 60000000000L));
                    totalNanos = Math.addExact(totalNanos, Math.multiplyExact(Predef$.MODULE$.Long2long(som), 1000000000L));
                    totalNanos = Math.addExact(totalNanos, Predef$.MODULE$.Long2long(nos));
                    int excessDays = (int)Math.floorDiv(totalNanos, 86400000000000L);
                    long nod = Math.floorMod(totalNanos, 86400000000000L);
                    this.addObject(LocalTime$.MODULE$.ofNanoOfDay(nod));
                    this.excessDays_$eq(Period$.MODULE$.ofDays(excessDays));
                } else {
                    long totalSecs = Math.multiplyExact(hodVal, 3600L);
                    totalSecs = Math.addExact(totalSecs, Math.multiplyExact(Predef$.MODULE$.Long2long(moh), 60L));
                    int excessDays = (int)Math.floorDiv(totalSecs, 86400L);
                    long sod = Math.floorMod(totalSecs, 86400L);
                    this.addObject(LocalTime$.MODULE$.ofSecondOfDay(sod));
                    this.excessDays_$eq(Period$.MODULE$.ofDays(excessDays));
                }
            } else {
                int excessDays = Math.toIntExact(Math.floorDiv(hodVal, 24L));
                hodVal = Math.floorMod(hodVal, 24L);
                this.addObject(LocalTime$.MODULE$.of((int)hodVal, 0));
                this.excessDays_$eq(Period$.MODULE$.ofDays(excessDays));
            }
        }
        this.fieldValues().remove(ChronoField$.HOUR_OF_DAY);
        this.fieldValues().remove(ChronoField$.MINUTE_OF_HOUR);
        this.fieldValues().remove(ChronoField$.SECOND_OF_MINUTE);
        this.fieldValues().remove(ChronoField$.NANO_OF_SECOND);
    }

    private void mergeInstantFields() {
        if (this.fieldValues().containsKey(ChronoField$.INSTANT_SECONDS)) {
            if (this.zone() != null) {
                this.mergeInstantFields0(this.zone());
                return;
            }
            Long offsetSecs = this.fieldValues().get(ChronoField$.OFFSET_SECONDS);
            if (offsetSecs != null) {
                ZoneOffset offset = ZoneOffset$.MODULE$.ofTotalSeconds(offsetSecs.intValue());
                this.mergeInstantFields0(offset);
                return;
            }
            return;
        }
    }

    private void mergeInstantFields0(ZoneId selectedZone) {
        Instant instant = Instant$.MODULE$.ofEpochSecond(Predef$.MODULE$.Long2long(this.fieldValues().remove(ChronoField$.INSTANT_SECONDS)));
        ChronoZonedDateTime<? extends ChronoLocalDate> zdt = this.chrono().zonedDateTime(instant, selectedZone);
        if (this.date() == null) {
            this.addObject(zdt.toLocalDate());
        } else {
            this.resolveMakeChanges((TemporalField)ChronoField$.INSTANT_SECONDS, zdt.toLocalDate());
        }
        this.addFieldValue(ChronoField$.SECOND_OF_DAY, zdt.toLocalTime().toSecondOfDay());
    }

    private void crossCheck() {
        if (this.fieldValues().size() > 0) {
            if (this.date() != null && this.time() != null) {
                this.crossCheck(this.date().atTime(this.time()));
                return;
            }
            if (this.date() != null) {
                this.crossCheck(this.date());
                return;
            }
            if (this.time() != null) {
                this.crossCheck(this.time());
                return;
            }
            return;
        }
    }

    private void crossCheck(TemporalAccessor temporal) {
        Iterator<Map.Entry<TemporalField, Long>> it = this.fieldValues().entrySet().iterator();
        boolean bl = false;
        while (!bl && it.hasNext()) {
            Boolean bl2;
            Map.Entry<TemporalField, Long> entry = it.next();
            TemporalField field = entry.getKey();
            long value = Predef$.MODULE$.Long2long(entry.getValue());
            if (!temporal.isSupported(field)) continue;
            long temporalValue = 0L;
            try {
                temporalValue = temporal.getLong(field);
                bl2 = BoxedUnit.UNIT;
            }
            catch (RuntimeException runtimeException) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)bl);
            }
            if (bl) continue;
            if (temporalValue != value) {
                throw new DateTimeException(new StringBuilder(26).append("Cross check failed: ").append(field).append(" ").append(temporalValue).append(" vs ").append(field).append(" ").append(value).toString());
            }
            it.remove();
        }
    }

    private void resolveFractional() {
        if (this.time() == null && (this.fieldValues().containsKey(ChronoField$.INSTANT_SECONDS) || this.fieldValues().containsKey(ChronoField$.SECOND_OF_DAY) || this.fieldValues().containsKey(ChronoField$.SECOND_OF_MINUTE))) {
            if (this.fieldValues().containsKey(ChronoField$.NANO_OF_SECOND)) {
                long nos = Predef$.MODULE$.Long2long(this.fieldValues().get(ChronoField$.NANO_OF_SECOND));
                this.fieldValues().put(ChronoField$.MICRO_OF_SECOND, Predef$.MODULE$.long2Long(nos / 1000L));
                this.fieldValues().put(ChronoField$.MILLI_OF_SECOND, Predef$.MODULE$.long2Long(nos / 1000000L));
                return;
            }
            this.fieldValues().put(ChronoField$.NANO_OF_SECOND, Predef$.MODULE$.long2Long(0L));
            this.fieldValues().put(ChronoField$.MICRO_OF_SECOND, Predef$.MODULE$.long2Long(0L));
            this.fieldValues().put(ChronoField$.MILLI_OF_SECOND, Predef$.MODULE$.long2Long(0L));
            return;
        }
    }

    private void resolveInstant() {
        if (this.date() != null && this.time() != null) {
            Long offsetSecs = this.fieldValues().get(ChronoField$.OFFSET_SECONDS);
            if (offsetSecs != null) {
                ZoneOffset offset = ZoneOffset$.MODULE$.ofTotalSeconds(offsetSecs.intValue());
                long instant = this.date().atTime(this.time()).atZone(offset).getLong(ChronoField$.INSTANT_SECONDS);
                this.fieldValues().put(ChronoField$.INSTANT_SECONDS, Predef$.MODULE$.long2Long(instant));
            } else if (this.zone() != null) {
                long instant = this.date().atTime(this.time()).atZone(this.zone()).getLong(ChronoField$.INSTANT_SECONDS);
                this.fieldValues().put(ChronoField$.INSTANT_SECONDS, Predef$.MODULE$.long2Long(instant));
            }
            return;
        }
    }

    public <R> R build(TemporalQuery<R> tpe) {
        return tpe.queryFrom(this);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field == null) {
            return false;
        }
        return this.fieldValues().containsKey(field) || this.date() != null && this.date().isSupported(field) || this.time() != null && this.time().isSupported(field);
    }

    @Override
    public long getLong(TemporalField field) {
        Objects.requireNonNull(field, "field");
        Long value = this.getFieldValue0(field);
        if (value == null) {
            if (this.date() != null && this.date().isSupported(field)) {
                return this.date().getLong(field);
            }
            if (this.time() != null && this.time().isSupported(field)) {
                return this.time().getLong(field);
            }
            throw new DateTimeException(new StringBuilder(17).append("Field not found: ").append(field).toString());
        }
        return Predef$.MODULE$.Long2long(value);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries$.MODULE$.zoneId()) {
            return (R)this.zone();
        }
        if (query == TemporalQueries$.MODULE$.chronology()) {
            return (R)this.chrono();
        }
        if (query == TemporalQueries$.MODULE$.localDate()) {
            if (this.date() != null) {
                return (R)LocalDate$.MODULE$.from(this.date());
            }
            return null;
        }
        if (query == TemporalQueries$.MODULE$.localTime()) {
            return (R)this.time();
        }
        if (query == TemporalQueries$.MODULE$.zone() || query == TemporalQueries$.MODULE$.offset()) {
            return query.queryFrom(this);
        }
        if (query == TemporalQueries$.MODULE$.precision()) {
            return null;
        }
        return query.queryFrom(this);
    }

    public String toString() {
        String fields = this.fieldValues().size() > 0 ? new StringBuilder(9).append("fields=").append(this.fieldValues()).append(", ").toString() : "";
        return new StringBuilder(24).append("DateTimeBuilder[").append(fields).append(" ").append(this.chrono()).append(", ").append(this.zone()).append(", ").append(this.date()).append(", ").append(this.time()).append("]").toString();
    }
}

