/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateImpl;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.MinguoChronology;
import java.time.chrono.MinguoChronology$;
import java.time.chrono.MinguoDate$;
import java.time.chrono.MinguoEra;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.temporal.ValueRange$;
import java.util.Objects;

public final class MinguoDate
extends ChronoLocalDateImpl<MinguoDate> {
    private final LocalDate isoDate;

    public static MinguoDate from(TemporalAccessor temporalAccessor) {
        return MinguoDate$.MODULE$.from(temporalAccessor);
    }

    public static MinguoDate now() {
        return MinguoDate$.MODULE$.now();
    }

    public static MinguoDate now(Clock clock) {
        return MinguoDate$.MODULE$.now(clock);
    }

    public static MinguoDate now(ZoneId zoneId) {
        return MinguoDate$.MODULE$.now(zoneId);
    }

    public static MinguoDate of(int n, int n2, int n3) {
        return MinguoDate$.MODULE$.of(n, n2, n3);
    }

    public MinguoDate(LocalDate isoDate) {
        this.isoDate = isoDate;
        Objects.requireNonNull(isoDate, "date");
    }

    private LocalDate isoDate() {
        return this.isoDate;
    }

    @Override
    public MinguoChronology getChronology() {
        return MinguoChronology$.MODULE$.INSTANCE();
    }

    @Override
    public MinguoEra getEra() {
        return (MinguoEra)ChronoLocalDate.getEra$(this);
    }

    @Override
    public int lengthOfMonth() {
        return this.isoDate().lengthOfMonth();
    }

    @Override
    public ValueRange range(TemporalField field) {
        block4: {
            block5: {
                ChronoField chronoField;
                ChronoField f;
                block12: {
                    block7: {
                        ChronoField chronoField2;
                        ChronoField chronoField3;
                        block11: {
                            block10: {
                                ChronoField chronoField4;
                                ChronoField chronoField5;
                                block9: {
                                    block8: {
                                        ChronoField chronoField6;
                                        ChronoField chronoField7;
                                        block6: {
                                            if (!(field instanceof ChronoField)) break block4;
                                            if (!this.isSupported(field)) break block5;
                                            chronoField = f = (ChronoField)field;
                                            chronoField7 = ChronoField$.DAY_OF_MONTH;
                                            chronoField6 = chronoField;
                                            if (chronoField7 != null) break block6;
                                            if (chronoField6 == null) break block7;
                                            break block8;
                                        }
                                        if (chronoField7.equals(chronoField6)) break block7;
                                    }
                                    chronoField5 = ChronoField$.DAY_OF_YEAR;
                                    chronoField4 = chronoField;
                                    if (chronoField5 != null) break block9;
                                    if (chronoField4 == null) break block7;
                                    break block10;
                                }
                                if (chronoField5.equals(chronoField4)) break block7;
                            }
                            chronoField3 = ChronoField$.ALIGNED_WEEK_OF_MONTH;
                            chronoField2 = chronoField;
                            if (chronoField3 != null) break block11;
                            if (chronoField2 == null) break block7;
                            break block12;
                        }
                        if (!chronoField3.equals(chronoField2)) break block12;
                    }
                    return this.isoDate().range(field);
                }
                ChronoField chronoField8 = ChronoField$.YEAR_OF_ERA;
                ChronoField chronoField9 = chronoField;
                if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                    ValueRange range = ChronoField$.YEAR.range();
                    long max = this.getProlepticYear() <= 0 ? -range.getMinimum() + 1L + (long)MinguoChronology$.MODULE$.YEARS_DIFFERENCE() : range.getMaximum() - (long)MinguoChronology$.MODULE$.YEARS_DIFFERENCE();
                    return ValueRange$.MODULE$.of(1L, max);
                }
                return this.getChronology().range(f);
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)field;
            ChronoField chronoField2 = ChronoField$.PROLEPTIC_MONTH;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.getProlepticMonth();
            }
            ChronoField chronoField4 = ChronoField$.YEAR_OF_ERA;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                int prolepticYear = this.getProlepticYear();
                if (prolepticYear >= 1) {
                    return prolepticYear;
                }
                return 1L - (long)prolepticYear;
            }
            ChronoField chronoField6 = ChronoField$.YEAR;
            ChronoField chronoField7 = chronoField;
            if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                return this.getProlepticYear();
            }
            ChronoField chronoField8 = ChronoField$.ERA;
            ChronoField chronoField9 = chronoField;
            if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                if (this.getProlepticYear() >= 1) {
                    return 1L;
                }
                return 0L;
            }
            return this.isoDate().getLong(field);
        }
        return field.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.getProlepticYear() * 12L + (long)this.isoDate().getMonthValue() - 1L;
    }

    private int getProlepticYear() {
        return this.isoDate().getYear() - MinguoChronology$.MODULE$.YEARS_DIFFERENCE();
    }

    @Override
    public MinguoDate with(TemporalAdjuster adjuster) {
        return (MinguoDate)ChronoLocalDate.with$(this, adjuster);
    }

    @Override
    public MinguoDate with(TemporalField field, long newValue) {
        block8: {
            block15: {
                ChronoField f;
                block10: {
                    ChronoField chronoField;
                    ChronoField chronoField2;
                    block14: {
                        ChronoField chronoField3;
                        block13: {
                            ChronoField chronoField4;
                            ChronoField chronoField5;
                            block12: {
                                block11: {
                                    ChronoField chronoField6;
                                    ChronoField chronoField7;
                                    block9: {
                                        if (!(field instanceof ChronoField)) break block8;
                                        f = (ChronoField)field;
                                        if (this.getLong(f) == newValue) {
                                            return this;
                                        }
                                        chronoField3 = f;
                                        ChronoField chronoField8 = ChronoField$.PROLEPTIC_MONTH;
                                        ChronoField chronoField9 = chronoField3;
                                        if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                                            this.getChronology().range(f).checkValidValue(newValue, f);
                                            return this.plusMonths(newValue - this.getProlepticMonth());
                                        }
                                        chronoField7 = ChronoField$.YEAR_OF_ERA;
                                        chronoField6 = chronoField3;
                                        if (chronoField7 != null) break block9;
                                        if (chronoField6 == null) break block10;
                                        break block11;
                                    }
                                    if (chronoField7.equals(chronoField6)) break block10;
                                }
                                chronoField5 = ChronoField$.YEAR;
                                chronoField4 = chronoField3;
                                if (chronoField5 != null) break block12;
                                if (chronoField4 == null) break block10;
                                break block13;
                            }
                            if (chronoField5.equals(chronoField4)) break block10;
                        }
                        chronoField2 = ChronoField$.ERA;
                        chronoField = chronoField3;
                        if (chronoField2 != null) break block14;
                        if (chronoField == null) break block10;
                        break block15;
                    }
                    if (!chronoField2.equals(chronoField)) break block15;
                }
                int nvalue = this.getChronology().range(f).checkValidIntValue(newValue, f);
                ChronoField chronoField = f;
                ChronoField chronoField10 = ChronoField$.YEAR_OF_ERA;
                ChronoField chronoField11 = chronoField;
                if (!(chronoField10 != null ? !chronoField10.equals(chronoField11) : chronoField11 != null)) {
                    return this.with(this.isoDate().withYear(this.getProlepticYear() >= 1 ? nvalue + MinguoChronology$.MODULE$.YEARS_DIFFERENCE() : 1 - nvalue + MinguoChronology$.MODULE$.YEARS_DIFFERENCE()));
                }
                ChronoField chronoField12 = ChronoField$.YEAR;
                ChronoField chronoField13 = chronoField;
                if (!(chronoField12 != null ? !chronoField12.equals(chronoField13) : chronoField13 != null)) {
                    return this.with(this.isoDate().withYear(nvalue + MinguoChronology$.MODULE$.YEARS_DIFFERENCE()));
                }
                ChronoField chronoField14 = ChronoField$.ERA;
                ChronoField chronoField15 = chronoField;
                if (!(chronoField14 != null ? !chronoField14.equals(chronoField15) : chronoField15 != null)) {
                    return this.with(this.isoDate().withYear(1 - this.getProlepticYear() + MinguoChronology$.MODULE$.YEARS_DIFFERENCE()));
                }
                throw new UnsupportedOperationException();
            }
            return this.with(this.isoDate().with(field, newValue));
        }
        return field.adjustInto(this, newValue);
    }

    @Override
    public MinguoDate plus(TemporalAmount amount) {
        return (MinguoDate)ChronoLocalDate.plus$(this, amount);
    }

    @Override
    public MinguoDate plus(long amountToAdd, TemporalUnit unit) {
        return (MinguoDate)super.plus(amountToAdd, unit);
    }

    @Override
    public MinguoDate minus(TemporalAmount amount) {
        return (MinguoDate)ChronoLocalDate.minus$(this, amount);
    }

    @Override
    public MinguoDate minus(long amountToAdd, TemporalUnit unit) {
        return (MinguoDate)ChronoLocalDate.minus$(this, amountToAdd, unit);
    }

    public MinguoDate plusYears(long years) {
        return this.with(this.isoDate().plusYears(years));
    }

    public MinguoDate plusMonths(long months) {
        return this.with(this.isoDate().plusMonths(months));
    }

    public MinguoDate plusDays(long days) {
        return this.with(this.isoDate().plusDays(days));
    }

    private MinguoDate with(LocalDate newDate) {
        LocalDate localDate = newDate;
        LocalDate localDate2 = this.isoDate();
        if (!(localDate != null ? !((Object)localDate).equals(localDate2) : localDate2 != null)) {
            return this;
        }
        return new MinguoDate(newDate);
    }

    @Override
    public ChronoLocalDateTime<MinguoDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDate) {
        Period period = this.isoDate().until(endDate);
        return this.getChronology().period(period.getYears(), period.getMonths(), period.getDays());
    }

    @Override
    public long toEpochDay() {
        return this.isoDate().toEpochDay();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof MinguoDate)) return false;
        MinguoDate otherDate = (MinguoDate)object;
        if (this == otherDate) return true;
        LocalDate localDate = this.isoDate();
        LocalDate localDate2 = otherDate.isoDate();
        if (localDate != null) {
            if (!((Object)localDate).equals(localDate2)) return false;
            return true;
        }
        if (localDate2 == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate().hashCode();
    }
}

