/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek$;
import java.time.Instant;
import java.time.LocalDate$;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.time.chrono.IsoChronology$;
import java.time.chrono.MinguoChronology$;
import java.time.chrono.MinguoDate;
import java.time.chrono.MinguoEra;
import java.time.chrono.MinguoEra$;
import java.time.format.ResolverStyle;
import java.time.format.ResolverStyle$;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters$;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.time.temporal.ValueRange$;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import scala.Predef$;
import scala.math.Ordered;

public final class MinguoChronology
implements Ordered,
Chronology,
Serializable {
    private static final long serialVersionUID = 1039765215346859963L;

    public static MinguoChronology INSTANCE() {
        return MinguoChronology$.MODULE$.INSTANCE();
    }

    public static int YEARS_DIFFERENCE() {
        return MinguoChronology$.MODULE$.YEARS_DIFFERENCE();
    }

    public MinguoChronology() {
        Ordered.$init$((Ordered)this);
    }

    private Object readResolve() {
        return MinguoChronology$.MODULE$.INSTANCE();
    }

    @Override
    public String getId() {
        return "Minguo";
    }

    @Override
    public String getCalendarType() {
        return "roc";
    }

    @Override
    public MinguoDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return (MinguoDate)Chronology.date$(this, era, yearOfEra, month, dayOfMonth);
    }

    @Override
    public MinguoDate date(int prolepticYear, int month, int dayOfMonth) {
        return new MinguoDate(LocalDate$.MODULE$.of(prolepticYear + MinguoChronology$.MODULE$.YEARS_DIFFERENCE(), month, dayOfMonth));
    }

    @Override
    public MinguoDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return (MinguoDate)Chronology.dateYearDay$(this, era, yearOfEra, dayOfYear);
    }

    @Override
    public MinguoDate dateYearDay(int prolepticYear, int dayOfYear) {
        return new MinguoDate(LocalDate$.MODULE$.ofYearDay(prolepticYear + MinguoChronology$.MODULE$.YEARS_DIFFERENCE(), dayOfYear));
    }

    @Override
    public MinguoDate dateEpochDay(long epochDay) {
        return new MinguoDate(LocalDate$.MODULE$.ofEpochDay(epochDay));
    }

    @Override
    public MinguoDate date(TemporalAccessor temporal) {
        if (temporal instanceof MinguoDate) {
            return (MinguoDate)temporal;
        }
        return new MinguoDate(LocalDate$.MODULE$.from(temporal));
    }

    public ChronoLocalDateTime<MinguoDate> localDateTime(TemporalAccessor temporal) {
        return Chronology.localDateTime$(this, temporal);
    }

    public ChronoZonedDateTime<MinguoDate> zonedDateTime(TemporalAccessor temporal) {
        return Chronology.zonedDateTime$(this, temporal);
    }

    public ChronoZonedDateTime<MinguoDate> zonedDateTime(Instant instant, ZoneId zone) {
        return Chronology.zonedDateTime$(this, instant, zone);
    }

    @Override
    public MinguoDate dateNow() {
        return (MinguoDate)Chronology.dateNow$(this);
    }

    @Override
    public MinguoDate dateNow(ZoneId zone) {
        return (MinguoDate)Chronology.dateNow$((Chronology)this, zone);
    }

    @Override
    public MinguoDate dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return (MinguoDate)Chronology.dateNow$((Chronology)this, clock);
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return IsoChronology$.MODULE$.INSTANCE().isLeapYear(prolepticYear + (long)MinguoChronology$.MODULE$.YEARS_DIFFERENCE());
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof MinguoEra)) {
            throw new ClassCastException("Era must be MinguoEra");
        }
        if (era == MinguoEra$.ROC) {
            return yearOfEra;
        }
        return 1 - yearOfEra;
    }

    @Override
    public MinguoEra eraOf(int eraValue) {
        return MinguoEra$.MODULE$.of(eraValue);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(MinguoEra$.MODULE$.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        ChronoField chronoField = field;
        ChronoField chronoField2 = ChronoField$.PROLEPTIC_MONTH;
        ChronoField chronoField3 = chronoField;
        if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
            ValueRange range = ChronoField$.PROLEPTIC_MONTH.range();
            return ValueRange$.MODULE$.of(range.getMinimum() - (long)MinguoChronology$.MODULE$.YEARS_DIFFERENCE() * 12L, range.getMaximum() - (long)MinguoChronology$.MODULE$.YEARS_DIFFERENCE() * 12L);
        }
        ChronoField chronoField4 = ChronoField$.YEAR_OF_ERA;
        ChronoField chronoField5 = chronoField;
        if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
            ValueRange range = ChronoField$.YEAR.range();
            return ValueRange$.MODULE$.of(1L, range.getMaximum() - (long)MinguoChronology$.MODULE$.YEARS_DIFFERENCE(), -range.getMinimum() + 1L + (long)MinguoChronology$.MODULE$.YEARS_DIFFERENCE());
        }
        ChronoField chronoField6 = ChronoField$.YEAR;
        ChronoField chronoField7 = chronoField;
        if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
            ValueRange range = ChronoField$.YEAR.range();
            return ValueRange$.MODULE$.of(range.getMinimum() - (long)MinguoChronology$.MODULE$.YEARS_DIFFERENCE(), range.getMaximum() - (long)MinguoChronology$.MODULE$.YEARS_DIFFERENCE());
        }
        return field.range();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MinguoDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long yoeLong;
        if (fieldValues.containsKey(ChronoField$.EPOCH_DAY)) {
            return this.dateEpochDay(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.EPOCH_DAY)));
        }
        Long prolepticMonth = fieldValues.remove(ChronoField$.PROLEPTIC_MONTH);
        if (prolepticMonth != null) {
            if (resolverStyle != ResolverStyle$.LENIENT) {
                ChronoField$.PROLEPTIC_MONTH.checkValidValue(Predef$.MODULE$.Long2long(prolepticMonth));
            }
            this.updateResolveMap((Map)fieldValues, ChronoField$.MONTH_OF_YEAR, (long)Math.floorMod(Predef$.MODULE$.Long2long(prolepticMonth), 12) + 1L);
            this.updateResolveMap((Map)fieldValues, ChronoField$.YEAR, Math.floorDiv(Predef$.MODULE$.Long2long(prolepticMonth), 12));
        }
        if ((yoeLong = fieldValues.remove(ChronoField$.YEAR_OF_ERA)) != null) {
            Long era;
            if (resolverStyle != ResolverStyle$.LENIENT) {
                ChronoField$.YEAR_OF_ERA.checkValidValue(Predef$.MODULE$.Long2long(yoeLong));
            }
            if ((era = fieldValues.remove(ChronoField$.ERA)) == null) {
                Long year = fieldValues.get(ChronoField$.YEAR);
                if (resolverStyle == ResolverStyle$.STRICT) {
                    if (year != null) {
                        this.updateResolveMap((Map)fieldValues, ChronoField$.YEAR, Predef$.MODULE$.Long2long(year) > 0L ? Predef$.MODULE$.Long2long(yoeLong) : Math.subtractExact(1L, Predef$.MODULE$.Long2long(yoeLong)));
                    } else {
                        fieldValues.put(ChronoField$.YEAR_OF_ERA, yoeLong);
                    }
                } else {
                    this.updateResolveMap((Map)fieldValues, ChronoField$.YEAR, year == null || Predef$.MODULE$.Long2long(year) > 0L ? Predef$.MODULE$.Long2long(yoeLong) : Math.subtractExact(1L, Predef$.MODULE$.Long2long(yoeLong)));
                }
            } else if (era == 1L) {
                this.updateResolveMap((Map)fieldValues, ChronoField$.YEAR, Predef$.MODULE$.Long2long(yoeLong));
            } else {
                if (era != 0L) throw new DateTimeException(new StringBuilder(23).append("Invalid value for era: ").append(era).toString());
                this.updateResolveMap((Map)fieldValues, ChronoField$.YEAR, Math.subtractExact(1L, Predef$.MODULE$.Long2long(yoeLong)));
            }
        } else if (fieldValues.containsKey(ChronoField$.ERA)) {
            ChronoField$.ERA.checkValidValue(Predef$.MODULE$.Long2long(fieldValues.get(ChronoField$.ERA)));
        }
        if (!fieldValues.containsKey(ChronoField$.YEAR)) return null;
        if (fieldValues.containsKey(ChronoField$.MONTH_OF_YEAR)) {
            if (fieldValues.containsKey(ChronoField$.DAY_OF_MONTH)) {
                int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
                if (resolverStyle == ResolverStyle$.LENIENT) {
                    long months = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)), 1L);
                    long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_MONTH)), 1L);
                    return this.date(y, 1, 1).plusMonths(months).plusDays(days);
                }
                int moy = this.range(ChronoField$.MONTH_OF_YEAR).checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)), ChronoField$.MONTH_OF_YEAR);
                int dom = this.range(ChronoField$.DAY_OF_MONTH).checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_MONTH)), ChronoField$.DAY_OF_MONTH);
                if (resolverStyle != ResolverStyle$.SMART || dom <= 28) return this.date(y, moy, dom);
                dom = Math.min(dom, this.date(y, moy, 1).lengthOfMonth());
                return this.date(y, moy, dom);
            }
            if (fieldValues.containsKey(ChronoField$.ALIGNED_WEEK_OF_MONTH)) {
                if (fieldValues.containsKey(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH)) {
                    int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
                    if (resolverStyle == ResolverStyle$.LENIENT) {
                        long months = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)), 1L);
                        long weeks = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_MONTH)), 1L);
                        long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH)), 1L);
                        return this.date(y, 1, 1).plus(months, ChronoUnit$.MONTHS).plus(weeks, ChronoUnit$.WEEKS).plus(days, ChronoUnit$.DAYS);
                    }
                    int moy = ChronoField$.MONTH_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)));
                    int aw = ChronoField$.ALIGNED_WEEK_OF_MONTH.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_MONTH)));
                    int ad = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH)));
                    MinguoDate minguoDate = this.date(y, moy, 1).plus(((long)aw - 1L) * 7L + (long)(ad - 1), ChronoUnit$.DAYS);
                    if (resolverStyle != ResolverStyle$.STRICT || minguoDate.get(ChronoField$.MONTH_OF_YEAR) == moy) return minguoDate;
                    throw new DateTimeException("Strict mode rejected date parsed to a different month");
                }
                if (fieldValues.containsKey(ChronoField$.DAY_OF_WEEK)) {
                    int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
                    if (resolverStyle == ResolverStyle$.LENIENT) {
                        long months = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)), 1L);
                        long weeks = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_MONTH)), 1L);
                        long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_WEEK)), 1L);
                        return this.date(y, 1, 1).plus(months, ChronoUnit$.MONTHS).plus(weeks, ChronoUnit$.WEEKS).plus(days, ChronoUnit$.DAYS);
                    }
                    int moy = ChronoField$.MONTH_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)));
                    int aw = ChronoField$.ALIGNED_WEEK_OF_MONTH.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_MONTH)));
                    int dow = ChronoField$.DAY_OF_WEEK.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_WEEK)));
                    MinguoDate minguoDate = this.date(y, moy, 1).plus((long)aw - 1L, ChronoUnit$.WEEKS).with(TemporalAdjusters$.MODULE$.nextOrSame(DayOfWeek$.MODULE$.of(dow)));
                    if (resolverStyle != ResolverStyle$.STRICT || minguoDate.get(ChronoField$.MONTH_OF_YEAR) == moy) return minguoDate;
                    throw new DateTimeException("Strict mode rejected date parsed to a different month");
                }
            }
        }
        if (fieldValues.containsKey(ChronoField$.DAY_OF_YEAR)) {
            int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
            if (resolverStyle == ResolverStyle$.LENIENT) {
                long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_YEAR)), 1L);
                return this.dateYearDay(y, 1).plusDays(days);
            }
            int doy = ChronoField$.DAY_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_YEAR)));
            return this.dateYearDay(y, doy);
        }
        if (!fieldValues.containsKey(ChronoField$.ALIGNED_WEEK_OF_YEAR)) return null;
        if (fieldValues.containsKey(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR)) {
            int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
            if (resolverStyle == ResolverStyle$.LENIENT) {
                long weeks = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_YEAR)), 1L);
                long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR)), 1L);
                return this.date(y, 1, 1).plus(weeks, ChronoUnit$.WEEKS).plus(days, ChronoUnit$.DAYS);
            }
            int aw = ChronoField$.ALIGNED_WEEK_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_YEAR)));
            int ad = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR)));
            MinguoDate minguoDate = this.date(y, 1, 1).plusDays(((long)aw - 1L) * 7L + (long)(ad - 1));
            if (resolverStyle != ResolverStyle$.STRICT || minguoDate.get(ChronoField$.YEAR) == y) return minguoDate;
            throw new DateTimeException("Strict mode rejected date parsed to a different year");
        }
        if (!fieldValues.containsKey(ChronoField$.DAY_OF_WEEK)) return null;
        int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
        if (resolverStyle == ResolverStyle$.LENIENT) {
            long weeks = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_YEAR)), 1L);
            long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_WEEK)), 1L);
            return this.date(y, 1, 1).plus(weeks, ChronoUnit$.WEEKS).plus(days, ChronoUnit$.DAYS);
        }
        int aw = ChronoField$.ALIGNED_WEEK_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_YEAR)));
        int dow = ChronoField$.DAY_OF_WEEK.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_WEEK)));
        MinguoDate minguoDate = this.date(y, 1, 1).plus((long)aw - 1L, ChronoUnit$.WEEKS).with(TemporalAdjusters$.MODULE$.nextOrSame(DayOfWeek$.MODULE$.of(dow)));
        if (resolverStyle != ResolverStyle$.STRICT || minguoDate.get(ChronoField$.YEAR) == y) return minguoDate;
        throw new DateTimeException("Strict mode rejected date parsed to a different month");
    }
}

