/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.Clock;
import java.time.DayOfWeek;
import java.time.DayOfWeek$;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateImpl;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.HijrahChronology;
import java.time.chrono.HijrahChronology$;
import java.time.chrono.HijrahDate$;
import java.time.chrono.HijrahEra;
import java.time.chrono.HijrahEra$;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.temporal.ValueRange$;

public final class HijrahDate
extends ChronoLocalDateImpl<HijrahDate> {
    private static final long serialVersionUID = -5207853542612002020L;
    private final long gregorianEpochDay;
    private transient HijrahEra era;
    private transient int yearOfEra;
    private transient int monthOfYear;
    private transient int dayOfMonth;
    private transient int dayOfYear;
    private transient DayOfWeek dayOfWeek;
    private transient boolean _isLeapYear;

    public static int MAX_VALUE_OF_ERA() {
        return HijrahDate$.MODULE$.MAX_VALUE_OF_ERA();
    }

    public static int MIN_VALUE_OF_ERA() {
        return HijrahDate$.MODULE$.MIN_VALUE_OF_ERA();
    }

    public static void addDeviationAsHijrah(int n, int n2, int n3, int n4, int n5) {
        HijrahDate$.MODULE$.addDeviationAsHijrah(n, n2, n3, n4, n5);
    }

    public static HijrahDate from(TemporalAccessor temporalAccessor) {
        return HijrahDate$.MODULE$.from(temporalAccessor);
    }

    public static int getMaximumDayOfMonth() {
        return HijrahDate$.MODULE$.getMaximumDayOfMonth();
    }

    public static int getMaximumDayOfYear() {
        return HijrahDate$.MODULE$.getMaximumDayOfYear();
    }

    public static int getMonthLength(int n, int n2) {
        return HijrahDate$.MODULE$.getMonthLength(n, n2);
    }

    public static int getSmallestMaximumDayOfMonth() {
        return HijrahDate$.MODULE$.getSmallestMaximumDayOfMonth();
    }

    public static int getSmallestMaximumDayOfYear() {
        return HijrahDate$.MODULE$.getSmallestMaximumDayOfYear();
    }

    public static int getYearLength(int n) {
        return HijrahDate$.MODULE$.getYearLength(n);
    }

    public static HijrahDate now() {
        return HijrahDate$.MODULE$.now();
    }

    public static HijrahDate now(Clock clock) {
        return HijrahDate$.MODULE$.now(clock);
    }

    public static HijrahDate now(ZoneId zoneId) {
        return HijrahDate$.MODULE$.now(zoneId);
    }

    public static HijrahDate of(HijrahEra hijrahEra, int n, int n2, int n3) {
        return HijrahDate$.MODULE$.of(hijrahEra, n, n2, n3);
    }

    public static HijrahDate of(int n, int n2, int n3) {
        return HijrahDate$.MODULE$.of(n, n2, n3);
    }

    public static HijrahDate of(LocalDate localDate) {
        return HijrahDate$.MODULE$.of(localDate);
    }

    public static HijrahDate ofEpochDay(long l) {
        return HijrahDate$.MODULE$.ofEpochDay(l);
    }

    public HijrahDate(long gregorianEpochDay) {
        this.gregorianEpochDay = gregorianEpochDay;
        this.era = null;
        this.yearOfEra = 0;
        this.monthOfYear = 0;
        this.dayOfMonth = 0;
        this.dayOfYear = 0;
        this.dayOfWeek = null;
        this._isLeapYear = false;
        int[] dateInfo = HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$getHijrahDateInfo(gregorianEpochDay);
        HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$checkValidYearOfEra(dateInfo[1]);
        HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$checkValidMonth(dateInfo[2]);
        HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$checkValidDayOfMonth(dateInfo[3]);
        HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$checkValidDayOfYear(dateInfo[4]);
        this.era = HijrahEra$.MODULE$.of(dateInfo[0]);
        this.yearOfEra = dateInfo[1];
        this.monthOfYear = dateInfo[2];
        this.dayOfMonth = dateInfo[3];
        this.dayOfYear = dateInfo[4];
        this.dayOfWeek = DayOfWeek$.MODULE$.of(dateInfo[5]);
        this._isLeapYear = HijrahDate$.MODULE$.isLeapYear(this.yearOfEra);
    }

    private long gregorianEpochDay() {
        return this.gregorianEpochDay;
    }

    private Object readResolve() {
        return new HijrahDate(this.gregorianEpochDay());
    }

    @Override
    public HijrahChronology getChronology() {
        return HijrahChronology$.MODULE$.INSTANCE();
    }

    @Override
    public HijrahEra getEra() {
        return this.era;
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                ChronoField f;
                ChronoField chronoField = f = (ChronoField)field;
                ChronoField chronoField2 = ChronoField$.DAY_OF_MONTH;
                ChronoField chronoField3 = chronoField;
                if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                    return ValueRange$.MODULE$.of(1L, this.lengthOfMonth());
                }
                ChronoField chronoField4 = ChronoField$.DAY_OF_YEAR;
                ChronoField chronoField5 = chronoField;
                if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                    return ValueRange$.MODULE$.of(1L, this.lengthOfYear());
                }
                ChronoField chronoField6 = ChronoField$.ALIGNED_WEEK_OF_MONTH;
                ChronoField chronoField7 = chronoField;
                if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                    return ValueRange$.MODULE$.of(1L, 5L);
                }
                ChronoField chronoField8 = ChronoField$.YEAR_OF_ERA;
                ChronoField chronoField9 = chronoField;
                if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                    return ValueRange$.MODULE$.of(1L, 1000L);
                }
                return this.getChronology().range(f);
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField;
            ChronoField chronoField2 = chronoField = (ChronoField)temporalField;
            ChronoField chronoField3 = ChronoField$.DAY_OF_WEEK;
            ChronoField chronoField4 = chronoField2;
            if (!(chronoField3 != null ? !chronoField3.equals(chronoField4) : chronoField4 != null)) {
                return this.dayOfWeek.getValue();
            }
            ChronoField chronoField5 = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH;
            ChronoField chronoField6 = chronoField2;
            if (!(chronoField5 != null ? !chronoField5.equals(chronoField6) : chronoField6 != null)) {
                return ((long)this.dayOfMonth - 1L) % 7L + 1L;
            }
            ChronoField chronoField7 = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR;
            ChronoField chronoField8 = chronoField2;
            if (!(chronoField7 != null ? !chronoField7.equals(chronoField8) : chronoField8 != null)) {
                return ((long)this.dayOfYear - 1L) % 7L + 1L;
            }
            ChronoField chronoField9 = ChronoField$.DAY_OF_MONTH;
            ChronoField chronoField10 = chronoField2;
            if (!(chronoField9 != null ? !chronoField9.equals(chronoField10) : chronoField10 != null)) {
                return this.dayOfMonth;
            }
            ChronoField chronoField11 = ChronoField$.DAY_OF_YEAR;
            ChronoField chronoField12 = chronoField2;
            if (!(chronoField11 != null ? !chronoField11.equals(chronoField12) : chronoField12 != null)) {
                return this.dayOfYear;
            }
            ChronoField chronoField13 = ChronoField$.EPOCH_DAY;
            ChronoField chronoField14 = chronoField2;
            if (!(chronoField13 != null ? !chronoField13.equals(chronoField14) : chronoField14 != null)) {
                return this.toEpochDay();
            }
            ChronoField chronoField15 = ChronoField$.ALIGNED_WEEK_OF_MONTH;
            ChronoField chronoField16 = chronoField2;
            if (!(chronoField15 != null ? !chronoField15.equals(chronoField16) : chronoField16 != null)) {
                return ((long)this.dayOfMonth - 1L) / 7L + 1L;
            }
            ChronoField chronoField17 = ChronoField$.ALIGNED_WEEK_OF_YEAR;
            ChronoField chronoField18 = chronoField2;
            if (!(chronoField17 != null ? !chronoField17.equals(chronoField18) : chronoField18 != null)) {
                return ((long)this.dayOfYear - 1L) / 7L + 1L;
            }
            ChronoField chronoField19 = ChronoField$.MONTH_OF_YEAR;
            ChronoField chronoField20 = chronoField2;
            if (!(chronoField19 != null ? !chronoField19.equals(chronoField20) : chronoField20 != null)) {
                return this.monthOfYear;
            }
            ChronoField chronoField21 = ChronoField$.YEAR_OF_ERA;
            ChronoField chronoField22 = chronoField2;
            if (!(chronoField21 != null ? !chronoField21.equals(chronoField22) : chronoField22 != null)) {
                return this.yearOfEra;
            }
            ChronoField chronoField23 = ChronoField$.YEAR;
            ChronoField chronoField24 = chronoField2;
            if (!(chronoField23 != null ? !chronoField23.equals(chronoField24) : chronoField24 != null)) {
                return this.yearOfEra;
            }
            ChronoField chronoField25 = ChronoField$.ERA;
            ChronoField chronoField26 = chronoField2;
            if (!(chronoField25 != null ? !chronoField25.equals(chronoField26) : chronoField26 != null)) {
                return this.era.getValue();
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.getFrom(this);
    }

    @Override
    public HijrahDate with(TemporalAdjuster adjuster) {
        return (HijrahDate)ChronoLocalDate.with$(this, adjuster);
    }

    @Override
    public HijrahDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            f.checkValidValue(newValue);
            int nvalue = (int)newValue;
            ChronoField chronoField = f;
            ChronoField chronoField2 = ChronoField$.DAY_OF_WEEK;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.plusDays(newValue - (long)this.dayOfWeek.getValue());
            }
            ChronoField chronoField4 = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.plusDays(newValue - this.getLong(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH));
            }
            ChronoField chronoField6 = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR;
            ChronoField chronoField7 = chronoField;
            if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                return this.plusDays(newValue - this.getLong(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR));
            }
            ChronoField chronoField8 = ChronoField$.DAY_OF_MONTH;
            ChronoField chronoField9 = chronoField;
            if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                return HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$resolvePreviousValid(this.yearOfEra, this.monthOfYear, nvalue);
            }
            ChronoField chronoField10 = ChronoField$.DAY_OF_YEAR;
            ChronoField chronoField11 = chronoField;
            if (!(chronoField10 != null ? !chronoField10.equals(chronoField11) : chronoField11 != null)) {
                return HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$resolvePreviousValid(this.yearOfEra, (nvalue - 1) / 30 + 1, (nvalue - 1) % 30 + 1);
            }
            ChronoField chronoField12 = ChronoField$.EPOCH_DAY;
            ChronoField chronoField13 = chronoField;
            if (!(chronoField12 != null ? !chronoField12.equals(chronoField13) : chronoField13 != null)) {
                return new HijrahDate(nvalue);
            }
            ChronoField chronoField14 = ChronoField$.ALIGNED_WEEK_OF_MONTH;
            ChronoField chronoField15 = chronoField;
            if (!(chronoField14 != null ? !chronoField14.equals(chronoField15) : chronoField15 != null)) {
                return this.plusDays((newValue - this.getLong(ChronoField$.ALIGNED_WEEK_OF_MONTH)) * 7L);
            }
            ChronoField chronoField16 = ChronoField$.ALIGNED_WEEK_OF_YEAR;
            ChronoField chronoField17 = chronoField;
            if (!(chronoField16 != null ? !chronoField16.equals(chronoField17) : chronoField17 != null)) {
                return this.plusDays((newValue - this.getLong(ChronoField$.ALIGNED_WEEK_OF_YEAR)) * 7L);
            }
            ChronoField chronoField18 = ChronoField$.MONTH_OF_YEAR;
            ChronoField chronoField19 = chronoField;
            if (!(chronoField18 != null ? !chronoField18.equals(chronoField19) : chronoField19 != null)) {
                return HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$resolvePreviousValid(this.yearOfEra, nvalue, this.dayOfMonth);
            }
            ChronoField chronoField20 = ChronoField$.YEAR_OF_ERA;
            ChronoField chronoField21 = chronoField;
            if (!(chronoField20 != null ? !chronoField20.equals(chronoField21) : chronoField21 != null)) {
                return HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$resolvePreviousValid(this.yearOfEra >= 1 ? nvalue : 1 - nvalue, this.monthOfYear, this.dayOfMonth);
            }
            ChronoField chronoField22 = ChronoField$.YEAR;
            ChronoField chronoField23 = chronoField;
            if (!(chronoField22 != null ? !chronoField22.equals(chronoField23) : chronoField23 != null)) {
                return HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$resolvePreviousValid(nvalue, this.monthOfYear, this.dayOfMonth);
            }
            ChronoField chronoField24 = ChronoField$.ERA;
            ChronoField chronoField25 = chronoField;
            if (!(chronoField24 != null ? !chronoField24.equals(chronoField25) : chronoField25 != null)) {
                return HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$resolvePreviousValid(1 - this.yearOfEra, this.monthOfYear, this.dayOfMonth);
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.adjustInto(this, newValue);
    }

    @Override
    public HijrahDate plus(TemporalAmount amount) {
        return (HijrahDate)ChronoLocalDate.plus$(this, amount);
    }

    @Override
    public HijrahDate plus(long amountToAdd, TemporalUnit unit) {
        return (HijrahDate)super.plus(amountToAdd, unit);
    }

    @Override
    public HijrahDate minus(TemporalAmount amount) {
        return (HijrahDate)ChronoLocalDate.minus$(this, amount);
    }

    @Override
    public HijrahDate minus(long amountToAdd, TemporalUnit unit) {
        return (HijrahDate)ChronoLocalDate.minus$(this, amountToAdd, unit);
    }

    @Override
    public ChronoLocalDateTime<HijrahDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public long toEpochDay() {
        return HijrahDate$.MODULE$.java$time$chrono$HijrahDate$$$getGregorianEpochDay(this.yearOfEra, this.monthOfYear, this.dayOfMonth);
    }

    @Override
    public boolean isLeapYear() {
        return this._isLeapYear;
    }

    public HijrahDate plusYears(long years) {
        if (years == 0L) {
            return this;
        }
        int newYear = Math.addExact(this.yearOfEra, (int)years);
        return HijrahDate$.MODULE$.of(this.era, newYear, this.monthOfYear, this.dayOfMonth);
    }

    public HijrahDate plusMonths(long months) {
        if (months == 0L) {
            return this;
        }
        int newMonth = this.monthOfYear - 1;
        int years = (newMonth += (int)months) / 12;
        newMonth %= 12;
        while (newMonth < 0) {
            newMonth += 12;
            years = Math.subtractExact(years, 1);
        }
        int newYear = Math.addExact(this.yearOfEra, years);
        return HijrahDate$.MODULE$.of(this.era, newYear, newMonth + 1, this.dayOfMonth);
    }

    public HijrahDate plusDays(long days) {
        return new HijrahDate(this.gregorianEpochDay() + days);
    }

    @Override
    public int lengthOfMonth() {
        return HijrahDate$.MODULE$.getMonthLength(this.monthOfYear - 1, this.yearOfEra);
    }

    @Override
    public int lengthOfYear() {
        return HijrahDate$.MODULE$.getYearLength(this.yearOfEra);
    }
}

