/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.HijrahChronology$;
import java.time.chrono.HijrahDate;
import java.time.chrono.HijrahDateConfigurator$;
import java.time.chrono.HijrahEra;
import java.time.chrono.HijrahEra$;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Objects;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class HijrahDate$
implements Serializable {
    private int[] NUM_DAYS$lzy1;
    private boolean NUM_DAYSbitmap$1;
    private int[] LEAP_NUM_DAYS$lzy1;
    private boolean LEAP_NUM_DAYSbitmap$1;
    private int[] MONTH_LENGTH$lzy1;
    private boolean MONTH_LENGTHbitmap$1;
    private int[] LEAP_MONTH_LENGTH$lzy1;
    private boolean LEAP_MONTH_LENGTHbitmap$1;
    private int[] LEAST_MAX_VALUES$lzy1;
    private boolean LEAST_MAX_VALUESbitmap$1;
    private int[] MAX_VALUES$lzy1;
    private boolean MAX_VALUESbitmap$1;
    private int[] CYCLEYEAR_START_DATE$lzy1;
    private boolean CYCLEYEAR_START_DATEbitmap$1;
    private static final int MAX_ADJUSTED_CYCLE;
    private HashMap ADJUSTED_MONTH_DAYS$lzy1;
    private boolean ADJUSTED_MONTH_DAYSbitmap$1;
    private HashMap ADJUSTED_MONTH_LENGTHS$lzy1;
    private boolean ADJUSTED_MONTH_LENGTHSbitmap$1;
    private HashMap ADJUSTED_CYCLE_YEARS$lzy1;
    private boolean ADJUSTED_CYCLE_YEARSbitmap$1;
    private long[] ADJUSTED_CYCLES$lzy1;
    private boolean ADJUSTED_CYCLESbitmap$1;
    private Integer[] ADJUSTED_LEAST_MAX_VALUES$lzy1;
    private boolean ADJUSTED_LEAST_MAX_VALUESbitmap$1;
    private Integer[] ADJUSTED_MAX_VALUES$lzy1;
    private boolean ADJUSTED_MAX_VALUESbitmap$1;
    private Integer[] DEFAULT_MONTH_DAYS$lzy1;
    private boolean DEFAULT_MONTH_DAYSbitmap$1;
    private Integer[] DEFAULT_LEAP_MONTH_DAYS$lzy1;
    private boolean DEFAULT_LEAP_MONTH_DAYSbitmap$1;
    private Integer[] DEFAULT_MONTH_LENGTHS$lzy1;
    private boolean DEFAULT_MONTH_LENGTHSbitmap$1;
    private Integer[] DEFAULT_LEAP_MONTH_LENGTHS$lzy1;
    private boolean DEFAULT_LEAP_MONTH_LENGTHSbitmap$1;
    private Integer[] DEFAULT_CYCLE_YEARS$lzy1;
    private boolean DEFAULT_CYCLE_YEARSbitmap$1;
    private static final int HIJRAH_JAN_1_1_GREGORIAN_DAY;
    public static final HijrahDate$ MODULE$;

    private HijrahDate$() {
    }

    static {
        MODULE$ = new HijrahDate$();
        int POSITION_DAY_OF_MONTH = 5;
        int POSITION_DAY_OF_YEAR = 6;
        MAX_ADJUSTED_CYCLE = 334;
        HIJRAH_JAN_1_1_GREGORIAN_DAY = -492148;
        try {
            HijrahDateConfigurator$.MODULE$.readDeviationConfig();
        }
        catch (Exception exception) {}
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HijrahDate$.class);
    }

    public final int MIN_VALUE_OF_ERA() {
        return 1;
    }

    public final int MAX_VALUE_OF_ERA() {
        return 9999;
    }

    private int[] NUM_DAYS() {
        if (!this.NUM_DAYSbitmap$1) {
            this.NUM_DAYS$lzy1 = new int[]{0, 30, 59, 89, 118, 148, 177, 207, 236, 266, 295, 325};
            this.NUM_DAYSbitmap$1 = true;
        }
        return this.NUM_DAYS$lzy1;
    }

    private int[] LEAP_NUM_DAYS() {
        if (!this.LEAP_NUM_DAYSbitmap$1) {
            this.LEAP_NUM_DAYS$lzy1 = new int[]{0, 30, 59, 89, 118, 148, 177, 207, 236, 266, 295, 325};
            this.LEAP_NUM_DAYSbitmap$1 = true;
        }
        return this.LEAP_NUM_DAYS$lzy1;
    }

    private int[] MONTH_LENGTH() {
        if (!this.MONTH_LENGTHbitmap$1) {
            this.MONTH_LENGTH$lzy1 = new int[]{30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29};
            this.MONTH_LENGTHbitmap$1 = true;
        }
        return this.MONTH_LENGTH$lzy1;
    }

    private int[] LEAP_MONTH_LENGTH() {
        if (!this.LEAP_MONTH_LENGTHbitmap$1) {
            this.LEAP_MONTH_LENGTH$lzy1 = new int[]{30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 30};
            this.LEAP_MONTH_LENGTHbitmap$1 = true;
        }
        return this.LEAP_MONTH_LENGTH$lzy1;
    }

    private int[] LEAST_MAX_VALUES() {
        if (!this.LEAST_MAX_VALUESbitmap$1) {
            this.LEAST_MAX_VALUES$lzy1 = new int[]{1, 9999, 11, 51, 5, 29, 354};
            this.LEAST_MAX_VALUESbitmap$1 = true;
        }
        return this.LEAST_MAX_VALUES$lzy1;
    }

    private int[] MAX_VALUES() {
        if (!this.MAX_VALUESbitmap$1) {
            this.MAX_VALUES$lzy1 = new int[]{1, 9999, 11, 52, 6, 30, 355};
            this.MAX_VALUESbitmap$1 = true;
        }
        return this.MAX_VALUES$lzy1;
    }

    private int[] CYCLEYEAR_START_DATE() {
        if (!this.CYCLEYEAR_START_DATEbitmap$1) {
            this.CYCLEYEAR_START_DATE$lzy1 = new int[]{0, 354, 709, 1063, 1417, 1772, 2126, 2481, 2835, 3189, 3544, 3898, 4252, 4607, 4961, 5315, 5670, 6024, 6379, 6733, 7087, 7442, 7796, 8150, 8505, 8859, 9214, 9568, 9922, 10277};
            this.CYCLEYEAR_START_DATEbitmap$1 = true;
        }
        return this.CYCLEYEAR_START_DATE$lzy1;
    }

    private HashMap<Integer, Integer[]> ADJUSTED_MONTH_DAYS() {
        if (!this.ADJUSTED_MONTH_DAYSbitmap$1) {
            this.ADJUSTED_MONTH_DAYS$lzy1 = new HashMap();
            this.ADJUSTED_MONTH_DAYSbitmap$1 = true;
        }
        return this.ADJUSTED_MONTH_DAYS$lzy1;
    }

    private HashMap<Integer, Integer[]> ADJUSTED_MONTH_LENGTHS() {
        if (!this.ADJUSTED_MONTH_LENGTHSbitmap$1) {
            this.ADJUSTED_MONTH_LENGTHS$lzy1 = new HashMap();
            this.ADJUSTED_MONTH_LENGTHSbitmap$1 = true;
        }
        return this.ADJUSTED_MONTH_LENGTHS$lzy1;
    }

    private HashMap<Integer, Integer[]> ADJUSTED_CYCLE_YEARS() {
        if (!this.ADJUSTED_CYCLE_YEARSbitmap$1) {
            this.ADJUSTED_CYCLE_YEARS$lzy1 = new HashMap();
            this.ADJUSTED_CYCLE_YEARSbitmap$1 = true;
        }
        return this.ADJUSTED_CYCLE_YEARS$lzy1;
    }

    /*
     * WARNING - void declaration
     */
    private long[] ADJUSTED_CYCLES() {
        if (!this.ADJUSTED_CYCLESbitmap$1) {
            void var1_1;
            long[] cycles = new long[MAX_ADJUSTED_CYCLE];
            for (int i = 0; i < MAX_ADJUSTED_CYCLE; ++i) {
                cycles[i] = Predef$.MODULE$.Long2long(Long.valueOf(10631L * (long)i));
            }
            this.ADJUSTED_CYCLES$lzy1 = var1_1;
            this.ADJUSTED_CYCLESbitmap$1 = true;
        }
        return this.ADJUSTED_CYCLES$lzy1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer[] ADJUSTED_LEAST_MAX_VALUES() {
        if (!this.ADJUSTED_LEAST_MAX_VALUESbitmap$1) {
            void var1_1;
            Integer[] values = new Integer[this.LEAST_MAX_VALUES().length];
            for (int i = 0; i < this.LEAST_MAX_VALUES().length; ++i) {
                values[i] = this.LEAST_MAX_VALUES()[i];
            }
            this.ADJUSTED_LEAST_MAX_VALUES$lzy1 = var1_1;
            this.ADJUSTED_LEAST_MAX_VALUESbitmap$1 = true;
        }
        return this.ADJUSTED_LEAST_MAX_VALUES$lzy1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer[] ADJUSTED_MAX_VALUES() {
        if (!this.ADJUSTED_MAX_VALUESbitmap$1) {
            void var1_1;
            Integer[] values = new Integer[this.MAX_VALUES().length];
            for (int i = 0; i < this.MAX_VALUES().length; ++i) {
                values[i] = this.MAX_VALUES()[i];
            }
            this.ADJUSTED_MAX_VALUES$lzy1 = var1_1;
            this.ADJUSTED_MAX_VALUESbitmap$1 = true;
        }
        return this.ADJUSTED_MAX_VALUES$lzy1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer[] DEFAULT_MONTH_DAYS() {
        if (!this.DEFAULT_MONTH_DAYSbitmap$1) {
            void var1_1;
            Integer[] days = new Integer[this.NUM_DAYS().length];
            for (int i = 0; i < this.NUM_DAYS().length; ++i) {
                days[i] = this.NUM_DAYS()[i];
            }
            this.DEFAULT_MONTH_DAYS$lzy1 = var1_1;
            this.DEFAULT_MONTH_DAYSbitmap$1 = true;
        }
        return this.DEFAULT_MONTH_DAYS$lzy1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer[] DEFAULT_LEAP_MONTH_DAYS() {
        if (!this.DEFAULT_LEAP_MONTH_DAYSbitmap$1) {
            void var1_1;
            Integer[] days = new Integer[this.LEAP_NUM_DAYS().length];
            for (int i = 0; i < this.LEAP_NUM_DAYS().length; ++i) {
                days[i] = this.LEAP_NUM_DAYS()[i];
            }
            this.DEFAULT_LEAP_MONTH_DAYS$lzy1 = var1_1;
            this.DEFAULT_LEAP_MONTH_DAYSbitmap$1 = true;
        }
        return this.DEFAULT_LEAP_MONTH_DAYS$lzy1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer[] DEFAULT_MONTH_LENGTHS() {
        if (!this.DEFAULT_MONTH_LENGTHSbitmap$1) {
            void var1_1;
            Integer[] lengths = new Integer[this.MONTH_LENGTH().length];
            for (int i = 0; i < this.MONTH_LENGTH().length; ++i) {
                lengths[i] = this.MONTH_LENGTH()[i];
            }
            this.DEFAULT_MONTH_LENGTHS$lzy1 = var1_1;
            this.DEFAULT_MONTH_LENGTHSbitmap$1 = true;
        }
        return this.DEFAULT_MONTH_LENGTHS$lzy1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer[] DEFAULT_LEAP_MONTH_LENGTHS() {
        if (!this.DEFAULT_LEAP_MONTH_LENGTHSbitmap$1) {
            void var1_1;
            Integer[] lengths = new Integer[this.LEAP_MONTH_LENGTH().length];
            for (int i = 0; i < this.LEAP_MONTH_LENGTH().length; ++i) {
                lengths[i] = this.LEAP_MONTH_LENGTH()[i];
            }
            this.DEFAULT_LEAP_MONTH_LENGTHS$lzy1 = var1_1;
            this.DEFAULT_LEAP_MONTH_LENGTHSbitmap$1 = true;
        }
        return this.DEFAULT_LEAP_MONTH_LENGTHS$lzy1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer[] DEFAULT_CYCLE_YEARS() {
        if (!this.DEFAULT_CYCLE_YEARSbitmap$1) {
            void var1_1;
            Integer[] years = new Integer[this.CYCLEYEAR_START_DATE().length];
            for (int i = 0; i < this.CYCLEYEAR_START_DATE().length; ++i) {
                years[i] = this.CYCLEYEAR_START_DATE()[i];
            }
            this.DEFAULT_CYCLE_YEARS$lzy1 = var1_1;
            this.DEFAULT_CYCLE_YEARSbitmap$1 = true;
        }
        return this.DEFAULT_CYCLE_YEARS$lzy1;
    }

    public HijrahDate now() {
        return this.now(Clock$.MODULE$.systemDefaultZone());
    }

    public HijrahDate now(ZoneId zone) {
        return this.now(Clock$.MODULE$.system(zone));
    }

    public HijrahDate now(Clock clock) {
        return HijrahChronology$.MODULE$.INSTANCE().dateNow(clock);
    }

    public HijrahDate of(int prolepticYear, int monthOfYear, int dayOfMonth) {
        if (prolepticYear >= 1) {
            return this.of(HijrahEra$.AH, prolepticYear, monthOfYear, dayOfMonth);
        }
        return this.of(HijrahEra$.MODULE$.of(0), 1 - prolepticYear, monthOfYear, dayOfMonth);
    }

    public HijrahDate of(HijrahEra era, int yearOfEra, int monthOfYear, int dayOfMonth) {
        Objects.requireNonNull(era, "era");
        this.java$time$chrono$HijrahDate$$$checkValidYearOfEra(yearOfEra);
        this.java$time$chrono$HijrahDate$$$checkValidMonth(monthOfYear);
        this.java$time$chrono$HijrahDate$$$checkValidDayOfMonth(dayOfMonth);
        long gregorianDays = this.java$time$chrono$HijrahDate$$$getGregorianEpochDay(this.prolepticYear$1(era, yearOfEra), monthOfYear, dayOfMonth);
        return new HijrahDate(gregorianDays);
    }

    public void java$time$chrono$HijrahDate$$$checkValidYearOfEra(int yearOfEra) {
        if (yearOfEra < 1 || yearOfEra > 9999) {
            throw new DateTimeException("Invalid year of Hijrah Era");
        }
    }

    public void java$time$chrono$HijrahDate$$$checkValidDayOfYear(int dayOfYear) {
        if (dayOfYear < 1 || dayOfYear > this.getMaximumDayOfYear()) {
            throw new DateTimeException("Invalid day of year of Hijrah date");
        }
    }

    public void java$time$chrono$HijrahDate$$$checkValidMonth(int month) {
        if (month < 1 || month > 12) {
            throw new DateTimeException("Invalid month of Hijrah date");
        }
    }

    public void java$time$chrono$HijrahDate$$$checkValidDayOfMonth(int dayOfMonth) {
        if (dayOfMonth < 1 || dayOfMonth > this.getMaximumDayOfMonth()) {
            throw new DateTimeException(new StringBuilder(70).append("Invalid day of month of Hijrah date, day ").append(dayOfMonth).append(" greater than ").append(this.getMaximumDayOfMonth()).append(" or less than 1").toString());
        }
    }

    public HijrahDate of(LocalDate date) {
        long gregorianDays = date.toEpochDay();
        return new HijrahDate(gregorianDays);
    }

    public HijrahDate ofEpochDay(long epochDay) {
        return new HijrahDate(epochDay);
    }

    public HijrahDate from(TemporalAccessor temporal) {
        return HijrahChronology$.MODULE$.INSTANCE().date(temporal);
    }

    public HijrahDate java$time$chrono$HijrahDate$$$resolvePreviousValid(int yearOfEra, int month, int day) {
        int _day = day;
        int monthDays = this.getMonthDays(month - 1, yearOfEra);
        if (_day > monthDays) {
            _day = monthDays;
        }
        return this.of(yearOfEra, month, _day);
    }

    public int[] java$time$chrono$HijrahDate$$$getHijrahDateInfo(long gregorianDays) {
        int era = 0;
        int year = 0;
        int month = 0;
        int date = 0;
        int dayOfWeek = 0;
        int dayOfYear = 0;
        int cycleNumber = 0;
        int yearInCycle = 0;
        int dayOfCycle = 0;
        long epochDay = gregorianDays - (long)HIJRAH_JAN_1_1_GREGORIAN_DAY;
        if (epochDay >= 0L) {
            cycleNumber = this.getCycleNumber(epochDay);
            dayOfCycle = this.getDayOfCycle(epochDay, cycleNumber);
            yearInCycle = this.getYearInCycle(cycleNumber, dayOfCycle);
            dayOfYear = this.getDayOfYear(cycleNumber, dayOfCycle, yearInCycle);
            year = cycleNumber * 30 + yearInCycle + 1;
            month = this.getMonthOfYear(dayOfYear, year);
            date = this.getDayOfMonth(dayOfYear, month, year);
            ++date;
            era = HijrahEra$.AH.getValue();
        } else {
            cycleNumber = (int)epochDay / 10631;
            dayOfCycle = (int)epochDay % 10631;
            if (dayOfCycle == 0) {
                dayOfCycle = -10631;
                ++cycleNumber;
            }
            yearInCycle = this.getYearInCycle(cycleNumber, dayOfCycle);
            dayOfYear = this.getDayOfYear(cycleNumber, dayOfCycle, yearInCycle);
            year = cycleNumber * 30 - yearInCycle;
            dayOfYear = this.isLeapYear(year = 1 - year) ? dayOfYear + 355 : dayOfYear + 354;
            month = this.getMonthOfYear(dayOfYear, year);
            date = this.getDayOfMonth(dayOfYear, month, year);
            ++date;
            era = HijrahEra$.MODULE$.of(0).getValue();
        }
        dayOfWeek = (int)((epochDay + 5L) % 7L);
        return new int[]{era, year, month + 1, date, dayOfYear + 1, dayOfWeek += dayOfWeek <= 0 ? 7 : 0};
    }

    public long java$time$chrono$HijrahDate$$$getGregorianEpochDay(int prolepticYear, int monthOfYear, int dayOfMonth) {
        long day = this.yearToGregorianEpochDay(prolepticYear);
        day += (long)this.getMonthDays(monthOfYear - 1, prolepticYear);
        return day += (long)dayOfMonth;
    }

    private long yearToGregorianEpochDay(int prolepticYear) {
        int cycleNumber = (prolepticYear - 1) / 30;
        int yearInCycle = (prolepticYear - 1) % 30;
        int dayInCycle = this.getAdjustedCycle(cycleNumber)[Math.abs(yearInCycle)];
        if (yearInCycle < 0) {
            dayInCycle = -dayInCycle;
        }
        Long cycleDays = null;
        try {
            cycleDays = Predef$.MODULE$.long2Long(this.ADJUSTED_CYCLES()[cycleNumber]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            cycleDays = null;
        }
        if (cycleDays == null) {
            cycleDays = (long)cycleNumber * 10631L;
        }
        return cycleDays + (long)dayInCycle + (long)HIJRAH_JAN_1_1_GREGORIAN_DAY - 1L;
    }

    private int getCycleNumber(long epochDay) {
        long[] days = this.ADJUSTED_CYCLES();
        int cycleNumber = 0;
        try {
            for (int i = 0; i < days.length; ++i) {
                if (epochDay >= Predef$.MODULE$.long2Long(days[i])) continue;
                return i - 1;
            }
            cycleNumber = (int)epochDay / 10631;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            cycleNumber = (int)epochDay / 10631;
        }
        return cycleNumber;
    }

    private int getDayOfCycle(long epochDay, int cycleNumber) {
        Long day = null;
        try {
            day = Predef$.MODULE$.long2Long(this.ADJUSTED_CYCLES()[cycleNumber]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            day = null;
        }
        if (day == null) {
            day = (long)cycleNumber * 10631L;
        }
        return (int)(epochDay - day);
    }

    private int getYearInCycle(int cycleNumber, long dayOfCycle) {
        long _dayOfCycle = dayOfCycle;
        Integer[] cycles = this.getAdjustedCycle(cycleNumber);
        if (_dayOfCycle == 0L) {
            return 0;
        }
        if (_dayOfCycle > 0L) {
            for (int i = 0; i < cycles.length; ++i) {
                if (_dayOfCycle >= (long)cycles[i].intValue()) continue;
                return i - 1;
            }
            return 29;
        }
        _dayOfCycle = -_dayOfCycle;
        for (int i = 0; i < cycles.length; ++i) {
            if (_dayOfCycle > (long)cycles[i].intValue()) continue;
            return i - 1;
        }
        return 29;
    }

    private Integer[] getAdjustedCycle(int cycleNumber) {
        Integer[] cycles = null;
        try {
            cycles = this.ADJUSTED_CYCLE_YEARS().get(cycleNumber);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            cycles = null;
        }
        if (cycles == null) {
            cycles = this.DEFAULT_CYCLE_YEARS();
        }
        return cycles;
    }

    private Integer[] getAdjustedMonthDays(int year) {
        Integer[] newMonths = null;
        try {
            newMonths = this.ADJUSTED_MONTH_DAYS().get(year);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            newMonths = null;
        }
        if (newMonths == null) {
            newMonths = this.isLeapYear(year) ? this.DEFAULT_LEAP_MONTH_DAYS() : this.DEFAULT_MONTH_DAYS();
        }
        return newMonths;
    }

    private Integer[] getAdjustedMonthLength(int year) {
        Integer[] newMonths = null;
        try {
            newMonths = this.ADJUSTED_MONTH_LENGTHS().get(year);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            newMonths = null;
        }
        if (newMonths == null) {
            newMonths = this.isLeapYear(year) ? this.DEFAULT_LEAP_MONTH_LENGTHS() : this.DEFAULT_MONTH_LENGTHS();
        }
        return newMonths;
    }

    private int getDayOfYear(int cycleNumber, int dayOfCycle, int yearInCycle) {
        Integer[] cycles = this.getAdjustedCycle(cycleNumber);
        if (dayOfCycle > 0) {
            return dayOfCycle - cycles[yearInCycle];
        }
        return cycles[yearInCycle] + dayOfCycle;
    }

    private int getMonthOfYear(int dayOfYear, int year) {
        int _dayOfYear = dayOfYear;
        Integer[] newMonths = this.getAdjustedMonthDays(year);
        if (_dayOfYear >= 0) {
            for (int i = 0; i < newMonths.length; ++i) {
                if (_dayOfYear >= newMonths[i]) continue;
                return i - 1;
            }
            return 11;
        }
        _dayOfYear = this.isLeapYear(year) ? _dayOfYear + 355 : _dayOfYear + 354;
        for (int i = 0; i < newMonths.length; ++i) {
            if (_dayOfYear >= newMonths[i]) continue;
            return i - 1;
        }
        return 11;
    }

    private int getDayOfMonth(int dayOfYear, int month, int year) {
        int _dayOfYear = dayOfYear;
        Integer[] newMonths = this.getAdjustedMonthDays(year);
        if (_dayOfYear >= 0) {
            if (month > 0) {
                return _dayOfYear - newMonths[month];
            }
            return _dayOfYear;
        }
        int n = _dayOfYear = this.isLeapYear(year) ? dayOfYear + 355 : dayOfYear + 354;
        if (month > 0) {
            return _dayOfYear - newMonths[month];
        }
        return _dayOfYear;
    }

    public boolean isLeapYear(long year) {
        return (14L + 11L * (year > 0L ? year : -year)) % 30L < 11L;
    }

    private int getMonthDays(int month, int year) {
        Integer[] newMonths = this.getAdjustedMonthDays(year);
        return newMonths[month];
    }

    public int getMonthLength(int month, int year) {
        Integer[] newMonths = this.getAdjustedMonthLength(year);
        return newMonths[month];
    }

    public int getYearLength(int year) {
        int cycleNumber = (year - 1) / 30;
        Integer[] cycleYears = null;
        try {
            cycleYears = this.ADJUSTED_CYCLE_YEARS().get(BoxesRunTime.boxToInteger((int)cycleNumber));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            cycleYears = null;
        }
        if (cycleYears != null) {
            int yearInCycle = (year - 1) % 30;
            if (yearInCycle == 29) {
                return Predef$.MODULE$.long2Long(this.ADJUSTED_CYCLES()[cycleNumber + 1]).intValue() - Predef$.MODULE$.long2Long(this.ADJUSTED_CYCLES()[cycleNumber]).intValue() - cycleYears[yearInCycle];
            }
            return cycleYears[yearInCycle + 1] - cycleYears[yearInCycle];
        }
        if (this.isLeapYear(year)) {
            return 355;
        }
        return 354;
    }

    public int getMaximumDayOfMonth() {
        return Predef$.MODULE$.Integer2int(this.ADJUSTED_MAX_VALUES()[5]);
    }

    public int getSmallestMaximumDayOfMonth() {
        return Predef$.MODULE$.Integer2int(this.ADJUSTED_LEAST_MAX_VALUES()[5]);
    }

    public int getMaximumDayOfYear() {
        return Predef$.MODULE$.Integer2int(this.ADJUSTED_MAX_VALUES()[6]);
    }

    public int getSmallestMaximumDayOfYear() {
        return Predef$.MODULE$.Integer2int(this.ADJUSTED_LEAST_MAX_VALUES()[6]);
    }

    public void addDeviationAsHijrah(int startYear, int startMonth, int endYear, int endMonth, int offset) {
        if (startYear < 1) {
            throw new IllegalArgumentException("startYear < 1");
        }
        if (endYear < 1) {
            throw new IllegalArgumentException("endYear < 1");
        }
        if (startMonth < 0 || startMonth > 11) {
            throw new IllegalArgumentException("startMonth < 0 || startMonth > 11");
        }
        if (endMonth < 0 || endMonth > 11) {
            throw new IllegalArgumentException("endMonth < 0 || endMonth > 11");
        }
        if (endYear > 9999) {
            throw new IllegalArgumentException("endYear > 9999");
        }
        if (endYear < startYear) {
            throw new IllegalArgumentException("startYear > endYear");
        }
        if (endYear == startYear && endMonth < startMonth) {
            throw new IllegalArgumentException("startYear == endYear && endMonth < startMonth");
        }
        boolean isStartYLeap = this.isLeapYear(startYear);
        Integer[] orgStartMonthNums = this.ADJUSTED_MONTH_DAYS().get(startYear);
        if (orgStartMonthNums == null) {
            if (isStartYLeap) {
                orgStartMonthNums = new Integer[this.LEAP_NUM_DAYS().length];
                for (int l = 0; l < this.LEAP_NUM_DAYS().length; ++l) {
                    orgStartMonthNums[l] = this.LEAP_NUM_DAYS()[l];
                }
            } else {
                orgStartMonthNums = new Integer[this.NUM_DAYS().length];
                for (int l = 0; l < this.NUM_DAYS().length; ++l) {
                    orgStartMonthNums[l] = this.NUM_DAYS()[l];
                }
            }
        }
        Integer[] newStartMonthNums = new Integer[orgStartMonthNums.length];
        for (int month = 0; month < 12; ++month) {
            newStartMonthNums[month] = month > startMonth ? Integer.valueOf(orgStartMonthNums[month] - offset) : Integer.valueOf(orgStartMonthNums[month]);
        }
        this.ADJUSTED_MONTH_DAYS().put(startYear, newStartMonthNums);
        Integer[] orgStartMonthLengths = this.ADJUSTED_MONTH_LENGTHS().get(startYear);
        if (orgStartMonthLengths == null) {
            if (isStartYLeap) {
                orgStartMonthLengths = new Integer[this.LEAP_MONTH_LENGTH().length];
                for (int l = 0; l < this.LEAP_MONTH_LENGTH().length; ++l) {
                    orgStartMonthLengths[l] = this.LEAP_MONTH_LENGTH()[l];
                }
            } else {
                orgStartMonthLengths = new Integer[this.MONTH_LENGTH().length];
                for (int l = 0; l < this.MONTH_LENGTH().length; ++l) {
                    orgStartMonthLengths[l] = this.MONTH_LENGTH()[l];
                }
            }
        }
        Integer[] newStartMonthLengths = new Integer[orgStartMonthLengths.length];
        for (int month = 0; month < 12; ++month) {
            newStartMonthLengths[month] = month == startMonth ? Integer.valueOf(orgStartMonthLengths[month] - offset) : Integer.valueOf(orgStartMonthLengths[month]);
        }
        this.ADJUSTED_MONTH_LENGTHS().put(startYear, newStartMonthLengths);
        if (startYear != endYear) {
            int sCycleNumber = (startYear - 1) / 30;
            int sYearInCycle = (startYear - 1) % 30;
            Integer[] startCycles = this.ADJUSTED_CYCLE_YEARS().get(sCycleNumber);
            if (startCycles == null) {
                startCycles = new Integer[this.CYCLEYEAR_START_DATE().length];
                for (int j = 0; j < startCycles.length; ++j) {
                    startCycles[j] = this.CYCLEYEAR_START_DATE()[j];
                }
            }
            for (int j = sYearInCycle + 1; j < this.CYCLEYEAR_START_DATE().length; ++j) {
                startCycles[j] = startCycles[j] - offset;
            }
            this.ADJUSTED_CYCLE_YEARS().put(sCycleNumber, startCycles);
            int sYearInMaxY = (startYear - 1) / 30;
            int sEndInMaxY = (endYear - 1) / 30;
            if (sYearInMaxY != sEndInMaxY) {
                for (int j = sYearInMaxY + 1; j < this.ADJUSTED_CYCLES().length; ++j) {
                    this.ADJUSTED_CYCLES()[j] = Predef$.MODULE$.Long2long(Long.valueOf(Predef$.MODULE$.long2Long(this.ADJUSTED_CYCLES()[j]) - (long)offset));
                }
                for (int j = sEndInMaxY + 1; j < this.ADJUSTED_CYCLES().length; ++j) {
                    this.ADJUSTED_CYCLES()[j] = Predef$.MODULE$.Long2long(Long.valueOf(Predef$.MODULE$.long2Long(this.ADJUSTED_CYCLES()[j]) + (long)offset));
                }
            }
            int eCycleNumber = (endYear - 1) / 30;
            int sEndInCycle = (endYear - 1) % 30;
            Integer[] endCycles = this.ADJUSTED_CYCLE_YEARS().get(eCycleNumber);
            if (endCycles == null) {
                endCycles = new Integer[this.CYCLEYEAR_START_DATE().length];
                for (int j = 0; j < endCycles.length; ++j) {
                    endCycles[j] = this.CYCLEYEAR_START_DATE()[j];
                }
            }
            for (int j = sEndInCycle + 1; j < this.CYCLEYEAR_START_DATE().length; ++j) {
                endCycles[j] = endCycles[j] + offset;
            }
            this.ADJUSTED_CYCLE_YEARS().put(eCycleNumber, endCycles);
        }
        boolean isEndYLeap = this.isLeapYear(endYear);
        Integer[] orgEndMonthDays = this.ADJUSTED_MONTH_DAYS().get(endYear);
        if (orgEndMonthDays == null) {
            if (isEndYLeap) {
                orgEndMonthDays = new Integer[this.LEAP_NUM_DAYS().length];
                for (int l = 0; l < this.LEAP_NUM_DAYS().length; ++l) {
                    orgEndMonthDays[l] = this.LEAP_NUM_DAYS()[l];
                }
            } else {
                orgEndMonthDays = new Integer[this.NUM_DAYS().length];
                for (int l = 0; l < this.NUM_DAYS().length; ++l) {
                    orgEndMonthDays[l] = this.NUM_DAYS()[l];
                }
            }
        }
        Integer[] newEndMonthDays = new Integer[orgEndMonthDays.length];
        for (int month = 0; month < 12; ++month) {
            newEndMonthDays[month] = month > endMonth ? Integer.valueOf(orgEndMonthDays[month] + offset) : Integer.valueOf(orgEndMonthDays[month]);
        }
        this.ADJUSTED_MONTH_DAYS().put(endYear, newEndMonthDays);
        Integer[] orgEndMonthLengths = this.ADJUSTED_MONTH_LENGTHS().get(endYear);
        if (orgEndMonthLengths == null) {
            if (isEndYLeap) {
                orgEndMonthLengths = new Integer[this.LEAP_MONTH_LENGTH().length];
                for (int l = 0; l < this.LEAP_MONTH_LENGTH().length; ++l) {
                    orgEndMonthLengths[l] = this.LEAP_MONTH_LENGTH()[l];
                }
            } else {
                orgEndMonthLengths = new Integer[this.MONTH_LENGTH().length];
                int l = 0;
                while (l < this.MONTH_LENGTH().length) {
                    orgEndMonthLengths[l] = this.MONTH_LENGTH()[l];
                    int cfr_ignored_0 = ++l - 1;
                }
            }
        }
        Integer[] newEndMonthLengths = new Integer[orgEndMonthLengths.length];
        for (int month = 0; month < 12; ++month) {
            newEndMonthLengths[month] = month == endMonth ? Integer.valueOf(orgEndMonthLengths[month] + offset) : Integer.valueOf(orgEndMonthLengths[month]);
        }
        this.ADJUSTED_MONTH_LENGTHS().put(endYear, newEndMonthLengths);
        Integer[] startMonthLengths = this.ADJUSTED_MONTH_LENGTHS().get(startYear);
        Integer[] endMonthLengths = this.ADJUSTED_MONTH_LENGTHS().get(endYear);
        Integer[] startMonthDays = this.ADJUSTED_MONTH_DAYS().get(startYear);
        Integer[] endMonthDays = this.ADJUSTED_MONTH_DAYS().get(endYear);
        int startMonthLength = startMonthLengths[startMonth];
        int endMonthLength = endMonthLengths[endMonth];
        int startMonthDay = startMonthDays[11] + startMonthLengths[11];
        int endMonthDay = endMonthDays[11] + endMonthLengths[11];
        int maxMonthLength = this.ADJUSTED_MAX_VALUES()[5];
        int leastMaxMonthLength = this.ADJUSTED_LEAST_MAX_VALUES()[5];
        if (maxMonthLength < startMonthLength) {
            maxMonthLength = startMonthLength;
        }
        if (maxMonthLength < endMonthLength) {
            maxMonthLength = endMonthLength;
        }
        this.ADJUSTED_MAX_VALUES()[5] = maxMonthLength;
        if (leastMaxMonthLength > startMonthLength) {
            leastMaxMonthLength = startMonthLength;
        }
        if (leastMaxMonthLength > endMonthLength) {
            leastMaxMonthLength = endMonthLength;
        }
        this.ADJUSTED_LEAST_MAX_VALUES()[5] = leastMaxMonthLength;
        int maxMonthDay = this.ADJUSTED_MAX_VALUES()[6];
        int leastMaxMonthDay = this.ADJUSTED_LEAST_MAX_VALUES()[6];
        if (maxMonthDay < startMonthDay) {
            maxMonthDay = startMonthDay;
        }
        if (maxMonthDay < endMonthDay) {
            maxMonthDay = endMonthDay;
        }
        this.ADJUSTED_MAX_VALUES()[6] = maxMonthDay;
        if (leastMaxMonthDay > startMonthDay) {
            leastMaxMonthDay = startMonthDay;
        }
        if (leastMaxMonthDay > endMonthDay) {
            leastMaxMonthDay = endMonthDay;
        }
        this.ADJUSTED_LEAST_MAX_VALUES()[6] = leastMaxMonthDay;
    }

    private final int prolepticYear$1(HijrahEra era$1, int yearOfEra) {
        if (era$1 == HijrahEra$.AH) {
            return yearOfEra;
        }
        return 1 - yearOfEra;
    }
}

