/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek$;
import java.time.Instant;
import java.time.LocalDate$;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.time.chrono.HijrahChronology$;
import java.time.chrono.HijrahDate;
import java.time.chrono.HijrahDate$;
import java.time.chrono.HijrahEra;
import java.time.chrono.HijrahEra$;
import java.time.format.ResolverStyle;
import java.time.format.ResolverStyle$;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters$;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import scala.Predef$;
import scala.math.Ordered;

public final class HijrahChronology
implements Ordered,
Chronology,
Serializable {
    private static final long serialVersionUID = 3127340209035924785L;

    public static HijrahChronology INSTANCE() {
        return HijrahChronology$.MODULE$.INSTANCE();
    }

    public HijrahChronology() {
        Ordered.$init$((Ordered)this);
    }

    private Object readResolve() {
        return HijrahChronology$.MODULE$.INSTANCE();
    }

    @Override
    public String getId() {
        return "Hijrah-umalqura";
    }

    @Override
    public String getCalendarType() {
        return "islamic-umalqura";
    }

    @Override
    public HijrahDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return (HijrahDate)Chronology.date$(this, era, yearOfEra, month, dayOfMonth);
    }

    @Override
    public HijrahDate date(int prolepticYear, int month, int dayOfMonth) {
        return HijrahDate$.MODULE$.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public HijrahDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return (HijrahDate)Chronology.dateYearDay$(this, era, yearOfEra, dayOfYear);
    }

    @Override
    public HijrahDate dateYearDay(int prolepticYear, int dayOfYear) {
        return HijrahDate$.MODULE$.of(prolepticYear, 1, 1).plusDays((long)dayOfYear - 1L);
    }

    @Override
    public HijrahDate dateEpochDay(long epochDay) {
        return HijrahDate$.MODULE$.of(LocalDate$.MODULE$.ofEpochDay(epochDay));
    }

    @Override
    public HijrahDate date(TemporalAccessor temporal) {
        TemporalAccessor temporalAccessor = temporal;
        if (temporalAccessor instanceof HijrahDate) {
            HijrahDate date = (HijrahDate)temporalAccessor;
            return date;
        }
        return HijrahDate$.MODULE$.ofEpochDay(temporal.getLong(ChronoField$.EPOCH_DAY));
    }

    public ChronoLocalDateTime<HijrahDate> localDateTime(TemporalAccessor temporal) {
        return Chronology.localDateTime$(this, temporal);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(TemporalAccessor temporal) {
        return Chronology.zonedDateTime$(this, temporal);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(Instant instant, ZoneId zone) {
        return Chronology.zonedDateTime$(this, instant, zone);
    }

    @Override
    public HijrahDate dateNow() {
        return (HijrahDate)Chronology.dateNow$(this);
    }

    @Override
    public HijrahDate dateNow(ZoneId zone) {
        return (HijrahDate)Chronology.dateNow$((Chronology)this, zone);
    }

    @Override
    public HijrahDate dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return (HijrahDate)Chronology.dateNow$((Chronology)this, clock);
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return HijrahDate$.MODULE$.isLeapYear(prolepticYear);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof HijrahEra)) {
            throw new ClassCastException("Era must be HijrahEra");
        }
        if (era == HijrahEra$.AH) {
            return yearOfEra;
        }
        return 1 - yearOfEra;
    }

    @Override
    public HijrahEra eraOf(int eraValue) {
        int n = eraValue;
        if (0 == n) {
            return HijrahEra$.BEFORE_AH;
        }
        if (1 == n) {
            return HijrahEra$.AH;
        }
        throw new DateTimeException("invalid Hijrah era");
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(HijrahEra$.MODULE$.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        return field.range();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public HijrahDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long yoeLong;
        if (fieldValues.containsKey(ChronoField$.EPOCH_DAY)) {
            return this.dateEpochDay(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.EPOCH_DAY)));
        }
        Long prolepticMonth = fieldValues.remove(ChronoField$.PROLEPTIC_MONTH);
        if (prolepticMonth != null) {
            if (resolverStyle != ResolverStyle$.LENIENT) {
                ChronoField$.PROLEPTIC_MONTH.checkValidValue(Predef$.MODULE$.Long2long(prolepticMonth));
            }
            this.updateResolveMap((Map)fieldValues, ChronoField$.MONTH_OF_YEAR, (long)Math.floorMod(Predef$.MODULE$.Long2long(prolepticMonth), 12) + 1L);
            this.updateResolveMap((Map)fieldValues, ChronoField$.YEAR, Math.floorDiv(Predef$.MODULE$.Long2long(prolepticMonth), 12));
        }
        if ((yoeLong = fieldValues.remove(ChronoField$.YEAR_OF_ERA)) != null) {
            Long era;
            if (resolverStyle != ResolverStyle$.LENIENT) {
                ChronoField$.YEAR_OF_ERA.checkValidValue(Predef$.MODULE$.Long2long(yoeLong));
            }
            if ((era = fieldValues.remove(ChronoField$.ERA)) == null) {
                Long year = fieldValues.get(ChronoField$.YEAR);
                if (resolverStyle == ResolverStyle$.STRICT) {
                    if (year != null) {
                        this.updateResolveMap((Map)fieldValues, ChronoField$.YEAR, Predef$.MODULE$.Long2long(year) > 0L ? Predef$.MODULE$.Long2long(yoeLong) : Math.subtractExact(1L, Predef$.MODULE$.Long2long(yoeLong)));
                    } else {
                        fieldValues.put(ChronoField$.YEAR_OF_ERA, yoeLong);
                    }
                } else {
                    this.updateResolveMap((Map)fieldValues, ChronoField$.YEAR, year == null || Predef$.MODULE$.Long2long(year) > 0L ? Predef$.MODULE$.Long2long(yoeLong) : Math.subtractExact(1L, Predef$.MODULE$.Long2long(yoeLong)));
                }
            } else if (era == 1L) {
                this.updateResolveMap((Map)fieldValues, ChronoField$.YEAR, Predef$.MODULE$.Long2long(yoeLong));
            } else {
                if (era != 0L) throw new DateTimeException(new StringBuilder(23).append("Invalid value for era: ").append(era).toString());
                this.updateResolveMap((Map)fieldValues, ChronoField$.YEAR, Math.subtractExact(1L, Predef$.MODULE$.Long2long(yoeLong)));
            }
        } else if (fieldValues.containsKey(ChronoField$.ERA)) {
            ChronoField$.ERA.checkValidValue(Predef$.MODULE$.Long2long(fieldValues.get(ChronoField$.ERA)));
        }
        if (!fieldValues.containsKey(ChronoField$.YEAR)) return null;
        if (fieldValues.containsKey(ChronoField$.MONTH_OF_YEAR)) {
            if (fieldValues.containsKey(ChronoField$.DAY_OF_MONTH)) {
                int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
                if (resolverStyle == ResolverStyle$.LENIENT) {
                    long months = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)), 1L);
                    long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_MONTH)), 1L);
                    return this.date(y, 1, 1).plusMonths(months).plusDays(days);
                }
                int moy = this.range(ChronoField$.MONTH_OF_YEAR).checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)), ChronoField$.MONTH_OF_YEAR);
                int dom = this.range(ChronoField$.DAY_OF_MONTH).checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_MONTH)), ChronoField$.DAY_OF_MONTH);
                if (resolverStyle != ResolverStyle$.SMART || dom <= 28) return this.date(y, moy, dom);
                dom = Math.min(dom, this.date(y, moy, 1).lengthOfMonth());
                return this.date(y, moy, dom);
            }
            if (fieldValues.containsKey(ChronoField$.ALIGNED_WEEK_OF_MONTH)) {
                if (fieldValues.containsKey(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH)) {
                    int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
                    if (resolverStyle == ResolverStyle$.LENIENT) {
                        long months = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)), 1L);
                        long weeks = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_MONTH)), 1L);
                        long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH)), 1L);
                        return this.date(y, 1, 1).plus(months, ChronoUnit$.MONTHS).plus(weeks, ChronoUnit$.WEEKS).plus(days, ChronoUnit$.DAYS);
                    }
                    int moy = ChronoField$.MONTH_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)));
                    int aw = ChronoField$.ALIGNED_WEEK_OF_MONTH.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_MONTH)));
                    int ad = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH)));
                    HijrahDate hijrahDate = this.date(y, moy, 1).plus(((long)aw - 1L) * 7L + (long)(ad - 1), ChronoUnit$.DAYS);
                    if (resolverStyle != ResolverStyle$.STRICT || hijrahDate.get(ChronoField$.MONTH_OF_YEAR) == moy) return hijrahDate;
                    throw new DateTimeException("Strict mode rejected date parsed to a different month");
                }
                if (fieldValues.containsKey(ChronoField$.DAY_OF_WEEK)) {
                    int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
                    if (resolverStyle == ResolverStyle$.LENIENT) {
                        long months = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)), 1L);
                        long weeks = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_MONTH)), 1L);
                        long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_WEEK)), 1L);
                        return this.date(y, 1, 1).plus(months, ChronoUnit$.MONTHS).plus(weeks, ChronoUnit$.WEEKS).plus(days, ChronoUnit$.DAYS);
                    }
                    int moy = ChronoField$.MONTH_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.MONTH_OF_YEAR)));
                    int aw = ChronoField$.ALIGNED_WEEK_OF_MONTH.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_MONTH)));
                    int dow = ChronoField$.DAY_OF_WEEK.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_WEEK)));
                    HijrahDate hijrahDate = this.date(y, moy, 1).plus((long)aw - 1L, ChronoUnit$.WEEKS).with(TemporalAdjusters$.MODULE$.nextOrSame(DayOfWeek$.MODULE$.of(dow)));
                    if (resolverStyle != ResolverStyle$.STRICT || hijrahDate.get(ChronoField$.MONTH_OF_YEAR) == moy) return hijrahDate;
                    throw new DateTimeException("Strict mode rejected date parsed to a different month");
                }
            }
        }
        if (fieldValues.containsKey(ChronoField$.DAY_OF_YEAR)) {
            int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
            if (resolverStyle == ResolverStyle$.LENIENT) {
                long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_YEAR)), 1L);
                return this.dateYearDay(y, 1).plusDays(days);
            }
            int doy = ChronoField$.DAY_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_YEAR)));
            return this.dateYearDay(y, doy);
        }
        if (!fieldValues.containsKey(ChronoField$.ALIGNED_WEEK_OF_YEAR)) return null;
        if (fieldValues.containsKey(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR)) {
            int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
            if (resolverStyle == ResolverStyle$.LENIENT) {
                long weeks = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_YEAR)), 1L);
                long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR)), 1L);
                return this.date(y, 1, 1).plus(weeks, ChronoUnit$.WEEKS).plus(days, ChronoUnit$.DAYS);
            }
            int aw = ChronoField$.ALIGNED_WEEK_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_YEAR)));
            int ad = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR)));
            HijrahDate hijrahDate = this.date(y, 1, 1).plusDays(((long)aw - 1L) * 7L + (long)(ad - 1));
            if (resolverStyle != ResolverStyle$.STRICT || hijrahDate.get(ChronoField$.YEAR) == y) return hijrahDate;
            throw new DateTimeException("Strict mode rejected date parsed to a different year");
        }
        if (!fieldValues.containsKey(ChronoField$.DAY_OF_WEEK)) return null;
        int y = ChronoField$.YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.YEAR)));
        if (resolverStyle == ResolverStyle$.LENIENT) {
            long weeks = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_YEAR)), 1L);
            long days = Math.subtractExact(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_WEEK)), 1L);
            return this.date(y, 1, 1).plus(weeks, ChronoUnit$.WEEKS).plus(days, ChronoUnit$.DAYS);
        }
        int aw = ChronoField$.ALIGNED_WEEK_OF_YEAR.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.ALIGNED_WEEK_OF_YEAR)));
        int dow = ChronoField$.DAY_OF_WEEK.checkValidIntValue(Predef$.MODULE$.Long2long(fieldValues.remove(ChronoField$.DAY_OF_WEEK)));
        HijrahDate hijrahDate = this.date(y, 1, 1).plus((long)aw - 1L, ChronoUnit$.WEEKS).with(TemporalAdjusters$.MODULE$.nextOrSame(DayOfWeek$.MODULE$.of(dow)));
        if (resolverStyle != ResolverStyle$.STRICT || hijrahDate.get(ChronoField$.YEAR) == y) return hijrahDate;
        throw new DateTimeException("Strict mode rejected date parsed to a different month");
    }
}

