/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Locale;

public interface Era
extends TemporalAccessor,
TemporalAdjuster {
    public int getValue();

    public static String getDisplayName$(Era $this, TextStyle style, Locale locale) {
        return $this.getDisplayName(style, locale);
    }

    default public String getDisplayName(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField$.ERA, style).toFormatter(locale).format(this);
    }

    public static boolean isSupported$(Era $this, TemporalField field) {
        return $this.isSupported(field);
    }

    @Override
    default public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField$.ERA;
        }
        return field != null && field.isSupportedBy(this);
    }

    public static int get$(Era $this, TemporalField field) {
        return $this.get(field);
    }

    @Override
    default public int get(TemporalField field) {
        if (field == ChronoField$.ERA) {
            return this.getValue();
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    public static long getLong$(Era $this, TemporalField field) {
        return $this.getLong(field);
    }

    @Override
    default public long getLong(TemporalField field) {
        if (field == ChronoField$.ERA) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.getFrom(this);
    }

    public static Temporal adjustInto$(Era $this, Temporal temporal) {
        return $this.adjustInto(temporal);
    }

    @Override
    default public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField$.ERA, this.getValue());
    }

    public static Object query$(Era $this, TemporalQuery query) {
        return $this.query(query);
    }

    @Override
    default public <R> R query(TemporalQuery<R> query) {
        block16: {
            block5: {
                TemporalQuery<R> temporalQuery;
                TemporalQuery<LocalTime> temporalQuery2;
                block15: {
                    TemporalQuery<R> temporalQuery3;
                    block14: {
                        TemporalQuery<R> temporalQuery4;
                        TemporalQuery<LocalDate> temporalQuery5;
                        block13: {
                            block12: {
                                TemporalQuery<R> temporalQuery6;
                                TemporalQuery<ZoneOffset> temporalQuery7;
                                block11: {
                                    block10: {
                                        TemporalQuery<R> temporalQuery8;
                                        TemporalQuery<ZoneId> temporalQuery9;
                                        block9: {
                                            block8: {
                                                TemporalQuery<R> temporalQuery10;
                                                TemporalQuery<ZoneId> temporalQuery11;
                                                block7: {
                                                    block6: {
                                                        TemporalQuery<R> temporalQuery12;
                                                        TemporalQuery<Chronology> temporalQuery13;
                                                        block4: {
                                                            temporalQuery3 = query;
                                                            TemporalQuery<TemporalUnit> temporalQuery14 = TemporalQueries$.MODULE$.precision();
                                                            TemporalQuery<R> temporalQuery15 = temporalQuery3;
                                                            if (!(temporalQuery14 != null ? !temporalQuery14.equals(temporalQuery15) : temporalQuery15 != null)) {
                                                                return (R)ChronoUnit$.ERAS;
                                                            }
                                                            temporalQuery13 = TemporalQueries$.MODULE$.chronology();
                                                            temporalQuery12 = temporalQuery3;
                                                            if (temporalQuery13 != null) break block4;
                                                            if (temporalQuery12 == null) break block5;
                                                            break block6;
                                                        }
                                                        if (temporalQuery13.equals(temporalQuery12)) break block5;
                                                    }
                                                    temporalQuery11 = TemporalQueries$.MODULE$.zone();
                                                    temporalQuery10 = temporalQuery3;
                                                    if (temporalQuery11 != null) break block7;
                                                    if (temporalQuery10 == null) break block5;
                                                    break block8;
                                                }
                                                if (temporalQuery11.equals(temporalQuery10)) break block5;
                                            }
                                            temporalQuery9 = TemporalQueries$.MODULE$.zoneId();
                                            temporalQuery8 = temporalQuery3;
                                            if (temporalQuery9 != null) break block9;
                                            if (temporalQuery8 == null) break block5;
                                            break block10;
                                        }
                                        if (temporalQuery9.equals(temporalQuery8)) break block5;
                                    }
                                    temporalQuery7 = TemporalQueries$.MODULE$.offset();
                                    temporalQuery6 = temporalQuery3;
                                    if (temporalQuery7 != null) break block11;
                                    if (temporalQuery6 == null) break block5;
                                    break block12;
                                }
                                if (temporalQuery7.equals(temporalQuery6)) break block5;
                            }
                            temporalQuery5 = TemporalQueries$.MODULE$.localDate();
                            temporalQuery4 = temporalQuery3;
                            if (temporalQuery5 != null) break block13;
                            if (temporalQuery4 == null) break block5;
                            break block14;
                        }
                        if (temporalQuery5.equals(temporalQuery4)) break block5;
                    }
                    temporalQuery2 = TemporalQueries$.MODULE$.localTime();
                    temporalQuery = temporalQuery3;
                    if (temporalQuery2 != null) break block15;
                    if (temporalQuery == null) break block5;
                    break block16;
                }
                if (!temporalQuery2.equals(temporalQuery)) break block16;
            }
            return null;
        }
        return query.queryFrom(this);
    }
}

