/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.Instant$;
import java.time.LocalDate$;
import java.time.LocalTime$;
import java.time.ZoneId;
import java.time.ZoneId$;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoLocalDateTimeImpl;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.ChronoPeriodImpl;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.ChronoZonedDateTimeImpl;
import java.time.chrono.ChronoZonedDateTimeImpl$;
import java.time.chrono.Chronology$;
import java.time.chrono.Era;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import scala.Predef$;
import scala.math.Ordered;

public interface Chronology
extends Ordered<Chronology> {
    public static Chronology from(TemporalAccessor temporalAccessor) {
        return Chronology$.MODULE$.from(temporalAccessor);
    }

    public static Set<Chronology> getAvailableChronologies() {
        return Chronology$.MODULE$.getAvailableChronologies();
    }

    public static Chronology of(String string) {
        return Chronology$.MODULE$.of(string);
    }

    public static Chronology ofLocale(Locale locale) {
        return Chronology$.MODULE$.ofLocale(locale);
    }

    public static ChronoLocalDate ensureChronoLocalDate$(Chronology $this, Temporal temporal) {
        return $this.ensureChronoLocalDate(temporal);
    }

    default public <D extends ChronoLocalDate> D ensureChronoLocalDate(Temporal temporal) {
        ChronoLocalDate other = (ChronoLocalDate)temporal;
        Chronology chronology = this;
        Chronology chronology2 = other.getChronology();
        if (chronology == null ? chronology2 != null : !((Object)chronology).equals(chronology2)) {
            throw new ClassCastException(new StringBuilder(37).append("Chrono mismatch, expected: ").append(this.getId()).append(", actual: ").append(other.getChronology().getId()).toString());
        }
        return (D)other;
    }

    public static ChronoLocalDateTimeImpl ensureChronoLocalDateTime$(Chronology $this, Temporal temporal) {
        return $this.ensureChronoLocalDateTime(temporal);
    }

    default public <D extends ChronoLocalDate> ChronoLocalDateTimeImpl<D> ensureChronoLocalDateTime(Temporal temporal) {
        ChronoLocalDateTimeImpl other = (ChronoLocalDateTimeImpl)temporal;
        Chronology chronology = this;
        Chronology chronology2 = other.toLocalDate().getChronology();
        if (chronology == null ? chronology2 != null : !((Object)chronology).equals(chronology2)) {
            throw new ClassCastException(new StringBuilder(39).append("Chrono mismatch, required: ").append(this.getId()).append(", supplied: ").append(other.toLocalDate().getChronology().getId()).toString());
        }
        return other;
    }

    public static ChronoZonedDateTimeImpl ensureChronoZonedDateTime$(Chronology $this, Temporal temporal) {
        return $this.ensureChronoZonedDateTime(temporal);
    }

    default public <D extends ChronoLocalDate> ChronoZonedDateTimeImpl<D> ensureChronoZonedDateTime(Temporal temporal) {
        ChronoZonedDateTimeImpl other = (ChronoZonedDateTimeImpl)temporal;
        Chronology chronology = this;
        Chronology chronology2 = other.toLocalDate().getChronology();
        if (chronology == null ? chronology2 != null : !((Object)chronology).equals(chronology2)) {
            throw new ClassCastException(new StringBuilder(39).append("Chrono mismatch, required: ").append(this.getId()).append(", supplied: ").append(other.toLocalDate().getChronology().getId()).toString());
        }
        return other;
    }

    public String getId();

    public String getCalendarType();

    public static ChronoLocalDate date$(Chronology $this, Era era, int yearOfEra, int month, int dayOfMonth) {
        return $this.date(era, yearOfEra, month, dayOfMonth);
    }

    default public ChronoLocalDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    public ChronoLocalDate date(int var1, int var2, int var3);

    public static ChronoLocalDate dateYearDay$(Chronology $this, Era era, int yearOfEra, int dayOfYear) {
        return $this.dateYearDay(era, yearOfEra, dayOfYear);
    }

    default public ChronoLocalDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    public ChronoLocalDate dateYearDay(int var1, int var2);

    public ChronoLocalDate dateEpochDay(long var1);

    public ChronoLocalDate date(TemporalAccessor var1);

    public static ChronoLocalDate dateNow$(Chronology $this) {
        return $this.dateNow();
    }

    default public ChronoLocalDate dateNow() {
        return this.dateNow(Clock$.MODULE$.systemDefaultZone());
    }

    public static ChronoLocalDate dateNow$(Chronology $this, ZoneId zone) {
        return $this.dateNow(zone);
    }

    default public ChronoLocalDate dateNow(ZoneId zone) {
        return this.dateNow(Clock$.MODULE$.system(zone));
    }

    public static ChronoLocalDate dateNow$(Chronology $this, Clock clock) {
        return $this.dateNow(clock);
    }

    default public ChronoLocalDate dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return this.date(LocalDate$.MODULE$.now(clock));
    }

    public static ChronoLocalDateTime localDateTime$(Chronology $this, TemporalAccessor temporal) {
        return $this.localDateTime(temporal);
    }

    default public ChronoLocalDateTime<?> localDateTime(TemporalAccessor temporal) {
        ChronoLocalDateTime<? extends ChronoLocalDate> chronoLocalDateTime;
        try {
            ChronoLocalDate clDate = this.date(temporal);
            chronoLocalDateTime = clDate.atTime(LocalTime$.MODULE$.from(temporal));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException(new StringBuilder(60).append("Unable to obtain ChronoLocalDateTime from TemporalAccessor: ").append(temporal.getClass()).toString(), ex);
        }
        return chronoLocalDateTime;
    }

    public static ChronoZonedDateTime zonedDateTime$(Chronology $this, TemporalAccessor temporal) {
        return $this.zonedDateTime(temporal);
    }

    default public ChronoZonedDateTime<?> zonedDateTime(TemporalAccessor temporal) {
        ChronoZonedDateTime<ChronoLocalDate> chronoZonedDateTime;
        try {
            ZoneId zone = ZoneId$.MODULE$.from(temporal);
            try {
                Instant instant = Instant$.MODULE$.from(temporal);
                chronoZonedDateTime = this.zonedDateTime(instant, zone);
            }
            catch (DateTimeException dateTimeException) {
                ChronoLocalDateTime<?> cldt = this.localDateTime(temporal);
                ChronoLocalDateTimeImpl cldtImpl = this.ensureChronoLocalDateTime(cldt);
                chronoZonedDateTime = ChronoZonedDateTimeImpl$.MODULE$.ofBest(cldtImpl, zone, null);
            }
        }
        catch (DateTimeException ex) {
            throw new DateTimeException(new StringBuilder(60).append("Unable to obtain ChronoZonedDateTime from TemporalAccessor: ").append(temporal.getClass()).toString(), ex);
        }
        return chronoZonedDateTime;
    }

    public static ChronoZonedDateTime zonedDateTime$(Chronology $this, Instant instant, ZoneId zone) {
        return $this.zonedDateTime(instant, zone);
    }

    default public ChronoZonedDateTime<? extends ChronoLocalDate> zonedDateTime(Instant instant, ZoneId zone) {
        return ChronoZonedDateTimeImpl$.MODULE$.ofInstant(this, instant, zone);
    }

    public static ChronoPeriod period$(Chronology $this, int years, int months, int days) {
        return $this.period(years, months, days);
    }

    default public ChronoPeriod period(int years, int months, int days) {
        return new ChronoPeriodImpl(this, years, months, days);
    }

    public boolean isLeapYear(long var1);

    public int prolepticYear(Era var1, int var2);

    public Era eraOf(int var1);

    public List<Era> eras();

    public ValueRange range(ChronoField var1);

    public static String getDisplayName$(Chronology $this, TextStyle style, Locale locale) {
        return $this.getDisplayName(style, locale);
    }

    default public String getDisplayName(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendChronologyText(style).toFormatter(locale).format(new TemporalAccessor(){

            public boolean isSupported(TemporalField field) {
                return false;
            }

            public long getLong(TemporalField field) {
                throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
            }

            public Object query(TemporalQuery query) {
                if (query == TemporalQueries$.MODULE$.chronology()) {
                    return this;
                }
                return TemporalAccessor.query$(this, query);
            }
        });
    }

    public ChronoLocalDate resolveDate(Map<TemporalField, Long> var1, ResolverStyle var2);

    public static void updateResolveMap$(Chronology $this, Map fieldValues, ChronoField field, long value) {
        $this.updateResolveMap(fieldValues, field, value);
    }

    default public void updateResolveMap(Map<TemporalField, Long> fieldValues, ChronoField field, long value) {
        Long current = fieldValues.get(field);
        if (current != null && current != value) {
            throw new DateTimeException(new StringBuilder(40).append("Invalid state, field: ").append(field).append(" ").append(current).append(" conflicts with ").append(field).append(" ").append(value).toString());
        }
        fieldValues.put(field, Predef$.MODULE$.long2Long(value));
    }

    public static int compare$(Chronology $this, Chronology other) {
        return $this.compare(other);
    }

    default public int compare(Chronology other) {
        return this.getId().compareTo(other.getId());
    }

    public static boolean equals$(Chronology $this, Object obj) {
        return $this.equals(obj);
    }

    default public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof Chronology) {
            Chronology other = (Chronology)object;
            return this == other || this.compareTo(other) == 0;
        }
        return false;
    }

    public static int hashCode$(Chronology $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        return this.getClass().hashCode() ^ this.getId().hashCode();
    }

    public static String toString$(Chronology $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.getId();
    }
}

