/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.chrono.Chronology;
import java.time.chrono.ChronologyPlatformHelper$;
import java.time.chrono.HijrahChronology$;
import java.time.chrono.IsoChronology$;
import java.time.chrono.MinguoChronology$;
import java.time.chrono.ThaiBuddhistChronology$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries$;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import scala.runtime.ModuleSerializationProxy;

public final class Chronology$
implements Serializable {
    private Map CHRONOS_BY_ID$lzy1;
    private boolean CHRONOS_BY_IDbitmap$1;
    private Map CHRONOS_BY_TYPE$lzy1;
    private boolean CHRONOS_BY_TYPEbitmap$1;
    public static final Chronology$ MODULE$ = new Chronology$();

    private Chronology$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Chronology$.class);
    }

    private Map<String, Chronology> CHRONOS_BY_ID() {
        if (!this.CHRONOS_BY_IDbitmap$1) {
            this.CHRONOS_BY_ID$lzy1 = new HashMap();
            this.CHRONOS_BY_IDbitmap$1 = true;
        }
        return this.CHRONOS_BY_ID$lzy1;
    }

    private Map<String, Chronology> CHRONOS_BY_TYPE() {
        if (!this.CHRONOS_BY_TYPEbitmap$1) {
            this.CHRONOS_BY_TYPE$lzy1 = new HashMap();
            this.CHRONOS_BY_TYPEbitmap$1 = true;
        }
        return this.CHRONOS_BY_TYPE$lzy1;
    }

    public Chronology from(TemporalAccessor temporal) {
        Objects.requireNonNull(temporal, "temporal");
        Chronology obj = temporal.query(TemporalQueries$.MODULE$.chronology());
        if (obj != null) {
            return obj;
        }
        return IsoChronology$.MODULE$.INSTANCE();
    }

    public Chronology ofLocale(Locale locale) {
        this.init();
        Objects.requireNonNull(locale, "locale");
        String localeType = locale.getUnicodeLocaleType("ca");
        if (localeType == null || "iso".equals(localeType) || "iso8601".equals(localeType)) {
            return IsoChronology$.MODULE$.INSTANCE();
        }
        Chronology chrono = this.CHRONOS_BY_TYPE().get(localeType);
        if (chrono == null) {
            throw new DateTimeException(new StringBuilder(25).append("Unknown calendar system: ").append(localeType).toString());
        }
        return chrono;
    }

    public Chronology of(String id) {
        this.init();
        Chronology chrono = this.CHRONOS_BY_ID().get(id);
        if (chrono != null) {
            return chrono;
        }
        chrono = this.CHRONOS_BY_TYPE().get(id);
        if (chrono != null) {
            return chrono;
        }
        throw new DateTimeException(new StringBuilder(20).append("Unknown chronology: ").append(id).toString());
    }

    public Set<Chronology> getAvailableChronologies() {
        this.init();
        return new HashSet<Chronology>(this.CHRONOS_BY_ID().values());
    }

    private void init() {
        if (this.CHRONOS_BY_ID().isEmpty()) {
            this.register(IsoChronology$.MODULE$.INSTANCE());
            this.register(ThaiBuddhistChronology$.MODULE$.INSTANCE());
            this.register(MinguoChronology$.MODULE$.INSTANCE());
            this.register(HijrahChronology$.MODULE$.INSTANCE());
            this.CHRONOS_BY_ID().put("Hijrah", HijrahChronology$.MODULE$.INSTANCE());
            this.CHRONOS_BY_TYPE().put("islamic", HijrahChronology$.MODULE$.INSTANCE());
            Iterator<Chronology> chronologies = ChronologyPlatformHelper$.MODULE$.loadAdditionalChronologies();
            while (chronologies.hasNext()) {
                Chronology chrono = chronologies.next();
                this.CHRONOS_BY_ID().put(chrono.getId(), chrono);
                String type = chrono.getCalendarType();
                if (type == null) continue;
                this.CHRONOS_BY_TYPE().put(type, chrono);
            }
            return;
        }
    }

    private void register(Chronology chrono) {
        this.CHRONOS_BY_ID().put(chrono.getId(), chrono);
        String type = chrono.getCalendarType();
        if (type != null) {
            this.CHRONOS_BY_TYPE().put(type, chrono);
        }
    }
}

