/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoLocalDateTimeImpl;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.ChronoZonedDateTimeImpl$;
import java.time.chrono.Chronology;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.zone.ZoneOffsetTransition;
import java.util.Objects;
import scala.math.Ordered;

public final class ChronoZonedDateTimeImpl<D extends ChronoLocalDate>
implements ChronoZonedDateTime<D>,
Serializable {
    private static final long serialVersionUID = -5261813987200935591L;
    private final ChronoLocalDateTimeImpl dateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;

    public static <R extends ChronoLocalDate> ChronoZonedDateTime<R> ofBest(ChronoLocalDateTimeImpl<R> chronoLocalDateTimeImpl, ZoneId zoneId, ZoneOffset zoneOffset) {
        return ChronoZonedDateTimeImpl$.MODULE$.ofBest(chronoLocalDateTimeImpl, zoneId, zoneOffset);
    }

    public static <R extends ChronoLocalDate> ChronoZonedDateTimeImpl<R> ofInstant(Chronology chronology, Instant instant, ZoneId zoneId) {
        return ChronoZonedDateTimeImpl$.MODULE$.ofInstant(chronology, instant, zoneId);
    }

    public ChronoZonedDateTimeImpl(ChronoLocalDateTimeImpl<D> dateTime, ZoneOffset offset, ZoneId zone) {
        this.dateTime = dateTime;
        this.offset = offset;
        this.zone = zone;
        Ordered.$init$((Ordered)this);
        Objects.requireNonNull(dateTime, "dateTime");
        Objects.requireNonNull(offset, "offset");
        Objects.requireNonNull(zone, "zone");
    }

    @Override
    public /* synthetic */ int java$time$chrono$ChronoZonedDateTime$$super$get(TemporalField field) {
        return TemporalAccessor.get$(this, field);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$with(TemporalAdjuster adjuster) {
        return Temporal.with$(this, adjuster);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$plus(TemporalAmount amount) {
        return Temporal.plus$(this, amount);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$minus(TemporalAmount amount) {
        return Temporal.minus$(this, amount);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$minus(long amountToSubtract, TemporalUnit unit) {
        return Temporal.minus$(this, amountToSubtract, unit);
    }

    @Override
    public /* synthetic */ Object java$time$chrono$ChronoZonedDateTime$$super$query(TemporalQuery query) {
        return TemporalAccessor.query$(this, query);
    }

    private ChronoLocalDateTimeImpl<D> dateTime() {
        return this.dateTime;
    }

    private ZoneOffset offset() {
        return this.offset;
    }

    private ZoneId zone() {
        return this.zone;
    }

    private ChronoZonedDateTimeImpl<D> create(Instant instant, ZoneId zone) {
        return ChronoZonedDateTimeImpl$.MODULE$.ofInstant(this.toLocalDate().getChronology(), instant, zone);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit.isDateBased() || unit.isTimeBased();
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ZoneOffset getOffset() {
        return this.offset();
    }

    @Override
    public ChronoZonedDateTime<D> withEarlierOffsetAtOverlap() {
        ZoneOffsetTransition trans = this.getZone().getRules().getTransition(LocalDateTime$.MODULE$.from(this));
        if (trans != null && trans.isOverlap()) {
            ZoneOffset earlierOffset;
            ZoneOffset zoneOffset = earlierOffset = trans.getOffsetBefore();
            ZoneOffset zoneOffset2 = this.offset();
            if (zoneOffset == null ? zoneOffset2 != null : !((Object)zoneOffset).equals(zoneOffset2)) {
                return new ChronoZonedDateTimeImpl<D>(this.dateTime(), earlierOffset, this.zone());
            }
        }
        return this;
    }

    @Override
    public ChronoZonedDateTime<D> withLaterOffsetAtOverlap() {
        ZoneOffsetTransition trans = this.getZone().getRules().getTransition(LocalDateTime$.MODULE$.from(this));
        if (trans != null) {
            ZoneOffset offset;
            ZoneOffset zoneOffset = offset = trans.getOffsetAfter();
            ZoneOffset zoneOffset2 = this.getOffset();
            if (zoneOffset == null ? zoneOffset2 != null : !((Object)zoneOffset).equals(zoneOffset2)) {
                return new ChronoZonedDateTimeImpl<D>(this.dateTime(), offset, this.zone());
            }
        }
        return this;
    }

    @Override
    public ChronoLocalDateTime<D> toLocalDateTime() {
        return this.dateTime();
    }

    @Override
    public ZoneId getZone() {
        return this.zone();
    }

    @Override
    public ChronoZonedDateTime<D> withZoneSameLocal(ZoneId zone) {
        return ChronoZonedDateTimeImpl$.MODULE$.ofBest(this.dateTime(), zone, this.offset());
    }

    @Override
    public ChronoZonedDateTime<D> withZoneSameInstant(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        ZoneId zoneId = this.zone();
        ZoneId zoneId2 = zone;
        if (!(zoneId != null ? !((Object)zoneId).equals(zoneId2) : zoneId2 != null)) {
            return this;
        }
        return this.create(this.dateTime().toInstant(this.offset()), zone);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return field instanceof ChronoField || field != null && field.isSupportedBy(this);
    }

    @Override
    public ChronoZonedDateTime<D> with(TemporalField field, long newValue) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f;
            ChronoField chronoField = f = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.INSTANT_SECONDS;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.plus(newValue - this.toEpochSecond(), ChronoUnit$.SECONDS);
            }
            ChronoField chronoField4 = ChronoField$.OFFSET_SECONDS;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                ZoneOffset offset = ZoneOffset$.MODULE$.ofTotalSeconds(f.checkValidIntValue(newValue));
                return this.create(this.dateTime().toInstant(offset), this.zone());
            }
            return ChronoZonedDateTimeImpl$.MODULE$.ofBest(this.dateTime().with(field, newValue), this.zone(), this.offset());
        }
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(field.adjustInto(this, newValue));
    }

    @Override
    public ChronoZonedDateTime<D> plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return this.with(this.dateTime().plus(amountToAdd, unit));
        }
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(unit.addTo(this, amountToAdd));
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        ChronoZonedDateTime<?> end = this.toLocalDate().getChronology().zonedDateTime(endExclusive);
        if (unit instanceof ChronoUnit) {
            end = end.withZoneSameInstant(this.offset());
            return this.dateTime().until(end.toLocalDateTime(), unit);
        }
        return unit.between(this, end);
    }

    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ChronoZonedDateTime) {
            ChronoZonedDateTime other = (ChronoZonedDateTime)object;
            return this == other || this.compareTo(other) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toLocalDateTime().hashCode() ^ this.getOffset().hashCode() ^ Integer.rotateLeft(this.getZone().hashCode(), 3);
    }

    @Override
    public String toString() {
        String str = new StringBuilder(0).append(this.toLocalDateTime().toString()).append(this.getOffset().toString()).toString();
        if (this.getOffset() != this.getZone()) {
            str = new StringBuilder(0).append(str).append(new StringBuilder(2).append("[").append(this.getZone()).append("]").toString()).toString();
        }
        return str;
    }
}

