/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalDateTime$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTimeImpl;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.ChronoZonedDateTimeImpl;
import java.time.chrono.Chronology;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.List;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class ChronoZonedDateTimeImpl$
implements Serializable {
    public static final ChronoZonedDateTimeImpl$ MODULE$ = new ChronoZonedDateTimeImpl$();

    private ChronoZonedDateTimeImpl$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ChronoZonedDateTimeImpl$.class);
    }

    public <R extends ChronoLocalDate> ChronoZonedDateTime<R> ofBest(ChronoLocalDateTimeImpl<R> localDateTime, ZoneId zone, ZoneOffset preferredOffset) {
        ChronoLocalDateTimeImpl<R> _localDateTime = localDateTime;
        Objects.requireNonNull(_localDateTime, "localDateTime");
        Objects.requireNonNull(zone, "zone");
        ZoneId zoneId = zone;
        if (zoneId instanceof ZoneOffset) {
            ZoneOffset offset = (ZoneOffset)zoneId;
            return new ChronoZonedDateTimeImpl<R>(_localDateTime, offset, zone);
        }
        ZoneRules rules = zone.getRules();
        LocalDateTime isoLDT = LocalDateTime$.MODULE$.from(_localDateTime);
        List<ZoneOffset> validOffsets = rules.getValidOffsets(isoLDT);
        ZoneOffset offset = null;
        if (validOffsets.size() == 1) {
            offset = validOffsets.get(0);
        } else if (validOffsets.size() == 0) {
            ZoneOffsetTransition trans = rules.getTransition(isoLDT);
            _localDateTime = _localDateTime.plusSeconds(trans.getDuration().getSeconds());
            offset = trans.getOffsetAfter();
        } else {
            offset = preferredOffset != null && validOffsets.contains(preferredOffset) ? preferredOffset : validOffsets.get(0);
        }
        Objects.requireNonNull(offset, "offset");
        return new ChronoZonedDateTimeImpl<R>(_localDateTime, offset, zone);
    }

    public <R extends ChronoLocalDate> ChronoZonedDateTimeImpl<R> ofInstant(Chronology chrono, Instant instant, ZoneId zone) {
        ZoneRules rules = zone.getRules();
        ZoneOffset offset = rules.getOffset(instant);
        Objects.requireNonNull(offset, "offset");
        LocalDateTime ldt = LocalDateTime$.MODULE$.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), offset);
        ChronoLocalDateTimeImpl cldt = (ChronoLocalDateTimeImpl)chrono.localDateTime(ldt);
        return new ChronoZonedDateTimeImpl(cldt, offset, zone);
    }
}

