/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.Instant;
import java.time.Instant$;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime$;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Comparator;
import java.util.Objects;
import scala.math.Ordered;

public interface ChronoZonedDateTime<D extends ChronoLocalDate>
extends Temporal,
Ordered<ChronoZonedDateTime<?>> {
    public static ChronoZonedDateTime<?> from(TemporalAccessor temporalAccessor) {
        return ChronoZonedDateTime$.MODULE$.from(temporalAccessor);
    }

    public static Comparator<ChronoZonedDateTime<?>> timeLineOrder() {
        return ChronoZonedDateTime$.MODULE$.timeLineOrder();
    }

    public /* synthetic */ int java$time$chrono$ChronoZonedDateTime$$super$get(TemporalField var1);

    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$with(TemporalAdjuster var1);

    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$plus(TemporalAmount var1);

    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$minus(TemporalAmount var1);

    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$minus(long var1, TemporalUnit var3);

    public /* synthetic */ Object java$time$chrono$ChronoZonedDateTime$$super$query(TemporalQuery var1);

    public static ValueRange range$(ChronoZonedDateTime $this, TemporalField field) {
        return $this.range(field);
    }

    @Override
    default public ValueRange range(TemporalField field) {
        TemporalField temporalField;
        block8: {
            block5: {
                TemporalField temporalField2;
                ChronoField chronoField;
                block7: {
                    block6: {
                        TemporalField temporalField3;
                        ChronoField chronoField2;
                        block4: {
                            temporalField = field;
                            chronoField2 = ChronoField$.INSTANT_SECONDS;
                            temporalField3 = temporalField;
                            if (chronoField2 != null) break block4;
                            if (temporalField3 == null) break block5;
                            break block6;
                        }
                        if (chronoField2.equals(temporalField3)) break block5;
                    }
                    chronoField = ChronoField$.OFFSET_SECONDS;
                    temporalField2 = temporalField;
                    if (chronoField != null) break block7;
                    if (temporalField2 == null) break block5;
                    break block8;
                }
                if (!chronoField.equals(temporalField2)) break block8;
            }
            return field.range();
        }
        if (temporalField instanceof ChronoField) {
            return this.toLocalDateTime().range(field);
        }
        return field.rangeRefinedBy(this);
    }

    public static int get$(ChronoZonedDateTime $this, TemporalField field) {
        return $this.get(field);
    }

    @Override
    default public int get(TemporalField field) {
        TemporalField temporalField = field;
        ChronoField chronoField = ChronoField$.INSTANT_SECONDS;
        TemporalField temporalField2 = temporalField;
        if (!(chronoField != null ? !chronoField.equals(temporalField2) : temporalField2 != null)) {
            throw new UnsupportedTemporalTypeException(new StringBuilder(28).append("Field too large for an int: ").append(field).toString());
        }
        ChronoField chronoField2 = ChronoField$.OFFSET_SECONDS;
        TemporalField temporalField3 = temporalField;
        if (!(chronoField2 != null ? !chronoField2.equals(temporalField3) : temporalField3 != null)) {
            return this.getOffset().getTotalSeconds();
        }
        if (temporalField instanceof ChronoField) {
            return this.toLocalDateTime().get(field);
        }
        return this.java$time$chrono$ChronoZonedDateTime$$super$get(field);
    }

    public static long getLong$(ChronoZonedDateTime $this, TemporalField field) {
        return $this.getLong(field);
    }

    @Override
    default public long getLong(TemporalField field) {
        TemporalField temporalField = field;
        ChronoField chronoField = ChronoField$.INSTANT_SECONDS;
        TemporalField temporalField2 = temporalField;
        if (!(chronoField != null ? !chronoField.equals(temporalField2) : temporalField2 != null)) {
            return this.toEpochSecond();
        }
        ChronoField chronoField2 = ChronoField$.OFFSET_SECONDS;
        TemporalField temporalField3 = temporalField;
        if (!(chronoField2 != null ? !chronoField2.equals(temporalField3) : temporalField3 != null)) {
            return this.getOffset().getTotalSeconds();
        }
        if (temporalField instanceof ChronoField) {
            return this.toLocalDateTime().getLong(field);
        }
        return field.getFrom(this);
    }

    public static ChronoLocalDate toLocalDate$(ChronoZonedDateTime $this) {
        return $this.toLocalDate();
    }

    default public D toLocalDate() {
        return this.toLocalDateTime().toLocalDate();
    }

    public static LocalTime toLocalTime$(ChronoZonedDateTime $this) {
        return $this.toLocalTime();
    }

    default public LocalTime toLocalTime() {
        return this.toLocalDateTime().toLocalTime();
    }

    public ChronoLocalDateTime<D> toLocalDateTime();

    public static Chronology getChronology$(ChronoZonedDateTime $this) {
        return $this.getChronology();
    }

    default public Chronology getChronology() {
        return this.toLocalDate().getChronology();
    }

    public ZoneOffset getOffset();

    public ZoneId getZone();

    public ChronoZonedDateTime<D> withEarlierOffsetAtOverlap();

    public ChronoZonedDateTime<D> withLaterOffsetAtOverlap();

    public ChronoZonedDateTime<D> withZoneSameLocal(ZoneId var1);

    public ChronoZonedDateTime<D> withZoneSameInstant(ZoneId var1);

    public static ChronoZonedDateTime with$(ChronoZonedDateTime $this, TemporalAdjuster adjuster) {
        return $this.with(adjuster);
    }

    @Override
    default public ChronoZonedDateTime<D> with(TemporalAdjuster adjuster) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(this.java$time$chrono$ChronoZonedDateTime$$super$with(adjuster));
    }

    @Override
    public ChronoZonedDateTime<D> with(TemporalField var1, long var2);

    public static ChronoZonedDateTime plus$(ChronoZonedDateTime $this, TemporalAmount amount) {
        return $this.plus(amount);
    }

    @Override
    default public ChronoZonedDateTime<D> plus(TemporalAmount amount) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(this.java$time$chrono$ChronoZonedDateTime$$super$plus(amount));
    }

    @Override
    public ChronoZonedDateTime<D> plus(long var1, TemporalUnit var3);

    public static ChronoZonedDateTime minus$(ChronoZonedDateTime $this, TemporalAmount amount) {
        return $this.minus(amount);
    }

    @Override
    default public ChronoZonedDateTime<D> minus(TemporalAmount amount) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(this.java$time$chrono$ChronoZonedDateTime$$super$minus(amount));
    }

    public static ChronoZonedDateTime minus$(ChronoZonedDateTime $this, long amountToSubtract, TemporalUnit unit) {
        return $this.minus(amountToSubtract, unit);
    }

    @Override
    default public ChronoZonedDateTime<D> minus(long amountToSubtract, TemporalUnit unit) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(this.java$time$chrono$ChronoZonedDateTime$$super$minus(amountToSubtract, unit));
    }

    public static Object query$(ChronoZonedDateTime $this, TemporalQuery query) {
        return $this.query(query);
    }

    @Override
    default public <R> R query(TemporalQuery<R> query) {
        TemporalQuery<R> temporalQuery;
        block12: {
            block9: {
                TemporalQuery<R> temporalQuery2;
                TemporalQuery<ZoneId> temporalQuery3;
                block11: {
                    block10: {
                        TemporalQuery<R> temporalQuery4;
                        TemporalQuery<ZoneId> temporalQuery5;
                        block8: {
                            temporalQuery = query;
                            temporalQuery5 = TemporalQueries$.MODULE$.zoneId();
                            temporalQuery4 = temporalQuery;
                            if (temporalQuery5 != null) break block8;
                            if (temporalQuery4 == null) break block9;
                            break block10;
                        }
                        if (temporalQuery5.equals(temporalQuery4)) break block9;
                    }
                    temporalQuery3 = TemporalQueries$.MODULE$.zone();
                    temporalQuery2 = temporalQuery;
                    if (temporalQuery3 != null) break block11;
                    if (temporalQuery2 == null) break block9;
                    break block12;
                }
                if (!temporalQuery3.equals(temporalQuery2)) break block12;
            }
            return (R)this.getZone();
        }
        TemporalQuery<Chronology> temporalQuery6 = TemporalQueries$.MODULE$.chronology();
        TemporalQuery<R> temporalQuery7 = temporalQuery;
        if (!(temporalQuery6 != null ? !temporalQuery6.equals(temporalQuery7) : temporalQuery7 != null)) {
            return (R)this.toLocalDate().getChronology();
        }
        TemporalQuery<TemporalUnit> temporalQuery8 = TemporalQueries$.MODULE$.precision();
        TemporalQuery<R> temporalQuery9 = temporalQuery;
        if (!(temporalQuery8 != null ? !temporalQuery8.equals(temporalQuery9) : temporalQuery9 != null)) {
            return (R)ChronoUnit$.NANOS;
        }
        TemporalQuery<ZoneOffset> temporalQuery10 = TemporalQueries$.MODULE$.offset();
        TemporalQuery<R> temporalQuery11 = temporalQuery;
        if (!(temporalQuery10 != null ? !temporalQuery10.equals(temporalQuery11) : temporalQuery11 != null)) {
            return (R)this.getOffset();
        }
        TemporalQuery<LocalDate> temporalQuery12 = TemporalQueries$.MODULE$.localDate();
        TemporalQuery<R> temporalQuery13 = temporalQuery;
        if (!(temporalQuery12 != null ? !temporalQuery12.equals(temporalQuery13) : temporalQuery13 != null)) {
            return (R)LocalDate$.MODULE$.ofEpochDay(this.toLocalDate().toEpochDay());
        }
        TemporalQuery<LocalTime> temporalQuery14 = TemporalQueries$.MODULE$.localTime();
        TemporalQuery<R> temporalQuery15 = temporalQuery;
        if (!(temporalQuery14 != null ? !temporalQuery14.equals(temporalQuery15) : temporalQuery15 != null)) {
            return (R)this.toLocalTime();
        }
        return (R)this.java$time$chrono$ChronoZonedDateTime$$super$query(query);
    }

    public static String format$(ChronoZonedDateTime $this, DateTimeFormatter formatter) {
        return $this.format(formatter);
    }

    default public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public static Instant toInstant$(ChronoZonedDateTime $this) {
        return $this.toInstant();
    }

    default public Instant toInstant() {
        return Instant$.MODULE$.ofEpochSecond(this.toEpochSecond(), this.toLocalTime().getNano());
    }

    public static long toEpochSecond$(ChronoZonedDateTime $this) {
        return $this.toEpochSecond();
    }

    default public long toEpochSecond() {
        long epochDay = this.toLocalDate().toEpochDay();
        long secs = epochDay * 86400L + (long)this.toLocalTime().toSecondOfDay();
        return secs -= (long)this.getOffset().getTotalSeconds();
    }

    public static int compare$(ChronoZonedDateTime $this, ChronoZonedDateTime other) {
        return $this.compare(other);
    }

    default public int compare(ChronoZonedDateTime<?> other) {
        int cmp = Long.compare(this.toEpochSecond(), other.toEpochSecond());
        if (cmp == 0 && (cmp = this.toLocalTime().getNano() - other.toLocalTime().getNano()) == 0 && (cmp = this.toLocalDateTime().compareTo(other.toLocalDateTime())) == 0 && (cmp = this.getZone().getId().compareTo(other.getZone().getId())) == 0) {
            cmp = this.toLocalDate().getChronology().compareTo(other.toLocalDate().getChronology());
        }
        return cmp;
    }

    public static boolean isAfter$(ChronoZonedDateTime $this, ChronoZonedDateTime other) {
        return $this.isAfter(other);
    }

    default public boolean isAfter(ChronoZonedDateTime<?> other) {
        long otherEpochSec;
        long thisEpochSec = this.toEpochSecond();
        return thisEpochSec > (otherEpochSec = other.toEpochSecond()) || thisEpochSec == otherEpochSec && this.toLocalTime().getNano() > other.toLocalTime().getNano();
    }

    public static boolean isBefore$(ChronoZonedDateTime $this, ChronoZonedDateTime other) {
        return $this.isBefore(other);
    }

    default public boolean isBefore(ChronoZonedDateTime<?> other) {
        long otherEpochSec;
        long thisEpochSec = this.toEpochSecond();
        return thisEpochSec < (otherEpochSec = other.toEpochSecond()) || thisEpochSec == otherEpochSec && this.toLocalTime().getNano() < other.toLocalTime().getNano();
    }

    public static boolean isEqual$(ChronoZonedDateTime $this, ChronoZonedDateTime other) {
        return $this.isEqual(other);
    }

    default public boolean isEqual(ChronoZonedDateTime<?> other) {
        return this.toEpochSecond() == other.toEpochSecond() && this.toLocalTime().getNano() == other.toLocalTime().getNano();
    }

    public static boolean equals$(ChronoZonedDateTime $this, Object obj) {
        return $this.equals(obj);
    }

    default public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ChronoZonedDateTime) {
            ChronoZonedDateTime other = (ChronoZonedDateTime)object;
            return this == other || this.compareTo(other) == 0;
        }
        return false;
    }

    public static int hashCode$(ChronoZonedDateTime $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        return this.toLocalDateTime().hashCode() ^ this.getOffset().hashCode() ^ Integer.rotateLeft(this.getZone().hashCode(), 3);
    }

    public static String toString$(ChronoZonedDateTime $this) {
        return $this.toString();
    }

    default public String toString() {
        String str = new StringBuilder(0).append(this.toLocalDateTime().toString()).append(this.getOffset().toString()).toString();
        if (this.getOffset() != this.getZone()) {
            str = new StringBuilder(0).append(str).append(new StringBuilder(2).append("[").append(this.getZone()).append("]").toString()).toString();
        }
        return str;
    }
}

