/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.Chronology;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import scala.collection.mutable.StringBuilder;

public final class ChronoPeriodImpl
implements ChronoPeriod,
Serializable {
    private static final long serialVersionUID = 275618735781L;
    private final Chronology chronology;
    private final int years;
    private final int months;
    private final int days;

    public ChronoPeriodImpl(Chronology chronology, int years, int months, int days) {
        this.chronology = chronology;
        this.years = years;
        this.months = months;
        this.days = days;
    }

    private Chronology chronology() {
        return this.chronology;
    }

    private int years() {
        return this.years;
    }

    private int months() {
        return this.months;
    }

    private int days() {
        return this.days;
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit$.YEARS) {
            return this.years();
        }
        if (unit == ChronoUnit$.MONTHS) {
            return this.months();
        }
        if (unit == ChronoUnit$.DAYS) {
            return this.days();
        }
        throw new UnsupportedTemporalTypeException(new java.lang.StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.unmodifiableList(Arrays.asList(ChronoUnit$.YEARS, ChronoUnit$.MONTHS, ChronoUnit$.DAYS));
    }

    @Override
    public Chronology getChronology() {
        return this.chronology();
    }

    @Override
    public ChronoPeriod plus(TemporalAmount amountToAdd) {
        TemporalAmount temporalAmount = amountToAdd;
        if (temporalAmount instanceof ChronoPeriodImpl) {
            ChronoPeriodImpl amount = (ChronoPeriodImpl)temporalAmount;
            Chronology chronology = amount.getChronology();
            Chronology chronology2 = this.getChronology();
            if (!(chronology != null ? !((Object)chronology).equals(chronology2) : chronology2 != null)) {
                return new ChronoPeriodImpl(this.chronology(), Math.addExact(this.years(), amount.years()), Math.addExact(this.months(), amount.months()), Math.addExact(this.days(), amount.days()));
            }
        }
        throw new DateTimeException(new java.lang.StringBuilder(22).append("Unable to add amount: ").append(amountToAdd).toString());
    }

    @Override
    public ChronoPeriod minus(TemporalAmount amountToSubtract) {
        TemporalAmount temporalAmount = amountToSubtract;
        if (temporalAmount instanceof ChronoPeriodImpl) {
            ChronoPeriodImpl amount = (ChronoPeriodImpl)temporalAmount;
            Chronology chronology = amount.getChronology();
            Chronology chronology2 = this.getChronology();
            if (!(chronology != null ? !((Object)chronology).equals(chronology2) : chronology2 != null)) {
                return new ChronoPeriodImpl(this.chronology(), Math.subtractExact(this.years(), amount.years()), Math.subtractExact(this.months(), amount.months()), Math.subtractExact(this.days(), amount.days()));
            }
        }
        throw new DateTimeException(new java.lang.StringBuilder(27).append("Unable to subtract amount: ").append(amountToSubtract).toString());
    }

    @Override
    public ChronoPeriod multipliedBy(int scalar) {
        return new ChronoPeriodImpl(this.chronology(), Math.multiplyExact(this.years(), scalar), Math.multiplyExact(this.months(), scalar), Math.multiplyExact(this.days(), scalar));
    }

    @Override
    public ChronoPeriod normalized() {
        if (this.chronology().range(ChronoField$.MONTH_OF_YEAR).isFixed()) {
            long monthLength = this.chronology().range(ChronoField$.MONTH_OF_YEAR).getMaximum() - this.chronology().range(ChronoField$.MONTH_OF_YEAR).getMinimum() + 1L;
            long total = (long)this.years() * monthLength + (long)this.months();
            int _years = Math.toIntExact(total / monthLength);
            int _months = Math.toIntExact(total % monthLength);
            return new ChronoPeriodImpl(this.chronology(), _years, _months, this.days());
        }
        return this;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        Temporal _temporal = temporal;
        Chronology temporalChrono = _temporal.query(TemporalQueries$.MODULE$.chronology());
        if (temporalChrono != null) {
            Chronology chronology = this.chronology();
            Chronology chronology2 = temporalChrono;
            if (chronology == null ? chronology2 != null : !((Object)chronology).equals(chronology2)) {
                throw new DateTimeException(new java.lang.StringBuilder(41).append("Invalid chronology, required: ").append(this.chronology().getId()).append(", but was: ").append(temporalChrono.getId()).toString());
            }
        }
        if (this.years() != 0) {
            _temporal = _temporal.plus(this.years(), ChronoUnit$.YEARS);
        }
        if (this.months() != 0) {
            _temporal = _temporal.plus(this.months(), ChronoUnit$.MONTHS);
        }
        if (this.days() != 0) {
            _temporal = _temporal.plus(this.days(), ChronoUnit$.DAYS);
        }
        return _temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        Temporal _temporal = temporal;
        Chronology temporalChrono = _temporal.query(TemporalQueries$.MODULE$.chronology());
        if (temporalChrono != null) {
            Chronology chronology = this.chronology();
            Chronology chronology2 = temporalChrono;
            if (chronology == null ? chronology2 != null : !((Object)chronology).equals(chronology2)) {
                throw new DateTimeException(new java.lang.StringBuilder(41).append("Invalid chronology, required: ").append(this.chronology().getId()).append(", but was: ").append(temporalChrono.getId()).toString());
            }
        }
        if (this.years() != 0) {
            _temporal = _temporal.minus(this.years(), ChronoUnit$.YEARS);
        }
        if (this.months() != 0) {
            _temporal = _temporal.minus(this.months(), ChronoUnit$.MONTHS);
        }
        if (this.days() != 0) {
            _temporal = _temporal.minus(this.days(), ChronoUnit$.DAYS);
        }
        return _temporal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof ChronoPeriodImpl)) return false;
        ChronoPeriodImpl other = (ChronoPeriodImpl)object;
        if (this == other) return true;
        if (this.years() != other.years()) return false;
        if (this.months() != other.months()) return false;
        if (this.days() != other.days()) return false;
        Chronology chronology = this.chronology();
        Chronology chronology2 = other.chronology();
        if (chronology != null) {
            if (!((Object)chronology).equals(chronology2)) return false;
            return true;
        }
        if (chronology2 == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        return this.chronology().hashCode() + Integer.rotateLeft(this.years(), 16) + Integer.rotateLeft(this.months(), 8) + this.days();
    }

    @Override
    public String toString() {
        if (this.isZero()) {
            return new java.lang.StringBuilder(4).append(this.chronology()).append(" P0D").toString();
        }
        StringBuilder buf = new StringBuilder();
        buf.append((Object)this.chronology()).append(' ').append('P');
        if (this.years() != 0) {
            buf.append(this.years()).append('Y');
        }
        if (this.months() != 0) {
            buf.append(this.months()).append('M');
        }
        if (this.days() != 0) {
            buf.append(this.days()).append('D');
        }
        return buf.toString();
    }
}

