/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.LocalTime;
import java.time.LocalTime$;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoLocalDateTimeImpl$;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.ChronoZonedDateTimeImpl$;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Objects;

public final class ChronoLocalDateTimeImpl<D extends ChronoLocalDate>
extends ChronoLocalDateTime<D>
implements Serializable {
    private static final long serialVersionUID = 4556003607393004514L;
    private final ChronoLocalDate date;
    private final LocalTime time;

    public static <R extends ChronoLocalDate> ChronoLocalDateTimeImpl<R> of(R r, LocalTime localTime) {
        return ChronoLocalDateTimeImpl$.MODULE$.of(r, localTime);
    }

    public ChronoLocalDateTimeImpl(D date, LocalTime time) {
        this.date = date;
        this.time = time;
        Objects.requireNonNull(date, "date");
        Objects.requireNonNull(time, "time");
    }

    private D date() {
        return (D)this.date;
    }

    private LocalTime time() {
        return this.time;
    }

    private ChronoLocalDateTimeImpl<D> with(Temporal newDate, LocalTime newTime) {
        if (this.date() == newDate && this.time() == newTime) {
            return this;
        }
        Object cd = this.date().getChronology().ensureChronoLocalDate(newDate);
        return new ChronoLocalDateTimeImpl(cd, newTime);
    }

    @Override
    public D toLocalDate() {
        return this.date();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time();
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field.isDateBased() || field.isTimeBased();
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit.isDateBased() || unit.isTimeBased();
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field.isTimeBased()) {
                return this.time().range(field);
            }
            return this.date().range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field.isTimeBased()) {
                return this.time().get(field);
            }
            return this.date().get(field);
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field.isTimeBased()) {
                return this.time().getLong(field);
            }
            return this.date().getLong(field);
        }
        return field.getFrom(this);
    }

    @Override
    public ChronoLocalDateTimeImpl<D> with(TemporalAdjuster adjuster) {
        if (adjuster instanceof ChronoLocalDate) {
            return this.with((ChronoLocalDate)adjuster, this.time());
        }
        if (adjuster instanceof LocalTime) {
            return this.with((Temporal)this.date(), (LocalTime)adjuster);
        }
        if (adjuster instanceof ChronoLocalDateTimeImpl) {
            return this.date().getChronology().ensureChronoLocalDateTime((ChronoLocalDateTimeImpl)adjuster);
        }
        return this.date().getChronology().ensureChronoLocalDateTime((ChronoLocalDateTimeImpl)adjuster.adjustInto(this));
    }

    @Override
    public ChronoLocalDateTimeImpl<D> with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            if (field.isTimeBased()) {
                return this.with((Temporal)this.date(), this.time().with(field, newValue));
            }
            return this.with(this.date().with(field, newValue), this.time());
        }
        return this.date().getChronology().ensureChronoLocalDateTime(field.adjustInto(this, newValue));
    }

    @Override
    public ChronoLocalDateTimeImpl<D> plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit f;
            ChronoUnit chronoUnit = f = (ChronoUnit)unit;
            ChronoUnit chronoUnit2 = ChronoUnit$.NANOS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.plusNanos(amountToAdd);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.MICROS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return super.plusNanos(amountToAdd % 86400000000L * 1000L);
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MILLIS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return super.plusNanos(amountToAdd % 86400000L * 1000000L);
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.SECONDS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.plusSeconds(amountToAdd);
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.MINUTES;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return this.plusMinutes(amountToAdd);
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.HOURS;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return this.plusHours(amountToAdd);
            }
            ChronoUnit chronoUnit14 = ChronoUnit$.HALF_DAYS;
            ChronoUnit chronoUnit15 = chronoUnit;
            if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                return super.plusHours(amountToAdd % 256L * 12L);
            }
            return this.with(this.date().plus(amountToAdd, unit), this.time());
        }
        return this.date().getChronology().ensureChronoLocalDateTime(unit.addTo(this, amountToAdd));
    }

    private ChronoLocalDateTimeImpl<D> plusDays(long days) {
        return this.with(this.date().plus(days, ChronoUnit$.DAYS), this.time());
    }

    private ChronoLocalDateTimeImpl<D> plusHours(long hours) {
        return this.plusWithOverflow(this.date(), hours, 0L, 0L, 0L);
    }

    private ChronoLocalDateTimeImpl<D> plusMinutes(long minutes) {
        return this.plusWithOverflow(this.date(), 0L, minutes, 0L, 0L);
    }

    public ChronoLocalDateTimeImpl<D> plusSeconds(long seconds) {
        return this.plusWithOverflow(this.date(), 0L, 0L, seconds, 0L);
    }

    private ChronoLocalDateTimeImpl<D> plusNanos(long nanos) {
        return this.plusWithOverflow(this.date(), 0L, 0L, 0L, nanos);
    }

    private ChronoLocalDateTimeImpl<D> plusWithOverflow(D newDate, long hours, long minutes, long seconds, long nanos) {
        if ((hours | minutes | seconds | nanos) == 0L) {
            return this.with((Temporal)newDate, this.time());
        }
        long totDays = nanos / 86400000000000L + seconds / 86400L + minutes / 1440L + hours / 24L;
        long totNanos = nanos % 86400000000000L + seconds % 86400L * 1000000000L + minutes % 1440L * 60000000000L + hours % 24L * 3600000000000L;
        long curNoD = this.time().toNanoOfDay();
        long newNoD = Math.floorMod(totNanos, 86400000000000L);
        LocalTime newTime = newNoD == curNoD ? this.time() : LocalTime$.MODULE$.ofNanoOfDay(newNoD);
        return this.with(newDate.plus(totDays += Math.floorDiv(totNanos += curNoD, 86400000000000L), ChronoUnit$.DAYS), newTime);
    }

    @Override
    public ChronoZonedDateTime<D> atZone(ZoneId zoneId) {
        return ChronoZonedDateTimeImpl$.MODULE$.ofBest(this, zoneId, null);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        ChronoLocalDateTime<?> end = this.toLocalDate().getChronology().localDateTime(endExclusive);
        if (unit instanceof ChronoUnit) {
            ChronoUnit f = (ChronoUnit)unit;
            if (f.isTimeBased()) {
                long amount = end.getLong(ChronoField$.EPOCH_DAY) - this.date().getLong(ChronoField$.EPOCH_DAY);
                ChronoUnit chronoUnit = f;
                ChronoUnit chronoUnit2 = ChronoUnit$.NANOS;
                ChronoUnit chronoUnit3 = chronoUnit;
                if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                    amount = Math.multiplyExact(amount, 86400000000000L);
                } else {
                    ChronoUnit chronoUnit4 = ChronoUnit$.MICROS;
                    ChronoUnit chronoUnit5 = chronoUnit;
                    if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                        amount = Math.multiplyExact(amount, 86400000000L);
                    } else {
                        ChronoUnit chronoUnit6 = ChronoUnit$.MILLIS;
                        ChronoUnit chronoUnit7 = chronoUnit;
                        if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                            amount = Math.multiplyExact(amount, 86400000L);
                        } else {
                            ChronoUnit chronoUnit8 = ChronoUnit$.SECONDS;
                            ChronoUnit chronoUnit9 = chronoUnit;
                            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                                amount = Math.multiplyExact(amount, (long)86400);
                            } else {
                                ChronoUnit chronoUnit10 = ChronoUnit$.MINUTES;
                                ChronoUnit chronoUnit11 = chronoUnit;
                                if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                                    amount = Math.multiplyExact(amount, (long)1440);
                                } else {
                                    ChronoUnit chronoUnit12 = ChronoUnit$.HOURS;
                                    ChronoUnit chronoUnit13 = chronoUnit;
                                    if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                                        amount = Math.multiplyExact(amount, (long)24);
                                    } else {
                                        ChronoUnit chronoUnit14 = ChronoUnit$.HALF_DAYS;
                                        ChronoUnit chronoUnit15 = chronoUnit;
                                        if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                                            amount = Math.multiplyExact(amount, 2L);
                                        } else {
                                            throw new UnsupportedOperationException();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                return Math.addExact(amount, this.time().until(end.toLocalTime(), unit));
            }
            Object endDate = end.toLocalDate();
            if (end.toLocalTime().isBefore(this.time())) {
                endDate = endDate.minus(1L, ChronoUnit$.DAYS);
            }
            return this.date().until((Temporal)endDate, unit);
        }
        return unit.between(this, end);
    }
}

