/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.Instant;
import java.time.Instant$;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime$;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.util.Comparator;
import java.util.Objects;
import scala.math.Ordered;

public abstract class ChronoLocalDateTime<D extends ChronoLocalDate>
implements Temporal,
TemporalAdjuster,
Ordered<ChronoLocalDateTime<?>> {
    public static ChronoLocalDateTime<?> from(TemporalAccessor temporalAccessor) {
        return ChronoLocalDateTime$.MODULE$.from(temporalAccessor);
    }

    public static Comparator<ChronoLocalDateTime<? extends ChronoLocalDate>> timeLineOrder() {
        return ChronoLocalDateTime$.MODULE$.timeLineOrder();
    }

    public ChronoLocalDateTime() {
        Ordered.$init$((Ordered)this);
    }

    public Chronology getChronology() {
        return this.toLocalDate().getChronology();
    }

    public abstract D toLocalDate();

    public abstract LocalTime toLocalTime();

    @Override
    public ChronoLocalDateTime<D> with(TemporalAdjuster adjuster) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(Temporal.with$(this, adjuster));
    }

    @Override
    public abstract ChronoLocalDateTime<D> with(TemporalField var1, long var2);

    @Override
    public ChronoLocalDateTime<D> plus(TemporalAmount amount) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(Temporal.plus$(this, amount));
    }

    @Override
    public abstract ChronoLocalDateTime<D> plus(long var1, TemporalUnit var3);

    @Override
    public ChronoLocalDateTime<D> minus(TemporalAmount amount) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(Temporal.minus$(this, amount));
    }

    @Override
    public ChronoLocalDateTime<D> minus(long amountToSubtract, TemporalUnit unit) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(Temporal.minus$(this, amountToSubtract, unit));
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        block13: {
            block8: {
                TemporalQuery<R> temporalQuery;
                TemporalQuery<ZoneOffset> temporalQuery2;
                block12: {
                    TemporalQuery<R> temporalQuery3;
                    block11: {
                        TemporalQuery<R> temporalQuery4;
                        TemporalQuery<ZoneId> temporalQuery5;
                        block10: {
                            block9: {
                                TemporalQuery<R> temporalQuery6;
                                TemporalQuery<ZoneId> temporalQuery7;
                                block7: {
                                    temporalQuery3 = query;
                                    TemporalQuery<Chronology> temporalQuery8 = TemporalQueries$.MODULE$.chronology();
                                    TemporalQuery<R> temporalQuery9 = temporalQuery3;
                                    if (!(temporalQuery8 != null ? !temporalQuery8.equals(temporalQuery9) : temporalQuery9 != null)) {
                                        return (R)this.getChronology();
                                    }
                                    TemporalQuery<TemporalUnit> temporalQuery10 = TemporalQueries$.MODULE$.precision();
                                    TemporalQuery<R> temporalQuery11 = temporalQuery3;
                                    if (!(temporalQuery10 != null ? !temporalQuery10.equals(temporalQuery11) : temporalQuery11 != null)) {
                                        return (R)ChronoUnit$.NANOS;
                                    }
                                    TemporalQuery<LocalDate> temporalQuery12 = TemporalQueries$.MODULE$.localDate();
                                    TemporalQuery<R> temporalQuery13 = temporalQuery3;
                                    if (!(temporalQuery12 != null ? !temporalQuery12.equals(temporalQuery13) : temporalQuery13 != null)) {
                                        return (R)LocalDate$.MODULE$.ofEpochDay(this.toLocalDate().toEpochDay());
                                    }
                                    TemporalQuery<LocalTime> temporalQuery14 = TemporalQueries$.MODULE$.localTime();
                                    TemporalQuery<R> temporalQuery15 = temporalQuery3;
                                    if (!(temporalQuery14 != null ? !temporalQuery14.equals(temporalQuery15) : temporalQuery15 != null)) {
                                        return (R)this.toLocalTime();
                                    }
                                    temporalQuery7 = TemporalQueries$.MODULE$.zone();
                                    temporalQuery6 = temporalQuery3;
                                    if (temporalQuery7 != null) break block7;
                                    if (temporalQuery6 == null) break block8;
                                    break block9;
                                }
                                if (temporalQuery7.equals(temporalQuery6)) break block8;
                            }
                            temporalQuery5 = TemporalQueries$.MODULE$.zoneId();
                            temporalQuery4 = temporalQuery3;
                            if (temporalQuery5 != null) break block10;
                            if (temporalQuery4 == null) break block8;
                            break block11;
                        }
                        if (temporalQuery5.equals(temporalQuery4)) break block8;
                    }
                    temporalQuery2 = TemporalQueries$.MODULE$.offset();
                    temporalQuery = temporalQuery3;
                    if (temporalQuery2 != null) break block12;
                    if (temporalQuery == null) break block8;
                    break block13;
                }
                if (!temporalQuery2.equals(temporalQuery)) break block13;
            }
            return null;
        }
        return (R)TemporalAccessor.query$(this, query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField$.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField$.NANO_OF_DAY, this.toLocalTime().toNanoOfDay());
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public abstract ChronoZonedDateTime<D> atZone(ZoneId var1);

    public Instant toInstant(ZoneOffset offset) {
        return Instant$.MODULE$.ofEpochSecond(this.toEpochSecond(offset), this.toLocalTime().getNano());
    }

    public long toEpochSecond(ZoneOffset offset) {
        Objects.requireNonNull(offset, "offset");
        long epochDay = this.toLocalDate().toEpochDay();
        long secs = epochDay * 86400L + (long)this.toLocalTime().toSecondOfDay();
        return secs -= (long)offset.getTotalSeconds();
    }

    public int compare(ChronoLocalDateTime<?> other) {
        int cmp = this.toLocalDate().compareTo(other.toLocalDate());
        if (cmp == 0 && (cmp = this.toLocalTime().compareTo(other.toLocalTime())) == 0) {
            cmp = this.getChronology().compareTo(other.getChronology());
        }
        return cmp;
    }

    public boolean isAfter(ChronoLocalDateTime<? extends ChronoLocalDate> other) {
        long otherEpDay;
        long thisEpDay = this.toLocalDate().toEpochDay();
        return thisEpDay > (otherEpDay = other.toLocalDate().toEpochDay()) || thisEpDay == otherEpDay && this.toLocalTime().toNanoOfDay() > other.toLocalTime().toNanoOfDay();
    }

    public boolean isBefore(ChronoLocalDateTime<? extends ChronoLocalDate> other) {
        long otherEpDay;
        long thisEpDay = this.toLocalDate().toEpochDay();
        return thisEpDay < (otherEpDay = other.toLocalDate().toEpochDay()) || thisEpDay == otherEpDay && this.toLocalTime().toNanoOfDay() < other.toLocalTime().toNanoOfDay();
    }

    public boolean isEqual(ChronoLocalDateTime<? extends ChronoLocalDate> other) {
        return this.toLocalTime().toNanoOfDay() == other.toLocalTime().toNanoOfDay() && this.toLocalDate().toEpochDay() == other.toLocalDate().toEpochDay();
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ChronoLocalDateTime) {
            ChronoLocalDateTime other = (ChronoLocalDateTime)object;
            return this == other || this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toLocalDate().hashCode() ^ this.toLocalTime().hashCode();
    }

    public String toString() {
        return new StringBuilder(11).append(this.toLocalDate().toString()).append('T').append(this.toLocalTime().toString()).toString();
    }
}

