/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate$;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoLocalDateTimeImpl$;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import scala.math.Ordered;

public abstract class ChronoLocalDateImpl<D extends ChronoLocalDate>
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = 6282433883239719096L;

    public ChronoLocalDateImpl() {
        Ordered.$init$((Ordered)this);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$with(TemporalAdjuster adjuster) {
        return Temporal.with$(this, adjuster);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$plus(TemporalAmount amount) {
        return Temporal.plus$(this, amount);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$minus(TemporalAmount amount) {
        return Temporal.minus$(this, amount);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$minus(long amountToSubtract, TemporalUnit unit) {
        return Temporal.minus$(this, amountToSubtract, unit);
    }

    @Override
    public /* synthetic */ Object java$time$chrono$ChronoLocalDate$$super$query(TemporalQuery query) {
        return TemporalAccessor.query$(this, query);
    }

    @Override
    public ChronoLocalDateImpl<D> plus(long amountToAdd, TemporalUnit unit) {
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit f;
            ChronoUnit chronoUnit = f = (ChronoUnit)temporalUnit;
            ChronoUnit chronoUnit2 = ChronoUnit$.DAYS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.plusDays(amountToAdd);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.WEEKS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return this.plusDays(Math.multiplyExact(amountToAdd, 7L));
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MONTHS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return this.plusMonths(amountToAdd);
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.YEARS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.plusYears(amountToAdd);
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.DECADES;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 10L));
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.CENTURIES;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 100L));
            }
            ChronoUnit chronoUnit14 = ChronoUnit$.MILLENNIA;
            ChronoUnit chronoUnit15 = chronoUnit;
            if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 1000L));
            }
            throw new DateTimeException(new StringBuilder(26).append(unit).append(" not valid for chronology ").append(this.getChronology().getId()).toString());
        }
        return (ChronoLocalDateImpl)this.getChronology().ensureChronoLocalDate(unit.addTo(this, amountToAdd));
    }

    public abstract ChronoLocalDateImpl<D> plusYears(long var1);

    public abstract ChronoLocalDateImpl<D> plusMonths(long var1);

    public ChronoLocalDateImpl<D> plusWeeks(long weeksToAdd) {
        return this.plusDays(Math.multiplyExact(weeksToAdd, 7));
    }

    public abstract ChronoLocalDateImpl<D> plusDays(long var1);

    public ChronoLocalDateImpl<D> minusYears(long yearsToSubtract) {
        if (yearsToSubtract == Long.MIN_VALUE) {
            return this.plusYears(Long.MAX_VALUE).plusYears(1L);
        }
        return this.plusYears(-yearsToSubtract);
    }

    public ChronoLocalDateImpl<D> minusMonths(long monthsToSubtract) {
        if (monthsToSubtract == Long.MIN_VALUE) {
            return this.plusMonths(Long.MAX_VALUE).plusMonths(1L);
        }
        return this.plusMonths(-monthsToSubtract);
    }

    public ChronoLocalDateImpl<D> minusWeeks(long weeksToSubtract) {
        if (weeksToSubtract == Long.MIN_VALUE) {
            return this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L);
        }
        return this.plusWeeks(-weeksToSubtract);
    }

    public ChronoLocalDateImpl<D> minusDays(long daysToSubtract) {
        if (daysToSubtract == Long.MIN_VALUE) {
            return this.plusDays(Long.MAX_VALUE).plusDays(1L);
        }
        return this.plusDays(-daysToSubtract);
    }

    @Override
    public ChronoLocalDateTime<? extends ChronoLocalDate> atTime(LocalTime localTime) {
        return ChronoLocalDateTimeImpl$.MODULE$.of(this, localTime);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        ChronoLocalDate end = this.getChronology().date(endExclusive);
        if (unit instanceof ChronoUnit) {
            return LocalDate$.MODULE$.from(this).until(end, unit);
        }
        return unit.between(this, end);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDate) {
        throw new UnsupportedOperationException("Not supported in ThreeTen backport");
    }
}

