/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate$;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoLocalDateTimeImpl$;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.util.Comparator;
import java.util.Objects;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordered;

public interface ChronoLocalDate
extends Temporal,
TemporalAdjuster,
Ordered<ChronoLocalDate> {
    public static ChronoLocalDate from(TemporalAccessor temporalAccessor) {
        return ChronoLocalDate$.MODULE$.from(temporalAccessor);
    }

    public static Comparator<ChronoLocalDate> timeLineOrder() {
        return ChronoLocalDate$.MODULE$.timeLineOrder();
    }

    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$with(TemporalAdjuster var1);

    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$plus(TemporalAmount var1);

    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$minus(TemporalAmount var1);

    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$minus(long var1, TemporalUnit var3);

    public /* synthetic */ Object java$time$chrono$ChronoLocalDate$$super$query(TemporalQuery var1);

    public Chronology getChronology();

    public static Era getEra$(ChronoLocalDate $this) {
        return $this.getEra();
    }

    default public Era getEra() {
        return this.getChronology().eraOf(this.get(ChronoField$.ERA));
    }

    public static boolean isLeapYear$(ChronoLocalDate $this) {
        return $this.isLeapYear();
    }

    default public boolean isLeapYear() {
        return this.getChronology().isLeapYear(this.getLong(ChronoField$.YEAR));
    }

    public int lengthOfMonth();

    public static int lengthOfYear$(ChronoLocalDate $this) {
        return $this.lengthOfYear();
    }

    default public int lengthOfYear() {
        if (this.isLeapYear()) {
            return 366;
        }
        return 365;
    }

    public static boolean isSupported$(ChronoLocalDate $this, TemporalField field) {
        return $this.isSupported(field);
    }

    @Override
    default public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field.isDateBased();
        }
        return field != null && field.isSupportedBy(this);
    }

    public static boolean isSupported$(ChronoLocalDate $this, TemporalUnit unit) {
        return $this.isSupported(unit);
    }

    @Override
    default public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit.isDateBased();
        }
        return unit != null && unit.isSupportedBy(this);
    }

    public static ChronoLocalDate with$(ChronoLocalDate $this, TemporalAdjuster adjuster) {
        return $this.with(adjuster);
    }

    @Override
    default public ChronoLocalDate with(TemporalAdjuster adjuster) {
        return this.getChronology().ensureChronoLocalDate(this.java$time$chrono$ChronoLocalDate$$super$with(adjuster));
    }

    @Override
    public ChronoLocalDate with(TemporalField var1, long var2);

    public static ChronoLocalDate plus$(ChronoLocalDate $this, TemporalAmount amount) {
        return $this.plus(amount);
    }

    @Override
    default public ChronoLocalDate plus(TemporalAmount amount) {
        return this.getChronology().ensureChronoLocalDate(this.java$time$chrono$ChronoLocalDate$$super$plus(amount));
    }

    @Override
    public ChronoLocalDate plus(long var1, TemporalUnit var3);

    public static ChronoLocalDate minus$(ChronoLocalDate $this, TemporalAmount amount) {
        return $this.minus(amount);
    }

    @Override
    default public ChronoLocalDate minus(TemporalAmount amount) {
        return this.getChronology().ensureChronoLocalDate(this.java$time$chrono$ChronoLocalDate$$super$minus(amount));
    }

    public static ChronoLocalDate minus$(ChronoLocalDate $this, long amountToSubtract, TemporalUnit unit) {
        return $this.minus(amountToSubtract, unit);
    }

    @Override
    default public ChronoLocalDate minus(long amountToSubtract, TemporalUnit unit) {
        return this.getChronology().ensureChronoLocalDate(this.java$time$chrono$ChronoLocalDate$$super$minus(amountToSubtract, unit));
    }

    public static Object query$(ChronoLocalDate $this, TemporalQuery query) {
        return $this.query(query);
    }

    @Override
    default public <R> R query(TemporalQuery<R> query) {
        block14: {
            block7: {
                TemporalQuery<R> temporalQuery;
                TemporalQuery<ZoneOffset> temporalQuery2;
                block13: {
                    TemporalQuery<R> temporalQuery3;
                    block12: {
                        TemporalQuery<R> temporalQuery4;
                        TemporalQuery<ZoneId> temporalQuery5;
                        block11: {
                            block10: {
                                TemporalQuery<R> temporalQuery6;
                                TemporalQuery<ZoneId> temporalQuery7;
                                block9: {
                                    block8: {
                                        TemporalQuery<R> temporalQuery8;
                                        TemporalQuery<LocalTime> temporalQuery9;
                                        block6: {
                                            temporalQuery3 = query;
                                            TemporalQuery<Chronology> temporalQuery10 = TemporalQueries$.MODULE$.chronology();
                                            TemporalQuery<R> temporalQuery11 = temporalQuery3;
                                            if (!(temporalQuery10 != null ? !temporalQuery10.equals(temporalQuery11) : temporalQuery11 != null)) {
                                                return (R)this.getChronology();
                                            }
                                            TemporalQuery<TemporalUnit> temporalQuery12 = TemporalQueries$.MODULE$.precision();
                                            TemporalQuery<R> temporalQuery13 = temporalQuery3;
                                            if (!(temporalQuery12 != null ? !temporalQuery12.equals(temporalQuery13) : temporalQuery13 != null)) {
                                                return (R)ChronoUnit$.DAYS;
                                            }
                                            TemporalQuery<LocalDate> temporalQuery14 = TemporalQueries$.MODULE$.localDate();
                                            TemporalQuery<R> temporalQuery15 = temporalQuery3;
                                            if (!(temporalQuery14 != null ? !temporalQuery14.equals(temporalQuery15) : temporalQuery15 != null)) {
                                                return (R)LocalDate$.MODULE$.ofEpochDay(this.toEpochDay());
                                            }
                                            temporalQuery9 = TemporalQueries$.MODULE$.localTime();
                                            temporalQuery8 = temporalQuery3;
                                            if (temporalQuery9 != null) break block6;
                                            if (temporalQuery8 == null) break block7;
                                            break block8;
                                        }
                                        if (temporalQuery9.equals(temporalQuery8)) break block7;
                                    }
                                    temporalQuery7 = TemporalQueries$.MODULE$.zone();
                                    temporalQuery6 = temporalQuery3;
                                    if (temporalQuery7 != null) break block9;
                                    if (temporalQuery6 == null) break block7;
                                    break block10;
                                }
                                if (temporalQuery7.equals(temporalQuery6)) break block7;
                            }
                            temporalQuery5 = TemporalQueries$.MODULE$.zoneId();
                            temporalQuery4 = temporalQuery3;
                            if (temporalQuery5 != null) break block11;
                            if (temporalQuery4 == null) break block7;
                            break block12;
                        }
                        if (temporalQuery5.equals(temporalQuery4)) break block7;
                    }
                    temporalQuery2 = TemporalQueries$.MODULE$.offset();
                    temporalQuery = temporalQuery3;
                    if (temporalQuery2 != null) break block13;
                    if (temporalQuery == null) break block7;
                    break block14;
                }
                if (!temporalQuery2.equals(temporalQuery)) break block14;
            }
            return null;
        }
        return (R)this.java$time$chrono$ChronoLocalDate$$super$query(query);
    }

    public static Temporal adjustInto$(ChronoLocalDate $this, Temporal temporal) {
        return $this.adjustInto(temporal);
    }

    @Override
    default public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField$.EPOCH_DAY, this.toEpochDay());
    }

    public ChronoPeriod until(ChronoLocalDate var1);

    public static String format$(ChronoLocalDate $this, DateTimeFormatter formatter) {
        return $this.format(formatter);
    }

    default public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public static ChronoLocalDateTime atTime$(ChronoLocalDate $this, LocalTime localTime) {
        return $this.atTime(localTime);
    }

    default public ChronoLocalDateTime<? extends ChronoLocalDate> atTime(LocalTime localTime) {
        return ChronoLocalDateTimeImpl$.MODULE$.of(this, localTime);
    }

    public static long toEpochDay$(ChronoLocalDate $this) {
        return $this.toEpochDay();
    }

    default public long toEpochDay() {
        return this.getLong(ChronoField$.EPOCH_DAY);
    }

    public static int compare$(ChronoLocalDate $this, ChronoLocalDate other) {
        return $this.compare(other);
    }

    default public int compare(ChronoLocalDate other) {
        int cmp = Long.compare(this.toEpochDay(), other.toEpochDay());
        if (cmp == 0) {
            cmp = this.getChronology().compareTo(other.getChronology());
        }
        return cmp;
    }

    public static boolean isAfter$(ChronoLocalDate $this, ChronoLocalDate other) {
        return $this.isAfter(other);
    }

    default public boolean isAfter(ChronoLocalDate other) {
        return this.toEpochDay() > other.toEpochDay();
    }

    public static boolean isBefore$(ChronoLocalDate $this, ChronoLocalDate other) {
        return $this.isBefore(other);
    }

    default public boolean isBefore(ChronoLocalDate other) {
        return this.toEpochDay() < other.toEpochDay();
    }

    public static boolean isEqual$(ChronoLocalDate $this, ChronoLocalDate other) {
        return $this.isEqual(other);
    }

    default public boolean isEqual(ChronoLocalDate other) {
        return this.toEpochDay() == other.toEpochDay();
    }

    public static boolean equals$(ChronoLocalDate $this, Object obj) {
        return $this.equals(obj);
    }

    default public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ChronoLocalDate) {
            ChronoLocalDate other = (ChronoLocalDate)object;
            return this == other || this.compareTo(other) == 0;
        }
        return false;
    }

    public static int hashCode$(ChronoLocalDate $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        long epDay = this.toEpochDay();
        return this.getChronology().hashCode() ^ (int)(epDay ^ epDay >>> 32);
    }

    public static String toString$(ChronoLocalDate $this) {
        return $this.toString();
    }

    default public String toString() {
        long yoe = this.getLong(ChronoField$.YEAR_OF_ERA);
        long moy = this.getLong(ChronoField$.MONTH_OF_YEAR);
        long dom = this.getLong(ChronoField$.DAY_OF_MONTH);
        StringBuilder buf = new StringBuilder(30);
        buf.append(this.getChronology().toString()).append(" ").append((Object)this.getEra()).append(" ").append(yoe).append(moy < 10L ? "-0" : "-").append(moy).append(dom < 10L ? "-0" : "-").append(dom);
        return buf.toString();
    }
}

