/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalDateTime$;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetDateTime$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.ZonedDateTime$;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneOffsetTransition;
import java.util.Objects;
import scala.math.Ordered;

public final class ZonedDateTime
implements ChronoZonedDateTime<LocalDate>,
Serializable {
    private static final long serialVersionUID = -6260982410461394882L;
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;

    public static ZonedDateTime from(TemporalAccessor temporalAccessor) {
        return ZonedDateTime$.MODULE$.from(temporalAccessor);
    }

    public static ZonedDateTime now() {
        return ZonedDateTime$.MODULE$.now();
    }

    public static ZonedDateTime now(Clock clock) {
        return ZonedDateTime$.MODULE$.now(clock);
    }

    public static ZonedDateTime now(ZoneId zoneId) {
        return ZonedDateTime$.MODULE$.now(zoneId);
    }

    public static ZonedDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7, ZoneId zoneId) {
        return ZonedDateTime$.MODULE$.of(n, n2, n3, n4, n5, n6, n7, zoneId);
    }

    public static ZonedDateTime of(LocalDate localDate, LocalTime localTime, ZoneId zoneId) {
        return ZonedDateTime$.MODULE$.of(localDate, localTime, zoneId);
    }

    public static ZonedDateTime of(LocalDateTime localDateTime, ZoneId zoneId) {
        return ZonedDateTime$.MODULE$.of(localDateTime, zoneId);
    }

    public static ZonedDateTime ofInstant(Instant instant, ZoneId zoneId) {
        return ZonedDateTime$.MODULE$.ofInstant(instant, zoneId);
    }

    public static ZonedDateTime ofInstant(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        return ZonedDateTime$.MODULE$.ofInstant(localDateTime, zoneOffset, zoneId);
    }

    public static ZonedDateTime ofLocal(LocalDateTime localDateTime, ZoneId zoneId, ZoneOffset zoneOffset) {
        return ZonedDateTime$.MODULE$.ofLocal(localDateTime, zoneId, zoneOffset);
    }

    public static ZonedDateTime ofStrict(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        return ZonedDateTime$.MODULE$.ofStrict(localDateTime, zoneOffset, zoneId);
    }

    public static ZonedDateTime parse(CharSequence charSequence) {
        return ZonedDateTime$.MODULE$.parse(charSequence);
    }

    public static ZonedDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return ZonedDateTime$.MODULE$.parse(charSequence, dateTimeFormatter);
    }

    public ZonedDateTime(LocalDateTime dateTime, ZoneOffset offset, ZoneId zone) {
        this.dateTime = dateTime;
        this.offset = offset;
        this.zone = zone;
        Ordered.$init$((Ordered)this);
    }

    @Override
    public /* synthetic */ int java$time$chrono$ChronoZonedDateTime$$super$get(TemporalField field) {
        return TemporalAccessor.get$(this, field);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$with(TemporalAdjuster adjuster) {
        return Temporal.with$(this, adjuster);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$plus(TemporalAmount amount) {
        return Temporal.plus$(this, amount);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$minus(TemporalAmount amount) {
        return Temporal.minus$(this, amount);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoZonedDateTime$$super$minus(long amountToSubtract, TemporalUnit unit) {
        return Temporal.minus$(this, amountToSubtract, unit);
    }

    @Override
    public /* synthetic */ Object java$time$chrono$ChronoZonedDateTime$$super$query(TemporalQuery query) {
        return TemporalAccessor.query$(this, query);
    }

    private LocalDateTime dateTime() {
        return this.dateTime;
    }

    private ZoneOffset offset() {
        return this.offset;
    }

    private ZoneId zone() {
        return this.zone;
    }

    private ZonedDateTime resolveLocal(LocalDateTime newDateTime) {
        return ZonedDateTime$.MODULE$.ofLocal(newDateTime, this.zone(), this.offset());
    }

    private ZonedDateTime resolveInstant(LocalDateTime newDateTime) {
        return ZonedDateTime$.MODULE$.ofInstant(newDateTime, this.offset(), this.zone());
    }

    private ZonedDateTime resolveOffset(ZoneOffset offset) {
        ZoneOffset zoneOffset = offset;
        ZoneOffset zoneOffset2 = this.offset();
        if ((zoneOffset == null ? zoneOffset2 != null : !((Object)zoneOffset).equals(zoneOffset2)) && this.zone().getRules().isValidOffset(this.dateTime(), offset)) {
            return new ZonedDateTime(this.dateTime(), offset, this.zone());
        }
        return this;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            return true;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            return unit.isDateBased() || unit.isTimeBased();
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField$.INSTANT_SECONDS || field == ChronoField$.OFFSET_SECONDS) {
                return field.range();
            }
            return this.dateTime().range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f;
            ChronoField chronoField = f = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.INSTANT_SECONDS;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                throw new DateTimeException(new StringBuilder(28).append("Field too large for an int: ").append(field).toString());
            }
            ChronoField chronoField4 = ChronoField$.OFFSET_SECONDS;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.getOffset().getTotalSeconds();
            }
            return this.dateTime().get(field);
        }
        return ChronoZonedDateTime.get$(this, field);
    }

    @Override
    public long getLong(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f;
            ChronoField chronoField = f = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.INSTANT_SECONDS;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.toEpochSecond();
            }
            ChronoField chronoField4 = ChronoField$.OFFSET_SECONDS;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.getOffset().getTotalSeconds();
            }
            return this.dateTime().getLong(field);
        }
        return field.getFrom(this);
    }

    @Override
    public ZoneOffset getOffset() {
        return this.offset();
    }

    public ZonedDateTime withEarlierOffsetAtOverlap() {
        ZoneOffsetTransition trans = this.getZone().getRules().getTransition(this.dateTime());
        if (trans != null && trans.isOverlap()) {
            ZoneOffset earlierOffset;
            ZoneOffset zoneOffset = earlierOffset = trans.getOffsetBefore();
            ZoneOffset zoneOffset2 = this.offset();
            if (zoneOffset == null ? zoneOffset2 != null : !((Object)zoneOffset).equals(zoneOffset2)) {
                return new ZonedDateTime(this.dateTime(), earlierOffset, this.zone());
            }
        }
        return this;
    }

    public ZonedDateTime withLaterOffsetAtOverlap() {
        ZoneOffsetTransition trans = this.getZone().getRules().getTransition(this.toLocalDateTime());
        if (trans != null) {
            ZoneOffset laterOffset;
            ZoneOffset zoneOffset = laterOffset = trans.getOffsetAfter();
            ZoneOffset zoneOffset2 = this.offset();
            if (zoneOffset == null ? zoneOffset2 != null : !((Object)zoneOffset).equals(zoneOffset2)) {
                return new ZonedDateTime(this.dateTime(), laterOffset, this.zone());
            }
        }
        return this;
    }

    public int compareTo(ChronoZonedDateTime<?> other) {
        return ChronoZonedDateTime.compare$(this, other);
    }

    @Override
    public ZoneId getZone() {
        return this.zone();
    }

    public ZonedDateTime withZoneSameLocal(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        ZoneId zoneId = this.zone();
        ZoneId zoneId2 = zone;
        if (!(zoneId != null ? !((Object)zoneId).equals(zoneId2) : zoneId2 != null)) {
            return this;
        }
        return ZonedDateTime$.MODULE$.ofLocal(this.dateTime(), zone, this.offset());
    }

    public ZonedDateTime withZoneSameInstant(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        ZoneId zoneId = this.zone();
        ZoneId zoneId2 = zone;
        if (!(zoneId != null ? !((Object)zoneId).equals(zoneId2) : zoneId2 != null)) {
            return this;
        }
        return ZonedDateTime$.MODULE$.java$time$ZonedDateTime$$$create(this.dateTime().toEpochSecond(this.offset()), this.dateTime().getNano(), zone);
    }

    public ZonedDateTime withFixedOffsetZone() {
        ZoneId zoneId = this.zone();
        ZoneOffset zoneOffset = this.offset();
        if (!(zoneId != null ? !((Object)zoneId).equals(zoneOffset) : zoneOffset != null)) {
            return this;
        }
        return new ZonedDateTime(this.dateTime(), this.offset(), this.offset());
    }

    public int getYear() {
        return this.dateTime().getYear();
    }

    public int getMonthValue() {
        return this.dateTime().getMonthValue();
    }

    public Month getMonth() {
        return this.dateTime().getMonth();
    }

    public int getDayOfMonth() {
        return this.dateTime().getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime().getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime().getDayOfWeek();
    }

    public int getHour() {
        return this.dateTime().getHour();
    }

    public int getMinute() {
        return this.dateTime().getMinute();
    }

    public int getSecond() {
        return this.dateTime().getSecond();
    }

    public int getNano() {
        return this.dateTime().getNano();
    }

    @Override
    public ZonedDateTime with(TemporalAdjuster adjuster) {
        TemporalAdjuster temporalAdjuster = adjuster;
        if (temporalAdjuster instanceof LocalDate) {
            LocalDate date = (LocalDate)temporalAdjuster;
            return this.resolveLocal(LocalDateTime$.MODULE$.of(date, this.dateTime().toLocalTime()));
        }
        if (temporalAdjuster instanceof LocalTime) {
            LocalTime time = (LocalTime)temporalAdjuster;
            return this.resolveLocal(LocalDateTime$.MODULE$.of(this.dateTime().toLocalDate(), time));
        }
        if (temporalAdjuster instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)temporalAdjuster;
            return this.resolveLocal(dateTime);
        }
        if (temporalAdjuster instanceof Instant) {
            Instant instant = (Instant)temporalAdjuster;
            return ZonedDateTime$.MODULE$.java$time$ZonedDateTime$$$create(instant.getEpochSecond(), instant.getNano(), this.zone());
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            ZoneOffset offset = (ZoneOffset)temporalAdjuster;
            return this.resolveOffset(offset);
        }
        return (ZonedDateTime)adjuster.adjustInto(this);
    }

    @Override
    public ZonedDateTime with(TemporalField field, long newValue) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f;
            ChronoField chronoField = f = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.INSTANT_SECONDS;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return ZonedDateTime$.MODULE$.java$time$ZonedDateTime$$$create(newValue, this.getNano(), this.zone());
            }
            ChronoField chronoField4 = ChronoField$.OFFSET_SECONDS;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.resolveOffset(ZoneOffset$.MODULE$.ofTotalSeconds(f.checkValidIntValue(newValue)));
            }
            return this.resolveLocal(this.dateTime().with(field, newValue));
        }
        return field.adjustInto(this, newValue);
    }

    public ZonedDateTime withYear(int year) {
        return this.resolveLocal(this.dateTime().withYear(year));
    }

    public ZonedDateTime withMonth(int month) {
        return this.resolveLocal(this.dateTime().withMonth(month));
    }

    public ZonedDateTime withDayOfMonth(int dayOfMonth) {
        return this.resolveLocal(this.dateTime().withDayOfMonth(dayOfMonth));
    }

    public ZonedDateTime withDayOfYear(int dayOfYear) {
        return this.resolveLocal(this.dateTime().withDayOfYear(dayOfYear));
    }

    public ZonedDateTime withHour(int hour) {
        return this.resolveLocal(this.dateTime().withHour(hour));
    }

    public ZonedDateTime withMinute(int minute) {
        return this.resolveLocal(this.dateTime().withMinute(minute));
    }

    public ZonedDateTime withSecond(int second) {
        return this.resolveLocal(this.dateTime().withSecond(second));
    }

    public ZonedDateTime withNano(int nanoOfSecond) {
        return this.resolveLocal(this.dateTime().withNano(nanoOfSecond));
    }

    public ZonedDateTime truncatedTo(TemporalUnit unit) {
        return this.resolveLocal(this.dateTime().truncatedTo(unit));
    }

    @Override
    public ZonedDateTime plus(TemporalAmount amount) {
        return (ZonedDateTime)amount.addTo(this);
    }

    @Override
    public ZonedDateTime plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            if (unit.isDateBased()) {
                return this.resolveLocal(this.dateTime().plus(amountToAdd, unit));
            }
            return this.resolveInstant(this.dateTime().plus(amountToAdd, unit));
        }
        return unit.addTo(this, amountToAdd);
    }

    public ZonedDateTime plusYears(long years) {
        return this.resolveLocal(this.dateTime().plusYears(years));
    }

    public ZonedDateTime plusMonths(long months) {
        return this.resolveLocal(this.dateTime().plusMonths(months));
    }

    public ZonedDateTime plusWeeks(long weeks) {
        return this.resolveLocal(this.dateTime().plusWeeks(weeks));
    }

    public ZonedDateTime plusDays(long days) {
        return this.resolveLocal(this.dateTime().plusDays(days));
    }

    public ZonedDateTime plusHours(long hours) {
        return this.resolveInstant(this.dateTime().plusHours(hours));
    }

    public ZonedDateTime plusMinutes(long minutes) {
        return this.resolveInstant(this.dateTime().plusMinutes(minutes));
    }

    public ZonedDateTime plusSeconds(long seconds) {
        return this.resolveInstant(this.dateTime().plusSeconds(seconds));
    }

    public ZonedDateTime plusNanos(long nanos) {
        return this.resolveInstant(this.dateTime().plusNanos(nanos));
    }

    @Override
    public ZonedDateTime minus(TemporalAmount amount) {
        return (ZonedDateTime)amount.subtractFrom(this);
    }

    @Override
    public ZonedDateTime minus(long amountToSubtract, TemporalUnit unit) {
        if (amountToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, unit).plus(1L, unit);
        }
        return this.plus(-amountToSubtract, unit);
    }

    public ZonedDateTime minusYears(long years) {
        if (years == Long.MIN_VALUE) {
            return this.plusYears(Long.MAX_VALUE).plusYears(1L);
        }
        return this.plusYears(-years);
    }

    public ZonedDateTime minusMonths(long months) {
        if (months == Long.MIN_VALUE) {
            return this.plusMonths(Long.MAX_VALUE).plusMonths(1L);
        }
        return this.plusMonths(-months);
    }

    public ZonedDateTime minusWeeks(long weeks) {
        if (weeks == Long.MIN_VALUE) {
            return this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L);
        }
        return this.plusWeeks(-weeks);
    }

    public ZonedDateTime minusDays(long days) {
        if (days == Long.MIN_VALUE) {
            return this.plusDays(Long.MAX_VALUE).plusDays(1L);
        }
        return this.plusDays(-days);
    }

    public ZonedDateTime minusHours(long hours) {
        if (hours == Long.MIN_VALUE) {
            return this.plusHours(Long.MAX_VALUE).plusHours(1L);
        }
        return this.plusHours(-hours);
    }

    public ZonedDateTime minusMinutes(long minutes) {
        if (minutes == Long.MIN_VALUE) {
            return this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L);
        }
        return this.plusMinutes(-minutes);
    }

    public ZonedDateTime minusSeconds(long seconds) {
        if (seconds == Long.MIN_VALUE) {
            return this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L);
        }
        return this.plusSeconds(-seconds);
    }

    public ZonedDateTime minusNanos(long nanos) {
        if (nanos == Long.MIN_VALUE) {
            return this.plusNanos(Long.MAX_VALUE).plusNanos(1L);
        }
        return this.plusNanos(-nanos);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries$.MODULE$.localDate()) {
            return (R)this.toLocalDate();
        }
        return (R)ChronoZonedDateTime.query$(this, query);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        ZonedDateTime end = ZonedDateTime$.MODULE$.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            end = end.withZoneSameInstant(this.zone());
            if (unit.isDateBased()) {
                return this.dateTime().until(end.dateTime(), unit);
            }
            return this.toOffsetDateTime().until(end.toOffsetDateTime(), unit);
        }
        return unit.between(this, end);
    }

    public LocalDateTime toLocalDateTime() {
        return this.dateTime();
    }

    @Override
    public LocalDate toLocalDate() {
        return this.dateTime().toLocalDate();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.dateTime().toLocalTime();
    }

    public OffsetDateTime toOffsetDateTime() {
        return OffsetDateTime$.MODULE$.of(this.dateTime(), this.offset());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof ZonedDateTime)) return false;
        ZonedDateTime other = (ZonedDateTime)object;
        if (this == other) return true;
        LocalDateTime localDateTime = this.dateTime();
        LocalDateTime localDateTime2 = other.dateTime();
        if (localDateTime == null) {
            if (localDateTime2 != null) {
                return false;
            }
        } else if (!((Object)localDateTime).equals(localDateTime2)) return false;
        ZoneOffset zoneOffset = this.offset();
        ZoneOffset zoneOffset2 = other.offset();
        if (zoneOffset == null) {
            if (zoneOffset2 != null) {
                return false;
            }
        } else if (!((Object)zoneOffset).equals(zoneOffset2)) return false;
        ZoneId zoneId = this.zone();
        ZoneId zoneId2 = other.zone();
        if (zoneId == null) {
            if (zoneId2 == null) return true;
            return false;
        } else {
            if (!((Object)zoneId).equals(zoneId2)) return false;
            return true;
        }
    }

    @Override
    public int hashCode() {
        return this.dateTime().hashCode() ^ this.offset().hashCode() ^ Integer.rotateLeft(this.zone().hashCode(), 3);
    }

    @Override
    public String toString() {
        String str = new StringBuilder(0).append(this.dateTime().toString()).append(this.offset().toString()).toString();
        if (this.offset() != this.zone()) {
            str = new StringBuilder(0).append(str).append(new StringBuilder(2).append("[").append(this.zone()).append("]").toString()).toString();
        }
        return str;
    }

    @Override
    public String format(DateTimeFormatter formatter) {
        return ChronoZonedDateTime.format$(this, formatter);
    }
}

