/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.Instant$;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalDateTime$;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneId$;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatter$;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.List;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class ZonedDateTime$
implements Serializable {
    public static final ZonedDateTime$ MODULE$ = new ZonedDateTime$();

    private ZonedDateTime$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ZonedDateTime$.class);
    }

    public ZonedDateTime now() {
        return this.now(Clock$.MODULE$.systemDefaultZone());
    }

    public ZonedDateTime now(ZoneId zone) {
        return this.now(Clock$.MODULE$.system(zone));
    }

    public ZonedDateTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        return this.ofInstant(now, clock.getZone());
    }

    public ZonedDateTime of(LocalDate date, LocalTime time, ZoneId zone) {
        return this.of(LocalDateTime$.MODULE$.of(date, time), zone);
    }

    public ZonedDateTime of(LocalDateTime localDateTime, ZoneId zone) {
        return this.ofLocal(localDateTime, zone, null);
    }

    public ZonedDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, ZoneId zone) {
        LocalDateTime dt = LocalDateTime$.MODULE$.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond);
        return this.ofLocal(dt, zone, null);
    }

    public ZonedDateTime ofLocal(LocalDateTime localDateTime, ZoneId zone, ZoneOffset preferredOffset) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(zone, "zone");
        LocalDateTime _localDateTime = localDateTime;
        ZoneId zoneId = zone;
        if (zoneId instanceof ZoneOffset) {
            ZoneOffset offset = (ZoneOffset)zoneId;
            return new ZonedDateTime(_localDateTime, offset, zone);
        }
        ZoneRules rules = zone.getRules();
        List<ZoneOffset> validOffsets = rules.getValidOffsets(_localDateTime);
        ZoneOffset offset = null;
        if (validOffsets.size() == 1) {
            offset = validOffsets.get(0);
        } else if (validOffsets.size() == 0) {
            ZoneOffsetTransition trans = rules.getTransition(_localDateTime);
            _localDateTime = _localDateTime.plusSeconds(trans.getDuration().getSeconds());
            offset = trans.getOffsetAfter();
        } else {
            offset = preferredOffset != null && validOffsets.contains(preferredOffset) ? preferredOffset : Objects.requireNonNull(validOffsets.get(0), "offset");
        }
        return new ZonedDateTime(_localDateTime, offset, zone);
    }

    public ZonedDateTime ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        return this.java$time$ZonedDateTime$$$create(instant.getEpochSecond(), instant.getNano(), zone);
    }

    public ZonedDateTime ofInstant(LocalDateTime localDateTime, ZoneOffset offset, ZoneId zone) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(offset, "offset");
        Objects.requireNonNull(zone, "zone");
        return this.java$time$ZonedDateTime$$$create(localDateTime.toEpochSecond(offset), localDateTime.getNano(), zone);
    }

    public ZonedDateTime java$time$ZonedDateTime$$$create(long epochSecond, int nanoOfSecond, ZoneId zone) {
        ZoneRules rules = zone.getRules();
        Instant instant = Instant$.MODULE$.ofEpochSecond(epochSecond, nanoOfSecond);
        ZoneOffset offset = rules.getOffset(instant);
        return new ZonedDateTime(LocalDateTime$.MODULE$.ofEpochSecond(epochSecond, nanoOfSecond, offset), offset, zone);
    }

    public ZonedDateTime ofStrict(LocalDateTime localDateTime, ZoneOffset offset, ZoneId zone) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(offset, "offset");
        Objects.requireNonNull(zone, "zone");
        ZoneRules rules = zone.getRules();
        if (!rules.isValidOffset(localDateTime, offset)) {
            ZoneOffsetTransition trans = rules.getTransition(localDateTime);
            if (trans != null && trans.isGap()) {
                throw new DateTimeException(new StringBuilder(116).append("LocalDateTime '").append(localDateTime).append("' does not exist in zone '").append(zone).append("' due to a gap in the local time-line, typically caused by daylight savings").toString());
            }
            throw new DateTimeException(new StringBuilder(58).append("ZoneOffset '").append(offset).append("' is not valid for LocalDateTime '").append(localDateTime).append("' in zone '").append(zone).append("'").toString());
        }
        return new ZonedDateTime(localDateTime, offset, zone);
    }

    /*
     * Unable to fully structure code
     */
    public ZonedDateTime from(TemporalAccessor temporal) {
        var2_2 = temporal;
        if (var2_2 instanceof ZonedDateTime) {
            time = (ZonedDateTime)var2_2;
            return time;
        }
        zone = ZoneId$.MODULE$.from(temporal);
        if (!temporal.isSupported(ChronoField$.INSTANT_SECONDS)) ** GOTO lbl-1000
        try {
            epochSecond = temporal.getLong(ChronoField$.INSTANT_SECONDS);
            nanoOfSecond = temporal.get(ChronoField$.NANO_OF_SECOND);
            return this.java$time$ZonedDateTime$$$create(epochSecond, nanoOfSecond, zone);
        }
        catch (DateTimeException v0) {
            try lbl-1000:
            // 2 sources

            {
                ldt = LocalDateTime$.MODULE$.from(temporal);
                v1 = this.of(ldt, zone);
            }
            catch (DateTimeException v2) {
                throw new DateTimeException(new StringBuilder(61).append("Unable to obtain ZonedDateTime from TemporalAccessor: ").append(temporal).append(", type ").append(temporal.getClass().getName()).toString());
            }
        }
        return v1;
    }

    public ZonedDateTime parse(CharSequence text) {
        return this.parse(text, DateTimeFormatter$.MODULE$.ISO_ZONED_DATE_TIME());
    }

    public ZonedDateTime parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, new TemporalQuery<ZonedDateTime>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public ZonedDateTime queryFrom(TemporalAccessor temporal) {
                return ZonedDateTime$.MODULE$.from(temporal);
            }
        });
    }
}

