/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset$;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRules$;
import scala.math.Ordered;

public final class ZoneOffset
extends ZoneId
implements TemporalAccessor,
TemporalAdjuster,
Ordered<ZoneOffset> {
    private static final long serialVersionUID = 2357656521762053153L;
    private final int totalSeconds;
    private final transient String id;

    public static ZoneOffset MAX() {
        return ZoneOffset$.MODULE$.MAX();
    }

    public static ZoneOffset MIN() {
        return ZoneOffset$.MODULE$.MIN();
    }

    public static ZoneOffset UTC() {
        return ZoneOffset$.MODULE$.UTC();
    }

    public static ZoneOffset from(TemporalAccessor temporalAccessor) {
        return ZoneOffset$.MODULE$.from(temporalAccessor);
    }

    public static ZoneOffset of(String string) {
        return ZoneOffset$.MODULE$.of(string);
    }

    public static ZoneOffset ofHours(int n) {
        return ZoneOffset$.MODULE$.ofHours(n);
    }

    public static ZoneOffset ofHoursMinutes(int n, int n2) {
        return ZoneOffset$.MODULE$.ofHoursMinutes(n, n2);
    }

    public static ZoneOffset ofHoursMinutesSeconds(int n, int n2, int n3) {
        return ZoneOffset$.MODULE$.ofHoursMinutesSeconds(n, n2, n3);
    }

    public static ZoneOffset ofTotalSeconds(int n) {
        return ZoneOffset$.MODULE$.ofTotalSeconds(n);
    }

    public ZoneOffset(int totalSeconds) {
        this.totalSeconds = totalSeconds;
        Ordered.$init$((Ordered)this);
        this.id = ZoneOffset$.MODULE$.java$time$ZoneOffset$$$buildId(totalSeconds);
    }

    private int totalSeconds() {
        return this.totalSeconds;
    }

    public int getTotalSeconds() {
        return this.totalSeconds();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ZoneRules getRules() {
        return ZoneRules$.MODULE$.of(this);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField$.OFFSET_SECONDS;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField$.OFFSET_SECONDS) {
            return field.range();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field == ChronoField$.OFFSET_SECONDS) {
            return this.totalSeconds();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField$.OFFSET_SECONDS) {
            return this.totalSeconds();
        }
        if (field instanceof ChronoField) {
            throw new DateTimeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.getFrom(this);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries$.MODULE$.offset() || query == TemporalQueries$.MODULE$.zone()) {
            return (R)this;
        }
        if (query == TemporalQueries$.MODULE$.localDate() || query == TemporalQueries$.MODULE$.localTime() || query == TemporalQueries$.MODULE$.precision() || query == TemporalQueries$.MODULE$.chronology() || query == TemporalQueries$.MODULE$.zoneId()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField$.OFFSET_SECONDS, this.totalSeconds());
    }

    public int compare(ZoneOffset other) {
        return other.totalSeconds() - this.totalSeconds();
    }

    public int compareTo(ZoneOffset other) {
        return this.compare(other);
    }

    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ZoneOffset) {
            ZoneOffset that = (ZoneOffset)object;
            return this == that || this.totalSeconds() == that.totalSeconds();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.totalSeconds();
    }

    @Override
    public String toString() {
        return this.id;
    }
}

