/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries$;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ModuleSerializationProxy;

public final class ZoneOffset$
implements Serializable {
    private Map SECONDS_CACHE$lzy1;
    private boolean SECONDS_CACHEbitmap$1;
    private Map ID_CACHE$lzy1;
    private boolean ID_CACHEbitmap$1;
    private static final int SECONDS_PER_HOUR;
    private static final int SECONDS_PER_MINUTE;
    private static final int MINUTES_PER_HOUR;
    private static final int MAX_SECONDS;
    private ZoneOffset UTC$lzy1;
    private boolean UTCbitmap$1;
    private ZoneOffset MIN$lzy1;
    private boolean MINbitmap$1;
    private ZoneOffset MAX$lzy1;
    private boolean MAXbitmap$1;
    public static final ZoneOffset$ MODULE$;

    private ZoneOffset$() {
    }

    static {
        MODULE$ = new ZoneOffset$();
        SECONDS_PER_HOUR = 3600;
        SECONDS_PER_MINUTE = 60;
        MINUTES_PER_HOUR = 60;
        MAX_SECONDS = 18 * SECONDS_PER_HOUR;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ZoneOffset$.class);
    }

    private Map<Integer, ZoneOffset> SECONDS_CACHE() {
        if (!this.SECONDS_CACHEbitmap$1) {
            this.SECONDS_CACHE$lzy1 = new HashMap();
            this.SECONDS_CACHEbitmap$1 = true;
        }
        return this.SECONDS_CACHE$lzy1;
    }

    private Map<String, ZoneOffset> ID_CACHE() {
        if (!this.ID_CACHEbitmap$1) {
            this.ID_CACHE$lzy1 = new HashMap();
            this.ID_CACHEbitmap$1 = true;
        }
        return this.ID_CACHE$lzy1;
    }

    public ZoneOffset UTC() {
        if (!this.UTCbitmap$1) {
            this.UTC$lzy1 = this.ofTotalSeconds(0);
            this.UTCbitmap$1 = true;
        }
        return this.UTC$lzy1;
    }

    public ZoneOffset MIN() {
        if (!this.MINbitmap$1) {
            this.MIN$lzy1 = this.ofTotalSeconds(-MAX_SECONDS);
            this.MINbitmap$1 = true;
        }
        return this.MIN$lzy1;
    }

    public ZoneOffset MAX() {
        if (!this.MAXbitmap$1) {
            this.MAX$lzy1 = this.ofTotalSeconds(MAX_SECONDS);
            this.MAXbitmap$1 = true;
        }
        return this.MAX$lzy1;
    }

    public ZoneOffset of(String offsetId) {
        String _offsetId = offsetId;
        Objects.requireNonNull(_offsetId, "offsetId");
        ZoneOffset offset = this.ID_CACHE().get(_offsetId);
        if (offset != null) {
            return offset;
        }
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        if (_offsetId.length() == 2) {
            _offsetId = new java.lang.StringBuilder(1).append(_offsetId.charAt(0)).append("0").append(_offsetId.charAt(1)).toString();
        }
        int n = _offsetId.length();
        switch (n) {
            case 3: {
                hours = this.parseNumber(_offsetId, 1, false);
                minutes = 0;
                seconds = 0;
                break;
            }
            case 5: {
                hours = this.parseNumber(_offsetId, 1, false);
                minutes = this.parseNumber(_offsetId, 3, false);
                seconds = 0;
                break;
            }
            case 6: {
                hours = this.parseNumber(_offsetId, 1, false);
                minutes = this.parseNumber(_offsetId, 4, true);
                seconds = 0;
                break;
            }
            case 7: {
                hours = this.parseNumber(_offsetId, 1, false);
                minutes = this.parseNumber(_offsetId, 3, false);
                seconds = this.parseNumber(_offsetId, 5, false);
                break;
            }
            case 9: {
                hours = this.parseNumber(_offsetId, 1, false);
                minutes = this.parseNumber(_offsetId, 4, true);
                seconds = this.parseNumber(_offsetId, 7, true);
                break;
            }
            default: {
                throw new DateTimeException(new java.lang.StringBuilder(43).append("Invalid ID for ZoneOffset, invalid format: ").append(_offsetId).toString());
            }
        }
        char first = _offsetId.charAt(0);
        if (first != '+' && first != '-') {
            throw new DateTimeException(new java.lang.StringBuilder(63).append("Invalid ID for ZoneOffset, plus/minus not found when expected: ").append(_offsetId).toString());
        }
        if (first == '-') {
            return this.ofHoursMinutesSeconds(-hours, -minutes, -seconds);
        }
        return this.ofHoursMinutesSeconds(hours, minutes, seconds);
    }

    private int parseNumber(CharSequence offsetId, int pos, boolean precededByColon) {
        if (precededByColon && offsetId.charAt(pos - 1) != ':') {
            throw new DateTimeException(new java.lang.StringBuilder(58).append("Invalid ID for ZoneOffset, colon not found when expected: ").append(offsetId).toString());
        }
        char ch1 = offsetId.charAt(pos);
        char ch2 = offsetId.charAt(pos + 1);
        if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9') {
            throw new DateTimeException(new java.lang.StringBuilder(57).append("Invalid ID for ZoneOffset, non numeric characters found: ").append(offsetId).toString());
        }
        return (ch1 - 48) * 10 + (ch2 - 48);
    }

    public ZoneOffset ofHours(int hours) {
        return this.ofHoursMinutesSeconds(hours, 0, 0);
    }

    public ZoneOffset ofHoursMinutes(int hours, int minutes) {
        return this.ofHoursMinutesSeconds(hours, minutes, 0);
    }

    public ZoneOffset ofHoursMinutesSeconds(int hours, int minutes, int seconds) {
        this.validate(hours, minutes, seconds);
        int totalSecs = this.totalSeconds(hours, minutes, seconds);
        return this.ofTotalSeconds(totalSecs);
    }

    public ZoneOffset from(TemporalAccessor temporal) {
        ZoneOffset offset = temporal.query(TemporalQueries$.MODULE$.offset());
        if (offset == null) {
            throw new DateTimeException(new java.lang.StringBuilder(58).append("Unable to obtain ZoneOffset from TemporalAccessor: ").append(temporal).append(", type ").append(temporal.getClass().getName()).toString());
        }
        return offset;
    }

    private void validate(int hours, int minutes, int seconds) {
        if (hours < -18 || hours > 18) {
            throw new DateTimeException(new java.lang.StringBuilder(74).append("Zone offset hours not in valid range: value ").append(hours).append(" is not in the range -18 to 18").toString());
        }
        if (hours > 0) {
            if (minutes < 0 || seconds < 0) {
                throw new DateTimeException(this.msg2$1("positive"));
            }
        } else if (hours < 0) {
            if (minutes > 0 || seconds > 0) {
                throw new DateTimeException(this.msg2$1("negative"));
            }
        } else if (minutes > 0 && seconds < 0 || minutes < 0 && seconds > 0) {
            throw new DateTimeException("Zone offset minutes and seconds must have the same sign");
        }
        if (Math.abs(minutes) > 59) {
            throw new DateTimeException(this.msg$1(minutes, "minutes"));
        }
        if (Math.abs(seconds) > 59) {
            throw new DateTimeException(this.msg$1(minutes, "seconds"));
        }
        if (Math.abs(hours) == 18 && (Math.abs(minutes) > 0 || Math.abs(seconds) > 0)) {
            throw new DateTimeException("Zone offset not in valid range: -18:00 to +18:00");
        }
    }

    private int totalSeconds(int hours, int minutes, int seconds) {
        return hours * SECONDS_PER_HOUR + minutes * SECONDS_PER_MINUTE + seconds;
    }

    public ZoneOffset ofTotalSeconds(int totalSeconds) {
        if (Math.abs(totalSeconds) > MAX_SECONDS) {
            throw new DateTimeException("Zone offset not in valid range: -18:00 to +18:00");
        }
        if (totalSeconds % (15 * SECONDS_PER_MINUTE) == 0) {
            Integer totalSecs = Predef$.MODULE$.int2Integer(totalSeconds);
            ZoneOffset result = this.SECONDS_CACHE().get(totalSecs);
            if (result == null) {
                result = new ZoneOffset(totalSeconds);
                this.SECONDS_CACHE().put(totalSecs, result);
                result = this.SECONDS_CACHE().get(totalSecs);
                this.ID_CACHE().put(result.getId(), result);
            }
            return result;
        }
        return new ZoneOffset(totalSeconds);
    }

    public String java$time$ZoneOffset$$$buildId(int totalSeconds) {
        if (totalSeconds == 0) {
            return "Z";
        }
        int absTotalSeconds = Math.abs(totalSeconds);
        StringBuilder buf = new StringBuilder();
        int absHours = absTotalSeconds / SECONDS_PER_HOUR;
        int absMinutes = absTotalSeconds / SECONDS_PER_MINUTE % MINUTES_PER_HOUR;
        buf.append(totalSeconds < 0 ? "-" : "+").append(absHours < 10 ? "0" : "").append(absHours).append(absMinutes < 10 ? ":0" : ":").append(absMinutes);
        int absSeconds = absTotalSeconds % SECONDS_PER_MINUTE;
        if (absSeconds != 0) {
            buf.append(absSeconds < 10 ? ":0" : ":").append(absSeconds);
        }
        return buf.toString();
    }

    private final String msg$1(int minutes$1, String v) {
        return new java.lang.StringBuilder(72).append("Zone offset ").append(v).append(" not in valid range: abs(value) ").append(Math.abs(minutes$1)).append(" is not in the range 0 to 59").toString();
    }

    private final String msg2$1(String v) {
        return new java.lang.StringBuilder(58).append("Zone offset minutes and seconds must be ").append(v).append(" because hours is ").append(v).toString();
    }
}

