/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Instant$;
import java.time.ZoneId$;
import java.time.ZoneOffset;
import java.time.ZoneRegion;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class ZoneId
implements Serializable {
    private static final long serialVersionUID = 8352817235686L;

    public static Map<String, String> SHORT_IDS() {
        return ZoneId$.MODULE$.SHORT_IDS();
    }

    public static ZoneId from(TemporalAccessor temporalAccessor) {
        return ZoneId$.MODULE$.from(temporalAccessor);
    }

    public static Set<String> getAvailableZoneIds() {
        return ZoneId$.MODULE$.getAvailableZoneIds();
    }

    public static ZoneId of(String string) {
        return ZoneId$.MODULE$.of(string);
    }

    public static ZoneId of(String string, Map<String, String> map) {
        return ZoneId$.MODULE$.of(string, map);
    }

    public static ZoneId ofOffset(String string, ZoneOffset zoneOffset) {
        return ZoneId$.MODULE$.ofOffset(string, zoneOffset);
    }

    public static ZoneId systemDefault() {
        return ZoneId$.MODULE$.systemDefault();
    }

    public ZoneId() {
        if (this.getClass() != ZoneOffset.class && this.getClass() != ZoneRegion.class) {
            throw new AssertionError((Object)"Invalid subclass");
        }
    }

    public abstract String getId();

    public abstract ZoneRules getRules();

    public String getDisplayName(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendZoneText(style).toFormatter(locale).format(new TemporalAccessor(this){
            private final /* synthetic */ ZoneId $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public boolean isSupported(TemporalField field) {
                return false;
            }

            public long getLong(TemporalField field) {
                throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
            }

            public Object query(TemporalQuery query) {
                if (query == TemporalQueries$.MODULE$.zoneId()) {
                    return this.$outer;
                }
                return TemporalAccessor.query$(this, query);
            }
        });
    }

    public ZoneId normalized() {
        try {
            ZoneRules rules = this.getRules();
            if (rules.isFixedOffset()) {
                return rules.getOffset(Instant$.MODULE$.EPOCH());
            }
        }
        catch (ZoneRulesException zoneRulesException) {}
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof ZoneId)) return false;
        ZoneId other = (ZoneId)object;
        if (this == other) return true;
        String string = this.getId();
        String string2 = other.getId();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }
}

