/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.Month;
import java.time.Month$;
import java.time.Year$;
import java.time.YearMonth$;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.chrono.Chronology$;
import java.time.chrono.IsoChronology;
import java.time.chrono.IsoChronology$;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.temporal.ValueRange$;
import java.util.Objects;
import scala.math.Ordered;

public final class YearMonth
implements Temporal,
TemporalAdjuster,
Ordered<YearMonth>,
Serializable {
    private final int year;
    private final int month;

    public static YearMonth from(TemporalAccessor temporalAccessor) {
        return YearMonth$.MODULE$.from(temporalAccessor);
    }

    public static YearMonth now() {
        return YearMonth$.MODULE$.now();
    }

    public static YearMonth now(Clock clock) {
        return YearMonth$.MODULE$.now(clock);
    }

    public static YearMonth now(ZoneId zoneId) {
        return YearMonth$.MODULE$.now(zoneId);
    }

    public static YearMonth of(int n, int n2) {
        return YearMonth$.MODULE$.of(n, n2);
    }

    public static YearMonth of(int n, Month month) {
        return YearMonth$.MODULE$.of(n, month);
    }

    public static YearMonth parse(CharSequence charSequence) {
        return YearMonth$.MODULE$.parse(charSequence);
    }

    public static YearMonth parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return YearMonth$.MODULE$.parse(charSequence, dateTimeFormatter);
    }

    public YearMonth(int year, int month) {
        this.year = year;
        this.month = month;
        Ordered.$init$((Ordered)this);
    }

    private int year() {
        return this.year;
    }

    private int month() {
        return this.month;
    }

    private YearMonth with(int newYear, int newMonth) {
        if (this.year() == newYear && this.month() == newMonth) {
            return this;
        }
        return new YearMonth(newYear, newMonth);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField$.YEAR || field == ChronoField$.MONTH_OF_YEAR || field == ChronoField$.PROLEPTIC_MONTH || field == ChronoField$.YEAR_OF_ERA || field == ChronoField$.ERA;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit == ChronoUnit$.MONTHS || unit == ChronoUnit$.YEARS || unit == ChronoUnit$.DECADES || unit == ChronoUnit$.CENTURIES || unit == ChronoUnit$.MILLENNIA || unit == ChronoUnit$.ERAS;
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField$.YEAR_OF_ERA) {
            if (this.getYear() <= 0) {
                return ValueRange$.MODULE$.of(1L, (long)Year$.MODULE$.MAX_VALUE() + 1L);
            }
            return ValueRange$.MODULE$.of(1L, Year$.MODULE$.MAX_VALUE());
        }
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                return field.range();
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        TemporalField temporalField = field;
        ChronoField chronoField = ChronoField$.MONTH_OF_YEAR;
        TemporalField temporalField2 = temporalField;
        if (!(chronoField != null ? !chronoField.equals(temporalField2) : temporalField2 != null)) {
            return this.month();
        }
        ChronoField chronoField2 = ChronoField$.PROLEPTIC_MONTH;
        TemporalField temporalField3 = temporalField;
        if (!(chronoField2 != null ? !chronoField2.equals(temporalField3) : temporalField3 != null)) {
            return this.getProlepticMonth();
        }
        ChronoField chronoField3 = ChronoField$.YEAR_OF_ERA;
        TemporalField temporalField4 = temporalField;
        if (!(chronoField3 != null ? !chronoField3.equals(temporalField4) : temporalField4 != null)) {
            if (this.year() < 1) {
                return 1L - (long)this.year();
            }
            return this.year();
        }
        ChronoField chronoField4 = ChronoField$.YEAR;
        TemporalField temporalField5 = temporalField;
        if (!(chronoField4 != null ? !chronoField4.equals(temporalField5) : temporalField5 != null)) {
            return this.year();
        }
        ChronoField chronoField5 = ChronoField$.ERA;
        TemporalField temporalField6 = temporalField;
        if (!(chronoField5 != null ? !chronoField5.equals(temporalField6) : temporalField6 != null)) {
            if (this.year() < 1) {
                return 0L;
            }
            return 1L;
        }
        if (temporalField instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.year() * 12L + (long)(this.month() - 1);
    }

    public int getYear() {
        return this.year();
    }

    public int getMonthValue() {
        return this.month();
    }

    public Month getMonth() {
        return Month$.MODULE$.of(this.month());
    }

    public boolean isLeapYear() {
        return IsoChronology$.MODULE$.INSTANCE().isLeapYear(this.year());
    }

    public boolean isValidDay(int dayOfMonth) {
        return dayOfMonth >= 1 && dayOfMonth <= this.lengthOfMonth();
    }

    public int lengthOfMonth() {
        return this.getMonth().length(this.isLeapYear());
    }

    public int lengthOfYear() {
        if (this.isLeapYear()) {
            return 366;
        }
        return 365;
    }

    @Override
    public YearMonth with(TemporalAdjuster adjuster) {
        return (YearMonth)adjuster.adjustInto(this);
    }

    @Override
    public YearMonth with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            f.checkValidValue(newValue);
            ChronoField chronoField = f;
            ChronoField chronoField2 = ChronoField$.MONTH_OF_YEAR;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.withMonth((int)newValue);
            }
            ChronoField chronoField4 = ChronoField$.PROLEPTIC_MONTH;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.plusMonths(newValue - this.getLong(ChronoField$.PROLEPTIC_MONTH));
            }
            ChronoField chronoField6 = ChronoField$.YEAR_OF_ERA;
            ChronoField chronoField7 = chronoField;
            if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                return this.withYear((int)(this.year() < 1 ? 1L - newValue : newValue));
            }
            ChronoField chronoField8 = ChronoField$.YEAR;
            ChronoField chronoField9 = chronoField;
            if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                return this.withYear((int)newValue);
            }
            ChronoField chronoField10 = ChronoField$.ERA;
            ChronoField chronoField11 = chronoField;
            if (!(chronoField10 != null ? !chronoField10.equals(chronoField11) : chronoField11 != null)) {
                if (this.getLong(ChronoField$.ERA) == newValue) {
                    return this;
                }
                return this.withYear(1 - this.year());
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.adjustInto(this, newValue);
    }

    public YearMonth withYear(int year) {
        ChronoField$.YEAR.checkValidValue(year);
        return this.with(year, this.month());
    }

    public YearMonth withMonth(int month) {
        ChronoField$.MONTH_OF_YEAR.checkValidValue(month);
        return this.with(this.year(), month);
    }

    @Override
    public YearMonth plus(TemporalAmount amount) {
        return (YearMonth)amount.addTo(this);
    }

    @Override
    public YearMonth plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            ChronoUnit chronoUnit2 = ChronoUnit$.MONTHS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.plusMonths(amountToAdd);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.YEARS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return this.plusYears(amountToAdd);
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.DECADES;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 10L));
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.CENTURIES;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 100L));
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.MILLENNIA;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 1000L));
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.ERAS;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return this.with(ChronoField$.ERA, Math.addExact(this.getLong(ChronoField$.ERA), amountToAdd));
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.addTo(this, amountToAdd);
    }

    public YearMonth plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        int newYear = ChronoField$.YEAR.checkValidIntValue((long)this.year() + yearsToAdd);
        return this.with(newYear, this.month());
    }

    public YearMonth plusMonths(long monthsToAdd) {
        if (monthsToAdd == 0L) {
            return this;
        }
        long monthCount = (long)this.year() * 12L + (long)(this.month() - 1);
        long calcMonths = monthCount + monthsToAdd;
        int newYear = ChronoField$.YEAR.checkValidIntValue(Math.floorDiv(calcMonths, 12L));
        int newMonth = (int)Math.floorMod(calcMonths, 12L) + 1;
        return this.with(newYear, newMonth);
    }

    @Override
    public YearMonth minus(TemporalAmount amount) {
        return (YearMonth)amount.subtractFrom(this);
    }

    @Override
    public YearMonth minus(long amountToSubtract, TemporalUnit unit) {
        if (amountToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, unit).plus(1L, unit);
        }
        return this.plus(-amountToSubtract, unit);
    }

    public YearMonth minusYears(long yearsToSubtract) {
        if (yearsToSubtract == Long.MIN_VALUE) {
            return this.plusYears(Long.MAX_VALUE).plusYears(1L);
        }
        return this.plusYears(-yearsToSubtract);
    }

    public YearMonth minusMonths(long monthsToSubtract) {
        if (monthsToSubtract == Long.MIN_VALUE) {
            return this.plusMonths(Long.MAX_VALUE).plusMonths(1L);
        }
        return this.plusMonths(-monthsToSubtract);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries$.MODULE$.chronology()) {
            return (R)IsoChronology$.MODULE$.INSTANCE();
        }
        if (query == TemporalQueries$.MODULE$.precision()) {
            return (R)ChronoUnit$.MONTHS;
        }
        if (query == TemporalQueries$.MODULE$.localDate() || query == TemporalQueries$.MODULE$.localTime() || query == TemporalQueries$.MODULE$.zone() || query == TemporalQueries$.MODULE$.zoneId() || query == TemporalQueries$.MODULE$.offset()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        Chronology chronology = Chronology$.MODULE$.from(temporal);
        IsoChronology isoChronology = IsoChronology$.MODULE$.INSTANCE();
        if (chronology == null ? isoChronology != null : !((Object)chronology).equals(isoChronology)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField$.PROLEPTIC_MONTH, this.getProlepticMonth());
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        YearMonth end = YearMonth$.MODULE$.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            long monthsUntil = end.getProlepticMonth() - this.getProlepticMonth();
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            ChronoUnit chronoUnit2 = ChronoUnit$.MONTHS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return monthsUntil;
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.YEARS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return monthsUntil / 12L;
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.DECADES;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return monthsUntil / 120L;
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.CENTURIES;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return monthsUntil / 1200L;
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.MILLENNIA;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return monthsUntil / 12000L;
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.ERAS;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return end.getLong(ChronoField$.ERA) - this.getLong(ChronoField$.ERA);
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.between(this, end);
    }

    public LocalDate atDay(int dayOfMonth) {
        return LocalDate$.MODULE$.of(this.year(), this.month(), dayOfMonth);
    }

    public LocalDate atEndOfMonth() {
        return LocalDate$.MODULE$.of(this.year(), this.month(), this.lengthOfMonth());
    }

    public int compare(YearMonth other) {
        int cmp = this.year() - other.year();
        if (cmp == 0) {
            cmp = this.month() - other.month();
        }
        return cmp;
    }

    public int compareTo(YearMonth other) {
        return this.compare(other);
    }

    public boolean isAfter(YearMonth other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(YearMonth other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof YearMonth) {
            YearMonth other = (YearMonth)object;
            return this == other || this.year() == other.year() && this.month() == other.month();
        }
        return false;
    }

    public int hashCode() {
        return this.year() ^ this.month() << 27;
    }

    public String toString() {
        int absYear = Math.abs(this.year());
        scala.collection.mutable.StringBuilder buf = new scala.collection.mutable.StringBuilder(9);
        scala.collection.mutable.StringBuilder stringBuilder = absYear < 1000 ? (this.year() < 0 ? buf.append(this.year() - 10000).deleteCharAt(1) : buf.append(this.year() + 10000).deleteCharAt(0)) : buf.append(this.year());
        return buf.append(this.month() < 10 ? "-0" : "-").append(this.month()).toString();
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }
}

