/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year$;
import java.time.YearMonth;
import java.time.YearMonth$;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.chrono.Chronology$;
import java.time.chrono.IsoChronology;
import java.time.chrono.IsoChronology$;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.temporal.ValueRange$;
import java.util.Objects;
import scala.math.Ordered;

public final class Year
implements Temporal,
TemporalAdjuster,
Ordered<Year>,
Serializable {
    private static final long serialVersionUID = -23038383694477807L;
    private final int year;

    public static int MAX_VALUE() {
        return Year$.MODULE$.MAX_VALUE();
    }

    public static int MIN_VALUE() {
        return Year$.MODULE$.MIN_VALUE();
    }

    public static Year from(TemporalAccessor temporalAccessor) {
        return Year$.MODULE$.from(temporalAccessor);
    }

    public static Year now() {
        return Year$.MODULE$.now();
    }

    public static Year now(Clock clock) {
        return Year$.MODULE$.now(clock);
    }

    public static Year now(ZoneId zoneId) {
        return Year$.MODULE$.now(zoneId);
    }

    public static Year of(int n) {
        return Year$.MODULE$.of(n);
    }

    public static Year parse(CharSequence charSequence) {
        return Year$.MODULE$.parse(charSequence);
    }

    public static Year parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return Year$.MODULE$.parse(charSequence, dateTimeFormatter);
    }

    public Year(int year) {
        this.year = year;
        Ordered.$init$((Ordered)this);
    }

    private int year() {
        return this.year;
    }

    public int getValue() {
        return this.year();
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField$.YEAR || field == ChronoField$.YEAR_OF_ERA || field == ChronoField$.ERA;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit == ChronoUnit$.YEARS || unit == ChronoUnit$.DECADES || unit == ChronoUnit$.CENTURIES || unit == ChronoUnit$.MILLENNIA || unit == ChronoUnit$.ERAS;
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField$.YEAR_OF_ERA) {
            if (this.year() <= 0) {
                return ValueRange$.MODULE$.of(1L, (long)Year$.MODULE$.MAX_VALUE() + 1L);
            }
            return ValueRange$.MODULE$.of(1L, Year$.MODULE$.MAX_VALUE());
        }
        return TemporalAccessor.range$(this, field);
    }

    @Override
    public int get(TemporalField field) {
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f;
            ChronoField chronoField = f = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.YEAR_OF_ERA;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                if (this.year() < 1) {
                    return 1L - (long)this.year();
                }
                return this.year();
            }
            ChronoField chronoField4 = ChronoField$.YEAR;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.year();
            }
            ChronoField chronoField6 = ChronoField$.ERA;
            ChronoField chronoField7 = chronoField;
            if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                if (this.year() < 1) {
                    return 0L;
                }
                return 1L;
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.getFrom(this);
    }

    public boolean isLeap() {
        return Year$.MODULE$.isLeap(this.year());
    }

    public boolean isValidMonthDay(MonthDay monthDay) {
        return monthDay != null && monthDay.isValidYear(this.year());
    }

    public int length() {
        if (this.isLeap()) {
            return 366;
        }
        return 365;
    }

    @Override
    public Year with(TemporalAdjuster adjuster) {
        return (Year)adjuster.adjustInto(this);
    }

    @Override
    public Year with(TemporalField field, long newValue) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f = (ChronoField)temporalField;
            f.checkValidValue(newValue);
            ChronoField chronoField = f;
            ChronoField chronoField2 = ChronoField$.YEAR_OF_ERA;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return Year$.MODULE$.of((int)(this.year() < 1 ? 1L - newValue : newValue));
            }
            ChronoField chronoField4 = ChronoField$.YEAR;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return Year$.MODULE$.of((int)newValue);
            }
            ChronoField chronoField6 = ChronoField$.ERA;
            ChronoField chronoField7 = chronoField;
            if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                if (this.getLong(ChronoField$.ERA) == newValue) {
                    return this;
                }
                return Year$.MODULE$.of(1 - this.year());
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.adjustInto(this, newValue);
    }

    @Override
    public Year plus(TemporalAmount amount) {
        return (Year)amount.addTo(this);
    }

    @Override
    public Year plus(long amountToAdd, TemporalUnit unit) {
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit u;
            ChronoUnit chronoUnit = u = (ChronoUnit)temporalUnit;
            ChronoUnit chronoUnit2 = ChronoUnit$.YEARS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.plusYears(amountToAdd);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.DECADES;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 10L));
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.CENTURIES;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 100L));
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.MILLENNIA;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 1000L));
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.ERAS;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return this.with(ChronoField$.ERA, Math.addExact(this.getLong(ChronoField$.ERA), amountToAdd));
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.addTo(this, amountToAdd);
    }

    public Year plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        return Year$.MODULE$.of(ChronoField$.YEAR.checkValidIntValue((long)this.year() + yearsToAdd));
    }

    @Override
    public Year minus(TemporalAmount amount) {
        return (Year)amount.subtractFrom(this);
    }

    @Override
    public Year minus(long amountToSubtract, TemporalUnit unit) {
        if (amountToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, unit).plus(1L, unit);
        }
        return this.plus(-amountToSubtract, unit);
    }

    public Year minusYears(long yearsToSubtract) {
        if (yearsToSubtract == Long.MIN_VALUE) {
            return this.plusYears(Long.MAX_VALUE).plusYears(1L);
        }
        return this.plusYears(-yearsToSubtract);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries$.MODULE$.chronology()) {
            return (R)IsoChronology$.MODULE$.INSTANCE();
        }
        if (query == TemporalQueries$.MODULE$.precision()) {
            return (R)ChronoUnit$.YEARS;
        }
        if (query == TemporalQueries$.MODULE$.localDate() || query == TemporalQueries$.MODULE$.localTime() || query == TemporalQueries$.MODULE$.zone() || query == TemporalQueries$.MODULE$.zoneId() || query == TemporalQueries$.MODULE$.offset()) {
            return null;
        }
        return (R)TemporalAccessor.query$(this, query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        Chronology chronology = Chronology$.MODULE$.from(temporal);
        IsoChronology isoChronology = IsoChronology$.MODULE$.INSTANCE();
        if (chronology == null ? isoChronology != null : !((Object)chronology).equals(isoChronology)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField$.YEAR, this.year());
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        Year end = Year$.MODULE$.from(endExclusive);
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit u = (ChronoUnit)temporalUnit;
            long yearsUntil = (long)end.year() - (long)this.year();
            ChronoUnit chronoUnit = u;
            ChronoUnit chronoUnit2 = ChronoUnit$.YEARS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return yearsUntil;
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.DECADES;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return yearsUntil / 10L;
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.CENTURIES;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return yearsUntil / 100L;
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.MILLENNIA;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return yearsUntil / 1000L;
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.ERAS;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return end.getLong(ChronoField$.ERA) - this.getLong(ChronoField$.ERA);
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.between(this, end);
    }

    public LocalDate atDay(int dayOfYear) {
        return LocalDate$.MODULE$.ofYearDay(this.year(), dayOfYear);
    }

    public YearMonth atMonth(Month month) {
        return YearMonth$.MODULE$.of(this.year(), month);
    }

    public YearMonth atMonth(int month) {
        return YearMonth$.MODULE$.of(this.year(), month);
    }

    public LocalDate atMonthDay(MonthDay monthDay) {
        return monthDay.atYear(this.year());
    }

    public int compare(Year other) {
        return this.year() - other.year();
    }

    public int compareTo(Year other) {
        return this.compare(other);
    }

    public boolean isAfter(Year other) {
        return this.year() > other.year();
    }

    public boolean isBefore(Year other) {
        return this.year() < other.year();
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof Year) {
            Year thatYear = (Year)object;
            return this == thatYear || this.year() == thatYear.year();
        }
        return false;
    }

    public int hashCode() {
        return this.year();
    }

    public String toString() {
        return Integer.toString(this.year());
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }
}

