/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.Year;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.chrono.Chronology$;
import java.time.chrono.IsoChronology;
import java.time.chrono.IsoChronology$;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle$;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class Year$
implements Serializable {
    private static final long serialVersionUID = -23038383694477807L;
    private int MIN_VALUE$lzy1;
    private boolean MIN_VALUEbitmap$1;
    private int MAX_VALUE$lzy1;
    private boolean MAX_VALUEbitmap$1;
    private DateTimeFormatter PARSER$lzy1;
    private boolean PARSERbitmap$1;
    public static final Year$ MODULE$ = new Year$();

    private Year$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Year$.class);
    }

    public int MIN_VALUE() {
        if (!this.MIN_VALUEbitmap$1) {
            this.MIN_VALUE$lzy1 = -999999999;
            this.MIN_VALUEbitmap$1 = true;
        }
        return this.MIN_VALUE$lzy1;
    }

    public int MAX_VALUE() {
        if (!this.MAX_VALUEbitmap$1) {
            this.MAX_VALUE$lzy1 = 999999999;
            this.MAX_VALUEbitmap$1 = true;
        }
        return this.MAX_VALUE$lzy1;
    }

    private DateTimeFormatter PARSER() {
        if (!this.PARSERbitmap$1) {
            this.PARSER$lzy1 = new DateTimeFormatterBuilder().appendValue(ChronoField$.YEAR, 4, 10, SignStyle$.EXCEEDS_PAD).toFormatter();
            this.PARSERbitmap$1 = true;
        }
        return this.PARSER$lzy1;
    }

    public Year now() {
        return this.now(Clock$.MODULE$.systemDefaultZone());
    }

    public Year now(ZoneId zone) {
        return this.now(Clock$.MODULE$.system(zone));
    }

    public Year now(Clock clock) {
        LocalDate now = LocalDate$.MODULE$.now(clock);
        return this.of(now.getYear());
    }

    public Year of(int isoYear) {
        ChronoField$.YEAR.checkValidValue(isoYear);
        return new Year(isoYear);
    }

    public Year from(TemporalAccessor temporal) {
        Year year;
        TemporalAccessor _temporal = temporal;
        TemporalAccessor temporalAccessor = _temporal;
        if (temporalAccessor instanceof Year) {
            Year year2 = (Year)temporalAccessor;
            return year2;
        }
        try {
            IsoChronology isoChronology = IsoChronology$.MODULE$.INSTANCE();
            Chronology chronology = Chronology$.MODULE$.from(_temporal);
            if (isoChronology == null ? chronology != null : !((Object)isoChronology).equals(chronology)) {
                _temporal = LocalDate$.MODULE$.from(_temporal);
            }
            year = this.of(_temporal.get(ChronoField$.YEAR));
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException(new StringBuilder(52).append("Unable to obtain Year from TemporalAccessor: ").append(_temporal).append(", type ").append(_temporal.getClass().getName()).toString());
        }
        return year;
    }

    public Year parse(CharSequence text) {
        return this.parse(text, this.PARSER());
    }

    public Year parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, new TemporalQuery<Year>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Year queryFrom(TemporalAccessor temporal) {
                return Year$.MODULE$.from(temporal);
            }
        });
    }

    public boolean isLeap(long year) {
        return (year & 3L) == 0L && (year % 100L != 0L || year % 400L == 0L);
    }
}

