/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period$;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Period
implements ChronoPeriod,
Serializable {
    private static final long serialVersionUID = -8290556941213247973L;
    private final int years;
    private final int months;
    private final int days;

    public static Period ZERO() {
        return Period$.MODULE$.ZERO();
    }

    public static Period between(LocalDate localDate, LocalDate localDate2) {
        return Period$.MODULE$.between(localDate, localDate2);
    }

    public static Period from(TemporalAmount temporalAmount) {
        return Period$.MODULE$.from(temporalAmount);
    }

    public static Period of(int n, int n2, int n3) {
        return Period$.MODULE$.of(n, n2, n3);
    }

    public static Period ofDays(int n) {
        return Period$.MODULE$.ofDays(n);
    }

    public static Period ofMonths(int n) {
        return Period$.MODULE$.ofMonths(n);
    }

    public static Period ofWeeks(int n) {
        return Period$.MODULE$.ofWeeks(n);
    }

    public static Period ofYears(int n) {
        return Period$.MODULE$.ofYears(n);
    }

    public static Period parse(CharSequence charSequence) {
        return Period$.MODULE$.parse(charSequence);
    }

    public Period(int years, int months, int days) {
        this.years = years;
        this.months = months;
        this.days = days;
    }

    private int years() {
        return this.years;
    }

    private int months() {
        return this.months;
    }

    private int days() {
        return this.days;
    }

    private Object readResolve() {
        if ((this.years() | this.months() | this.days()) == 0) {
            return Period$.MODULE$.ZERO();
        }
        return this;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.unmodifiableList(Arrays.asList(ChronoUnit$.YEARS, ChronoUnit$.MONTHS, ChronoUnit$.DAYS));
    }

    @Override
    public Chronology getChronology() {
        return IsoChronology$.MODULE$.INSTANCE();
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit$.YEARS) {
            return this.years();
        }
        if (unit == ChronoUnit$.MONTHS) {
            return this.months();
        }
        if (unit == ChronoUnit$.DAYS) {
            return this.days();
        }
        throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
    }

    @Override
    public boolean isZero() {
        return this == Period$.MODULE$.ZERO();
    }

    @Override
    public boolean isNegative() {
        return this.years() < 0 || this.months() < 0 || this.days() < 0;
    }

    public int getYears() {
        return this.years();
    }

    public int getMonths() {
        return this.months();
    }

    public int getDays() {
        return this.days();
    }

    public Period withYears(int years) {
        if (years == this.years()) {
            return this;
        }
        return Period$.MODULE$.java$time$Period$$$create(years, this.months(), this.days());
    }

    public Period withMonths(int months) {
        if (months == this.months()) {
            return this;
        }
        return Period$.MODULE$.java$time$Period$$$create(this.years(), months, this.days());
    }

    public Period withDays(int days) {
        if (days == this.days()) {
            return this;
        }
        return Period$.MODULE$.java$time$Period$$$create(this.years(), this.months(), days);
    }

    @Override
    public Period plus(TemporalAmount amountToAdd) {
        Period amount = Period$.MODULE$.from(amountToAdd);
        return Period$.MODULE$.java$time$Period$$$create(Math.addExact(this.years(), amount.years()), Math.addExact(this.months(), amount.months()), Math.addExact(this.days(), amount.days()));
    }

    public Period plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        return Period$.MODULE$.java$time$Period$$$create(Math.toIntExact(Math.addExact((long)this.years(), yearsToAdd)), this.months(), this.days());
    }

    public Period plusMonths(long monthsToAdd) {
        if (monthsToAdd == 0L) {
            return this;
        }
        return Period$.MODULE$.java$time$Period$$$create(this.years(), Math.toIntExact(Math.addExact((long)this.months(), monthsToAdd)), this.days());
    }

    public Period plusDays(long daysToAdd) {
        if (daysToAdd == 0L) {
            return this;
        }
        return Period$.MODULE$.java$time$Period$$$create(this.years(), this.months(), Math.toIntExact(Math.addExact((long)this.days(), daysToAdd)));
    }

    @Override
    public Period minus(TemporalAmount amountToSubtract) {
        Period amount = Period$.MODULE$.from(amountToSubtract);
        return Period$.MODULE$.java$time$Period$$$create(Math.subtractExact(this.years(), amount.years()), Math.subtractExact(this.months(), amount.months()), Math.subtractExact(this.days(), amount.days()));
    }

    public Period minusYears(long yearsToSubtract) {
        if (yearsToSubtract == Long.MIN_VALUE) {
            return this.plusYears(Long.MAX_VALUE).plusYears(1L);
        }
        return this.plusYears(-yearsToSubtract);
    }

    public Period minusMonths(long monthsToSubtract) {
        if (monthsToSubtract == Long.MIN_VALUE) {
            return this.plusMonths(Long.MAX_VALUE).plusMonths(1L);
        }
        return this.plusMonths(-monthsToSubtract);
    }

    public Period minusDays(long daysToSubtract) {
        if (daysToSubtract == Long.MIN_VALUE) {
            return this.plusDays(Long.MAX_VALUE).plusDays(1L);
        }
        return this.plusDays(-daysToSubtract);
    }

    @Override
    public Period multipliedBy(int scalar) {
        if (this == Period$.MODULE$.ZERO() || scalar == 1) {
            return this;
        }
        return Period$.MODULE$.java$time$Period$$$create(Math.multiplyExact(this.years(), scalar), Math.multiplyExact(this.months(), scalar), Math.multiplyExact(this.days(), scalar));
    }

    @Override
    public Period negated() {
        return this.multipliedBy(-1);
    }

    @Override
    public Period normalized() {
        long totalMonths = this.toTotalMonths();
        long splitYears = totalMonths / 12L;
        int splitMonths = (int)(totalMonths % 12L);
        if (splitYears == (long)this.years() && splitMonths == this.months()) {
            return this;
        }
        return Period$.MODULE$.java$time$Period$$$create(Math.toIntExact(splitYears), splitMonths, this.days());
    }

    public long toTotalMonths() {
        return (long)this.years() * 12L + (long)this.months();
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        Temporal _temporal = temporal;
        Objects.requireNonNull(_temporal, "temporal");
        if (this.years() != 0) {
            _temporal = this.months() != 0 ? _temporal.plus(this.toTotalMonths(), ChronoUnit$.MONTHS) : _temporal.plus(this.years(), ChronoUnit$.YEARS);
        } else if (this.months() != 0) {
            _temporal = _temporal.plus(this.months(), ChronoUnit$.MONTHS);
        }
        if (this.days() != 0) {
            _temporal = _temporal.plus(this.days(), ChronoUnit$.DAYS);
        }
        return _temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Temporal _temporal = temporal;
        Objects.requireNonNull(_temporal, "temporal");
        if (this.years() != 0) {
            _temporal = this.months() != 0 ? _temporal.minus(this.toTotalMonths(), ChronoUnit$.MONTHS) : _temporal.minus(this.years(), ChronoUnit$.YEARS);
        } else if (this.months() != 0) {
            _temporal = _temporal.minus(this.months(), ChronoUnit$.MONTHS);
        }
        if (this.days() != 0) {
            _temporal = _temporal.minus(this.days(), ChronoUnit$.DAYS);
        }
        return _temporal;
    }

    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof Period) {
            Period other = (Period)object;
            return this == other || this.years() == other.years() && this.months() == other.months() && this.days() == other.days();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.years() + Integer.rotateLeft(this.months(), 8) + Integer.rotateLeft(this.days(), 16);
    }

    @Override
    public String toString() {
        if (this == Period$.MODULE$.ZERO()) {
            return "P0D";
        }
        scala.collection.mutable.StringBuilder buf = new scala.collection.mutable.StringBuilder();
        buf.append('P');
        if (this.years() != 0) {
            buf.append(this.years()).append('Y');
        }
        if (this.months() != 0) {
            buf.append(this.months()).append('M');
        }
        if (this.days() != 0) {
            buf.append(this.days()).append('D');
        }
        return buf.toString();
    }
}

