/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Period;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.chrono.IsoChronology$;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.ModuleSerializationProxy;

public final class Period$
implements Serializable {
    private static final long serialVersionUID = -8290556941213247973L;
    private Period ZERO$lzy1;
    private boolean ZERObitmap$1;
    private Pattern PATTERN$lzy1;
    private boolean PATTERNbitmap$1;
    public static final Period$ MODULE$ = new Period$();

    private Period$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Period$.class);
    }

    public Period ZERO() {
        if (!this.ZERObitmap$1) {
            this.ZERO$lzy1 = new Period(0, 0, 0);
            this.ZERObitmap$1 = true;
        }
        return this.ZERO$lzy1;
    }

    private Pattern PATTERN() {
        if (!this.PATTERNbitmap$1) {
            this.PATTERN$lzy1 = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)Y)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)W)?(?:([-+]?[0-9]+)D)?", 2);
            this.PATTERNbitmap$1 = true;
        }
        return this.PATTERN$lzy1;
    }

    public Period ofYears(int years) {
        return this.java$time$Period$$$create(years, 0, 0);
    }

    public Period ofMonths(int months) {
        return this.java$time$Period$$$create(0, months, 0);
    }

    public Period ofWeeks(int weeks) {
        return this.java$time$Period$$$create(0, 0, Math.multiplyExact(weeks, 7));
    }

    public Period ofDays(int days) {
        return this.java$time$Period$$$create(0, 0, days);
    }

    public Period of(int years, int months, int days) {
        return this.java$time$Period$$$create(years, months, days);
    }

    public Period from(TemporalAmount amount) {
        TemporalAmount temporalAmount = amount;
        if (temporalAmount instanceof Period) {
            Period period = (Period)temporalAmount;
            return period;
        }
        if (temporalAmount instanceof ChronoPeriod) {
            ChronoPeriod chrono = (ChronoPeriod)temporalAmount;
            IsoChronology isoChronology = IsoChronology$.MODULE$.INSTANCE();
            Chronology chronology = chrono.getChronology();
            if (isoChronology == null ? chronology != null : !((Object)isoChronology).equals(chronology)) {
                throw new DateTimeException(new StringBuilder(32).append("Period requires ISO chronology: ").append(amount).toString());
            }
            return this.fromAmount$1(amount);
        }
        return this.fromAmount$1(amount);
    }

    public Period between(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate);
    }

    public Period parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        Matcher matcher = this.PATTERN().matcher(text);
        if (matcher.matches()) {
            int negate = "-".equals(matcher.group(1)) ? -1 : 1;
            String yearMatch = matcher.group(2);
            String monthMatch = matcher.group(3);
            String weekMatch = matcher.group(4);
            String dayMatch = matcher.group(5);
            if (yearMatch != null || monthMatch != null || weekMatch != null || dayMatch != null) {
                try {
                    int years = this.parseNumber(text, yearMatch, negate);
                    int months = this.parseNumber(text, monthMatch, negate);
                    int weeks = this.parseNumber(text, weekMatch, negate);
                    int days = this.parseNumber(text, dayMatch, negate);
                    days = Math.addExact(days, Math.multiplyExact(weeks, 7));
                    return this.java$time$Period$$$create(years, months, days);
                }
                catch (NumberFormatException ex) {
                    throw new DateTimeParseException("Text cannot be parsed to a Period", text, 0, ex);
                }
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a Period", text, 0);
    }

    private int parseNumber(CharSequence text, String str, int negate) {
        int n;
        if (str == null) {
            return 0;
        }
        int val = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(str));
        try {
            n = Math.multiplyExact(val, negate);
        }
        catch (ArithmeticException ex) {
            throw new DateTimeParseException("Text cannot be parsed to a Period", text, 0, ex);
        }
        return n;
    }

    public Period java$time$Period$$$create(int years, int months, int days) {
        if ((years | months | days) == 0) {
            return this.ZERO();
        }
        return new Period(years, months, days);
    }

    private final Period fromAmount$1(TemporalAmount amount$1) {
        Objects.requireNonNull(amount$1, "amount");
        int years = 0;
        int months = 0;
        int days = 0;
        for (TemporalUnit unit : amount$1.getUnits()) {
            long unitAmount = amount$1.get(unit);
            if (unit == ChronoUnit$.YEARS) {
                years = Math.toIntExact(unitAmount);
                continue;
            }
            if (unit == ChronoUnit$.MONTHS) {
                months = Math.toIntExact(unitAmount);
                continue;
            }
            if (unit == ChronoUnit$.DAYS) {
                days = Math.toIntExact(unitAmount);
                continue;
            }
            throw new DateTimeException(new StringBuilder(44).append("Unit must be Years, Months or Days, but was ").append(unit).toString());
        }
        return this.java$time$Period$$$create(years, months, days);
    }
}

