/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetDateTime$;
import java.time.OffsetTime$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;
import scala.math.Ordered;

public final class OffsetTime
implements Temporal,
TemporalAdjuster,
Ordered<OffsetTime>,
Serializable {
    private static final long serialVersionUID = 7264499704384272492L;
    private final LocalTime time;
    private final ZoneOffset offset;

    public static OffsetTime MAX() {
        return OffsetTime$.MODULE$.MAX();
    }

    public static OffsetTime MIN() {
        return OffsetTime$.MODULE$.MIN();
    }

    public static OffsetTime from(TemporalAccessor temporalAccessor) {
        return OffsetTime$.MODULE$.from(temporalAccessor);
    }

    public static OffsetTime now() {
        return OffsetTime$.MODULE$.now();
    }

    public static OffsetTime now(Clock clock) {
        return OffsetTime$.MODULE$.now(clock);
    }

    public static OffsetTime now(ZoneId zoneId) {
        return OffsetTime$.MODULE$.now(zoneId);
    }

    public static OffsetTime of(int n, int n2, int n3, int n4, ZoneOffset zoneOffset) {
        return OffsetTime$.MODULE$.of(n, n2, n3, n4, zoneOffset);
    }

    public static OffsetTime of(LocalTime localTime, ZoneOffset zoneOffset) {
        return OffsetTime$.MODULE$.of(localTime, zoneOffset);
    }

    public static OffsetTime ofInstant(Instant instant, ZoneId zoneId) {
        return OffsetTime$.MODULE$.ofInstant(instant, zoneId);
    }

    public static OffsetTime parse(CharSequence charSequence) {
        return OffsetTime$.MODULE$.parse(charSequence);
    }

    public static OffsetTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return OffsetTime$.MODULE$.parse(charSequence, dateTimeFormatter);
    }

    public OffsetTime(LocalTime time, ZoneOffset offset) {
        this.time = time;
        this.offset = offset;
        Ordered.$init$((Ordered)this);
        Objects.requireNonNull(time, "time");
        Objects.requireNonNull(offset, "offset");
    }

    private LocalTime time() {
        return this.time;
    }

    private ZoneOffset offset() {
        return this.offset;
    }

    private OffsetTime with(LocalTime time, ZoneOffset offset) {
        if (this.time() == time) {
            ZoneOffset zoneOffset = this.offset();
            ZoneOffset zoneOffset2 = offset;
            if (!(zoneOffset != null ? !((Object)zoneOffset).equals(zoneOffset2) : zoneOffset2 != null)) {
                return this;
            }
        }
        return new OffsetTime(time, offset);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field.isTimeBased() || field == ChronoField$.OFFSET_SECONDS;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit.isTimeBased();
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField$.OFFSET_SECONDS) {
                return field.range();
            }
            return this.time().range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        return TemporalAccessor.get$(this, field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField$.OFFSET_SECONDS) {
                return this.getOffset().getTotalSeconds();
            }
            return this.time().getLong(field);
        }
        return field.getFrom(this);
    }

    public ZoneOffset getOffset() {
        return this.offset();
    }

    public OffsetTime withOffsetSameLocal(ZoneOffset offset) {
        if (offset != null) {
            ZoneOffset zoneOffset = offset;
            ZoneOffset zoneOffset2 = this.offset();
            if (!(zoneOffset != null ? !((Object)zoneOffset).equals(zoneOffset2) : zoneOffset2 != null)) {
                return this;
            }
        }
        return new OffsetTime(this.time(), offset);
    }

    public OffsetTime withOffsetSameInstant(ZoneOffset offset) {
        ZoneOffset zoneOffset = offset;
        ZoneOffset zoneOffset2 = this.offset();
        if (!(zoneOffset != null ? !((Object)zoneOffset).equals(zoneOffset2) : zoneOffset2 != null)) {
            return this;
        }
        int difference = offset.getTotalSeconds() - this.offset().getTotalSeconds();
        LocalTime adjusted = this.time().plusSeconds(difference);
        return new OffsetTime(adjusted, offset);
    }

    public int getHour() {
        return this.time().getHour();
    }

    public int getMinute() {
        return this.time().getMinute();
    }

    public int getSecond() {
        return this.time().getSecond();
    }

    public int getNano() {
        return this.time().getNano();
    }

    @Override
    public OffsetTime with(TemporalAdjuster adjuster) {
        TemporalAdjuster temporalAdjuster = adjuster;
        if (temporalAdjuster instanceof LocalTime) {
            LocalTime localTime = (LocalTime)temporalAdjuster;
            return this.with(localTime, this.offset());
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            ZoneOffset zoneOffset = (ZoneOffset)temporalAdjuster;
            return this.with(this.time(), zoneOffset);
        }
        if (temporalAdjuster instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)temporalAdjuster;
            return offsetTime;
        }
        return (OffsetTime)adjuster.adjustInto(this);
    }

    @Override
    public OffsetTime with(TemporalField field, long newValue) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f = (ChronoField)temporalField;
            if (field == ChronoField$.OFFSET_SECONDS) {
                return this.with(this.time(), ZoneOffset$.MODULE$.ofTotalSeconds(f.checkValidIntValue(newValue)));
            }
            return this.with(this.time().with(field, newValue), this.offset());
        }
        return field.adjustInto(this, newValue);
    }

    public OffsetTime withHour(int hour) {
        return this.with(this.time().withHour(hour), this.offset());
    }

    public OffsetTime withMinute(int minute) {
        return this.with(this.time().withMinute(minute), this.offset());
    }

    public OffsetTime withSecond(int second) {
        return this.with(this.time().withSecond(second), this.offset());
    }

    public OffsetTime withNano(int nanoOfSecond) {
        return this.with(this.time().withNano(nanoOfSecond), this.offset());
    }

    public OffsetTime truncatedTo(TemporalUnit unit) {
        return this.with(this.time().truncatedTo(unit), this.offset());
    }

    @Override
    public OffsetTime plus(TemporalAmount amount) {
        return (OffsetTime)amount.addTo(this);
    }

    @Override
    public OffsetTime plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return this.with(this.time().plus(amountToAdd, unit), this.offset());
        }
        return unit.addTo(this, amountToAdd);
    }

    public OffsetTime plusHours(long hours) {
        return this.with(this.time().plusHours(hours), this.offset());
    }

    public OffsetTime plusMinutes(long minutes) {
        return this.with(this.time().plusMinutes(minutes), this.offset());
    }

    public OffsetTime plusSeconds(long seconds) {
        return this.with(this.time().plusSeconds(seconds), this.offset());
    }

    public OffsetTime plusNanos(long nanos) {
        return this.with(this.time().plusNanos(nanos), this.offset());
    }

    @Override
    public OffsetTime minus(TemporalAmount amount) {
        return (OffsetTime)amount.subtractFrom(this);
    }

    @Override
    public OffsetTime minus(long amountToSubtract, TemporalUnit unit) {
        if (amountToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, unit).plus(1L, unit);
        }
        return this.plus(-amountToSubtract, unit);
    }

    public OffsetTime minusHours(long hours) {
        return this.with(this.time().minusHours(hours), this.offset());
    }

    public OffsetTime minusMinutes(long minutes) {
        return this.with(this.time().minusMinutes(minutes), this.offset());
    }

    public OffsetTime minusSeconds(long seconds) {
        return this.with(this.time().minusSeconds(seconds), this.offset());
    }

    public OffsetTime minusNanos(long nanos) {
        return this.with(this.time().minusNanos(nanos), this.offset());
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        block19: {
            block14: {
                TemporalQuery<R> temporalQuery;
                TemporalQuery<ZoneId> temporalQuery2;
                block18: {
                    TemporalQuery<R> temporalQuery3;
                    block17: {
                        TemporalQuery<R> temporalQuery4;
                        TemporalQuery<LocalDate> temporalQuery5;
                        block16: {
                            block15: {
                                TemporalQuery<R> temporalQuery6;
                                TemporalQuery<Chronology> temporalQuery7;
                                block13: {
                                    block12: {
                                        block9: {
                                            TemporalQuery<R> temporalQuery8;
                                            TemporalQuery<ZoneId> temporalQuery9;
                                            block11: {
                                                block10: {
                                                    TemporalQuery<R> temporalQuery10;
                                                    TemporalQuery<ZoneOffset> temporalQuery11;
                                                    block8: {
                                                        temporalQuery3 = query;
                                                        TemporalQuery<TemporalUnit> temporalQuery12 = TemporalQueries$.MODULE$.precision();
                                                        TemporalQuery<R> temporalQuery13 = temporalQuery3;
                                                        if (!(temporalQuery12 != null ? !temporalQuery12.equals(temporalQuery13) : temporalQuery13 != null)) {
                                                            return (R)ChronoUnit$.NANOS;
                                                        }
                                                        temporalQuery11 = TemporalQueries$.MODULE$.offset();
                                                        temporalQuery10 = temporalQuery3;
                                                        if (temporalQuery11 != null) break block8;
                                                        if (temporalQuery10 == null) break block9;
                                                        break block10;
                                                    }
                                                    if (temporalQuery11.equals(temporalQuery10)) break block9;
                                                }
                                                temporalQuery9 = TemporalQueries$.MODULE$.zone();
                                                temporalQuery8 = temporalQuery3;
                                                if (temporalQuery9 != null) break block11;
                                                if (temporalQuery8 == null) break block9;
                                                break block12;
                                            }
                                            if (!temporalQuery9.equals(temporalQuery8)) break block12;
                                        }
                                        return (R)this.getOffset();
                                    }
                                    TemporalQuery<LocalTime> temporalQuery14 = TemporalQueries$.MODULE$.localTime();
                                    TemporalQuery<R> temporalQuery15 = temporalQuery3;
                                    if (!(temporalQuery14 != null ? !temporalQuery14.equals(temporalQuery15) : temporalQuery15 != null)) {
                                        return (R)this.time();
                                    }
                                    temporalQuery7 = TemporalQueries$.MODULE$.chronology();
                                    temporalQuery6 = temporalQuery3;
                                    if (temporalQuery7 != null) break block13;
                                    if (temporalQuery6 == null) break block14;
                                    break block15;
                                }
                                if (temporalQuery7.equals(temporalQuery6)) break block14;
                            }
                            temporalQuery5 = TemporalQueries$.MODULE$.localDate();
                            temporalQuery4 = temporalQuery3;
                            if (temporalQuery5 != null) break block16;
                            if (temporalQuery4 == null) break block14;
                            break block17;
                        }
                        if (temporalQuery5.equals(temporalQuery4)) break block14;
                    }
                    temporalQuery2 = TemporalQueries$.MODULE$.zoneId();
                    temporalQuery = temporalQuery3;
                    if (temporalQuery2 != null) break block18;
                    if (temporalQuery == null) break block14;
                    break block19;
                }
                if (!temporalQuery2.equals(temporalQuery)) break block19;
            }
            return null;
        }
        return (R)TemporalAccessor.query$(this, query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField$.NANO_OF_DAY, this.time().toNanoOfDay()).with(ChronoField$.OFFSET_SECONDS, this.getOffset().getTotalSeconds());
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        OffsetTime end = OffsetTime$.MODULE$.from(endExclusive);
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit u = (ChronoUnit)temporalUnit;
            long nanosUntil = end.toEpochNano() - this.toEpochNano();
            ChronoUnit chronoUnit = u;
            ChronoUnit chronoUnit2 = ChronoUnit$.NANOS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return nanosUntil;
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.MICROS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return nanosUntil / 1000L;
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MILLIS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return nanosUntil / 1000000L;
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.SECONDS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return nanosUntil / 1000000000L;
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.MINUTES;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return nanosUntil / 60000000000L;
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.HOURS;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return nanosUntil / 3600000000000L;
            }
            ChronoUnit chronoUnit14 = ChronoUnit$.HALF_DAYS;
            ChronoUnit chronoUnit15 = chronoUnit;
            if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                return nanosUntil / 43200000000000L;
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.between(this, end);
    }

    public OffsetDateTime atDate(LocalDate date) {
        return OffsetDateTime$.MODULE$.of(date, this.time(), this.offset());
    }

    public LocalTime toLocalTime() {
        return this.time();
    }

    private long toEpochNano() {
        long nod = this.time().toNanoOfDay();
        long offsetNanos = (long)this.offset().getTotalSeconds() * 1000000000L;
        return nod - offsetNanos;
    }

    public int compare(OffsetTime other) {
        ZoneOffset zoneOffset = this.offset();
        ZoneOffset zoneOffset2 = other.offset();
        if (!(zoneOffset != null ? !((Object)zoneOffset).equals(zoneOffset2) : zoneOffset2 != null)) {
            return this.time().compareTo(other.time());
        }
        int compare = Long.compare(this.toEpochNano(), other.toEpochNano());
        if (compare == 0) {
            compare = this.time().compareTo(other.time());
        }
        return compare;
    }

    public int compareTo(OffsetTime other) {
        return this.compare(other);
    }

    public boolean isAfter(OffsetTime other) {
        return this.toEpochNano() > other.toEpochNano();
    }

    public boolean isBefore(OffsetTime other) {
        return this.toEpochNano() < other.toEpochNano();
    }

    public boolean isEqual(OffsetTime other) {
        return this.toEpochNano() == other.toEpochNano();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof OffsetTime)) return false;
        OffsetTime other = (OffsetTime)object;
        if (this == other) return true;
        LocalTime localTime = this.time();
        LocalTime localTime2 = other.time();
        if (localTime == null) {
            if (localTime2 != null) {
                return false;
            }
        } else if (!((Object)localTime).equals(localTime2)) return false;
        ZoneOffset zoneOffset = this.offset();
        ZoneOffset zoneOffset2 = other.offset();
        if (zoneOffset == null) {
            if (zoneOffset2 == null) return true;
            return false;
        } else {
            if (!((Object)zoneOffset).equals(zoneOffset2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return this.time().hashCode() ^ this.offset().hashCode();
    }

    public String toString() {
        return new StringBuilder(0).append(this.time().toString()).append(this.offset().toString()).toString();
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }
}

