/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.LocalTime$;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatter$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.time.zone.ZoneRules;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class OffsetTime$
implements Serializable {
    private OffsetTime MIN$lzy1;
    private boolean MINbitmap$1;
    private OffsetTime MAX$lzy1;
    private boolean MAXbitmap$1;
    public static final OffsetTime$ MODULE$ = new OffsetTime$();

    private OffsetTime$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(OffsetTime$.class);
    }

    public OffsetTime MIN() {
        if (!this.MINbitmap$1) {
            this.MIN$lzy1 = LocalTime$.MODULE$.MIN().atOffset(ZoneOffset$.MODULE$.MAX());
            this.MINbitmap$1 = true;
        }
        return this.MIN$lzy1;
    }

    public OffsetTime MAX() {
        if (!this.MAXbitmap$1) {
            this.MAX$lzy1 = LocalTime$.MODULE$.MAX().atOffset(ZoneOffset$.MODULE$.MIN());
            this.MAXbitmap$1 = true;
        }
        return this.MAX$lzy1;
    }

    public OffsetTime now() {
        return this.now(Clock$.MODULE$.systemDefaultZone());
    }

    public OffsetTime now(ZoneId zone) {
        return this.now(Clock$.MODULE$.system(zone));
    }

    public OffsetTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        return this.ofInstant(now, clock.getZone().getRules().getOffset(now));
    }

    public OffsetTime of(LocalTime time, ZoneOffset offset) {
        return new OffsetTime(time, offset);
    }

    public OffsetTime of(int hour, int minute, int second, int nanoOfSecond, ZoneOffset offset) {
        return new OffsetTime(LocalTime$.MODULE$.of(hour, minute, second, nanoOfSecond), offset);
    }

    public OffsetTime ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        ZoneRules rules = zone.getRules();
        ZoneOffset offset = rules.getOffset(instant);
        long secsOfDay = instant.getEpochSecond() % 86400L;
        secsOfDay = (secsOfDay + (long)offset.getTotalSeconds()) % 86400L;
        if (secsOfDay < 0L) {
            secsOfDay += 86400L;
        }
        LocalTime time = LocalTime$.MODULE$.ofSecondOfDay(secsOfDay, instant.getNano());
        return new OffsetTime(time, offset);
    }

    public OffsetTime from(TemporalAccessor temporal) {
        OffsetTime offsetTime;
        TemporalAccessor temporalAccessor = temporal;
        if (temporalAccessor instanceof OffsetTime) {
            OffsetTime time = (OffsetTime)temporalAccessor;
            return time;
        }
        try {
            LocalTime time = LocalTime$.MODULE$.from(temporal);
            ZoneOffset offset = ZoneOffset$.MODULE$.from(temporal);
            offsetTime = new OffsetTime(time, offset);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException(new StringBuilder(58).append("Unable to obtain OffsetTime from TemporalAccessor: ").append(temporal).append(", type ").append(temporal.getClass().getName()).toString());
        }
        return offsetTime;
    }

    public OffsetTime parse(CharSequence text) {
        return this.parse(text, DateTimeFormatter$.MODULE$.ISO_OFFSET_TIME());
    }

    public OffsetTime parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, new TemporalQuery<OffsetTime>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public OffsetTime queryFrom(TemporalAccessor temporal) {
                return OffsetTime$.MODULE$.from(temporal);
            }
        });
    }
}

