/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.Instant$;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime$;
import java.time.OffsetTime;
import java.time.OffsetTime$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.ZonedDateTime;
import java.time.ZonedDateTime$;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology$;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Comparator;
import java.util.Objects;
import scala.math.Ordered;

public final class OffsetDateTime
implements Temporal,
TemporalAdjuster,
Ordered<OffsetDateTime>,
Serializable {
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;

    public static OffsetDateTime MAX() {
        return OffsetDateTime$.MODULE$.MAX();
    }

    public static OffsetDateTime MIN() {
        return OffsetDateTime$.MODULE$.MIN();
    }

    public static OffsetDateTime from(TemporalAccessor temporalAccessor) {
        return OffsetDateTime$.MODULE$.from(temporalAccessor);
    }

    public static OffsetDateTime now() {
        return OffsetDateTime$.MODULE$.now();
    }

    public static OffsetDateTime now(Clock clock) {
        return OffsetDateTime$.MODULE$.now(clock);
    }

    public static OffsetDateTime now(ZoneId zoneId) {
        return OffsetDateTime$.MODULE$.now(zoneId);
    }

    public static OffsetDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7, ZoneOffset zoneOffset) {
        return OffsetDateTime$.MODULE$.of(n, n2, n3, n4, n5, n6, n7, zoneOffset);
    }

    public static OffsetDateTime of(LocalDate localDate, LocalTime localTime, ZoneOffset zoneOffset) {
        return OffsetDateTime$.MODULE$.of(localDate, localTime, zoneOffset);
    }

    public static OffsetDateTime of(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        return OffsetDateTime$.MODULE$.of(localDateTime, zoneOffset);
    }

    public static OffsetDateTime ofInstant(Instant instant, ZoneId zoneId) {
        return OffsetDateTime$.MODULE$.ofInstant(instant, zoneId);
    }

    public static OffsetDateTime parse(CharSequence charSequence) {
        return OffsetDateTime$.MODULE$.parse(charSequence);
    }

    public static OffsetDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return OffsetDateTime$.MODULE$.parse(charSequence, dateTimeFormatter);
    }

    public static Comparator<OffsetDateTime> timeLineOrder() {
        return OffsetDateTime$.MODULE$.timeLineOrder();
    }

    public OffsetDateTime(LocalDateTime dateTime, ZoneOffset offset) {
        this.dateTime = dateTime;
        this.offset = offset;
        Ordered.$init$((Ordered)this);
        Objects.requireNonNull(dateTime, "dateTime");
        Objects.requireNonNull(offset, "offset");
    }

    private LocalDateTime dateTime() {
        return this.dateTime;
    }

    private ZoneOffset offset() {
        return this.offset;
    }

    private OffsetDateTime with(LocalDateTime dateTime, ZoneOffset offset) {
        if (this.dateTime() == dateTime) {
            ZoneOffset zoneOffset = this.offset();
            ZoneOffset zoneOffset2 = offset;
            if (!(zoneOffset != null ? !((Object)zoneOffset).equals(zoneOffset2) : zoneOffset2 != null)) {
                return this;
            }
        }
        return new OffsetDateTime(dateTime, offset);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return field instanceof ChronoField || field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit.isDateBased() || unit.isTimeBased();
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField$.INSTANT_SECONDS || field == ChronoField$.OFFSET_SECONDS) {
                return field.range();
            }
            return this.dateTime().range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f;
            ChronoField chronoField = f = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.INSTANT_SECONDS;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                throw new DateTimeException(new StringBuilder(28).append("Field too large for an int: ").append(field).toString());
            }
            ChronoField chronoField4 = ChronoField$.OFFSET_SECONDS;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.getOffset().getTotalSeconds();
            }
            return this.dateTime().get(field);
        }
        return TemporalAccessor.get$(this, field);
    }

    @Override
    public long getLong(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f;
            ChronoField chronoField = f = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.INSTANT_SECONDS;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.toEpochSecond();
            }
            ChronoField chronoField4 = ChronoField$.OFFSET_SECONDS;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.getOffset().getTotalSeconds();
            }
            return this.dateTime().getLong(field);
        }
        return field.getFrom(this);
    }

    public ZoneOffset getOffset() {
        return this.offset();
    }

    public OffsetDateTime withOffsetSameLocal(ZoneOffset offset) {
        return this.with(this.dateTime(), offset);
    }

    public OffsetDateTime withOffsetSameInstant(ZoneOffset offset) {
        ZoneOffset zoneOffset = offset;
        ZoneOffset zoneOffset2 = this.offset();
        if (!(zoneOffset != null ? !((Object)zoneOffset).equals(zoneOffset2) : zoneOffset2 != null)) {
            return this;
        }
        int difference = offset.getTotalSeconds() - this.offset().getTotalSeconds();
        LocalDateTime adjusted = this.dateTime().plusSeconds(difference);
        return new OffsetDateTime(adjusted, offset);
    }

    public int getYear() {
        return this.dateTime().getYear();
    }

    public int getMonthValue() {
        return this.dateTime().getMonthValue();
    }

    public Month getMonth() {
        return this.dateTime().getMonth();
    }

    public int getDayOfMonth() {
        return this.dateTime().getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime().getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime().getDayOfWeek();
    }

    public int getHour() {
        return this.dateTime().getHour();
    }

    public int getMinute() {
        return this.dateTime().getMinute();
    }

    public int getSecond() {
        return this.dateTime().getSecond();
    }

    public int getNano() {
        return this.dateTime().getNano();
    }

    @Override
    public OffsetDateTime with(TemporalAdjuster adjuster) {
        TemporalAdjuster temporalAdjuster = adjuster;
        if (temporalAdjuster instanceof LocalDate || temporalAdjuster instanceof LocalTime || temporalAdjuster instanceof LocalDateTime) {
            return this.with(this.dateTime().with(adjuster), this.offset());
        }
        if (temporalAdjuster instanceof Instant) {
            Instant i = (Instant)temporalAdjuster;
            return OffsetDateTime$.MODULE$.ofInstant(i, this.offset());
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            ZoneOffset z = (ZoneOffset)temporalAdjuster;
            return this.with(this.dateTime(), z);
        }
        if (temporalAdjuster instanceof OffsetDateTime) {
            OffsetDateTime o = (OffsetDateTime)temporalAdjuster;
            return o;
        }
        return (OffsetDateTime)adjuster.adjustInto(this);
    }

    @Override
    public OffsetDateTime with(TemporalField field, long newValue) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f;
            ChronoField chronoField = f = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.INSTANT_SECONDS;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return OffsetDateTime$.MODULE$.ofInstant(Instant$.MODULE$.ofEpochSecond(newValue, this.getNano()), this.offset());
            }
            ChronoField chronoField4 = ChronoField$.OFFSET_SECONDS;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.with(this.dateTime(), ZoneOffset$.MODULE$.ofTotalSeconds(f.checkValidIntValue(newValue)));
            }
            return this.with(this.dateTime().with(field, newValue), this.offset());
        }
        return field.adjustInto(this, newValue);
    }

    public OffsetDateTime withYear(int year) {
        return this.with(this.dateTime().withYear(year), this.offset());
    }

    public OffsetDateTime withMonth(int month) {
        return this.with(this.dateTime().withMonth(month), this.offset());
    }

    public OffsetDateTime withDayOfMonth(int dayOfMonth) {
        return this.with(this.dateTime().withDayOfMonth(dayOfMonth), this.offset());
    }

    public OffsetDateTime withDayOfYear(int dayOfYear) {
        return this.with(this.dateTime().withDayOfYear(dayOfYear), this.offset());
    }

    public OffsetDateTime withHour(int hour) {
        return this.with(this.dateTime().withHour(hour), this.offset());
    }

    public OffsetDateTime withMinute(int minute) {
        return this.with(this.dateTime().withMinute(minute), this.offset());
    }

    public OffsetDateTime withSecond(int second) {
        return this.with(this.dateTime().withSecond(second), this.offset());
    }

    public OffsetDateTime withNano(int nanoOfSecond) {
        return this.with(this.dateTime().withNano(nanoOfSecond), this.offset());
    }

    public OffsetDateTime truncatedTo(TemporalUnit unit) {
        return this.with(this.dateTime().truncatedTo(unit), this.offset());
    }

    @Override
    public OffsetDateTime plus(TemporalAmount amount) {
        return (OffsetDateTime)amount.addTo(this);
    }

    @Override
    public OffsetDateTime plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return this.with(this.dateTime().plus(amountToAdd, unit), this.offset());
        }
        return unit.addTo(this, amountToAdd);
    }

    public OffsetDateTime plusYears(long years) {
        return this.with(this.dateTime().plusYears(years), this.offset());
    }

    public OffsetDateTime plusMonths(long months) {
        return this.with(this.dateTime().plusMonths(months), this.offset());
    }

    public OffsetDateTime plusWeeks(long weeks) {
        return this.with(this.dateTime().plusWeeks(weeks), this.offset());
    }

    public OffsetDateTime plusDays(long days) {
        return this.with(this.dateTime().plusDays(days), this.offset());
    }

    public OffsetDateTime plusHours(long hours) {
        return this.with(this.dateTime().plusHours(hours), this.offset());
    }

    public OffsetDateTime plusMinutes(long minutes) {
        return this.with(this.dateTime().plusMinutes(minutes), this.offset());
    }

    public OffsetDateTime plusSeconds(long seconds) {
        return this.with(this.dateTime().plusSeconds(seconds), this.offset());
    }

    public OffsetDateTime plusNanos(long nanos) {
        return this.with(this.dateTime().plusNanos(nanos), this.offset());
    }

    @Override
    public OffsetDateTime minus(TemporalAmount amount) {
        return (OffsetDateTime)amount.subtractFrom(this);
    }

    @Override
    public OffsetDateTime minus(long amountToSubtract, TemporalUnit unit) {
        if (amountToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, unit).plus(1L, unit);
        }
        return this.plus(-amountToSubtract, unit);
    }

    public OffsetDateTime minusYears(long years) {
        if (years == Long.MIN_VALUE) {
            return this.plusYears(Long.MAX_VALUE).plusYears(1L);
        }
        return this.plusYears(-years);
    }

    public OffsetDateTime minusMonths(long months) {
        if (months == Long.MIN_VALUE) {
            return this.plusMonths(Long.MAX_VALUE).plusMonths(1L);
        }
        return this.plusMonths(-months);
    }

    public OffsetDateTime minusWeeks(long weeks) {
        if (weeks == Long.MIN_VALUE) {
            return this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L);
        }
        return this.plusWeeks(-weeks);
    }

    public OffsetDateTime minusDays(long days) {
        if (days == Long.MIN_VALUE) {
            return this.plusDays(Long.MAX_VALUE).plusDays(1L);
        }
        return this.plusDays(-days);
    }

    public OffsetDateTime minusHours(long hours) {
        if (hours == Long.MIN_VALUE) {
            return this.plusHours(Long.MAX_VALUE).plusHours(1L);
        }
        return this.plusHours(-hours);
    }

    public OffsetDateTime minusMinutes(long minutes) {
        if (minutes == Long.MIN_VALUE) {
            return this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L);
        }
        return this.plusMinutes(-minutes);
    }

    public OffsetDateTime minusSeconds(long seconds) {
        if (seconds == Long.MIN_VALUE) {
            return this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L);
        }
        return this.plusSeconds(-seconds);
    }

    public OffsetDateTime minusNanos(long nanos) {
        if (nanos == Long.MIN_VALUE) {
            return this.plusNanos(Long.MAX_VALUE).plusNanos(1L);
        }
        return this.plusNanos(-nanos);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        TemporalQuery<R> temporalQuery;
        block12: {
            block9: {
                TemporalQuery<R> temporalQuery2;
                TemporalQuery<ZoneId> temporalQuery3;
                block11: {
                    block10: {
                        TemporalQuery<R> temporalQuery4;
                        TemporalQuery<ZoneOffset> temporalQuery5;
                        block8: {
                            temporalQuery = query;
                            TemporalQuery<Chronology> temporalQuery6 = TemporalQueries$.MODULE$.chronology();
                            TemporalQuery<R> temporalQuery7 = temporalQuery;
                            if (!(temporalQuery6 != null ? !temporalQuery6.equals(temporalQuery7) : temporalQuery7 != null)) {
                                return (R)IsoChronology$.MODULE$.INSTANCE();
                            }
                            TemporalQuery<TemporalUnit> temporalQuery8 = TemporalQueries$.MODULE$.precision();
                            TemporalQuery<R> temporalQuery9 = temporalQuery;
                            if (!(temporalQuery8 != null ? !temporalQuery8.equals(temporalQuery9) : temporalQuery9 != null)) {
                                return (R)ChronoUnit$.NANOS;
                            }
                            temporalQuery5 = TemporalQueries$.MODULE$.offset();
                            temporalQuery4 = temporalQuery;
                            if (temporalQuery5 != null) break block8;
                            if (temporalQuery4 == null) break block9;
                            break block10;
                        }
                        if (temporalQuery5.equals(temporalQuery4)) break block9;
                    }
                    temporalQuery3 = TemporalQueries$.MODULE$.zone();
                    temporalQuery2 = temporalQuery;
                    if (temporalQuery3 != null) break block11;
                    if (temporalQuery2 == null) break block9;
                    break block12;
                }
                if (!temporalQuery3.equals(temporalQuery2)) break block12;
            }
            return (R)this.getOffset();
        }
        TemporalQuery<LocalDate> temporalQuery10 = TemporalQueries$.MODULE$.localDate();
        TemporalQuery<R> temporalQuery11 = temporalQuery;
        if (!(temporalQuery10 != null ? !temporalQuery10.equals(temporalQuery11) : temporalQuery11 != null)) {
            return (R)this.toLocalDate();
        }
        TemporalQuery<LocalTime> temporalQuery12 = TemporalQueries$.MODULE$.localTime();
        TemporalQuery<R> temporalQuery13 = temporalQuery;
        if (!(temporalQuery12 != null ? !temporalQuery12.equals(temporalQuery13) : temporalQuery13 != null)) {
            return (R)this.toLocalTime();
        }
        TemporalQuery<ZoneId> temporalQuery14 = TemporalQueries$.MODULE$.zoneId();
        TemporalQuery<R> temporalQuery15 = temporalQuery;
        if (!(temporalQuery14 != null ? !temporalQuery14.equals(temporalQuery15) : temporalQuery15 != null)) {
            return null;
        }
        return (R)TemporalAccessor.query$(this, query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField$.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField$.NANO_OF_DAY, this.toLocalTime().toNanoOfDay()).with(ChronoField$.OFFSET_SECONDS, this.getOffset().getTotalSeconds());
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        OffsetDateTime end = OffsetDateTime$.MODULE$.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            end = end.withOffsetSameInstant(this.offset());
            return this.dateTime().until(end.dateTime(), unit);
        }
        return unit.between(this, end);
    }

    public ZonedDateTime atZoneSameInstant(ZoneId zone) {
        return ZonedDateTime$.MODULE$.ofInstant(this.dateTime(), this.offset(), zone);
    }

    public ZonedDateTime atZoneSimilarLocal(ZoneId zone) {
        return ZonedDateTime$.MODULE$.ofLocal(this.dateTime(), zone, this.offset());
    }

    public LocalDateTime toLocalDateTime() {
        return this.dateTime();
    }

    public LocalDate toLocalDate() {
        return this.dateTime().toLocalDate();
    }

    public LocalTime toLocalTime() {
        return this.dateTime().toLocalTime();
    }

    public OffsetTime toOffsetTime() {
        return OffsetTime$.MODULE$.of(this.dateTime().toLocalTime(), this.offset());
    }

    public ZonedDateTime toZonedDateTime() {
        return ZonedDateTime$.MODULE$.of(this.dateTime(), this.offset());
    }

    public Instant toInstant() {
        return this.dateTime().toInstant(this.offset());
    }

    public long toEpochSecond() {
        return this.dateTime().toEpochSecond(this.offset());
    }

    public int compare(OffsetDateTime other) {
        ZoneOffset zoneOffset = this.getOffset();
        ZoneOffset zoneOffset2 = other.getOffset();
        if (!(zoneOffset != null ? !((Object)zoneOffset).equals(zoneOffset2) : zoneOffset2 != null)) {
            return this.toLocalDateTime().compareTo(other.toLocalDateTime());
        }
        int cmp = Long.compare(this.toEpochSecond(), other.toEpochSecond());
        if (cmp == 0 && (cmp = this.toLocalTime().getNano() - other.toLocalTime().getNano()) == 0) {
            cmp = this.toLocalDateTime().compareTo(other.toLocalDateTime());
        }
        return cmp;
    }

    public int compareTo(OffsetDateTime other) {
        return this.compare(other);
    }

    public boolean isAfter(OffsetDateTime other) {
        long otherEpochSec;
        long thisEpochSec = this.toEpochSecond();
        return thisEpochSec > (otherEpochSec = other.toEpochSecond()) || thisEpochSec == otherEpochSec && this.toLocalTime().getNano() > other.toLocalTime().getNano();
    }

    public boolean isBefore(OffsetDateTime other) {
        long otherEpochSec;
        long thisEpochSec = this.toEpochSecond();
        return thisEpochSec < (otherEpochSec = other.toEpochSecond()) || thisEpochSec == otherEpochSec && this.toLocalTime().getNano() < other.toLocalTime().getNano();
    }

    public boolean isEqual(OffsetDateTime other) {
        return this.toEpochSecond() == other.toEpochSecond() && this.toLocalTime().getNano() == other.toLocalTime().getNano();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof OffsetDateTime)) return false;
        OffsetDateTime other = (OffsetDateTime)object;
        if (this == other) return true;
        LocalDateTime localDateTime = this.dateTime();
        LocalDateTime localDateTime2 = other.dateTime();
        if (localDateTime == null) {
            if (localDateTime2 != null) {
                return false;
            }
        } else if (!((Object)localDateTime).equals(localDateTime2)) return false;
        ZoneOffset zoneOffset = this.offset();
        ZoneOffset zoneOffset2 = other.offset();
        if (zoneOffset == null) {
            if (zoneOffset2 == null) return true;
            return false;
        } else {
            if (!((Object)zoneOffset).equals(zoneOffset2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return this.dateTime().hashCode() ^ this.offset().hashCode();
    }

    public String toString() {
        return new StringBuilder(0).append(this.dateTime().toString()).append(this.offset().toString()).toString();
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }
}

