/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.Instant$;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalDateTime$;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZoneOffset$;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatter$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.time.zone.ZoneRules;
import java.util.Comparator;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class OffsetDateTime$
implements Serializable {
    private OffsetDateTime MIN$lzy1;
    private boolean MINbitmap$1;
    private OffsetDateTime MAX$lzy1;
    private boolean MAXbitmap$1;
    private Comparator INSTANT_COMPARATOR$lzy1;
    private boolean INSTANT_COMPARATORbitmap$1;
    public static final OffsetDateTime$ MODULE$ = new OffsetDateTime$();

    private OffsetDateTime$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(OffsetDateTime$.class);
    }

    public OffsetDateTime MIN() {
        if (!this.MINbitmap$1) {
            this.MIN$lzy1 = LocalDateTime$.MODULE$.MIN().atOffset(ZoneOffset$.MODULE$.MAX());
            this.MINbitmap$1 = true;
        }
        return this.MIN$lzy1;
    }

    public OffsetDateTime MAX() {
        if (!this.MAXbitmap$1) {
            this.MAX$lzy1 = LocalDateTime$.MODULE$.MAX().atOffset(ZoneOffset$.MODULE$.MIN());
            this.MAXbitmap$1 = true;
        }
        return this.MAX$lzy1;
    }

    public Comparator<OffsetDateTime> timeLineOrder() {
        return this.INSTANT_COMPARATOR();
    }

    private Comparator<OffsetDateTime> INSTANT_COMPARATOR() {
        if (!this.INSTANT_COMPARATORbitmap$1) {
            this.INSTANT_COMPARATOR$lzy1 = new Comparator<OffsetDateTime>(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                }

                public int compare(OffsetDateTime datetime1, OffsetDateTime datetime2) {
                    int cmp = Long.compare(datetime1.toEpochSecond(), datetime2.toEpochSecond());
                    if (cmp == 0) {
                        cmp = Long.compare(datetime1.getNano(), datetime2.getNano());
                    }
                    return cmp;
                }
            };
            this.INSTANT_COMPARATORbitmap$1 = true;
        }
        return this.INSTANT_COMPARATOR$lzy1;
    }

    public OffsetDateTime now() {
        return this.now(Clock$.MODULE$.systemDefaultZone());
    }

    public OffsetDateTime now(ZoneId zone) {
        return this.now(Clock$.MODULE$.system(zone));
    }

    public OffsetDateTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        return this.ofInstant(now, clock.getZone().getRules().getOffset(now));
    }

    public OffsetDateTime of(LocalDate date, LocalTime time, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime$.MODULE$.of(date, time);
        return new OffsetDateTime(dt, offset);
    }

    public OffsetDateTime of(LocalDateTime dateTime, ZoneOffset offset) {
        return new OffsetDateTime(dateTime, offset);
    }

    public OffsetDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, ZoneOffset offset) {
        LocalDateTime dt = LocalDateTime$.MODULE$.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond);
        return new OffsetDateTime(dt, offset);
    }

    public OffsetDateTime ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        ZoneRules rules = zone.getRules();
        ZoneOffset offset = rules.getOffset(instant);
        LocalDateTime ldt = LocalDateTime$.MODULE$.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), offset);
        return new OffsetDateTime(ldt, offset);
    }

    public OffsetDateTime from(TemporalAccessor temporal) {
        OffsetDateTime offsetDateTime;
        TemporalAccessor temporalAccessor = temporal;
        if (temporalAccessor instanceof OffsetDateTime) {
            OffsetDateTime time = (OffsetDateTime)temporalAccessor;
            return time;
        }
        try {
            ZoneOffset offset = ZoneOffset$.MODULE$.from(temporal);
            try {
                LocalDateTime ldt = LocalDateTime$.MODULE$.from(temporal);
                offsetDateTime = this.of(ldt, offset);
            }
            catch (DateTimeException dateTimeException) {
                Instant instant = Instant$.MODULE$.from(temporal);
                offsetDateTime = this.ofInstant(instant, offset);
            }
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException(new StringBuilder(62).append("Unable to obtain OffsetDateTime from TemporalAccessor: ").append(temporal).append(", type ").append(temporal.getClass().getName()).toString());
        }
        return offsetDateTime;
    }

    public OffsetDateTime parse(CharSequence text) {
        return this.parse(text, DateTimeFormatter$.MODULE$.ISO_OFFSET_DATE_TIME());
    }

    public OffsetDateTime parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, new TemporalQuery<OffsetDateTime>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public OffsetDateTime queryFrom(TemporalAccessor temporal) {
                return OffsetDateTime$.MODULE$.from(temporal);
            }
        });
    }
}

