/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.Month;
import java.time.Month$;
import java.time.MonthDay$;
import java.time.Year$;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.chrono.Chronology$;
import java.time.chrono.IsoChronology;
import java.time.chrono.IsoChronology$;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.temporal.ValueRange$;
import java.util.Objects;
import scala.math.Ordered;

public final class MonthDay
implements TemporalAccessor,
TemporalAdjuster,
Ordered<MonthDay>,
Serializable {
    private static final long serialVersionUID = -939150713474957432L;
    private final int month;
    private final int day;

    public static MonthDay from(TemporalAccessor temporalAccessor) {
        return MonthDay$.MODULE$.from(temporalAccessor);
    }

    public static MonthDay now() {
        return MonthDay$.MODULE$.now();
    }

    public static MonthDay now(Clock clock) {
        return MonthDay$.MODULE$.now(clock);
    }

    public static MonthDay now(ZoneId zoneId) {
        return MonthDay$.MODULE$.now(zoneId);
    }

    public static MonthDay of(int n, int n2) {
        return MonthDay$.MODULE$.of(n, n2);
    }

    public static MonthDay of(Month month, int n) {
        return MonthDay$.MODULE$.of(month, n);
    }

    public static MonthDay parse(CharSequence charSequence) {
        return MonthDay$.MODULE$.parse(charSequence);
    }

    public static MonthDay parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return MonthDay$.MODULE$.parse(charSequence, dateTimeFormatter);
    }

    public MonthDay(int month, int day) {
        this.month = month;
        this.day = day;
        Ordered.$init$((Ordered)this);
    }

    private int month() {
        return this.month;
    }

    private int day() {
        return this.day;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField$.MONTH_OF_YEAR || field == ChronoField$.DAY_OF_MONTH;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField$.MONTH_OF_YEAR) {
            return field.range();
        }
        if (field == ChronoField$.DAY_OF_MONTH) {
            return ValueRange$.MODULE$.of(1L, this.getMonth().minLength(), this.getMonth().maxLength());
        }
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                return field.range();
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField field1;
            ChronoField chronoField = field1 = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.DAY_OF_MONTH;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.day();
            }
            ChronoField chronoField4 = ChronoField$.MONTH_OF_YEAR;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.month();
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.getFrom(this);
    }

    public int getMonthValue() {
        return this.month();
    }

    public Month getMonth() {
        return Month$.MODULE$.of(this.month());
    }

    public int getDayOfMonth() {
        return this.day();
    }

    public boolean isValidYear(int year) {
        return this.day() != 29 || this.month() != 2 || Year$.MODULE$.isLeap(year);
    }

    public MonthDay withMonth(int month) {
        return this.with(Month$.MODULE$.of(month));
    }

    public MonthDay with(Month month) {
        Objects.requireNonNull(month, "month");
        if (month.getValue() == this.month()) {
            return this;
        }
        int day = Math.min(this.day(), month.maxLength());
        return new MonthDay(month.getValue(), day);
    }

    public MonthDay withDayOfMonth(int dayOfMonth) {
        if (dayOfMonth == this.day()) {
            return this;
        }
        return MonthDay$.MODULE$.of(this.month(), dayOfMonth);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries$.MODULE$.chronology()) {
            return (R)IsoChronology$.MODULE$.INSTANCE();
        }
        if (query == TemporalQueries$.MODULE$.zoneId() || query == TemporalQueries$.MODULE$.precision()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        Temporal _temporal = temporal;
        Chronology chronology = Chronology$.MODULE$.from(_temporal);
        IsoChronology isoChronology = IsoChronology$.MODULE$.INSTANCE();
        if (chronology == null ? isoChronology != null : !((Object)chronology).equals(isoChronology)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        _temporal = _temporal.with(ChronoField$.MONTH_OF_YEAR, this.month());
        return _temporal.with(ChronoField$.DAY_OF_MONTH, Math.min(_temporal.range(ChronoField$.DAY_OF_MONTH).getMaximum(), (long)this.day()));
    }

    public LocalDate atYear(int year) {
        return LocalDate$.MODULE$.of(year, this.month(), this.isValidYear(year) ? this.day() : 28);
    }

    public int compare(MonthDay other) {
        int cmp = this.month() - other.month();
        if (cmp == 0) {
            cmp = this.day() - other.day();
        }
        return cmp;
    }

    public int compareTo(MonthDay other) {
        return this.compare(other);
    }

    public boolean isAfter(MonthDay other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(MonthDay other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof MonthDay) {
            MonthDay other = (MonthDay)object;
            return this == other || this.month() == other.month() && this.day() == other.day();
        }
        return false;
    }

    public int hashCode() {
        return (this.month() << 6) + this.day();
    }

    public String toString() {
        return new scala.collection.mutable.StringBuilder(10).append("--").append(this.month() < 10 ? "0" : "").append(this.month()).append(this.day() < 10 ? "-0" : "-").append(this.day()).toString();
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }
}

