/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.Month;
import java.time.Month$;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.chrono.Chronology$;
import java.time.chrono.IsoChronology;
import java.time.chrono.IsoChronology$;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class MonthDay$
implements Serializable {
    private DateTimeFormatter PARSER$lzy1;
    private boolean PARSERbitmap$1;
    public static final MonthDay$ MODULE$ = new MonthDay$();

    private MonthDay$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MonthDay$.class);
    }

    private DateTimeFormatter PARSER() {
        if (!this.PARSERbitmap$1) {
            this.PARSER$lzy1 = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField$.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField$.DAY_OF_MONTH, 2).toFormatter();
            this.PARSERbitmap$1 = true;
        }
        return this.PARSER$lzy1;
    }

    public MonthDay now() {
        return this.now(Clock$.MODULE$.systemDefaultZone());
    }

    public MonthDay now(ZoneId zone) {
        return this.now(Clock$.MODULE$.system(zone));
    }

    public MonthDay now(Clock clock) {
        LocalDate now = LocalDate$.MODULE$.now(clock);
        return this.of(now.getMonth(), now.getDayOfMonth());
    }

    public MonthDay of(Month month, int dayOfMonth) {
        Objects.requireNonNull(month, "month");
        ChronoField$.DAY_OF_MONTH.checkValidValue(dayOfMonth);
        if (dayOfMonth > month.maxLength()) {
            throw new DateTimeException(new StringBuilder(66).append("Illegal value for DayOfMonth field, value ").append(dayOfMonth).append(" is not valid for month ").append(month.name()).toString());
        }
        return new MonthDay(month.getValue(), dayOfMonth);
    }

    public MonthDay of(int month, int dayOfMonth) {
        return this.of(Month$.MODULE$.of(month), dayOfMonth);
    }

    public MonthDay from(TemporalAccessor temporal) {
        MonthDay monthDay;
        TemporalAccessor _temporal = temporal;
        TemporalAccessor temporalAccessor = _temporal;
        if (temporalAccessor instanceof MonthDay) {
            MonthDay day = (MonthDay)temporalAccessor;
            return day;
        }
        try {
            IsoChronology isoChronology = IsoChronology$.MODULE$.INSTANCE();
            Chronology chronology = Chronology$.MODULE$.from(_temporal);
            if (isoChronology == null ? chronology != null : !((Object)isoChronology).equals(chronology)) {
                _temporal = LocalDate$.MODULE$.from(_temporal);
            }
            monthDay = this.of(_temporal.get(ChronoField$.MONTH_OF_YEAR), _temporal.get(ChronoField$.DAY_OF_MONTH));
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException(new StringBuilder(56).append("Unable to obtain MonthDay from TemporalAccessor: ").append(_temporal).append(", type ").append(_temporal.getClass().getName()).toString());
        }
        return monthDay;
    }

    public MonthDay parse(CharSequence text) {
        return this.parse(text, this.PARSER());
    }

    public MonthDay parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, new TemporalQuery<MonthDay>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public MonthDay queryFrom(TemporalAccessor temporal) {
                return MonthDay$.MODULE$.from(temporal);
            }
        });
    }
}

