/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalDateTime$;
import java.time.LocalTime$;
import java.time.OffsetTime;
import java.time.OffsetTime$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;
import scala.math.Ordered;

public final class LocalTime
implements Temporal,
TemporalAdjuster,
Ordered<LocalTime>,
Serializable {
    private static final long serialVersionUID = 6414437269572265201L;
    private final int nano;
    private final byte hour;
    private final byte minute;
    private final byte second;

    public static int HOURS_PER_DAY() {
        return LocalTime$.MODULE$.HOURS_PER_DAY();
    }

    public static LocalTime MAX() {
        return LocalTime$.MODULE$.MAX();
    }

    public static long MICROS_PER_DAY() {
        return LocalTime$.MODULE$.MICROS_PER_DAY();
    }

    public static LocalTime MIDNIGHT() {
        return LocalTime$.MODULE$.MIDNIGHT();
    }

    public static long MILLIS_PER_DAY() {
        return LocalTime$.MODULE$.MILLIS_PER_DAY();
    }

    public static LocalTime MIN() {
        return LocalTime$.MODULE$.MIN();
    }

    public static int MINUTES_PER_DAY() {
        return LocalTime$.MODULE$.MINUTES_PER_DAY();
    }

    public static int MINUTES_PER_HOUR() {
        return LocalTime$.MODULE$.MINUTES_PER_HOUR();
    }

    public static long NANOS_PER_DAY() {
        return LocalTime$.MODULE$.NANOS_PER_DAY();
    }

    public static long NANOS_PER_HOUR() {
        return LocalTime$.MODULE$.NANOS_PER_HOUR();
    }

    public static long NANOS_PER_MINUTE() {
        return LocalTime$.MODULE$.NANOS_PER_MINUTE();
    }

    public static long NANOS_PER_SECOND() {
        return LocalTime$.MODULE$.NANOS_PER_SECOND();
    }

    public static LocalTime NOON() {
        return LocalTime$.MODULE$.NOON();
    }

    public static int SECONDS_PER_DAY() {
        return LocalTime$.MODULE$.SECONDS_PER_DAY();
    }

    public static int SECONDS_PER_HOUR() {
        return LocalTime$.MODULE$.SECONDS_PER_HOUR();
    }

    public static int SECONDS_PER_MINUTE() {
        return LocalTime$.MODULE$.SECONDS_PER_MINUTE();
    }

    public static LocalTime from(TemporalAccessor temporalAccessor) {
        return LocalTime$.MODULE$.from(temporalAccessor);
    }

    public static LocalTime now() {
        return LocalTime$.MODULE$.now();
    }

    public static LocalTime now(Clock clock) {
        return LocalTime$.MODULE$.now(clock);
    }

    public static LocalTime now(ZoneId zoneId) {
        return LocalTime$.MODULE$.now(zoneId);
    }

    public static LocalTime of(int n, int n2) {
        return LocalTime$.MODULE$.of(n, n2);
    }

    public static LocalTime of(int n, int n2, int n3) {
        return LocalTime$.MODULE$.of(n, n2, n3);
    }

    public static LocalTime of(int n, int n2, int n3, int n4) {
        return LocalTime$.MODULE$.of(n, n2, n3, n4);
    }

    public static LocalTime ofNanoOfDay(long l) {
        return LocalTime$.MODULE$.ofNanoOfDay(l);
    }

    public static LocalTime ofSecondOfDay(long l) {
        return LocalTime$.MODULE$.ofSecondOfDay(l);
    }

    public static LocalTime ofSecondOfDay(long l, int n) {
        return LocalTime$.MODULE$.ofSecondOfDay(l, n);
    }

    public static LocalTime parse(CharSequence charSequence) {
        return LocalTime$.MODULE$.parse(charSequence);
    }

    public static LocalTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return LocalTime$.MODULE$.parse(charSequence, dateTimeFormatter);
    }

    public LocalTime(int _hour, int _minute, int _second, int nano) {
        this.nano = nano;
        Ordered.$init$((Ordered)this);
        this.hour = (byte)_hour;
        this.minute = (byte)_minute;
        this.second = (byte)_second;
    }

    private int nano() {
        return this.nano;
    }

    private byte hour() {
        return this.hour;
    }

    private byte minute() {
        return this.minute;
    }

    private byte second() {
        return this.second;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field.isTimeBased();
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit.isTimeBased();
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        return TemporalAccessor.range$(this, field);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            return (int)this.get0(field);
        }
        return TemporalAccessor.get$(this, field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField$.NANO_OF_DAY) {
                return this.toNanoOfDay();
            }
            if (field == ChronoField$.MICRO_OF_DAY) {
                return this.toNanoOfDay() / 1000L;
            }
            return this.get0(field);
        }
        return field.getFrom(this);
    }

    private long get0(TemporalField field) {
        ChronoField chronoField = (ChronoField)field;
        ChronoField chronoField2 = ChronoField$.NANO_OF_SECOND;
        ChronoField chronoField3 = chronoField;
        if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
            return this.nano();
        }
        ChronoField chronoField4 = ChronoField$.NANO_OF_DAY;
        ChronoField chronoField5 = chronoField;
        if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
            throw new DateTimeException(new StringBuilder(28).append("Field too large for an int: ").append(field).toString());
        }
        ChronoField chronoField6 = ChronoField$.MICRO_OF_SECOND;
        ChronoField chronoField7 = chronoField;
        if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
            return (long)this.nano() / 1000L;
        }
        ChronoField chronoField8 = ChronoField$.MICRO_OF_DAY;
        ChronoField chronoField9 = chronoField;
        if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
            throw new DateTimeException(new StringBuilder(28).append("Field too large for an int: ").append(field).toString());
        }
        ChronoField chronoField10 = ChronoField$.MILLI_OF_SECOND;
        ChronoField chronoField11 = chronoField;
        if (!(chronoField10 != null ? !chronoField10.equals(chronoField11) : chronoField11 != null)) {
            return (long)this.nano() / 1000000L;
        }
        ChronoField chronoField12 = ChronoField$.MILLI_OF_DAY;
        ChronoField chronoField13 = chronoField;
        if (!(chronoField12 != null ? !chronoField12.equals(chronoField13) : chronoField13 != null)) {
            return this.toNanoOfDay() / 1000000L;
        }
        ChronoField chronoField14 = ChronoField$.SECOND_OF_MINUTE;
        ChronoField chronoField15 = chronoField;
        if (!(chronoField14 != null ? !chronoField14.equals(chronoField15) : chronoField15 != null)) {
            return this.second();
        }
        ChronoField chronoField16 = ChronoField$.SECOND_OF_DAY;
        ChronoField chronoField17 = chronoField;
        if (!(chronoField16 != null ? !chronoField16.equals(chronoField17) : chronoField17 != null)) {
            return this.toSecondOfDay();
        }
        ChronoField chronoField18 = ChronoField$.MINUTE_OF_HOUR;
        ChronoField chronoField19 = chronoField;
        if (!(chronoField18 != null ? !chronoField18.equals(chronoField19) : chronoField19 != null)) {
            return this.minute();
        }
        ChronoField chronoField20 = ChronoField$.MINUTE_OF_DAY;
        ChronoField chronoField21 = chronoField;
        if (!(chronoField20 != null ? !chronoField20.equals(chronoField21) : chronoField21 != null)) {
            return (long)this.hour() * 60L + (long)this.minute();
        }
        ChronoField chronoField22 = ChronoField$.HOUR_OF_AMPM;
        ChronoField chronoField23 = chronoField;
        if (!(chronoField22 != null ? !chronoField22.equals(chronoField23) : chronoField23 != null)) {
            return (long)this.hour() % 12L;
        }
        ChronoField chronoField24 = ChronoField$.CLOCK_HOUR_OF_AMPM;
        ChronoField chronoField25 = chronoField;
        if (!(chronoField24 != null ? !chronoField24.equals(chronoField25) : chronoField25 != null)) {
            long ham = (long)this.hour() % 12L;
            if (ham % 12L == 0L) {
                return 12L;
            }
            return ham;
        }
        ChronoField chronoField26 = ChronoField$.HOUR_OF_DAY;
        ChronoField chronoField27 = chronoField;
        if (!(chronoField26 != null ? !chronoField26.equals(chronoField27) : chronoField27 != null)) {
            return this.hour();
        }
        ChronoField chronoField28 = ChronoField$.CLOCK_HOUR_OF_DAY;
        ChronoField chronoField29 = chronoField;
        if (!(chronoField28 != null ? !chronoField28.equals(chronoField29) : chronoField29 != null)) {
            if (this.hour() == 0) {
                return 24L;
            }
            return this.hour();
        }
        ChronoField chronoField30 = ChronoField$.AMPM_OF_DAY;
        ChronoField chronoField31 = chronoField;
        if (!(chronoField30 != null ? !chronoField30.equals(chronoField31) : chronoField31 != null)) {
            return (long)this.hour() / 12L;
        }
        throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
    }

    public int getHour() {
        return this.hour();
    }

    public int getMinute() {
        return this.minute();
    }

    public int getSecond() {
        return this.second();
    }

    public int getNano() {
        return this.nano();
    }

    @Override
    public LocalTime with(TemporalAdjuster adjuster) {
        TemporalAdjuster temporalAdjuster = adjuster;
        if (temporalAdjuster instanceof LocalTime) {
            LocalTime time = (LocalTime)temporalAdjuster;
            return time;
        }
        return (LocalTime)adjuster.adjustInto(this);
    }

    @Override
    public LocalTime with(TemporalField field, long newValue) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f = (ChronoField)temporalField;
            f.checkValidValue(newValue);
            ChronoField chronoField = f;
            ChronoField chronoField2 = ChronoField$.NANO_OF_SECOND;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.withNano((int)newValue);
            }
            ChronoField chronoField4 = ChronoField$.NANO_OF_DAY;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return LocalTime$.MODULE$.ofNanoOfDay(newValue);
            }
            ChronoField chronoField6 = ChronoField$.MICRO_OF_SECOND;
            ChronoField chronoField7 = chronoField;
            if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                return this.withNano((int)newValue * 1000);
            }
            ChronoField chronoField8 = ChronoField$.MICRO_OF_DAY;
            ChronoField chronoField9 = chronoField;
            if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                return LocalTime$.MODULE$.ofNanoOfDay(newValue * 1000L);
            }
            ChronoField chronoField10 = ChronoField$.MILLI_OF_SECOND;
            ChronoField chronoField11 = chronoField;
            if (!(chronoField10 != null ? !chronoField10.equals(chronoField11) : chronoField11 != null)) {
                return this.withNano((int)newValue * 1000000);
            }
            ChronoField chronoField12 = ChronoField$.MILLI_OF_DAY;
            ChronoField chronoField13 = chronoField;
            if (!(chronoField12 != null ? !chronoField12.equals(chronoField13) : chronoField13 != null)) {
                return LocalTime$.MODULE$.ofNanoOfDay(newValue * 1000000L);
            }
            ChronoField chronoField14 = ChronoField$.SECOND_OF_MINUTE;
            ChronoField chronoField15 = chronoField;
            if (!(chronoField14 != null ? !chronoField14.equals(chronoField15) : chronoField15 != null)) {
                return this.withSecond((int)newValue);
            }
            ChronoField chronoField16 = ChronoField$.SECOND_OF_DAY;
            ChronoField chronoField17 = chronoField;
            if (!(chronoField16 != null ? !chronoField16.equals(chronoField17) : chronoField17 != null)) {
                return this.plusSeconds(newValue - (long)this.toSecondOfDay());
            }
            ChronoField chronoField18 = ChronoField$.MINUTE_OF_HOUR;
            ChronoField chronoField19 = chronoField;
            if (!(chronoField18 != null ? !chronoField18.equals(chronoField19) : chronoField19 != null)) {
                return this.withMinute((int)newValue);
            }
            ChronoField chronoField20 = ChronoField$.MINUTE_OF_DAY;
            ChronoField chronoField21 = chronoField;
            if (!(chronoField20 != null ? !chronoField20.equals(chronoField21) : chronoField21 != null)) {
                return this.plusMinutes(newValue - (long)(this.hour() * 60 + this.minute()));
            }
            ChronoField chronoField22 = ChronoField$.HOUR_OF_AMPM;
            ChronoField chronoField23 = chronoField;
            if (!(chronoField22 != null ? !chronoField22.equals(chronoField23) : chronoField23 != null)) {
                return this.plusHours(newValue - (long)(this.hour() % 12));
            }
            ChronoField chronoField24 = ChronoField$.CLOCK_HOUR_OF_AMPM;
            ChronoField chronoField25 = chronoField;
            if (!(chronoField24 != null ? !chronoField24.equals(chronoField25) : chronoField25 != null)) {
                return this.plusHours((newValue == 12L ? 0L : newValue) - (long)(this.hour() % 12));
            }
            ChronoField chronoField26 = ChronoField$.HOUR_OF_DAY;
            ChronoField chronoField27 = chronoField;
            if (!(chronoField26 != null ? !chronoField26.equals(chronoField27) : chronoField27 != null)) {
                return this.withHour((int)newValue);
            }
            ChronoField chronoField28 = ChronoField$.CLOCK_HOUR_OF_DAY;
            ChronoField chronoField29 = chronoField;
            if (!(chronoField28 != null ? !chronoField28.equals(chronoField29) : chronoField29 != null)) {
                return this.withHour((int)(newValue == 24L ? 0L : newValue));
            }
            ChronoField chronoField30 = ChronoField$.AMPM_OF_DAY;
            ChronoField chronoField31 = chronoField;
            if (!(chronoField30 != null ? !chronoField30.equals(chronoField31) : chronoField31 != null)) {
                return this.plusHours((newValue - (long)(this.hour() / 12)) * 12L);
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.adjustInto(this, newValue);
    }

    public LocalTime withHour(int hour) {
        if (this.hour() == hour) {
            return this;
        }
        ChronoField$.HOUR_OF_DAY.checkValidValue(hour);
        return LocalTime$.MODULE$.java$time$LocalTime$$$create(hour, this.minute(), this.second(), this.nano());
    }

    public LocalTime withMinute(int minute) {
        if (this.minute() == minute) {
            return this;
        }
        ChronoField$.MINUTE_OF_HOUR.checkValidValue(minute);
        return LocalTime$.MODULE$.java$time$LocalTime$$$create(this.hour(), minute, this.second(), this.nano());
    }

    public LocalTime withSecond(int second) {
        if (this.second() == second) {
            return this;
        }
        ChronoField$.SECOND_OF_MINUTE.checkValidValue(second);
        return LocalTime$.MODULE$.java$time$LocalTime$$$create(this.hour(), this.minute(), second, this.nano());
    }

    public LocalTime withNano(int nanoOfSecond) {
        if (this.nano() == nanoOfSecond) {
            return this;
        }
        ChronoField$.NANO_OF_SECOND.checkValidValue(nanoOfSecond);
        return LocalTime$.MODULE$.java$time$LocalTime$$$create(this.hour(), this.minute(), this.second(), nanoOfSecond);
    }

    public LocalTime truncatedTo(TemporalUnit unit) {
        if (unit == ChronoUnit$.NANOS) {
            return this;
        }
        Duration unitDur = unit.getDuration();
        if (unitDur.getSeconds() > 86400L) {
            throw new DateTimeException("Unit is too large to be used for truncation");
        }
        long dur = unitDur.toNanos();
        if (86400000000000L % dur != 0L) {
            throw new DateTimeException("Unit must divide into a standard day without remainder");
        }
        long nod = this.toNanoOfDay();
        return LocalTime$.MODULE$.ofNanoOfDay(nod / dur * dur);
    }

    @Override
    public LocalTime plus(TemporalAmount amount) {
        return (LocalTime)amount.addTo(this);
    }

    @Override
    public LocalTime plus(long amountToAdd, TemporalUnit unit) {
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit f;
            ChronoUnit chronoUnit = f = (ChronoUnit)temporalUnit;
            ChronoUnit chronoUnit2 = ChronoUnit$.NANOS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.plusNanos(amountToAdd);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.MICROS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return this.plusNanos(amountToAdd % 86400000000L * 1000L);
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MILLIS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return this.plusNanos(amountToAdd % 86400000L * 1000000L);
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.SECONDS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.plusSeconds(amountToAdd);
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.MINUTES;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return this.plusMinutes(amountToAdd);
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.HOURS;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return this.plusHours(amountToAdd);
            }
            ChronoUnit chronoUnit14 = ChronoUnit$.HALF_DAYS;
            ChronoUnit chronoUnit15 = chronoUnit;
            if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                return this.plusHours(amountToAdd % 2L * 12L);
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.addTo(this, amountToAdd);
    }

    public LocalTime plusHours(long hoursToAdd) {
        if (hoursToAdd == 0L) {
            return this;
        }
        int newHour = ((int)(hoursToAdd % 24L) + this.hour() + 24) % 24;
        return LocalTime$.MODULE$.java$time$LocalTime$$$create(newHour, this.minute(), this.second(), this.nano());
    }

    public LocalTime plusMinutes(long minutesToAdd) {
        int newMofd;
        if (minutesToAdd == 0L) {
            return this;
        }
        int mofd = this.hour() * 60 + this.minute();
        if (mofd == (newMofd = ((int)(minutesToAdd % 1440L) + mofd + 1440) % 1440)) {
            return this;
        }
        int newHour = newMofd / 60;
        int newMinute = newMofd % 60;
        return LocalTime$.MODULE$.java$time$LocalTime$$$create(newHour, newMinute, this.second(), this.nano());
    }

    public LocalTime plusSeconds(long secondstoAdd) {
        int newSofd;
        if (secondstoAdd == 0L) {
            return this;
        }
        int sofd = this.hour() * 3600 + this.minute() * 60 + this.second();
        if (sofd == (newSofd = ((int)(secondstoAdd % 86400L) + sofd + 86400) % 86400)) {
            return this;
        }
        int newHour = newSofd / 3600;
        int newMinute = newSofd / 60 % 60;
        int newSecond = newSofd % 60;
        return LocalTime$.MODULE$.java$time$LocalTime$$$create(newHour, newMinute, newSecond, this.nano());
    }

    public LocalTime plusNanos(long nanosToAdd) {
        long newNofd;
        if (nanosToAdd == 0L) {
            return this;
        }
        long nofd = this.toNanoOfDay();
        if (nofd == (newNofd = (nanosToAdd % 86400000000000L + nofd + 86400000000000L) % 86400000000000L)) {
            return this;
        }
        int newHour = (int)(newNofd / 3600000000000L);
        int newMinute = (int)(newNofd / 60000000000L % 60L);
        int newSecond = (int)(newNofd / 1000000000L % 60L);
        int newNano = (int)(newNofd % 1000000000L);
        return LocalTime$.MODULE$.java$time$LocalTime$$$create(newHour, newMinute, newSecond, newNano);
    }

    @Override
    public LocalTime minus(TemporalAmount amount) {
        return (LocalTime)amount.subtractFrom(this);
    }

    @Override
    public LocalTime minus(long amountToSubtract, TemporalUnit unit) {
        if (amountToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, unit).plus(1L, unit);
        }
        return this.plus(-amountToSubtract, unit);
    }

    public LocalTime minusHours(long hoursToSubtract) {
        return this.plusHours(-(hoursToSubtract % 24L));
    }

    public LocalTime minusMinutes(long minutesToSubtract) {
        return this.plusMinutes(-(minutesToSubtract % 1440L));
    }

    public LocalTime minusSeconds(long secondsToSubtract) {
        return this.plusSeconds(-(secondsToSubtract % 86400L));
    }

    public LocalTime minusNanos(long nanosToSubtract) {
        return this.plusNanos(-(nanosToSubtract % 86400000000000L));
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        block15: {
            block6: {
                TemporalQuery<R> temporalQuery;
                TemporalQuery<LocalDate> temporalQuery2;
                block14: {
                    TemporalQuery<R> temporalQuery3;
                    block13: {
                        TemporalQuery<R> temporalQuery4;
                        TemporalQuery<ZoneOffset> temporalQuery5;
                        block12: {
                            block11: {
                                TemporalQuery<R> temporalQuery6;
                                TemporalQuery<ZoneId> temporalQuery7;
                                block10: {
                                    block9: {
                                        TemporalQuery<R> temporalQuery8;
                                        TemporalQuery<ZoneId> temporalQuery9;
                                        block8: {
                                            block7: {
                                                TemporalQuery<R> temporalQuery10;
                                                TemporalQuery<Chronology> temporalQuery11;
                                                block5: {
                                                    temporalQuery3 = query;
                                                    TemporalQuery<TemporalUnit> temporalQuery12 = TemporalQueries$.MODULE$.precision();
                                                    TemporalQuery<R> temporalQuery13 = temporalQuery3;
                                                    if (!(temporalQuery12 != null ? !temporalQuery12.equals(temporalQuery13) : temporalQuery13 != null)) {
                                                        return (R)ChronoUnit$.NANOS;
                                                    }
                                                    TemporalQuery<LocalTime> temporalQuery14 = TemporalQueries$.MODULE$.localTime();
                                                    TemporalQuery<R> temporalQuery15 = temporalQuery3;
                                                    if (!(temporalQuery14 != null ? !temporalQuery14.equals(temporalQuery15) : temporalQuery15 != null)) {
                                                        return (R)this;
                                                    }
                                                    temporalQuery11 = TemporalQueries$.MODULE$.chronology();
                                                    temporalQuery10 = temporalQuery3;
                                                    if (temporalQuery11 != null) break block5;
                                                    if (temporalQuery10 == null) break block6;
                                                    break block7;
                                                }
                                                if (temporalQuery11.equals(temporalQuery10)) break block6;
                                            }
                                            temporalQuery9 = TemporalQueries$.MODULE$.zoneId();
                                            temporalQuery8 = temporalQuery3;
                                            if (temporalQuery9 != null) break block8;
                                            if (temporalQuery8 == null) break block6;
                                            break block9;
                                        }
                                        if (temporalQuery9.equals(temporalQuery8)) break block6;
                                    }
                                    temporalQuery7 = TemporalQueries$.MODULE$.zone();
                                    temporalQuery6 = temporalQuery3;
                                    if (temporalQuery7 != null) break block10;
                                    if (temporalQuery6 == null) break block6;
                                    break block11;
                                }
                                if (temporalQuery7.equals(temporalQuery6)) break block6;
                            }
                            temporalQuery5 = TemporalQueries$.MODULE$.offset();
                            temporalQuery4 = temporalQuery3;
                            if (temporalQuery5 != null) break block12;
                            if (temporalQuery4 == null) break block6;
                            break block13;
                        }
                        if (temporalQuery5.equals(temporalQuery4)) break block6;
                    }
                    temporalQuery2 = TemporalQueries$.MODULE$.localDate();
                    temporalQuery = temporalQuery3;
                    if (temporalQuery2 != null) break block14;
                    if (temporalQuery == null) break block6;
                    break block15;
                }
                if (!temporalQuery2.equals(temporalQuery)) break block15;
            }
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField$.NANO_OF_DAY, this.toNanoOfDay());
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        LocalTime end = LocalTime$.MODULE$.from(endExclusive);
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit u = (ChronoUnit)temporalUnit;
            long nanosUntil = end.toNanoOfDay() - this.toNanoOfDay();
            ChronoUnit chronoUnit = u;
            ChronoUnit chronoUnit2 = ChronoUnit$.NANOS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return nanosUntil;
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.MICROS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return nanosUntil / 1000L;
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MILLIS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return nanosUntil / 1000000L;
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.SECONDS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return nanosUntil / 1000000000L;
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.MINUTES;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return nanosUntil / 60000000000L;
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.HOURS;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return nanosUntil / 3600000000000L;
            }
            ChronoUnit chronoUnit14 = ChronoUnit$.HALF_DAYS;
            ChronoUnit chronoUnit15 = chronoUnit;
            if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                return nanosUntil / 43200000000000L;
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.between(this, end);
    }

    public LocalDateTime atDate(LocalDate date) {
        return LocalDateTime$.MODULE$.of(date, this);
    }

    public OffsetTime atOffset(ZoneOffset offset) {
        return OffsetTime$.MODULE$.of(this, offset);
    }

    public int toSecondOfDay() {
        int total = this.hour() * 3600;
        total += this.minute() * 60;
        return total += this.second();
    }

    public long toNanoOfDay() {
        long total = (long)this.hour() * 3600000000000L;
        total += (long)this.minute() * 60000000000L;
        total += (long)this.second() * 1000000000L;
        return total += (long)this.nano();
    }

    public int compare(LocalTime other) {
        int cmp = Integer.compare(this.hour(), other.hour());
        if (cmp == 0 && (cmp = Integer.compare(this.minute(), other.minute())) == 0 && (cmp = Integer.compare(this.second(), other.second())) == 0) {
            cmp = Integer.compare(this.nano(), other.nano());
        }
        return cmp;
    }

    public int compareTo(LocalTime other) {
        return this.compare(other);
    }

    public boolean isAfter(LocalTime other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(LocalTime other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof LocalTime) {
            LocalTime other = (LocalTime)object;
            return this == other || this.hour() == other.hour() && this.minute() == other.minute() && this.second() == other.second() && this.nano() == other.nano();
        }
        return false;
    }

    public int hashCode() {
        long nod = this.toNanoOfDay();
        return (int)(nod ^ nod >>> 32);
    }

    public String toString() {
        scala.collection.mutable.StringBuilder buf = new scala.collection.mutable.StringBuilder(18);
        byte hourValue = this.hour();
        byte minuteValue = this.minute();
        byte secondValue = this.second();
        int nanoValue = this.nano();
        buf.append(hourValue < 10 ? "0" : "").append((int)hourValue).append(minuteValue < 10 ? ":0" : ":").append((int)minuteValue);
        if (secondValue > 0 || nanoValue > 0) {
            buf.append(secondValue < 10 ? ":0" : ":").append((int)secondValue);
            if (nanoValue > 0) {
                buf.append('.');
                if (nanoValue % 1000000 == 0) {
                    buf.append(Integer.toString(nanoValue / 1000000 + 1000).substring(1));
                } else if (nanoValue % 1000 == 0) {
                    buf.append(Integer.toString(nanoValue / 1000 + 1000000).substring(1));
                } else {
                    buf.append(Integer.toString(nanoValue + 1000000000).substring(1));
                }
            }
        }
        return buf.toString();
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }
}

