/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatter$;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class LocalTime$
implements Serializable {
    private LocalTime[] HOURS$lzy1;
    private boolean HOURSbitmap$1;
    private LocalTime MIN$lzy1;
    private boolean MINbitmap$1;
    private LocalTime MAX$lzy1;
    private boolean MAXbitmap$1;
    private LocalTime MIDNIGHT$lzy1;
    private boolean MIDNIGHTbitmap$1;
    private LocalTime NOON$lzy1;
    private boolean NOONbitmap$1;
    public static final LocalTime$ MODULE$ = new LocalTime$();

    private LocalTime$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LocalTime$.class);
    }

    /*
     * WARNING - void declaration
     */
    private LocalTime[] HOURS() {
        if (!this.HOURSbitmap$1) {
            void var1_1;
            LocalTime[] hours = new LocalTime[24];
            for (int i = 0; i < hours.length; ++i) {
                hours[i] = new LocalTime(i, 0, 0, 0);
            }
            this.HOURS$lzy1 = var1_1;
            this.HOURSbitmap$1 = true;
        }
        return this.HOURS$lzy1;
    }

    public LocalTime MIN() {
        if (!this.MINbitmap$1) {
            this.MIN$lzy1 = this.HOURS()[0];
            this.MINbitmap$1 = true;
        }
        return this.MIN$lzy1;
    }

    public LocalTime MAX() {
        if (!this.MAXbitmap$1) {
            this.MAX$lzy1 = new LocalTime(23, 59, 59, 999999999);
            this.MAXbitmap$1 = true;
        }
        return this.MAX$lzy1;
    }

    public LocalTime MIDNIGHT() {
        if (!this.MIDNIGHTbitmap$1) {
            this.MIDNIGHT$lzy1 = this.HOURS()[0];
            this.MIDNIGHTbitmap$1 = true;
        }
        return this.MIDNIGHT$lzy1;
    }

    public LocalTime NOON() {
        if (!this.NOONbitmap$1) {
            this.NOON$lzy1 = this.HOURS()[12];
            this.NOONbitmap$1 = true;
        }
        return this.NOON$lzy1;
    }

    public final int HOURS_PER_DAY() {
        return 24;
    }

    public final int MINUTES_PER_HOUR() {
        return 60;
    }

    public final int MINUTES_PER_DAY() {
        return 1440;
    }

    public final int SECONDS_PER_MINUTE() {
        return 60;
    }

    public final int SECONDS_PER_HOUR() {
        return 3600;
    }

    public final int SECONDS_PER_DAY() {
        return 86400;
    }

    public final long MILLIS_PER_DAY() {
        return 86400000L;
    }

    public final long MICROS_PER_DAY() {
        return 86400000000L;
    }

    public final long NANOS_PER_SECOND() {
        return 1000000000L;
    }

    public final long NANOS_PER_MINUTE() {
        return 60000000000L;
    }

    public final long NANOS_PER_HOUR() {
        return 3600000000000L;
    }

    public final long NANOS_PER_DAY() {
        return 86400000000000L;
    }

    public LocalTime now() {
        return this.now(Clock$.MODULE$.systemDefaultZone());
    }

    public LocalTime now(ZoneId zone) {
        return this.now(Clock$.MODULE$.system(zone));
    }

    public LocalTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        ZoneOffset offset = clock.getZone().getRules().getOffset(now);
        long secsOfDay = now.getEpochSecond() % 86400L;
        secsOfDay = (secsOfDay + (long)offset.getTotalSeconds()) % 86400L;
        if (secsOfDay < 0L) {
            secsOfDay += 86400L;
        }
        return this.ofSecondOfDay(secsOfDay, now.getNano());
    }

    public LocalTime of(int hour, int minute) {
        ChronoField$.HOUR_OF_DAY.checkValidValue(hour);
        if (minute == 0) {
            return this.HOURS()[hour];
        }
        ChronoField$.MINUTE_OF_HOUR.checkValidValue(minute);
        return new LocalTime(hour, minute, 0, 0);
    }

    public LocalTime of(int hour, int minute, int second) {
        ChronoField$.HOUR_OF_DAY.checkValidValue(hour);
        if ((minute | second) == 0) {
            return this.HOURS()[hour];
        }
        ChronoField$.MINUTE_OF_HOUR.checkValidValue(minute);
        ChronoField$.SECOND_OF_MINUTE.checkValidValue(second);
        return new LocalTime(hour, minute, second, 0);
    }

    public LocalTime of(int hour, int minute, int second, int nanoOfSecond) {
        ChronoField$.HOUR_OF_DAY.checkValidValue(hour);
        ChronoField$.MINUTE_OF_HOUR.checkValidValue(minute);
        ChronoField$.SECOND_OF_MINUTE.checkValidValue(second);
        ChronoField$.NANO_OF_SECOND.checkValidValue(nanoOfSecond);
        return this.java$time$LocalTime$$$create(hour, minute, second, nanoOfSecond);
    }

    public LocalTime ofSecondOfDay(long secondOfDay) {
        long _secondOfDay = secondOfDay;
        ChronoField$.SECOND_OF_DAY.checkValidValue(_secondOfDay);
        int hours = (int)(_secondOfDay / 3600L);
        int minutes = (int)((_secondOfDay -= (long)(hours * 3600)) / 60L);
        return this.java$time$LocalTime$$$create(hours, minutes, (int)(_secondOfDay -= (long)(minutes * 60)), 0);
    }

    public LocalTime ofSecondOfDay(long secondOfDay, int nanoOfSecond) {
        long _secondOfDay = secondOfDay;
        ChronoField$.SECOND_OF_DAY.checkValidValue(_secondOfDay);
        ChronoField$.NANO_OF_SECOND.checkValidValue(nanoOfSecond);
        int hours = (int)(_secondOfDay / 3600L);
        int minutes = (int)((_secondOfDay -= (long)(hours * 3600)) / 60L);
        return this.java$time$LocalTime$$$create(hours, minutes, (int)(_secondOfDay -= (long)(minutes * 60)), nanoOfSecond);
    }

    public LocalTime ofNanoOfDay(long nanoOfDay) {
        long _nanoOfDay = nanoOfDay;
        ChronoField$.NANO_OF_DAY.checkValidValue(_nanoOfDay);
        int hours = (int)(_nanoOfDay / 3600000000000L);
        int minutes = (int)((_nanoOfDay -= (long)hours * 3600000000000L) / 60000000000L);
        int seconds = (int)((_nanoOfDay -= (long)minutes * 60000000000L) / 1000000000L);
        return this.java$time$LocalTime$$$create(hours, minutes, seconds, (int)(_nanoOfDay -= (long)seconds * 1000000000L));
    }

    public LocalTime from(TemporalAccessor temporal) {
        LocalTime time = temporal.query(TemporalQueries$.MODULE$.localTime());
        if (time == null) {
            throw new DateTimeException(new StringBuilder(57).append("Unable to obtain LocalTime from TemporalAccessor: ").append(temporal).append(", type ").append(temporal.getClass().getName()).toString());
        }
        return time;
    }

    public LocalTime parse(CharSequence text) {
        return this.parse(text, DateTimeFormatter$.MODULE$.ISO_LOCAL_TIME());
    }

    public LocalTime parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, new TemporalQuery<LocalTime>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public LocalTime queryFrom(TemporalAccessor temporal) {
                return LocalTime$.MODULE$.from(temporal);
            }
        });
    }

    public LocalTime java$time$LocalTime$$$create(int hour, int minute, int second, int nanoOfSecond) {
        if ((minute | second | nanoOfSecond) == 0) {
            return this.HOURS()[hour];
        }
        return new LocalTime(hour, minute, second, nanoOfSecond);
    }
}

