/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime$;
import java.time.LocalTime;
import java.time.LocalTime$;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetDateTime$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.ZonedDateTime$;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import scala.math.Ordered;

public final class LocalDateTime
extends ChronoLocalDateTime<LocalDate>
implements Serializable {
    private static final long serialVersionUID = 6207766400415563566L;
    private final LocalDate date;
    private final LocalTime time;

    public static LocalDateTime MAX() {
        return LocalDateTime$.MODULE$.MAX();
    }

    public static LocalDateTime MIN() {
        return LocalDateTime$.MODULE$.MIN();
    }

    public static LocalDateTime from(TemporalAccessor temporalAccessor) {
        return LocalDateTime$.MODULE$.from(temporalAccessor);
    }

    public static LocalDateTime now() {
        return LocalDateTime$.MODULE$.now();
    }

    public static LocalDateTime now(Clock clock) {
        return LocalDateTime$.MODULE$.now(clock);
    }

    public static LocalDateTime now(ZoneId zoneId) {
        return LocalDateTime$.MODULE$.now(zoneId);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5) {
        return LocalDateTime$.MODULE$.of(n, n2, n3, n4, n5);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5, int n6) {
        return LocalDateTime$.MODULE$.of(n, n2, n3, n4, n5, n6);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return LocalDateTime$.MODULE$.of(n, n2, n3, n4, n5, n6, n7);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4) {
        return LocalDateTime$.MODULE$.of(n, month, n2, n3, n4);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4, int n5) {
        return LocalDateTime$.MODULE$.of(n, month, n2, n3, n4, n5);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4, int n5, int n6) {
        return LocalDateTime$.MODULE$.of(n, month, n2, n3, n4, n5, n6);
    }

    public static LocalDateTime of(LocalDate localDate, LocalTime localTime) {
        return LocalDateTime$.MODULE$.of(localDate, localTime);
    }

    public static LocalDateTime ofEpochSecond(long l, int n, ZoneOffset zoneOffset) {
        return LocalDateTime$.MODULE$.ofEpochSecond(l, n, zoneOffset);
    }

    public static LocalDateTime ofInstant(Instant instant, ZoneId zoneId) {
        return LocalDateTime$.MODULE$.ofInstant(instant, zoneId);
    }

    public static LocalDateTime parse(CharSequence charSequence) {
        return LocalDateTime$.MODULE$.parse(charSequence);
    }

    public static LocalDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return LocalDateTime$.MODULE$.parse(charSequence, dateTimeFormatter);
    }

    public LocalDateTime(LocalDate date, LocalTime time) {
        this.date = date;
        this.time = time;
    }

    private LocalDate date() {
        return this.date;
    }

    private LocalTime time() {
        return this.time;
    }

    private LocalDateTime with(LocalDate newDate, LocalTime newTime) {
        if (this.date() == newDate && this.time() == newTime) {
            return this;
        }
        return new LocalDateTime(newDate, newTime);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            return field.isDateBased() || field.isTimeBased();
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            return unit.isDateBased() || unit.isTimeBased();
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            if (field.isTimeBased()) {
                return this.time().range(field);
            }
            return this.date().range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            if (field.isTimeBased()) {
                return this.time().get(field);
            }
            return this.date().get(field);
        }
        return TemporalAccessor.get$(this, field);
    }

    @Override
    public long getLong(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            if (field.isTimeBased()) {
                return this.time().getLong(field);
            }
            return this.date().getLong(field);
        }
        return field.getFrom(this);
    }

    public int getYear() {
        return this.date().getYear();
    }

    public int getMonthValue() {
        return this.date().getMonthValue();
    }

    public Month getMonth() {
        return this.date().getMonth();
    }

    public int getDayOfMonth() {
        return this.date().getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.date().getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.date().getDayOfWeek();
    }

    public int getHour() {
        return this.time().getHour();
    }

    public int getMinute() {
        return this.time().getMinute();
    }

    public int getSecond() {
        return this.time().getSecond();
    }

    public int getNano() {
        return this.time().getNano();
    }

    @Override
    public LocalDateTime with(TemporalAdjuster adjuster) {
        TemporalAdjuster temporalAdjuster = adjuster;
        if (temporalAdjuster instanceof LocalDate) {
            LocalDate l = (LocalDate)temporalAdjuster;
            return this.with(l, this.time());
        }
        if (temporalAdjuster instanceof LocalTime) {
            LocalTime l = (LocalTime)temporalAdjuster;
            return this.with(this.date(), l);
        }
        if (temporalAdjuster instanceof LocalDateTime) {
            LocalDateTime l = (LocalDateTime)temporalAdjuster;
            return l;
        }
        return (LocalDateTime)adjuster.adjustInto(this);
    }

    @Override
    public LocalDateTime with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            if (field.isTimeBased()) {
                return this.with(this.date(), this.time().with(field, newValue));
            }
            return this.with(this.date().with(field, newValue), this.time());
        }
        return field.adjustInto(this, newValue);
    }

    public LocalDateTime withYear(int year) {
        return this.with(this.date().withYear(year), this.time());
    }

    public LocalDateTime withMonth(int month) {
        return this.with(this.date().withMonth(month), this.time());
    }

    public LocalDateTime withDayOfMonth(int dayOfMonth) {
        return this.with(this.date().withDayOfMonth(dayOfMonth), this.time());
    }

    public LocalDateTime withDayOfYear(int dayOfYear) {
        return this.with(this.date().withDayOfYear(dayOfYear), this.time());
    }

    public LocalDateTime withHour(int hour) {
        return this.with(this.date(), this.time().withHour(hour));
    }

    public LocalDateTime withMinute(int minute) {
        LocalTime newTime = this.time().withMinute(minute);
        return this.with(this.date(), newTime);
    }

    public LocalDateTime withSecond(int second) {
        LocalTime newTime = this.time().withSecond(second);
        return this.with(this.date(), newTime);
    }

    public LocalDateTime withNano(int nanoOfSecond) {
        LocalTime newTime = this.time().withNano(nanoOfSecond);
        return this.with(this.date(), newTime);
    }

    public LocalDateTime truncatedTo(TemporalUnit unit) {
        return this.with(this.date(), this.time().truncatedTo(unit));
    }

    @Override
    public LocalDateTime plus(TemporalAmount amount) {
        return (LocalDateTime)amount.addTo(this);
    }

    @Override
    public LocalDateTime plus(long amountToAdd, TemporalUnit unit) {
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit f;
            ChronoUnit chronoUnit = f = (ChronoUnit)temporalUnit;
            ChronoUnit chronoUnit2 = ChronoUnit$.NANOS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.plusNanos(amountToAdd);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.MICROS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return this.plusDays(amountToAdd / 86400000000L).plusNanos(amountToAdd % 86400000000L * 1000L);
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MILLIS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return this.plusDays(amountToAdd / 86400000L).plusNanos(amountToAdd % 86400000L * 1000000L);
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.SECONDS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.plusSeconds(amountToAdd);
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.MINUTES;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return this.plusMinutes(amountToAdd);
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.HOURS;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return this.plusHours(amountToAdd);
            }
            ChronoUnit chronoUnit14 = ChronoUnit$.HALF_DAYS;
            ChronoUnit chronoUnit15 = chronoUnit;
            if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                return this.plusDays(amountToAdd / 256L).plusHours(amountToAdd % 256L * 12L);
            }
            return this.with(this.date().plus(amountToAdd, unit), this.time());
        }
        return unit.addTo(this, amountToAdd);
    }

    public LocalDateTime plusYears(long years) {
        LocalDate newDate = this.date().plusYears(years);
        return this.with(newDate, this.time());
    }

    public LocalDateTime plusMonths(long months) {
        LocalDate newDate = this.date().plusMonths(months);
        return this.with(newDate, this.time());
    }

    public LocalDateTime plusWeeks(long weeks) {
        LocalDate newDate = this.date().plusWeeks(weeks);
        return this.with(newDate, this.time());
    }

    public LocalDateTime plusDays(long days) {
        LocalDate newDate = this.date().plusDays(days);
        return this.with(newDate, this.time());
    }

    public LocalDateTime plusHours(long hours) {
        return this.plusWithOverflow(this.date(), hours, 0L, 0L, 0L, 1);
    }

    public LocalDateTime plusMinutes(long minutes) {
        return this.plusWithOverflow(this.date(), 0L, minutes, 0L, 0L, 1);
    }

    public LocalDateTime plusSeconds(long seconds) {
        return this.plusWithOverflow(this.date(), 0L, 0L, seconds, 0L, 1);
    }

    public LocalDateTime plusNanos(long nanos) {
        return this.plusWithOverflow(this.date(), 0L, 0L, 0L, nanos, 1);
    }

    @Override
    public LocalDateTime minus(TemporalAmount amount) {
        return (LocalDateTime)amount.subtractFrom(this);
    }

    @Override
    public LocalDateTime minus(long amountToSubtract, TemporalUnit unit) {
        if (amountToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, unit).plus(1L, unit);
        }
        return this.plus(-amountToSubtract, unit);
    }

    public LocalDateTime minusYears(long years) {
        if (years == Long.MIN_VALUE) {
            return this.plusYears(Long.MAX_VALUE).plusYears(1L);
        }
        return this.plusYears(-years);
    }

    public LocalDateTime minusMonths(long months) {
        if (months == Long.MIN_VALUE) {
            return this.plusMonths(Long.MAX_VALUE).plusMonths(1L);
        }
        return this.plusMonths(-months);
    }

    public LocalDateTime minusWeeks(long weeks) {
        if (weeks == Long.MIN_VALUE) {
            return this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L);
        }
        return this.plusWeeks(-weeks);
    }

    public LocalDateTime minusDays(long days) {
        if (days == Long.MIN_VALUE) {
            return this.plusDays(Long.MAX_VALUE).plusDays(1L);
        }
        return this.plusDays(-days);
    }

    public LocalDateTime minusHours(long hours) {
        return this.plusWithOverflow(this.date(), hours, 0L, 0L, 0L, -1);
    }

    public LocalDateTime minusMinutes(long minutes) {
        return this.plusWithOverflow(this.date(), 0L, minutes, 0L, 0L, -1);
    }

    public LocalDateTime minusSeconds(long seconds) {
        return this.plusWithOverflow(this.date(), 0L, 0L, seconds, 0L, -1);
    }

    public LocalDateTime minusNanos(long nanos) {
        return this.plusWithOverflow(this.date(), 0L, 0L, 0L, nanos, -1);
    }

    private LocalDateTime plusWithOverflow(LocalDate newDate, long hours, long minutes, long seconds, long nanos, int sign) {
        if ((hours | minutes | seconds | nanos) == 0L) {
            return this.with(newDate, this.time());
        }
        long totDays = nanos / 86400000000000L + seconds / 86400L + minutes / 1440L + hours / 24L;
        totDays *= (long)sign;
        long totNanos = nanos % 86400000000000L + seconds % 86400L * 1000000000L + minutes % 1440L * 60000000000L + hours % 24L * 3600000000000L;
        long curNoD = this.time().toNanoOfDay();
        totNanos = totNanos * (long)sign + curNoD;
        long newNoD = Math.floorMod(totNanos, 86400000000000L);
        LocalTime newTime = newNoD == curNoD ? this.time() : LocalTime$.MODULE$.ofNanoOfDay(newNoD);
        return this.with(newDate.plusDays(totDays += Math.floorDiv(totNanos, 86400000000000L)), newTime);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries$.MODULE$.localDate()) {
            return (R)this.toLocalDate();
        }
        return super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return super.adjustInto(temporal);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        LocalDateTime end = LocalDateTime$.MODULE$.from(endExclusive);
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit f = (ChronoUnit)temporalUnit;
            if (f.isTimeBased()) {
                long daysUntil = this.date().daysUntil(end.date());
                long timeUntil = end.time().toNanoOfDay() - this.time().toNanoOfDay();
                if (daysUntil > 0L && timeUntil < 0L) {
                    --daysUntil;
                    timeUntil += 86400000000000L;
                } else if (daysUntil < 0L && timeUntil > 0L) {
                    ++daysUntil;
                    timeUntil -= 86400000000000L;
                }
                ChronoUnit chronoUnit = f;
                ChronoUnit chronoUnit2 = ChronoUnit$.NANOS;
                ChronoUnit chronoUnit3 = chronoUnit;
                if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                    return Math.addExact(Math.multiplyExact(daysUntil, 86400000000000L), timeUntil);
                }
                ChronoUnit chronoUnit4 = ChronoUnit$.MICROS;
                ChronoUnit chronoUnit5 = chronoUnit;
                if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                    return Math.addExact(Math.multiplyExact(daysUntil, 86400000000L), timeUntil / 1000L);
                }
                ChronoUnit chronoUnit6 = ChronoUnit$.MILLIS;
                ChronoUnit chronoUnit7 = chronoUnit;
                if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                    return Math.addExact(Math.multiplyExact(daysUntil, 86400000L), timeUntil / 1000000L);
                }
                ChronoUnit chronoUnit8 = ChronoUnit$.SECONDS;
                ChronoUnit chronoUnit9 = chronoUnit;
                if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                    return Math.addExact(Math.multiplyExact(daysUntil, (long)86400), timeUntil / 1000000000L);
                }
                ChronoUnit chronoUnit10 = ChronoUnit$.MINUTES;
                ChronoUnit chronoUnit11 = chronoUnit;
                if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                    return Math.addExact(Math.multiplyExact(daysUntil, (long)1440), timeUntil / 60000000000L);
                }
                ChronoUnit chronoUnit12 = ChronoUnit$.HOURS;
                ChronoUnit chronoUnit13 = chronoUnit;
                if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                    return Math.addExact(Math.multiplyExact(daysUntil, (long)24), timeUntil / 3600000000000L);
                }
                ChronoUnit chronoUnit14 = ChronoUnit$.HALF_DAYS;
                ChronoUnit chronoUnit15 = chronoUnit;
                if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                    return Math.addExact(Math.multiplyExact(daysUntil, 2L), timeUntil / 43200000000000L);
                }
                throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
            }
            LocalDate endDate = end.date().isAfter(this.date()) && end.time().isBefore(this.time()) ? end.date().minusDays(1L) : (end.date().isBefore(this.date()) && end.time().isAfter(this.time()) ? end.date().plusDays(1L) : end.date());
            return this.date().until(endDate, unit);
        }
        return unit.between(this, end);
    }

    public OffsetDateTime atOffset(ZoneOffset offset) {
        return OffsetDateTime$.MODULE$.of(this, offset);
    }

    public ZonedDateTime atZone(ZoneId zone) {
        return ZonedDateTime$.MODULE$.of(this, zone);
    }

    @Override
    public LocalDate toLocalDate() {
        return this.date();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time();
    }

    public int compareTo(ChronoLocalDateTime<?> other) {
        ChronoLocalDateTime<?> chronoLocalDateTime = other;
        if (chronoLocalDateTime instanceof LocalDateTime) {
            LocalDateTime l = (LocalDateTime)chronoLocalDateTime;
            return this.compareTo0(l);
        }
        return Ordered.compareTo$((Ordered)this, other);
    }

    private int compareTo0(LocalDateTime other) {
        int cmp = this.date().compareTo0(other.toLocalDate());
        if (cmp == 0) {
            cmp = this.time().compareTo(other.toLocalTime());
        }
        return cmp;
    }

    @Override
    public boolean isAfter(ChronoLocalDateTime<? extends ChronoLocalDate> other) {
        ChronoLocalDateTime<? extends ChronoLocalDate> chronoLocalDateTime = other;
        if (chronoLocalDateTime instanceof LocalDateTime) {
            LocalDateTime l = (LocalDateTime)chronoLocalDateTime;
            return this.compareTo0(l) > 0;
        }
        return super.isAfter(other);
    }

    @Override
    public boolean isBefore(ChronoLocalDateTime<? extends ChronoLocalDate> other) {
        ChronoLocalDateTime<? extends ChronoLocalDate> chronoLocalDateTime = other;
        if (chronoLocalDateTime instanceof LocalDateTime) {
            LocalDateTime l = (LocalDateTime)chronoLocalDateTime;
            return this.compareTo0(l) < 0;
        }
        return super.isBefore(other);
    }

    @Override
    public boolean isEqual(ChronoLocalDateTime<? extends ChronoLocalDate> other) {
        ChronoLocalDateTime<? extends ChronoLocalDate> chronoLocalDateTime = other;
        if (chronoLocalDateTime instanceof LocalDateTime) {
            LocalDateTime l = (LocalDateTime)chronoLocalDateTime;
            return this.compareTo0(l) == 0;
        }
        return super.isEqual(other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof LocalDateTime)) return false;
        LocalDateTime other = (LocalDateTime)object;
        if (this == other) return true;
        LocalDate localDate = this.date();
        LocalDate localDate2 = other.date();
        if (localDate == null) {
            if (localDate2 != null) {
                return false;
            }
        } else if (!((Object)localDate).equals(localDate2)) return false;
        LocalTime localTime = this.time();
        LocalTime localTime2 = other.time();
        if (localTime == null) {
            if (localTime2 == null) return true;
            return false;
        } else {
            if (!((Object)localTime).equals(localTime2)) return false;
            return true;
        }
    }

    @Override
    public int hashCode() {
        return this.date().hashCode() ^ this.time().hashCode();
    }

    @Override
    public String toString() {
        return new StringBuilder(11).append(this.date().toString()).append('T').append(this.time().toString()).toString();
    }

    @Override
    public String format(DateTimeFormatter formatter) {
        return super.format(formatter);
    }
}

