/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDate$;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.LocalTime$;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatter$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.time.zone.ZoneRules;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class LocalDateTime$
implements Serializable {
    private LocalDateTime MIN$lzy1;
    private boolean MINbitmap$1;
    private LocalDateTime MAX$lzy1;
    private boolean MAXbitmap$1;
    public static final LocalDateTime$ MODULE$ = new LocalDateTime$();

    private LocalDateTime$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LocalDateTime$.class);
    }

    public LocalDateTime MIN() {
        if (!this.MINbitmap$1) {
            this.MIN$lzy1 = this.of(LocalDate$.MODULE$.MIN(), LocalTime$.MODULE$.MIN());
            this.MINbitmap$1 = true;
        }
        return this.MIN$lzy1;
    }

    public LocalDateTime MAX() {
        if (!this.MAXbitmap$1) {
            this.MAX$lzy1 = this.of(LocalDate$.MODULE$.MAX(), LocalTime$.MODULE$.MAX());
            this.MAXbitmap$1 = true;
        }
        return this.MAX$lzy1;
    }

    public LocalDateTime now() {
        return this.now(Clock$.MODULE$.systemDefaultZone());
    }

    public LocalDateTime now(ZoneId zone) {
        return this.now(Clock$.MODULE$.system(zone));
    }

    public LocalDateTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        ZoneOffset offset = clock.getZone().getRules().getOffset(now);
        return this.ofEpochSecond(now.getEpochSecond(), now.getNano(), offset);
    }

    public LocalDateTime of(int year, Month month, int dayOfMonth, int hour, int minute) {
        LocalDate date = LocalDate$.MODULE$.of(year, month, dayOfMonth);
        LocalTime time = LocalTime$.MODULE$.of(hour, minute);
        return new LocalDateTime(date, time);
    }

    public LocalDateTime of(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        LocalDate date = LocalDate$.MODULE$.of(year, month, dayOfMonth);
        LocalTime time = LocalTime$.MODULE$.of(hour, minute, second);
        return new LocalDateTime(date, time);
    }

    public LocalDateTime of(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond) {
        LocalDate date = LocalDate$.MODULE$.of(year, month, dayOfMonth);
        LocalTime time = LocalTime$.MODULE$.of(hour, minute, second, nanoOfSecond);
        return new LocalDateTime(date, time);
    }

    public LocalDateTime of(int year, int month, int dayOfMonth, int hour, int minute) {
        LocalDate date = LocalDate$.MODULE$.of(year, month, dayOfMonth);
        LocalTime time = LocalTime$.MODULE$.of(hour, minute);
        return new LocalDateTime(date, time);
    }

    public LocalDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        LocalDate date = LocalDate$.MODULE$.of(year, month, dayOfMonth);
        LocalTime time = LocalTime$.MODULE$.of(hour, minute, second);
        return new LocalDateTime(date, time);
    }

    public LocalDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond) {
        LocalDate date = LocalDate$.MODULE$.of(year, month, dayOfMonth);
        LocalTime time = LocalTime$.MODULE$.of(hour, minute, second, nanoOfSecond);
        return new LocalDateTime(date, time);
    }

    public LocalDateTime of(LocalDate date, LocalTime time) {
        Objects.requireNonNull(date, "date");
        Objects.requireNonNull(time, "time");
        return new LocalDateTime(date, time);
    }

    public LocalDateTime ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        ZoneRules rules = zone.getRules();
        ZoneOffset offset = rules.getOffset(instant);
        return this.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), offset);
    }

    public LocalDateTime ofEpochSecond(long epochSecond, int nanoOfSecond, ZoneOffset offset) {
        Objects.requireNonNull(offset, "offset");
        long localSecond = epochSecond + (long)offset.getTotalSeconds();
        long localEpochDay = Math.floorDiv(localSecond, (long)86400);
        int secsOfDay = (int)Math.floorMod(localSecond, (long)86400);
        LocalDate date = LocalDate$.MODULE$.ofEpochDay(localEpochDay);
        LocalTime time = LocalTime$.MODULE$.ofSecondOfDay(secsOfDay, nanoOfSecond);
        return new LocalDateTime(date, time);
    }

    public LocalDateTime from(TemporalAccessor temporal) {
        LocalDateTime localDateTime;
        TemporalAccessor temporalAccessor = temporal;
        if (temporalAccessor instanceof LocalDateTime) {
            LocalDateTime l = (LocalDateTime)temporalAccessor;
            return l;
        }
        if (temporalAccessor instanceof ZonedDateTime) {
            ZonedDateTime z = (ZonedDateTime)temporalAccessor;
            return z.toLocalDateTime();
        }
        try {
            LocalDate date = LocalDate$.MODULE$.from(temporal);
            LocalTime time = LocalTime$.MODULE$.from(temporal);
            localDateTime = new LocalDateTime(date, time);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException(new StringBuilder(61).append("Unable to obtain LocalDateTime from TemporalAccessor: ").append(temporal).append(", type ").append(temporal.getClass().getName()).toString());
        }
        return localDateTime;
    }

    public LocalDateTime parse(CharSequence text) {
        return this.parse(text, DateTimeFormatter$.MODULE$.ISO_LOCAL_DATE_TIME());
    }

    public LocalDateTime parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, new TemporalQuery<LocalDateTime>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public LocalDateTime queryFrom(TemporalAccessor temporal) {
                return LocalDateTime$.MODULE$.from(temporal);
            }
        });
    }
}

