/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.DayOfWeek$;
import java.time.LocalDate$;
import java.time.LocalDateTime;
import java.time.LocalDateTime$;
import java.time.LocalTime;
import java.time.LocalTime$;
import java.time.Month;
import java.time.Month$;
import java.time.OffsetDateTime;
import java.time.OffsetDateTime$;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Period$;
import java.time.Year$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.ZonedDateTime$;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Era;
import java.time.chrono.IsoChronology;
import java.time.chrono.IsoChronology$;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.temporal.ValueRange$;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.Objects;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordered;

public final class LocalDate
implements TemporalAccessor,
Temporal,
Ordered,
ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = 2942565459149668126L;
    private final int year;
    private final short month;
    private final short day;

    public static long DAYS_0000_TO_1970() {
        return LocalDate$.MODULE$.DAYS_0000_TO_1970();
    }

    public static LocalDate MAX() {
        return LocalDate$.MODULE$.MAX();
    }

    public static LocalDate MIN() {
        return LocalDate$.MODULE$.MIN();
    }

    public static LocalDate from(TemporalAccessor temporalAccessor) {
        return LocalDate$.MODULE$.from(temporalAccessor);
    }

    public static LocalDate now() {
        return LocalDate$.MODULE$.now();
    }

    public static LocalDate now(Clock clock) {
        return LocalDate$.MODULE$.now(clock);
    }

    public static LocalDate now(ZoneId zoneId) {
        return LocalDate$.MODULE$.now(zoneId);
    }

    public static LocalDate of(int n, int n2, int n3) {
        return LocalDate$.MODULE$.of(n, n2, n3);
    }

    public static LocalDate of(int n, Month month, int n2) {
        return LocalDate$.MODULE$.of(n, month, n2);
    }

    public static LocalDate ofEpochDay(long l) {
        return LocalDate$.MODULE$.ofEpochDay(l);
    }

    public static LocalDate ofYearDay(int n, int n2) {
        return LocalDate$.MODULE$.ofYearDay(n, n2);
    }

    public static LocalDate parse(CharSequence charSequence) {
        return LocalDate$.MODULE$.parse(charSequence);
    }

    public static LocalDate parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return LocalDate$.MODULE$.parse(charSequence, dateTimeFormatter);
    }

    public LocalDate(int year, int monthOfYear, int dayOfMonth) {
        this.year = year;
        Ordered.$init$((Ordered)this);
        this.month = (short)monthOfYear;
        this.day = (short)dayOfMonth;
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$with(TemporalAdjuster adjuster) {
        return Temporal.with$(this, adjuster);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$plus(TemporalAmount amount) {
        return Temporal.plus$(this, amount);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$minus(TemporalAmount amount) {
        return Temporal.minus$(this, amount);
    }

    @Override
    public /* synthetic */ Temporal java$time$chrono$ChronoLocalDate$$super$minus(long amountToSubtract, TemporalUnit unit) {
        return Temporal.minus$(this, amountToSubtract, unit);
    }

    @Override
    public /* synthetic */ Object java$time$chrono$ChronoLocalDate$$super$query(TemporalQuery query) {
        return TemporalAccessor.query$(this, query);
    }

    private int year() {
        return this.year;
    }

    private short month() {
        return this.month;
    }

    private short day() {
        return this.day;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return ChronoLocalDate.isSupported$((ChronoLocalDate)this, field);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            if (f.isDateBased()) {
                ChronoField chronoField = f;
                ChronoField chronoField2 = ChronoField$.DAY_OF_MONTH;
                ChronoField chronoField3 = chronoField;
                if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                    return ValueRange$.MODULE$.of(1L, this.lengthOfMonth());
                }
                ChronoField chronoField4 = ChronoField$.DAY_OF_YEAR;
                ChronoField chronoField5 = chronoField;
                if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                    return ValueRange$.MODULE$.of(1L, this.lengthOfYear());
                }
                ChronoField chronoField6 = ChronoField$.ALIGNED_WEEK_OF_MONTH;
                ChronoField chronoField7 = chronoField;
                if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                    return ValueRange$.MODULE$.of(1L, this.getMonth() == Month$.FEBRUARY && !this.isLeapYear() ? 4L : 5L);
                }
                ChronoField chronoField8 = ChronoField$.YEAR_OF_ERA;
                ChronoField chronoField9 = chronoField;
                if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                    if (this.getYear() <= 0) {
                        return ValueRange$.MODULE$.of(1L, (long)Year$.MODULE$.MAX_VALUE() + 1L);
                    }
                    return ValueRange$.MODULE$.of(1L, Year$.MODULE$.MAX_VALUE());
                }
                return field.range();
            }
            throw new UnsupportedTemporalTypeException(new java.lang.StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            return (int)this.get0(field);
        }
        return TemporalAccessor.get$(this, field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField$.EPOCH_DAY) {
                return this.toEpochDay();
            }
            if (field == ChronoField$.PROLEPTIC_MONTH) {
                return this.getProlepticMonth();
            }
            return this.get0(field);
        }
        return field.getFrom(this);
    }

    private long get0(TemporalField field) {
        ChronoField chronoField = (ChronoField)field;
        ChronoField chronoField2 = ChronoField$.DAY_OF_WEEK;
        ChronoField chronoField3 = chronoField;
        if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
            return this.getDayOfWeek().getValue();
        }
        ChronoField chronoField4 = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH;
        ChronoField chronoField5 = chronoField;
        if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
            return ((long)this.day() - 1L) % 7L + 1L;
        }
        ChronoField chronoField6 = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR;
        ChronoField chronoField7 = chronoField;
        if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
            return ((long)this.getDayOfYear() - 1L) % 7L + 1L;
        }
        ChronoField chronoField8 = ChronoField$.DAY_OF_MONTH;
        ChronoField chronoField9 = chronoField;
        if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
            return this.day();
        }
        ChronoField chronoField10 = ChronoField$.DAY_OF_YEAR;
        ChronoField chronoField11 = chronoField;
        if (!(chronoField10 != null ? !chronoField10.equals(chronoField11) : chronoField11 != null)) {
            return this.getDayOfYear();
        }
        ChronoField chronoField12 = ChronoField$.EPOCH_DAY;
        ChronoField chronoField13 = chronoField;
        if (!(chronoField12 != null ? !chronoField12.equals(chronoField13) : chronoField13 != null)) {
            throw new DateTimeException(new java.lang.StringBuilder(28).append("Field too large for an int: ").append(field).toString());
        }
        ChronoField chronoField14 = ChronoField$.ALIGNED_WEEK_OF_MONTH;
        ChronoField chronoField15 = chronoField;
        if (!(chronoField14 != null ? !chronoField14.equals(chronoField15) : chronoField15 != null)) {
            return ((long)this.day() - 1L) / 7L + 1L;
        }
        ChronoField chronoField16 = ChronoField$.ALIGNED_WEEK_OF_YEAR;
        ChronoField chronoField17 = chronoField;
        if (!(chronoField16 != null ? !chronoField16.equals(chronoField17) : chronoField17 != null)) {
            return ((long)this.getDayOfYear() - 1L) / 7L + 1L;
        }
        ChronoField chronoField18 = ChronoField$.MONTH_OF_YEAR;
        ChronoField chronoField19 = chronoField;
        if (!(chronoField18 != null ? !chronoField18.equals(chronoField19) : chronoField19 != null)) {
            return this.month();
        }
        ChronoField chronoField20 = ChronoField$.PROLEPTIC_MONTH;
        ChronoField chronoField21 = chronoField;
        if (!(chronoField20 != null ? !chronoField20.equals(chronoField21) : chronoField21 != null)) {
            throw new DateTimeException(new java.lang.StringBuilder(28).append("Field too large for an int: ").append(field).toString());
        }
        ChronoField chronoField22 = ChronoField$.YEAR_OF_ERA;
        ChronoField chronoField23 = chronoField;
        if (!(chronoField22 != null ? !chronoField22.equals(chronoField23) : chronoField23 != null)) {
            if (this.year() >= 1) {
                return this.year();
            }
            return 1L - (long)this.year();
        }
        ChronoField chronoField24 = ChronoField$.YEAR;
        ChronoField chronoField25 = chronoField;
        if (!(chronoField24 != null ? !chronoField24.equals(chronoField25) : chronoField25 != null)) {
            return this.year();
        }
        ChronoField chronoField26 = ChronoField$.ERA;
        ChronoField chronoField27 = chronoField;
        if (!(chronoField26 != null ? !chronoField26.equals(chronoField27) : chronoField27 != null)) {
            if (this.year() >= 1) {
                return 1L;
            }
            return 0L;
        }
        throw new UnsupportedTemporalTypeException(new java.lang.StringBuilder(19).append("Unsupported field: ").append(field).toString());
    }

    private long getProlepticMonth() {
        return (long)this.year() * 12L + (long)(this.month() - 1);
    }

    @Override
    public IsoChronology getChronology() {
        return IsoChronology$.MODULE$.INSTANCE();
    }

    @Override
    public Era getEra() {
        return ChronoLocalDate.getEra$(this);
    }

    public int getYear() {
        return this.year();
    }

    public int getMonthValue() {
        return this.month();
    }

    public Month getMonth() {
        return Month$.MODULE$.of(this.month());
    }

    public int getDayOfMonth() {
        return this.day();
    }

    public int getDayOfYear() {
        return this.getMonth().firstDayOfYear(this.isLeapYear()) + this.day() - 1;
    }

    public DayOfWeek getDayOfWeek() {
        int dow0 = (int)Math.floorMod(this.toEpochDay() + 3L, 7L);
        return DayOfWeek$.MODULE$.of(dow0 + 1);
    }

    @Override
    public boolean isLeapYear() {
        return IsoChronology$.MODULE$.INSTANCE().isLeapYear(this.year());
    }

    @Override
    public int lengthOfMonth() {
        short s = this.month();
        switch (s) {
            case 2: {
                if (this.isLeapYear()) {
                    return 29;
                }
                return 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    @Override
    public int lengthOfYear() {
        if (this.isLeapYear()) {
            return 366;
        }
        return 365;
    }

    @Override
    public LocalDate with(TemporalAdjuster adjuster) {
        if (adjuster instanceof LocalDate) {
            return (LocalDate)adjuster;
        }
        return (LocalDate)adjuster.adjustInto(this);
    }

    @Override
    public LocalDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            f.checkValidValue(newValue);
            ChronoField chronoField = f;
            ChronoField chronoField2 = ChronoField$.DAY_OF_WEEK;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.plusDays(newValue - (long)this.getDayOfWeek().getValue());
            }
            ChronoField chronoField4 = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.plusDays(newValue - this.getLong(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_MONTH));
            }
            ChronoField chronoField6 = ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR;
            ChronoField chronoField7 = chronoField;
            if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                return this.plusDays(newValue - this.getLong(ChronoField$.ALIGNED_DAY_OF_WEEK_IN_YEAR));
            }
            ChronoField chronoField8 = ChronoField$.DAY_OF_MONTH;
            ChronoField chronoField9 = chronoField;
            if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                return this.withDayOfMonth((int)newValue);
            }
            ChronoField chronoField10 = ChronoField$.DAY_OF_YEAR;
            ChronoField chronoField11 = chronoField;
            if (!(chronoField10 != null ? !chronoField10.equals(chronoField11) : chronoField11 != null)) {
                return this.withDayOfYear((int)newValue);
            }
            ChronoField chronoField12 = ChronoField$.EPOCH_DAY;
            ChronoField chronoField13 = chronoField;
            if (!(chronoField12 != null ? !chronoField12.equals(chronoField13) : chronoField13 != null)) {
                return LocalDate$.MODULE$.ofEpochDay(newValue);
            }
            ChronoField chronoField14 = ChronoField$.ALIGNED_WEEK_OF_MONTH;
            ChronoField chronoField15 = chronoField;
            if (!(chronoField14 != null ? !chronoField14.equals(chronoField15) : chronoField15 != null)) {
                return this.plusWeeks(newValue - this.getLong(ChronoField$.ALIGNED_WEEK_OF_MONTH));
            }
            ChronoField chronoField16 = ChronoField$.ALIGNED_WEEK_OF_YEAR;
            ChronoField chronoField17 = chronoField;
            if (!(chronoField16 != null ? !chronoField16.equals(chronoField17) : chronoField17 != null)) {
                return this.plusWeeks(newValue - this.getLong(ChronoField$.ALIGNED_WEEK_OF_YEAR));
            }
            ChronoField chronoField18 = ChronoField$.MONTH_OF_YEAR;
            ChronoField chronoField19 = chronoField;
            if (!(chronoField18 != null ? !chronoField18.equals(chronoField19) : chronoField19 != null)) {
                return this.withMonth((int)newValue);
            }
            ChronoField chronoField20 = ChronoField$.PROLEPTIC_MONTH;
            ChronoField chronoField21 = chronoField;
            if (!(chronoField20 != null ? !chronoField20.equals(chronoField21) : chronoField21 != null)) {
                return this.plusMonths(newValue - this.getLong(ChronoField$.PROLEPTIC_MONTH));
            }
            ChronoField chronoField22 = ChronoField$.YEAR_OF_ERA;
            ChronoField chronoField23 = chronoField;
            if (!(chronoField22 != null ? !chronoField22.equals(chronoField23) : chronoField23 != null)) {
                return this.withYear((int)(this.year() >= 1 ? newValue : 1L - newValue));
            }
            ChronoField chronoField24 = ChronoField$.YEAR;
            ChronoField chronoField25 = chronoField;
            if (!(chronoField24 != null ? !chronoField24.equals(chronoField25) : chronoField25 != null)) {
                return this.withYear((int)newValue);
            }
            ChronoField chronoField26 = ChronoField$.ERA;
            ChronoField chronoField27 = chronoField;
            if (!(chronoField26 != null ? !chronoField26.equals(chronoField27) : chronoField27 != null)) {
                if (this.getLong(ChronoField$.ERA) == newValue) {
                    return this;
                }
                return this.withYear(1 - this.year());
            }
            throw new UnsupportedTemporalTypeException(new java.lang.StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.adjustInto(this, newValue);
    }

    public LocalDate withYear(int year) {
        if (this.year() == year) {
            return this;
        }
        ChronoField$.YEAR.checkValidValue(year);
        return LocalDate$.MODULE$.java$time$LocalDate$$$resolvePreviousValid(year, this.month(), this.day());
    }

    public LocalDate withMonth(int month) {
        if (this.month() == month) {
            return this;
        }
        ChronoField$.MONTH_OF_YEAR.checkValidValue(month);
        return LocalDate$.MODULE$.java$time$LocalDate$$$resolvePreviousValid(this.year(), month, this.day());
    }

    public LocalDate withDayOfMonth(int dayOfMonth) {
        if (this.day() == dayOfMonth) {
            return this;
        }
        return LocalDate$.MODULE$.of(this.year(), this.month(), dayOfMonth);
    }

    public LocalDate withDayOfYear(int dayOfYear) {
        if (this.getDayOfYear() == dayOfYear) {
            return this;
        }
        return LocalDate$.MODULE$.ofYearDay(this.year(), dayOfYear);
    }

    @Override
    public LocalDate plus(TemporalAmount amount) {
        return (LocalDate)amount.addTo(this);
    }

    @Override
    public LocalDate plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit f;
            ChronoUnit chronoUnit = f = (ChronoUnit)unit;
            ChronoUnit chronoUnit2 = ChronoUnit$.DAYS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.plusDays(amountToAdd);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.WEEKS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return this.plusWeeks(amountToAdd);
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MONTHS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return this.plusMonths(amountToAdd);
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.YEARS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.plusYears(amountToAdd);
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.DECADES;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 10L));
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.CENTURIES;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 100L));
            }
            ChronoUnit chronoUnit14 = ChronoUnit$.MILLENNIA;
            ChronoUnit chronoUnit15 = chronoUnit;
            if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                return this.plusYears(Math.multiplyExact(amountToAdd, 1000L));
            }
            ChronoUnit chronoUnit16 = ChronoUnit$.ERAS;
            ChronoUnit chronoUnit17 = chronoUnit;
            if (!(chronoUnit16 != null ? !chronoUnit16.equals(chronoUnit17) : chronoUnit17 != null)) {
                return this.with(ChronoField$.ERA, Math.addExact(this.getLong(ChronoField$.ERA), amountToAdd));
            }
            throw new UnsupportedTemporalTypeException(new java.lang.StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.addTo(this, amountToAdd);
    }

    public LocalDate plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        int newYear = ChronoField$.YEAR.checkValidIntValue((long)this.year() + yearsToAdd);
        return LocalDate$.MODULE$.java$time$LocalDate$$$resolvePreviousValid(newYear, this.month(), this.day());
    }

    public LocalDate plusMonths(long monthsToAdd) {
        if (monthsToAdd == 0L) {
            return this;
        }
        long monthCount = (long)this.year() * 12L + (long)(this.month() - 1);
        long calcMonths = monthCount + monthsToAdd;
        int newYear = ChronoField$.YEAR.checkValidIntValue(Math.floorDiv(calcMonths, 12L));
        int newMonth = (int)Math.floorMod(calcMonths, 12L) + 1;
        return LocalDate$.MODULE$.java$time$LocalDate$$$resolvePreviousValid(newYear, newMonth, this.day());
    }

    public LocalDate plusWeeks(long weeksToAdd) {
        return this.plusDays(Math.multiplyExact(weeksToAdd, 7L));
    }

    public LocalDate plusDays(long daysToAdd) {
        if (daysToAdd == 0L) {
            return this;
        }
        long mjDay = Math.addExact(this.toEpochDay(), daysToAdd);
        return LocalDate$.MODULE$.ofEpochDay(mjDay);
    }

    @Override
    public LocalDate minus(TemporalAmount amount) {
        return (LocalDate)amount.subtractFrom(this);
    }

    @Override
    public LocalDate minus(long amountToSubtract, TemporalUnit unit) {
        if (amountToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, unit).plus(1L, unit);
        }
        return this.plus(-amountToSubtract, unit);
    }

    public LocalDate minusYears(long yearsToSubtract) {
        if (yearsToSubtract == Long.MIN_VALUE) {
            return this.plusYears(Long.MAX_VALUE).plusYears(1L);
        }
        return this.plusYears(-yearsToSubtract);
    }

    public LocalDate minusMonths(long monthsToSubtract) {
        if (monthsToSubtract == Long.MIN_VALUE) {
            return this.plusMonths(Long.MAX_VALUE).plusMonths(1L);
        }
        return this.plusMonths(-monthsToSubtract);
    }

    public LocalDate minusWeeks(long weeksToSubtract) {
        if (weeksToSubtract == Long.MIN_VALUE) {
            return this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L);
        }
        return this.plusWeeks(-weeksToSubtract);
    }

    public LocalDate minusDays(long daysToSubtract) {
        if (daysToSubtract == Long.MIN_VALUE) {
            return this.plusDays(Long.MAX_VALUE).plusDays(1L);
        }
        return this.plusDays(-daysToSubtract);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries$.MODULE$.localDate()) {
            return (R)this;
        }
        return (R)ChronoLocalDate.query$(this, query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return ChronoLocalDate.adjustInto$(this, temporal);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        LocalDate end = LocalDate$.MODULE$.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            ChronoUnit chronoUnit2 = ChronoUnit$.DAYS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.daysUntil(end);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.WEEKS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return this.daysUntil(end) / 7L;
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MONTHS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return this.monthsUntil(end);
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.YEARS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.monthsUntil(end) / 12L;
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.DECADES;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return this.monthsUntil(end) / 120L;
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.CENTURIES;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return this.monthsUntil(end) / 1200L;
            }
            ChronoUnit chronoUnit14 = ChronoUnit$.MILLENNIA;
            ChronoUnit chronoUnit15 = chronoUnit;
            if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                return this.monthsUntil(end) / 12000L;
            }
            ChronoUnit chronoUnit16 = ChronoUnit$.ERAS;
            ChronoUnit chronoUnit17 = chronoUnit;
            if (!(chronoUnit16 != null ? !chronoUnit16.equals(chronoUnit17) : chronoUnit17 != null)) {
                return end.getLong(ChronoField$.ERA) - this.getLong(ChronoField$.ERA);
            }
            throw new UnsupportedTemporalTypeException(new java.lang.StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.between(this, end);
    }

    public long daysUntil(LocalDate end) {
        return end.toEpochDay() - this.toEpochDay();
    }

    private long monthsUntil(LocalDate end) {
        long packed1 = this.getProlepticMonth() * 32L + (long)this.getDayOfMonth();
        long packed2 = end.getProlepticMonth() * 32L + (long)end.getDayOfMonth();
        return (packed2 - packed1) / 32L;
    }

    @Override
    public Period until(ChronoLocalDate endDate) {
        LocalDate end = LocalDate$.MODULE$.from(endDate);
        long totalMonths = end.getProlepticMonth() - this.getProlepticMonth();
        int days = end.day() - this.day();
        if (totalMonths > 0L && days < 0) {
            LocalDate calcDate = this.plusMonths(--totalMonths);
            days = (int)(end.toEpochDay() - calcDate.toEpochDay());
        } else if (totalMonths < 0L && days > 0) {
            ++totalMonths;
            days -= end.lengthOfMonth();
        }
        long years = totalMonths / 12L;
        int months = (int)(totalMonths % 12L);
        return Period$.MODULE$.of(Math.toIntExact(years), months, days);
    }

    public LocalDateTime atTime(LocalTime time) {
        return LocalDateTime$.MODULE$.of(this, time);
    }

    public LocalDateTime atTime(int hour, int minute) {
        return this.atTime(LocalTime$.MODULE$.of(hour, minute));
    }

    public LocalDateTime atTime(int hour, int minute, int second) {
        return this.atTime(LocalTime$.MODULE$.of(hour, minute, second));
    }

    public LocalDateTime atTime(int hour, int minute, int second, int nanoOfSecond) {
        return this.atTime(LocalTime$.MODULE$.of(hour, minute, second, nanoOfSecond));
    }

    public OffsetDateTime atTime(OffsetTime time) {
        return OffsetDateTime$.MODULE$.of(LocalDateTime$.MODULE$.of(this, time.toLocalTime()), time.getOffset());
    }

    public LocalDateTime atStartOfDay() {
        return LocalDateTime$.MODULE$.of(this, LocalTime$.MODULE$.MIDNIGHT());
    }

    public ZonedDateTime atStartOfDay(ZoneId zone) {
        ZoneRules rules;
        ZoneOffsetTransition trans;
        Objects.requireNonNull(zone, "zone");
        LocalDateTime ldt = this.atTime(LocalTime$.MODULE$.MIDNIGHT());
        if (!(zone instanceof ZoneOffset) && (trans = (rules = zone.getRules()).getTransition(ldt)) != null && trans.isGap()) {
            ldt = trans.getDateTimeAfter();
        }
        return ZonedDateTime$.MODULE$.of(ldt, zone);
    }

    @Override
    public long toEpochDay() {
        long y = this.year();
        long m = this.month();
        long total = 0L;
        total += 365L * y;
        total = y >= 0L ? (total += (y + 3L) / 4L - (y + 99L) / 100L + (y + 399L) / 400L) : (total -= y / -4L - y / -100L + y / -400L);
        total += (367L * m - 362L) / 12L;
        total += (long)(this.day() - 1);
        if (m > 2L) {
            --total;
            if (!this.isLeapYear()) {
                --total;
            }
        }
        return total - LocalDate$.MODULE$.DAYS_0000_TO_1970();
    }

    public int compareTo(ChronoLocalDate other) {
        if (other instanceof LocalDate) {
            return this.compareTo0((LocalDate)other);
        }
        return Ordered.compareTo$((Ordered)this, (Object)other);
    }

    public int compareTo0(LocalDate otherDate) {
        int cmp = this.year() - otherDate.year();
        if (cmp == 0 && (cmp = this.month() - otherDate.month()) == 0) {
            cmp = this.day() - otherDate.day();
        }
        return cmp;
    }

    @Override
    public boolean isAfter(ChronoLocalDate other) {
        if (other instanceof LocalDate) {
            return this.compareTo0((LocalDate)other) > 0;
        }
        return ChronoLocalDate.isAfter$(this, other);
    }

    @Override
    public boolean isBefore(ChronoLocalDate other) {
        if (other instanceof LocalDate) {
            return this.compareTo0((LocalDate)other) < 0;
        }
        return ChronoLocalDate.isBefore$(this, other);
    }

    @Override
    public boolean isEqual(ChronoLocalDate other) {
        if (other instanceof LocalDate) {
            return this.compareTo0((LocalDate)other) == 0;
        }
        return ChronoLocalDate.isEqual$(this, other);
    }

    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof LocalDate) {
            LocalDate otherDate = (LocalDate)object;
            return this == otherDate || this.compareTo0(otherDate) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int yearValue = this.year();
        short monthValue = this.month();
        short dayValue = this.day();
        return yearValue & 0xFFFFF800 ^ (yearValue << 11) + (monthValue << 6) + dayValue;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        int yearValue = this.year();
        short monthValue = this.month();
        short dayValue = this.day();
        int absYear = Math.abs(yearValue);
        StringBuilder buf = new StringBuilder(10);
        if (absYear < 1000) {
            stringBuilder = yearValue < 0 ? buf.append(yearValue - 10000).deleteCharAt(1) : buf.append(yearValue + 10000).deleteCharAt(0);
        } else {
            if (yearValue > 9999) {
                buf.append('+');
            }
            stringBuilder = buf.append(yearValue);
        }
        return buf.append(monthValue < 10 ? "-0" : "-").append((int)monthValue).append(dayValue < 10 ? "-0" : "-").append((int)dayValue).toString();
    }

    @Override
    public String format(DateTimeFormatter formatter) {
        return ChronoLocalDate.format$(this, formatter);
    }
}

