/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.Month$;
import java.time.Year$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology$;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatter$;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class LocalDate$
implements Serializable {
    private LocalDate MIN$lzy1;
    private boolean MINbitmap$1;
    private LocalDate MAX$lzy1;
    private boolean MAXbitmap$1;
    private static final int DAYS_PER_CYCLE;
    private static final long DAYS_0000_TO_1970;
    public static final LocalDate$ MODULE$;

    private LocalDate$() {
    }

    static {
        MODULE$ = new LocalDate$();
        DAYS_PER_CYCLE = 146097;
        DAYS_0000_TO_1970 = (long)DAYS_PER_CYCLE * 5L - 10957L;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LocalDate$.class);
    }

    public LocalDate MIN() {
        if (!this.MINbitmap$1) {
            this.MIN$lzy1 = this.of(Year$.MODULE$.MIN_VALUE(), 1, 1);
            this.MINbitmap$1 = true;
        }
        return this.MIN$lzy1;
    }

    public LocalDate MAX() {
        if (!this.MAXbitmap$1) {
            this.MAX$lzy1 = this.of(Year$.MODULE$.MAX_VALUE(), 12, 31);
            this.MAXbitmap$1 = true;
        }
        return this.MAX$lzy1;
    }

    public long DAYS_0000_TO_1970() {
        return DAYS_0000_TO_1970;
    }

    public LocalDate now() {
        return this.now(Clock$.MODULE$.systemDefaultZone());
    }

    public LocalDate now(ZoneId zone) {
        return this.now(Clock$.MODULE$.system(zone));
    }

    public LocalDate now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        ZoneOffset offset = clock.getZone().getRules().getOffset(now);
        long epochSec = now.getEpochSecond() + (long)offset.getTotalSeconds();
        long epochDay = Math.floorDiv(epochSec, (long)86400);
        return this.ofEpochDay(epochDay);
    }

    public LocalDate of(int year, Month month, int dayOfMonth) {
        ChronoField$.YEAR.checkValidValue(year);
        Objects.requireNonNull(month, "month");
        ChronoField$.DAY_OF_MONTH.checkValidValue(dayOfMonth);
        return this.create(year, month, dayOfMonth);
    }

    public LocalDate of(int year, int month, int dayOfMonth) {
        ChronoField$.YEAR.checkValidValue(year);
        ChronoField$.MONTH_OF_YEAR.checkValidValue(month);
        ChronoField$.DAY_OF_MONTH.checkValidValue(dayOfMonth);
        return this.create(year, Month$.MODULE$.of(month), dayOfMonth);
    }

    public LocalDate ofYearDay(int year, int dayOfYear) {
        ChronoField$.YEAR.checkValidValue(year);
        ChronoField$.DAY_OF_YEAR.checkValidValue(dayOfYear);
        boolean leap = IsoChronology$.MODULE$.INSTANCE().isLeapYear(year);
        if (dayOfYear == 366 && !leap) {
            throw new DateTimeException(new StringBuilder(53).append("Invalid date 'DayOfYear 366' as '").append(year).append("' is not a leap year").toString());
        }
        Month moy = Month$.MODULE$.of((dayOfYear - 1) / 31 + 1);
        int monthEnd = moy.firstDayOfYear(leap) + moy.length(leap) - 1;
        if (dayOfYear > monthEnd) {
            moy = moy.plus(1L);
        }
        int dom = dayOfYear - moy.firstDayOfYear(leap) + 1;
        return this.create(year, moy, dom);
    }

    public LocalDate ofEpochDay(long epochDay) {
        long yearEst;
        long doyEst;
        ChronoField$.EPOCH_DAY.checkValidValue(epochDay);
        long zeroDay = epochDay + this.DAYS_0000_TO_1970();
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / (long)DAYS_PER_CYCLE - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * (long)DAYS_PER_CYCLE;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / (long)DAYS_PER_CYCLE) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dom = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        int year = ChronoField$.YEAR.checkValidIntValue(yearEst += (long)(marchMonth0 / 10));
        return new LocalDate(year, month, dom);
    }

    public LocalDate from(TemporalAccessor temporal) {
        LocalDate date = temporal.query(TemporalQueries$.MODULE$.localDate());
        if (date == null) {
            throw new DateTimeException(new StringBuilder(57).append("Unable to obtain LocalDate from TemporalAccessor: ").append(temporal).append(", type ").append(temporal.getClass().getName()).toString());
        }
        return date;
    }

    public LocalDate parse(CharSequence text) {
        return this.parse(text, DateTimeFormatter$.MODULE$.ISO_LOCAL_DATE());
    }

    public LocalDate parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, new TemporalQuery<LocalDate>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public LocalDate queryFrom(TemporalAccessor temporal) {
                return LocalDate$.MODULE$.from(temporal);
            }
        });
    }

    private LocalDate create(int year, Month month, int dayOfMonth) {
        if (dayOfMonth > 28 && dayOfMonth > month.length(IsoChronology$.MODULE$.INSTANCE().isLeapYear(year))) {
            if (dayOfMonth == 29) {
                throw new DateTimeException(new StringBuilder(51).append("Invalid date 'February 29' as '").append(year).append("' is not a leap year").toString());
            }
            throw new DateTimeException(new StringBuilder(16).append("Invalid date '").append(month.name()).append(" ").append(dayOfMonth).append("'").toString());
        }
        return new LocalDate(year, month.getValue(), dayOfMonth);
    }

    public LocalDate java$time$LocalDate$$$resolvePreviousValid(int year, int month, int day) {
        int n;
        int n2 = month;
        switch (n2) {
            case 2: {
                n = Math.min(day, IsoChronology$.MODULE$.INSTANCE().isLeapYear(year) ? 29 : 28);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n = Math.min(day, 30);
                break;
            }
            default: {
                n = day;
                break;
            }
        }
        int _day = n;
        return this.of(year, month, _day);
    }
}

