/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant$;
import java.time.OffsetDateTime;
import java.time.OffsetDateTime$;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.ZonedDateTime$;
import java.time.format.DateTimeFormatter$;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries$;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import scala.math.Ordered;

public final class Instant
implements Temporal,
TemporalAdjuster,
Ordered<Instant>,
Serializable {
    private static final long serialVersionUID = -665713676816604388L;
    private final long seconds;
    private final int nanos;

    public static Instant EPOCH() {
        return Instant$.MODULE$.EPOCH();
    }

    public static Instant MAX() {
        return Instant$.MODULE$.MAX();
    }

    public static Instant MIN() {
        return Instant$.MODULE$.MIN();
    }

    public static Instant from(TemporalAccessor temporalAccessor) {
        return Instant$.MODULE$.from(temporalAccessor);
    }

    public static Instant now() {
        return Instant$.MODULE$.now();
    }

    public static Instant now(Clock clock) {
        return Instant$.MODULE$.now(clock);
    }

    public static Instant ofEpochMilli(long l) {
        return Instant$.MODULE$.ofEpochMilli(l);
    }

    public static Instant ofEpochSecond(long l) {
        return Instant$.MODULE$.ofEpochSecond(l);
    }

    public static Instant ofEpochSecond(long l, long l2) {
        return Instant$.MODULE$.ofEpochSecond(l, l2);
    }

    public static Instant parse(CharSequence charSequence) {
        return Instant$.MODULE$.parse(charSequence);
    }

    public Instant(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
        Ordered.$init$((Ordered)this);
    }

    private long seconds() {
        return this.seconds;
    }

    private int nanos() {
        return this.nanos;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField$.INSTANT_SECONDS || field == ChronoField$.NANO_OF_SECOND || field == ChronoField$.MICRO_OF_SECOND || field == ChronoField$.MILLI_OF_SECOND;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit.isTimeBased() || unit == ChronoUnit$.DAYS;
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        return TemporalAccessor.range$(this, field);
    }

    @Override
    public int get(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f;
            ChronoField chronoField = f = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.NANO_OF_SECOND;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.nanos();
            }
            ChronoField chronoField4 = ChronoField$.MICRO_OF_SECOND;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return this.nanos() / 1000;
            }
            ChronoField chronoField6 = ChronoField$.MILLI_OF_SECOND;
            ChronoField chronoField7 = chronoField;
            if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                return this.nanos() / Instant$.MODULE$.java$time$Instant$$$NANOS_PER_MILLI();
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return this.range(field).checkValidIntValue(field.getFrom(this), field);
    }

    @Override
    public long getLong(TemporalField field) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f;
            ChronoField chronoField = f = (ChronoField)temporalField;
            ChronoField chronoField2 = ChronoField$.NANO_OF_SECOND;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                return this.nanos();
            }
            ChronoField chronoField4 = ChronoField$.MICRO_OF_SECOND;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                return (long)this.nanos() / 1000L;
            }
            ChronoField chronoField6 = ChronoField$.MILLI_OF_SECOND;
            ChronoField chronoField7 = chronoField;
            if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                return (long)this.nanos() / (long)Instant$.MODULE$.java$time$Instant$$$NANOS_PER_MILLI();
            }
            ChronoField chronoField8 = ChronoField$.INSTANT_SECONDS;
            ChronoField chronoField9 = chronoField;
            if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                return this.seconds();
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.getFrom(this);
    }

    public long getEpochSecond() {
        return this.seconds();
    }

    public int getNano() {
        return this.nanos();
    }

    @Override
    public Instant with(TemporalAdjuster adjuster) {
        return (Instant)adjuster.adjustInto(this);
    }

    @Override
    public Instant with(TemporalField field, long newValue) {
        TemporalField temporalField = field;
        if (temporalField instanceof ChronoField) {
            ChronoField f = (ChronoField)temporalField;
            f.checkValidValue(newValue);
            ChronoField chronoField = f;
            ChronoField chronoField2 = ChronoField$.MILLI_OF_SECOND;
            ChronoField chronoField3 = chronoField;
            if (!(chronoField2 != null ? !chronoField2.equals(chronoField3) : chronoField3 != null)) {
                int nval = (int)newValue * Instant$.MODULE$.java$time$Instant$$$NANOS_PER_MILLI();
                if (nval != this.nanos()) {
                    return Instant$.MODULE$.java$time$Instant$$$create(this.seconds(), nval);
                }
                return this;
            }
            ChronoField chronoField4 = ChronoField$.MICRO_OF_SECOND;
            ChronoField chronoField5 = chronoField;
            if (!(chronoField4 != null ? !chronoField4.equals(chronoField5) : chronoField5 != null)) {
                int nval = (int)newValue * 1000;
                if (nval != this.nanos()) {
                    return Instant$.MODULE$.java$time$Instant$$$create(this.seconds(), nval);
                }
                return this;
            }
            ChronoField chronoField6 = ChronoField$.NANO_OF_SECOND;
            ChronoField chronoField7 = chronoField;
            if (!(chronoField6 != null ? !chronoField6.equals(chronoField7) : chronoField7 != null)) {
                if (newValue != (long)this.nanos()) {
                    return Instant$.MODULE$.java$time$Instant$$$create(this.seconds(), (int)newValue);
                }
                return this;
            }
            ChronoField chronoField8 = ChronoField$.INSTANT_SECONDS;
            ChronoField chronoField9 = chronoField;
            if (!(chronoField8 != null ? !chronoField8.equals(chronoField9) : chronoField9 != null)) {
                if (newValue != this.seconds()) {
                    return Instant$.MODULE$.java$time$Instant$$$create(newValue, this.nanos());
                }
                return this;
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(19).append("Unsupported field: ").append(field).toString());
        }
        return field.adjustInto(this, newValue);
    }

    public Instant truncatedTo(TemporalUnit unit) {
        if (unit == ChronoUnit$.NANOS) {
            return this;
        }
        Duration unitDur = unit.getDuration();
        if (unitDur.getSeconds() > 86400L) {
            throw new DateTimeException("Unit is too large to be used for truncation");
        }
        long dur = unitDur.toNanos();
        if (86400000000000L % dur != 0L) {
            throw new DateTimeException("Unit must divide into a standard day without remainder");
        }
        long nod = this.seconds() % 86400L * 1000000000L + (long)this.nanos();
        long result = Math.floorDiv(nod, dur) * dur;
        return this.plusNanos(result - nod);
    }

    @Override
    public Instant plus(TemporalAmount amount) {
        return (Instant)amount.addTo(this);
    }

    @Override
    public Instant plus(long amountToAdd, TemporalUnit unit) {
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit u;
            ChronoUnit chronoUnit = u = (ChronoUnit)temporalUnit;
            ChronoUnit chronoUnit2 = ChronoUnit$.NANOS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.plusNanos(amountToAdd);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.MICROS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return this.plus(amountToAdd / 1000000L, amountToAdd % 1000000L * 1000L);
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MILLIS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return this.plusMillis(amountToAdd);
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.SECONDS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.plusSeconds(amountToAdd);
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.MINUTES;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return this.plusSeconds(Math.multiplyExact(amountToAdd, (long)60));
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.HOURS;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return this.plusSeconds(Math.multiplyExact(amountToAdd, (long)3600));
            }
            ChronoUnit chronoUnit14 = ChronoUnit$.HALF_DAYS;
            ChronoUnit chronoUnit15 = chronoUnit;
            if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                return this.plusSeconds(Math.multiplyExact(amountToAdd, 43200L));
            }
            ChronoUnit chronoUnit16 = ChronoUnit$.DAYS;
            ChronoUnit chronoUnit17 = chronoUnit;
            if (!(chronoUnit16 != null ? !chronoUnit16.equals(chronoUnit17) : chronoUnit17 != null)) {
                return this.plusSeconds(Math.multiplyExact(amountToAdd, (long)86400));
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.addTo(this, amountToAdd);
    }

    public Instant plusSeconds(long secondsToAdd) {
        return this.plus(secondsToAdd, 0L);
    }

    public Instant plusMillis(long millisToAdd) {
        return this.plus(millisToAdd / 1000L, millisToAdd % 1000L * (long)Instant$.MODULE$.java$time$Instant$$$NANOS_PER_MILLI());
    }

    public Instant plusNanos(long nanosToAdd) {
        return this.plus(0L, nanosToAdd);
    }

    private Instant plus(long secondsToAdd, long nanosToAdd) {
        long _nanosToAdd = nanosToAdd;
        if ((secondsToAdd | _nanosToAdd) == 0L) {
            return this;
        }
        long epochSec = Math.addExact(this.seconds(), secondsToAdd);
        epochSec = Math.addExact(epochSec, _nanosToAdd / (long)Instant$.MODULE$.java$time$Instant$$$NANOS_PER_SECOND());
        long nanoAdjustment = (long)this.nanos() + (_nanosToAdd %= (long)Instant$.MODULE$.java$time$Instant$$$NANOS_PER_SECOND());
        return Instant$.MODULE$.ofEpochSecond(epochSec, nanoAdjustment);
    }

    @Override
    public Instant minus(TemporalAmount amount) {
        return (Instant)amount.subtractFrom(this);
    }

    @Override
    public Instant minus(long amountToSubtract, TemporalUnit unit) {
        if (amountToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, unit).plus(1L, unit);
        }
        return this.plus(-amountToSubtract, unit);
    }

    public Instant minusSeconds(long secondsToSubtract) {
        if (secondsToSubtract == Long.MIN_VALUE) {
            return this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L);
        }
        return this.plusSeconds(-secondsToSubtract);
    }

    public Instant minusMillis(long millisToSubtract) {
        if (millisToSubtract == Long.MIN_VALUE) {
            return this.plusMillis(Long.MAX_VALUE).plusMillis(1L);
        }
        return this.plusMillis(-millisToSubtract);
    }

    public Instant minusNanos(long nanosToSubtract) {
        if (nanosToSubtract == Long.MIN_VALUE) {
            return this.plusNanos(Long.MAX_VALUE).plusNanos(1L);
        }
        return this.plusNanos(-nanosToSubtract);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries$.MODULE$.precision()) {
            return (R)ChronoUnit$.NANOS;
        }
        if (query == TemporalQueries$.MODULE$.localDate() || query == TemporalQueries$.MODULE$.localTime() || query == TemporalQueries$.MODULE$.chronology() || query == TemporalQueries$.MODULE$.zoneId() || query == TemporalQueries$.MODULE$.zone() || query == TemporalQueries$.MODULE$.offset()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField$.INSTANT_SECONDS, this.seconds()).with(ChronoField$.NANO_OF_SECOND, this.nanos());
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        Instant end = Instant$.MODULE$.from(endExclusive);
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit f;
            ChronoUnit chronoUnit = f = (ChronoUnit)temporalUnit;
            ChronoUnit chronoUnit2 = ChronoUnit$.NANOS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.nanosUntil(end);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.MICROS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return this.nanosUntil(end) / 1000L;
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MILLIS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return Math.subtractExact(end.toEpochMilli(), this.toEpochMilli());
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.SECONDS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.secondsUntil(end);
            }
            ChronoUnit chronoUnit10 = ChronoUnit$.MINUTES;
            ChronoUnit chronoUnit11 = chronoUnit;
            if (!(chronoUnit10 != null ? !chronoUnit10.equals(chronoUnit11) : chronoUnit11 != null)) {
                return this.secondsUntil(end) / 60L;
            }
            ChronoUnit chronoUnit12 = ChronoUnit$.HOURS;
            ChronoUnit chronoUnit13 = chronoUnit;
            if (!(chronoUnit12 != null ? !chronoUnit12.equals(chronoUnit13) : chronoUnit13 != null)) {
                return this.secondsUntil(end) / 3600L;
            }
            ChronoUnit chronoUnit14 = ChronoUnit$.HALF_DAYS;
            ChronoUnit chronoUnit15 = chronoUnit;
            if (!(chronoUnit14 != null ? !chronoUnit14.equals(chronoUnit15) : chronoUnit15 != null)) {
                return this.secondsUntil(end) / 43200L;
            }
            ChronoUnit chronoUnit16 = ChronoUnit$.DAYS;
            ChronoUnit chronoUnit17 = chronoUnit;
            if (!(chronoUnit16 != null ? !chronoUnit16.equals(chronoUnit17) : chronoUnit17 != null)) {
                return this.secondsUntil(end) / 86400L;
            }
            throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
        }
        return unit.between(this, end);
    }

    private long nanosUntil(Instant end) {
        long secsDiff = Math.subtractExact(end.seconds(), this.seconds());
        long totalNanos = Math.multiplyExact(secsDiff, (long)Instant$.MODULE$.java$time$Instant$$$NANOS_PER_SECOND());
        return Math.addExact(totalNanos, (long)end.nanos() - (long)this.nanos());
    }

    private long secondsUntil(Instant end) {
        long secsDiff = Math.subtractExact(end.seconds(), this.seconds());
        long nanosDiff = (long)end.nanos() - (long)this.nanos();
        if (secsDiff > 0L && nanosDiff < 0L) {
            return secsDiff - 1L;
        }
        if (secsDiff < 0L && nanosDiff > 0L) {
            return secsDiff + 1L;
        }
        return secsDiff;
    }

    public OffsetDateTime atOffset(ZoneOffset offset) {
        return OffsetDateTime$.MODULE$.ofInstant(this, offset);
    }

    public ZonedDateTime atZone(ZoneId zone) {
        return ZonedDateTime$.MODULE$.ofInstant(this, zone);
    }

    public long toEpochMilli() {
        if (this.seconds() >= 0L) {
            long millis = Math.multiplyExact(this.seconds(), (long)Instant$.MODULE$.java$time$Instant$$$MILLIS_PER_SEC());
            return Math.addExact(millis, (long)this.nanos() / (long)Instant$.MODULE$.java$time$Instant$$$NANOS_PER_MILLI());
        }
        long millis = Math.multiplyExact(this.seconds() + 1L, (long)Instant$.MODULE$.java$time$Instant$$$MILLIS_PER_SEC());
        return Math.subtractExact(millis, (long)Instant$.MODULE$.java$time$Instant$$$MILLIS_PER_SEC() - (long)this.nanos() / (long)Instant$.MODULE$.java$time$Instant$$$NANOS_PER_MILLI());
    }

    public int compare(Instant otherInstant) {
        int cmp = Long.compare(this.seconds(), otherInstant.seconds());
        if (cmp != 0) {
            return cmp;
        }
        return this.nanos() - otherInstant.nanos();
    }

    public int compareTo(Instant other) {
        return this.compare(other);
    }

    public boolean isAfter(Instant otherInstant) {
        return this.compareTo(otherInstant) > 0;
    }

    public boolean isBefore(Instant otherInstant) {
        return this.compareTo(otherInstant) < 0;
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof Instant) {
            Instant otherInstant = (Instant)object;
            return this == otherInstant || this.seconds() == otherInstant.seconds() && this.nanos() == otherInstant.nanos();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seconds() ^ this.seconds() >>> 32) + 51 * this.nanos();
    }

    public String toString() {
        return DateTimeFormatter$.MODULE$.ISO_INSTANT().format(this);
    }
}

