/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Clock$;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter$;
import java.time.temporal.ChronoField$;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class Instant$
implements Serializable {
    private static final long serialVersionUID = -665713676816604388L;
    private Instant EPOCH$lzy1;
    private boolean EPOCHbitmap$1;
    private Instant MIN$lzy1;
    private boolean MINbitmap$1;
    private Instant MAX$lzy1;
    private boolean MAXbitmap$1;
    public static final Instant$ MODULE$ = new Instant$();

    private Instant$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Instant$.class);
    }

    public Instant EPOCH() {
        if (!this.EPOCHbitmap$1) {
            this.EPOCH$lzy1 = new Instant(0L, 0);
            this.EPOCHbitmap$1 = true;
        }
        return this.EPOCH$lzy1;
    }

    private long MIN_SECOND() {
        return -31557014167219200L;
    }

    private long MAX_SECOND() {
        return 31556889864403199L;
    }

    public int java$time$Instant$$$NANOS_PER_SECOND() {
        return 1000000000;
    }

    public int java$time$Instant$$$NANOS_PER_MILLI() {
        return 1000000;
    }

    public int java$time$Instant$$$MILLIS_PER_SEC() {
        return 1000;
    }

    public Instant MIN() {
        if (!this.MINbitmap$1) {
            this.MIN$lzy1 = this.ofEpochSecond(this.MIN_SECOND(), 0L);
            this.MINbitmap$1 = true;
        }
        return this.MIN$lzy1;
    }

    public Instant MAX() {
        if (!this.MAXbitmap$1) {
            this.MAX$lzy1 = this.ofEpochSecond(this.MAX_SECOND(), 999999999L);
            this.MAXbitmap$1 = true;
        }
        return this.MAX$lzy1;
    }

    public Instant now() {
        return Clock$.MODULE$.systemUTC().instant();
    }

    public Instant now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return clock.instant();
    }

    public Instant ofEpochSecond(long epochSecond) {
        return this.java$time$Instant$$$create(epochSecond, 0);
    }

    public Instant ofEpochSecond(long epochSecond, long nanoAdjustment) {
        long secs = Math.addExact(epochSecond, Math.floorDiv(nanoAdjustment, (long)this.java$time$Instant$$$NANOS_PER_SECOND()));
        int nos = (int)Math.floorMod(nanoAdjustment, (long)this.java$time$Instant$$$NANOS_PER_SECOND());
        return this.java$time$Instant$$$create(secs, nos);
    }

    public Instant ofEpochMilli(long epochMilli) {
        long secs = Math.floorDiv(epochMilli, 1000L);
        int mos = (int)Math.floorMod(epochMilli, 1000L);
        return this.java$time$Instant$$$create(secs, mos * this.java$time$Instant$$$NANOS_PER_MILLI());
    }

    public Instant from(TemporalAccessor temporal) {
        Instant instant;
        try {
            long instantSecs = temporal.getLong(ChronoField$.INSTANT_SECONDS);
            int nanoOfSecond = temporal.get(ChronoField$.NANO_OF_SECOND);
            instant = this.ofEpochSecond(instantSecs, nanoOfSecond);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException(new StringBuilder(55).append("Unable to obtain Instant from TemporalAccessor: ").append(temporal).append(", type ").append(temporal.getClass().getName()).toString(), ex);
        }
        return instant;
    }

    public Instant parse(CharSequence text) {
        return DateTimeFormatter$.MODULE$.ISO_INSTANT().parse(text, new TemporalQuery<Instant>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Instant queryFrom(TemporalAccessor temporal) {
                return Instant$.MODULE$.from(temporal);
            }
        });
    }

    public Instant java$time$Instant$$$create(long seconds, int nanoOfSecond) {
        if ((seconds | (long)nanoOfSecond) == 0L) {
            return this.EPOCH();
        }
        if (seconds < this.MIN_SECOND() || seconds > this.MAX_SECOND()) {
            throw new DateTimeException("Instant exceeds minimum or maximum instant");
        }
        return new Instant(seconds, nanoOfSecond);
    }
}

