/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.DateTimeException;
import java.time.Duration$;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import scala.math.Ordered;

public final class Duration
implements TemporalAmount,
Ordered<Duration>,
Serializable {
    private static final long serialVersionUID = 3078945930695997490L;
    private final long seconds;
    private final int nanos;

    public static Duration ZERO() {
        return Duration$.MODULE$.ZERO();
    }

    public static Duration between(Temporal temporal, Temporal temporal2) {
        return Duration$.MODULE$.between(temporal, temporal2);
    }

    public static Duration from(TemporalAmount temporalAmount) {
        return Duration$.MODULE$.from(temporalAmount);
    }

    public static Duration of(long l, TemporalUnit temporalUnit) {
        return Duration$.MODULE$.of(l, temporalUnit);
    }

    public static Duration ofDays(long l) {
        return Duration$.MODULE$.ofDays(l);
    }

    public static Duration ofHours(long l) {
        return Duration$.MODULE$.ofHours(l);
    }

    public static Duration ofMillis(long l) {
        return Duration$.MODULE$.ofMillis(l);
    }

    public static Duration ofMinutes(long l) {
        return Duration$.MODULE$.ofMinutes(l);
    }

    public static Duration ofNanos(long l) {
        return Duration$.MODULE$.ofNanos(l);
    }

    public static Duration ofSeconds(long l) {
        return Duration$.MODULE$.ofSeconds(l);
    }

    public static Duration ofSeconds(long l, long l2) {
        return Duration$.MODULE$.ofSeconds(l, l2);
    }

    public static Duration parse(CharSequence charSequence) {
        return Duration$.MODULE$.parse(charSequence);
    }

    public Duration(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
        Ordered.$init$((Ordered)this);
    }

    private long seconds() {
        return this.seconds;
    }

    private int nanos() {
        return this.nanos;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.unmodifiableList(Arrays.asList(ChronoUnit$.SECONDS, ChronoUnit$.NANOS));
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit$.SECONDS) {
            return this.seconds();
        }
        if (unit == ChronoUnit$.NANOS) {
            return this.nanos();
        }
        throw new UnsupportedTemporalTypeException(new StringBuilder(18).append("Unsupported unit: ").append(unit).toString());
    }

    public boolean isZero() {
        return (this.seconds() | (long)this.nanos()) == 0L;
    }

    public boolean isNegative() {
        return this.seconds() < 0L;
    }

    public long getSeconds() {
        return this.seconds();
    }

    public int getNano() {
        return this.nanos();
    }

    public Duration withSeconds(long seconds) {
        return Duration$.MODULE$.java$time$Duration$$$create(seconds, this.nanos());
    }

    public Duration withNanos(int nanoOfSecond) {
        ChronoField$.NANO_OF_SECOND.checkValidIntValue(nanoOfSecond);
        return Duration$.MODULE$.java$time$Duration$$$create(this.seconds(), nanoOfSecond);
    }

    public Duration plus(Duration duration) {
        return this.plus(duration.getSeconds(), duration.getNano());
    }

    public Duration plus(long amountToAdd, TemporalUnit unit) {
        Objects.requireNonNull(unit, "unit");
        if (unit == ChronoUnit$.DAYS) {
            return this.plus(Math.multiplyExact(amountToAdd, (long)86400), 0L);
        }
        if (unit.isDurationEstimated()) {
            throw new DateTimeException("Unit must not have an estimated duration");
        }
        if (amountToAdd == 0L) {
            return this;
        }
        TemporalUnit temporalUnit = unit;
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit u;
            ChronoUnit chronoUnit = u = (ChronoUnit)temporalUnit;
            ChronoUnit chronoUnit2 = ChronoUnit$.NANOS;
            ChronoUnit chronoUnit3 = chronoUnit;
            if (!(chronoUnit2 != null ? !chronoUnit2.equals(chronoUnit3) : chronoUnit3 != null)) {
                return this.plusNanos(amountToAdd);
            }
            ChronoUnit chronoUnit4 = ChronoUnit$.MICROS;
            ChronoUnit chronoUnit5 = chronoUnit;
            if (!(chronoUnit4 != null ? !chronoUnit4.equals(chronoUnit5) : chronoUnit5 != null)) {
                return this.plusSeconds(amountToAdd / 1000000000L * 1000L).plusNanos(amountToAdd % 1000000000L * 1000L);
            }
            ChronoUnit chronoUnit6 = ChronoUnit$.MILLIS;
            ChronoUnit chronoUnit7 = chronoUnit;
            if (!(chronoUnit6 != null ? !chronoUnit6.equals(chronoUnit7) : chronoUnit7 != null)) {
                return this.plusMillis(amountToAdd);
            }
            ChronoUnit chronoUnit8 = ChronoUnit$.SECONDS;
            ChronoUnit chronoUnit9 = chronoUnit;
            if (!(chronoUnit8 != null ? !chronoUnit8.equals(chronoUnit9) : chronoUnit9 != null)) {
                return this.plusSeconds(amountToAdd);
            }
            return this.plusSeconds(Math.multiplyExact(unit.getDuration().seconds(), amountToAdd));
        }
        Duration duration = unit.getDuration().multipliedBy(amountToAdd);
        return this.plusSeconds(duration.getSeconds()).plusNanos(duration.getNano());
    }

    public Duration plusDays(long daysToAdd) {
        return this.plus(Math.multiplyExact(daysToAdd, (long)86400), 0L);
    }

    public Duration plusHours(long hoursToAdd) {
        return this.plus(Math.multiplyExact(hoursToAdd, (long)3600), 0L);
    }

    public Duration plusMinutes(long minutesToAdd) {
        return this.plus(Math.multiplyExact(minutesToAdd, (long)60), 0L);
    }

    public Duration plusSeconds(long secondsToAdd) {
        return this.plus(secondsToAdd, 0L);
    }

    public Duration plusMillis(long millisToAdd) {
        return this.plus(millisToAdd / 1000L, millisToAdd % 1000L * 1000000L);
    }

    public Duration plusNanos(long nanosToAdd) {
        return this.plus(0L, nanosToAdd);
    }

    private Duration plus(long secondsToAdd, long nanosToAdd) {
        long _nanosToAdd = nanosToAdd;
        if ((secondsToAdd | _nanosToAdd) == 0L) {
            return this;
        }
        long epochSec = Math.addExact(this.seconds(), secondsToAdd);
        epochSec = Math.addExact(epochSec, _nanosToAdd / 1000000000L);
        long nanoAdjustment = (long)this.nanos() + (_nanosToAdd %= 1000000000L);
        return Duration$.MODULE$.ofSeconds(epochSec, nanoAdjustment);
    }

    public Duration minus(Duration duration) {
        long secsToSubtract = duration.getSeconds();
        int nanosToSubtract = duration.getNano();
        if (secsToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, -((long)nanosToSubtract)).plus(1L, 0L);
        }
        return this.plus(-secsToSubtract, -((long)nanosToSubtract));
    }

    public Duration minus(long amountToSubtract, TemporalUnit unit) {
        if (amountToSubtract == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, unit).plus(1L, unit);
        }
        return this.plus(-amountToSubtract, unit);
    }

    public Duration minusDays(long daysToSubtract) {
        if (daysToSubtract == Long.MIN_VALUE) {
            return this.plusDays(Long.MAX_VALUE).plusDays(1L);
        }
        return this.plusDays(-daysToSubtract);
    }

    public Duration minusHours(long hoursToSubtract) {
        if (hoursToSubtract == Long.MIN_VALUE) {
            return this.plusHours(Long.MAX_VALUE).plusHours(1L);
        }
        return this.plusHours(-hoursToSubtract);
    }

    public Duration minusMinutes(long minutesToSubtract) {
        if (minutesToSubtract == Long.MIN_VALUE) {
            return this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L);
        }
        return this.plusMinutes(-minutesToSubtract);
    }

    public Duration minusSeconds(long secondsToSubtract) {
        if (secondsToSubtract == Long.MIN_VALUE) {
            return this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L);
        }
        return this.plusSeconds(-secondsToSubtract);
    }

    public Duration minusMillis(long millisToSubtract) {
        if (millisToSubtract == Long.MIN_VALUE) {
            return this.plusMillis(Long.MAX_VALUE).plusMillis(1L);
        }
        return this.plusMillis(-millisToSubtract);
    }

    public Duration minusNanos(long nanosToSubtract) {
        if (nanosToSubtract == Long.MIN_VALUE) {
            return this.plusNanos(Long.MAX_VALUE).plusNanos(1L);
        }
        return this.plusNanos(-nanosToSubtract);
    }

    public Duration multipliedBy(long multiplicand) {
        if (multiplicand == 0L) {
            return Duration$.MODULE$.ZERO();
        }
        if (multiplicand == 1L) {
            return this;
        }
        return Duration$.MODULE$.java$time$Duration$$$create(this.toSecondsBD().multiply(BigDecimal.valueOf(multiplicand)));
    }

    public Duration dividedBy(long divisor) {
        if (divisor == 0L) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        if (divisor == 1L) {
            return this;
        }
        return Duration$.MODULE$.java$time$Duration$$$create(this.toSecondsBD().divide(BigDecimal.valueOf(divisor), RoundingMode.DOWN));
    }

    private BigDecimal toSecondsBD() {
        return BigDecimal.valueOf(this.seconds()).add(BigDecimal.valueOf(this.nanos(), 9));
    }

    public long toSeconds() {
        return this.seconds();
    }

    public int toSecondsPart() {
        return (int)(this.toSeconds() % 60L);
    }

    public Duration negated() {
        return this.multipliedBy(-1L);
    }

    public Duration abs() {
        if (this.isNegative()) {
            return this.negated();
        }
        return this;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        Temporal _temporal = temporal;
        if (this.seconds() != 0L) {
            _temporal = _temporal.plus(this.seconds(), ChronoUnit$.SECONDS);
        }
        if (this.nanos() != 0) {
            _temporal = _temporal.plus(this.nanos(), ChronoUnit$.NANOS);
        }
        return _temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Temporal _temporal = temporal;
        if (this.seconds() != 0L) {
            _temporal = _temporal.minus(this.seconds(), ChronoUnit$.SECONDS);
        }
        if (this.nanos() != 0) {
            _temporal = _temporal.minus(this.nanos(), ChronoUnit$.NANOS);
        }
        return _temporal;
    }

    public long toDays() {
        return this.seconds() / 86400L;
    }

    public long toDaysPart() {
        return this.seconds() / 86400L;
    }

    public long toHours() {
        return this.seconds() / 3600L;
    }

    public int toHoursPart() {
        return (int)(this.toHours() % 24L);
    }

    public long toMinutes() {
        return this.seconds() / 60L;
    }

    public int toMinutesPart() {
        return (int)(this.toMinutes() % 60L);
    }

    public long toMillis() {
        long result = Math.multiplyExact(this.seconds(), 1000L);
        return Math.addExact(result, (long)this.nanos() / 1000000L);
    }

    public int toMillisPart() {
        return this.nanos() / 1000000;
    }

    public long toNanos() {
        long result = Math.multiplyExact(this.seconds(), (long)1000000000);
        return Math.addExact(result, (long)this.nanos());
    }

    public int toNanosPart() {
        return this.nanos();
    }

    public int compare(Duration otherDuration) {
        int cmp = Long.compare(this.seconds(), otherDuration.seconds());
        if (cmp != 0) {
            return cmp;
        }
        return this.nanos() - otherDuration.nanos();
    }

    public int compareTo(Duration other) {
        return this.compare(other);
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof Duration) {
            Duration otherDuration = (Duration)object;
            return this == otherDuration || this.seconds() == otherDuration.seconds() && this.nanos() == otherDuration.nanos();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seconds() ^ this.seconds() >>> 32) + 51 * this.nanos();
    }

    public String toString() {
        if (this == Duration$.MODULE$.ZERO()) {
            return "PT0S";
        }
        long hours = this.seconds() / 3600L;
        int minutes = (int)(this.seconds() % 3600L / 60L);
        int secs = (int)(this.seconds() % 60L);
        scala.collection.mutable.StringBuilder buf = new scala.collection.mutable.StringBuilder(24);
        buf.append("PT");
        if (hours != 0L) {
            buf.append(hours).append('H');
        }
        if (minutes != 0) {
            buf.append(minutes).append('M');
        }
        if (secs == 0 && this.nanos() == 0 && buf.length() > 2) {
            return buf.toString();
        }
        scala.collection.mutable.StringBuilder stringBuilder = secs < 0 && this.nanos() > 0 ? (secs == -1 ? buf.append("-0") : buf.append(secs + 1)) : buf.append(secs);
        if (this.nanos() > 0) {
            int pos = buf.length();
            scala.collection.mutable.StringBuilder stringBuilder2 = secs < 0 ? buf.append(2000000000 - this.nanos()) : buf.append(this.nanos() + 1000000000);
            while (buf.charAt(buf.length() - 1) == '0') {
                buf.setLength(buf.length() - 1);
            }
            buf.setCharAt(pos, '.');
        }
        buf.append('S');
        return buf.toString();
    }
}

