/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField$;
import java.time.temporal.ChronoUnit$;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.ModuleSerializationProxy;

public final class Duration$
implements Serializable {
    private Duration ZERO$lzy1;
    private boolean ZERObitmap$1;
    private Pattern PATTERN$lzy1;
    private boolean PATTERNbitmap$1;
    public static final Duration$ MODULE$ = new Duration$();

    private Duration$() {
    }

    static {
        int NANOS_PER_SECOND = 1000000000;
        int NANOS_PER_MILLI = 1000000;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Duration$.class);
    }

    public Duration ZERO() {
        if (!this.ZERObitmap$1) {
            this.ZERO$lzy1 = new Duration(0L, 0);
            this.ZERObitmap$1 = true;
        }
        return this.ZERO$lzy1;
    }

    private BigInteger BI_NANOS_PER_SECOND() {
        return BigInteger.valueOf(1000000000);
    }

    private Pattern PATTERN() {
        if (!this.PATTERNbitmap$1) {
            this.PATTERN$lzy1 = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?", 2);
            this.PATTERNbitmap$1 = true;
        }
        return this.PATTERN$lzy1;
    }

    public Duration ofDays(long days) {
        return this.java$time$Duration$$$create(Math.multiplyExact(days, 86400L), 0);
    }

    public Duration ofHours(long hours) {
        return this.java$time$Duration$$$create(Math.multiplyExact(hours, 3600L), 0);
    }

    public Duration ofMinutes(long minutes) {
        return this.java$time$Duration$$$create(Math.multiplyExact(minutes, 60L), 0);
    }

    public Duration ofSeconds(long seconds) {
        return this.java$time$Duration$$$create(seconds, 0);
    }

    public Duration ofSeconds(long seconds, long nanoAdjustment) {
        long secs = Math.addExact(seconds, Math.floorDiv(nanoAdjustment, (long)1000000000));
        int nos = (int)Math.floorMod(nanoAdjustment, (long)1000000000);
        return this.java$time$Duration$$$create(secs, nos);
    }

    public Duration ofMillis(long millis) {
        long secs = millis / 1000L;
        int mos = (int)(millis % 1000L);
        if (mos < 0) {
            mos += 1000;
            --secs;
        }
        return this.java$time$Duration$$$create(secs, mos * 1000000);
    }

    public Duration ofNanos(long nanos) {
        long secs = nanos / 1000000000L;
        int nos = (int)(nanos % 1000000000L);
        if (nos < 0) {
            nos += 1000000000;
            --secs;
        }
        return this.java$time$Duration$$$create(secs, nos);
    }

    public Duration of(long amount, TemporalUnit unit) {
        return this.ZERO().plus(amount, unit);
    }

    public Duration from(TemporalAmount amount) {
        Objects.requireNonNull(amount, "amount");
        Duration duration = this.ZERO();
        for (TemporalUnit unit : amount.getUnits()) {
            duration = duration.plus(amount.get(unit), unit);
        }
        return duration;
    }

    public Duration between(Temporal startInclusive, Temporal endExclusive) {
        long nanos;
        long secs;
        block8: {
            secs = startInclusive.until(endExclusive, ChronoUnit$.SECONDS);
            nanos = 0L;
            if (!startInclusive.isSupported(ChronoField$.NANO_OF_SECOND) || !endExclusive.isSupported(ChronoField$.NANO_OF_SECOND)) break block8;
            try {
                long startNos = startInclusive.getLong(ChronoField$.NANO_OF_SECOND);
                nanos = endExclusive.getLong(ChronoField$.NANO_OF_SECOND) - startNos;
                if (secs > 0L && nanos < 0L) {
                    nanos += 1000000000L;
                } else if (secs < 0L && nanos > 0L) {
                    nanos -= 1000000000L;
                } else if (secs == 0L && nanos != 0L) {
                    Temporal adjustedEnd = endExclusive.with(ChronoField$.NANO_OF_SECOND, startNos);
                    secs = startInclusive.until(adjustedEnd, ChronoUnit$.SECONDS);
                }
            }
            catch (DateTimeException dateTimeException) {
            }
            catch (ArithmeticException arithmeticException) {}
        }
        return this.ofSeconds(secs, nanos);
    }

    public Duration parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        Matcher matcher = this.PATTERN().matcher(text);
        if (matcher.matches() && !"T".equals(matcher.group(3))) {
            boolean negate = "-".equals(matcher.group(1));
            String dayMatch = matcher.group(2);
            String hourMatch = matcher.group(4);
            String minuteMatch = matcher.group(5);
            String secondMatch = matcher.group(6);
            String fractionMatch = matcher.group(7);
            if (dayMatch != null || hourMatch != null || minuteMatch != null || secondMatch != null) {
                long daysAsSecs = this.parseNumber(text, dayMatch, 86400, "days");
                long hoursAsSecs = this.parseNumber(text, hourMatch, 3600, "hours");
                long minsAsSecs = this.parseNumber(text, minuteMatch, 60, "minutes");
                long seconds = this.parseNumber(text, secondMatch, 1, "seconds");
                boolean negativeSecs = secondMatch != null && secondMatch.charAt(0) == '-';
                int nanos = this.parseFraction(text, fractionMatch, negativeSecs ? -1 : 1);
                try {
                    return this.create(negate, daysAsSecs, hoursAsSecs, minsAsSecs, seconds, nanos);
                }
                catch (ArithmeticException ex) {
                    throw new DateTimeParseException("Text cannot be parsed to a Duration: overflow", text, 0, ex);
                }
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a Duration", text, 0);
    }

    private long parseNumber(CharSequence text, String parsed, int multiplier, String errorText) {
        long l;
        String _parsed = parsed;
        if (_parsed == null) {
            return 0L;
        }
        try {
            if (_parsed.startsWith("+")) {
                _parsed = _parsed.substring(1);
            }
            long val = Long.parseLong(_parsed);
            l = Math.multiplyExact(val, (long)multiplier);
        }
        catch (NumberFormatException ex) {
            throw new DateTimeParseException(new StringBuilder(37).append("Text cannot be parsed to a Duration: ").append(errorText).toString(), text, 0, ex);
        }
        catch (ArithmeticException ex) {
            throw new DateTimeParseException(new StringBuilder(37).append("Text cannot be parsed to a Duration: ").append(errorText).toString(), text, 0, ex);
        }
        return l;
    }

    private int parseFraction(CharSequence text, String parsed, int negate) {
        int n;
        String _parsed = parsed;
        if (_parsed == null || _parsed.length() == 0) {
            return 0;
        }
        try {
            _parsed = new StringBuilder(9).append(_parsed).append("000000000").toString().substring(0, 9);
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_parsed)) * negate;
        }
        catch (NumberFormatException ex) {
            throw new DateTimeParseException("Text cannot be parsed to a Duration: fraction", text, 0, ex);
        }
        catch (ArithmeticException ex) {
            throw new DateTimeParseException("Text cannot be parsed to a Duration: fraction", text, 0, ex);
        }
        return n;
    }

    private Duration create(boolean negate, long daysAsSecs, long hoursAsSecs, long minsAsSecs, long secs, int nanos) {
        long seconds = Math.addExact(daysAsSecs, Math.addExact(hoursAsSecs, Math.addExact(minsAsSecs, secs)));
        if (negate) {
            return this.ofSeconds(seconds, nanos).negated();
        }
        return this.ofSeconds(seconds, nanos);
    }

    public Duration java$time$Duration$$$create(long seconds, int nanoAdjustment) {
        if ((seconds | (long)nanoAdjustment) == 0L) {
            return this.ZERO();
        }
        return new Duration(seconds, nanoAdjustment);
    }

    public Duration java$time$Duration$$$create(BigDecimal seconds) {
        BigInteger nanos = seconds.movePointRight(9).toBigIntegerExact();
        BigInteger[] divRem = nanos.divideAndRemainder(this.BI_NANOS_PER_SECOND());
        if (divRem[0].bitLength() > 63) {
            throw new ArithmeticException(new StringBuilder(30).append("Exceeds capacity of Duration: ").append(nanos).toString());
        }
        return this.ofSeconds(divRem[0].longValue(), divRem[1].longValue());
    }
}

