/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock$;
import java.time.Duration;
import java.time.Duration$;
import java.time.Instant;
import java.time.Instant$;
import java.time.ZoneId;

public abstract class Clock {
    public static Clock fixed(Instant instant, ZoneId zoneId) {
        return Clock$.MODULE$.fixed(instant, zoneId);
    }

    public static Clock offset(Clock clock, Duration duration) {
        return Clock$.MODULE$.offset(clock, duration);
    }

    public static Clock system(ZoneId zoneId) {
        return Clock$.MODULE$.system(zoneId);
    }

    public static Clock systemDefaultZone() {
        return Clock$.MODULE$.systemDefaultZone();
    }

    public static Clock systemUTC() {
        return Clock$.MODULE$.systemUTC();
    }

    public static Clock tick(Clock clock, Duration duration) {
        return Clock$.MODULE$.tick(clock, duration);
    }

    public static Clock tickMinutes(ZoneId zoneId) {
        return Clock$.MODULE$.tickMinutes(zoneId);
    }

    public static Clock tickSeconds(ZoneId zoneId) {
        return Clock$.MODULE$.tickSeconds(zoneId);
    }

    public abstract ZoneId getZone();

    public abstract Clock withZone(ZoneId var1);

    public long millis() {
        return this.instant().toEpochMilli();
    }

    public abstract Instant instant();

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static final class FixedClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 7430389292664866958L;
        private final Instant instant;
        private final ZoneId zone;

        public FixedClock(Instant instant, ZoneId zone) {
            this.instant = instant;
            this.zone = zone;
            if (zone == null) {
                throw new NullPointerException("'zone' can not be null");
            }
        }

        @Override
        public Instant instant() {
            return this.instant;
        }

        public ZoneId zone() {
            return this.zone;
        }

        @Override
        public ZoneId getZone() {
            return this.zone();
        }

        @Override
        public Clock withZone(ZoneId zone) {
            ZoneId zoneId = zone;
            ZoneId zoneId2 = this.zone();
            if (!(zoneId != null ? !((Object)zoneId).equals(zoneId2) : zoneId2 != null)) {
                return this;
            }
            return new FixedClock(this.instant(), zone);
        }

        @Override
        public long millis() {
            return this.instant().toEpochMilli();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            Object object = obj;
            if (!(object instanceof FixedClock)) return false;
            FixedClock other = (FixedClock)object;
            Instant instant = this.instant();
            Instant instant2 = other.instant();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            ZoneId zoneId = this.zone();
            ZoneId zoneId2 = other.zone();
            if (zoneId == null) {
                if (zoneId2 == null) return true;
                return false;
            } else {
                if (!((Object)zoneId).equals(zoneId2)) return false;
                return true;
            }
        }

        @Override
        public int hashCode() {
            return this.instant().hashCode() ^ this.zone().hashCode();
        }

        public String toString() {
            return new StringBuilder(13).append("FixedClock[").append(this.instant()).append(",").append(this.zone()).append("]").toString();
        }
    }

    public static final class OffsetClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 2007484719125426256L;
        private final Clock baseClock;
        private final Duration offset;

        public OffsetClock(Clock baseClock, Duration offset) {
            this.baseClock = baseClock;
            this.offset = offset;
        }

        public Clock baseClock() {
            return this.baseClock;
        }

        public Duration offset() {
            return this.offset;
        }

        @Override
        public ZoneId getZone() {
            return this.baseClock().getZone();
        }

        @Override
        public Clock withZone(ZoneId zone) {
            ZoneId zoneId = zone;
            ZoneId zoneId2 = this.baseClock().getZone();
            if (!(zoneId != null ? !((Object)zoneId).equals(zoneId2) : zoneId2 != null)) {
                return this;
            }
            return new OffsetClock(this.baseClock().withZone(zone), this.offset());
        }

        @Override
        public long millis() {
            return Math.addExact(this.baseClock().millis(), this.offset().toMillis());
        }

        @Override
        public Instant instant() {
            return this.baseClock().instant().plus(this.offset());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            Object object = obj;
            if (!(object instanceof OffsetClock)) return false;
            OffsetClock other = (OffsetClock)object;
            Clock clock = this.baseClock();
            Clock clock2 = other.baseClock();
            if (clock == null) {
                if (clock2 != null) {
                    return false;
                }
            } else if (!((Object)clock).equals(clock2)) return false;
            Duration duration = this.offset();
            Duration duration2 = other.offset();
            if (duration == null) {
                if (duration2 == null) return true;
                return false;
            } else {
                if (!((Object)duration).equals(duration2)) return false;
                return true;
            }
        }

        @Override
        public int hashCode() {
            return this.baseClock().hashCode() ^ this.offset().hashCode();
        }

        public String toString() {
            return new StringBuilder(14).append("OffsetClock[").append(this.baseClock()).append(",").append(this.offset()).append("]").toString();
        }
    }

    public static final class SystemClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 6740630888130243051L;
        private final ZoneId zone;

        public SystemClock(ZoneId zone) {
            this.zone = zone;
            if (zone == null) {
                throw new NullPointerException("'zone' can not be null");
            }
        }

        public ZoneId zone() {
            return this.zone;
        }

        @Override
        public ZoneId getZone() {
            return this.zone();
        }

        @Override
        public Clock withZone(ZoneId zone) {
            ZoneId zoneId = zone;
            ZoneId zoneId2 = this.zone();
            if (!(zoneId != null ? !((Object)zoneId).equals(zoneId2) : zoneId2 != null)) {
                return this;
            }
            return new SystemClock(zone);
        }

        @Override
        public long millis() {
            return System.currentTimeMillis();
        }

        @Override
        public Instant instant() {
            return Instant$.MODULE$.ofEpochMilli(this.millis());
        }

        @Override
        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof SystemClock) {
                SystemClock clock = (SystemClock)object;
                ZoneId zoneId = this.zone();
                ZoneId zoneId2 = clock.zone();
                return !(zoneId != null ? !((Object)zoneId).equals(zoneId2) : zoneId2 != null);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.zone().hashCode() + 1;
        }

        public String toString() {
            return new StringBuilder(13).append("SystemClock[").append(this.zone()).append("]").toString();
        }
    }

    public static final class TickClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 6504659149906368850L;
        private final Clock baseClock;
        private final long tickNanos;

        public TickClock(Clock baseClock, long tickNanos) {
            this.baseClock = baseClock;
            this.tickNanos = tickNanos;
        }

        public Clock baseClock() {
            return this.baseClock;
        }

        public long tickNanos() {
            return this.tickNanos;
        }

        @Override
        public ZoneId getZone() {
            return this.baseClock().getZone();
        }

        @Override
        public Clock withZone(ZoneId zone) {
            ZoneId zoneId = zone;
            ZoneId zoneId2 = this.baseClock().getZone();
            if (!(zoneId != null ? !((Object)zoneId).equals(zoneId2) : zoneId2 != null)) {
                return this;
            }
            return new TickClock(this.baseClock().withZone(zone), this.tickNanos());
        }

        @Override
        public long millis() {
            long millis = this.baseClock().millis();
            return millis - Math.floorMod(millis, this.tickNanos() / 1000000L);
        }

        @Override
        public Instant instant() {
            if (this.tickNanos() % 1000000L == 0L) {
                long millis = this.baseClock().millis();
                return Instant$.MODULE$.ofEpochMilli(millis - Math.floorMod(millis, this.tickNanos() / 1000000L));
            }
            Instant instant = this.baseClock().instant();
            long nanos = instant.getNano();
            long adjust = Math.floorMod(nanos, this.tickNanos());
            return instant.minusNanos(adjust);
        }

        @Override
        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof TickClock) {
                TickClock other = (TickClock)object;
                Clock clock = this.baseClock();
                Clock clock2 = other.baseClock();
                return !(clock != null ? !((Object)clock).equals(clock2) : clock2 != null) && this.tickNanos() == other.tickNanos();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.baseClock().hashCode() ^ (int)(this.tickNanos() ^ this.tickNanos() >>> 32);
        }

        public String toString() {
            return new StringBuilder(12).append("TickClock[").append(this.baseClock()).append(",").append(Duration$.MODULE$.ofNanos(this.tickNanos())).append("]").toString();
        }
    }
}

