/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Duration$;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneId$;
import java.time.ZoneOffset$;
import java.util.Objects;
import scala.runtime.ModuleSerializationProxy;

public final class Clock$
implements Serializable {
    public static final Clock$ MODULE$ = new Clock$();

    private Clock$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Clock$.class);
    }

    public Clock systemUTC() {
        return new Clock.SystemClock(ZoneOffset$.MODULE$.UTC());
    }

    public Clock systemDefaultZone() {
        return new Clock.SystemClock(ZoneId$.MODULE$.systemDefault());
    }

    public Clock system(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        return new Clock.SystemClock(zone);
    }

    public Clock tickSeconds(ZoneId zone) {
        return new Clock.TickClock(this.system(zone), 1000000000L);
    }

    public Clock tickMinutes(ZoneId zone) {
        return new Clock.TickClock(this.system(zone), 60000000000L);
    }

    public Clock tick(Clock baseClock, Duration tickDuration) {
        Objects.requireNonNull(baseClock, "baseClock");
        Objects.requireNonNull(tickDuration, "tickDuration");
        if (tickDuration.isNegative()) {
            throw new IllegalArgumentException("Tick duration must not be negative");
        }
        long tickNanos = tickDuration.toNanos();
        if (tickNanos % 1000000L != 0L && 1000000000L % tickNanos != 0L) {
            throw new IllegalArgumentException("Invalid tick duration");
        }
        if (tickNanos <= 1L) {
            return baseClock;
        }
        return new Clock.TickClock(baseClock, tickNanos);
    }

    public Clock fixed(Instant fixedInstant, ZoneId zone) {
        Objects.requireNonNull(fixedInstant, "fixedInstant");
        Objects.requireNonNull(zone, "zone");
        return new Clock.FixedClock(fixedInstant, zone);
    }

    public Clock offset(Clock baseClock, Duration offsetDuration) {
        Objects.requireNonNull(baseClock, "baseClock");
        Objects.requireNonNull(offsetDuration, "offsetDuration");
        Duration duration = offsetDuration;
        Duration duration2 = Duration$.MODULE$.ZERO();
        if (!(duration != null ? !((Object)duration).equals(duration2) : duration2 != null)) {
            return baseClock;
        }
        return new Clock.OffsetClock(baseClock, offsetDuration);
    }
}

